﻿/*  TiExample.cpp
*
*   一、TITD DEMO程序文件类别
*       ① lib/include  此文件夹下包含4个TITD的头文件
*          TiTdApi.h        该文件包含TITD所需要用的两个类：CTiTdSpi和CTiTdApi. CTiTdSpi为包含TITD通知和应答的类，CTiTdApi为请求类。
*          TiErrCode.h      该文件列出了TITD平台返回的错误码表，交易所返回的错误码表请参考TITDerrorcode.xls。
*          TiDataType.h     该文件列出了TITD中用到的结构体类型
*          TiDataStruct.h   该文件列出了TITD中用到的数据类型
*
*       ② lib/libtitdapi.so     TITD库, 普通socket连接时使用该库
*         lib/libtitdapi_exa.so TITD库,用exa网卡时使用该库
*         lib/libtitdapi_sf.so  TITD库,用ef网卡时使用该库
*         lib/libtitdapi_tcp.so TITD库,用tcp方式连接到titd柜台时使用该库，一般用于测试
*         lib/titdapi.ini       init初始化时的配置文件
*
*       ③ demo 此文件夹下包含了TITD demo程序
*           TiExample.cpp            main函数
*           TiExample.h              CTiTdSpi子类CExampleSpi的类申明, CTiTdSpi中有参数CTiTdApi* _api;
*           TiExampleInit.cpp        CExampleSpi类函数实现 -- "程序初始化并连接"相关的请求和应答、通知
*           TiExampleLogin.cpp       CExampleSpi类函数实现 -- "客户登录"相关的请求和应答、通知
*           TiExampleGet.cpp         CExampleSpi类函数实现 -- "同步查询"相关的请求和应答、通知
*           TiExampleQuery.cpp       CExampleSpi类函数实现 -- "异步查询"相关的请求和应答、通知
*           TiExampleOrder.cpp       CExampleSpi类函数实现 -- "报撤单"相关的请求和应答、通知
*           TiExampleQuote.cpp       CExampleSpi类函数实现 -- "询价、报价"相关的请求和应答、通知
*           TiExampleExercise.cpp    CExampleSpi类函数实现 -- "行权"相关的请求和应答、通知
*           TiExampleOther.cpp       CExampleSpi类函数实现 -- "组合行权、锁仓、出入金推送"相关的请求和应答、通知
*
*   二、TITD交易流程
*       ① 准备：需要有两项准备，创建api接口、指定应答类。
*       ② 初始化并连接：Init函数初始化系统的各个参数设置，同时init函数也是发送连接的请求。
*       ③ 等待连接成功：收到通知OnConnected
*       ④ 用户登录：连接成功后，进行用户登录ReqUserLogin
*       ⑤ 等待用户登录成功：OnRspUserLogin收到用户登录成功通知
*       ⑥ 交易操作：客户登录成功后，用户可以根据需要查询、报撤单、询价、报价、行权等。
*/
#include "TiExample.h"


using namespace std;

bool _bIsConnet = false;  //是否连接成功标志, 收到OnConnected设置为true
bool _bIsLogin  = false;  //是否用户登录成功标志，收到OnRspUserLogin通知已登录成功后，设置为true

int main()
{
    printf("start test\n\n");

    //两项准备：创建api接口、指定应答类。应答类需要是CTiTdSpi子类。
    CExampleSpi example;
    printf("CreateTiTdApi\n\n");
    example._api = CTiTdApi::CreateTiTdApi();
    printf("RegisterSpi\n\n");
    example._api->RegisterSpi(&example);

    //打印api版本信息
    char strversion[100] = {0};
    strncpy(strversion, example._api->GetApiVersion(), 99);
    printf("GetApiVersion: api version:%s\n\n", strversion);

    example.TESTINIT();         //程序初始化和连接   相关代码请参考TiExampleInit.cpp
    while(!_bIsConnet)          
    {
    	sleep(1);               //等待api连接成功，连接成功后再发送用户登录请求
    }

    printf("输入回车, 测试用户登录\n");
    getchar();
    example.TESTLOGIN();        //客户登录           相关代码请参考TiExampleLogin.cpp
    while(!_bIsLogin)
    {
    	sleep(1);               //等待用户登录成功，用户登录成功再发送各个其他请求
    }

    printf("输入回车, 测试密码认证\n");
    getchar();
    example.AUTHER();

    //用户登录后可以发送下面任一请求，无先后要求
    getchar();
    printf("输入回车, 测试GET同步查询\n");
    getchar();
    example.TESTGET();          //同步查询           相关代码请参考TiExampleGet.cpp

    getchar();
    printf("输入回车, 测试报单\n");
    getchar();
    example.TESTORDER();        //报撤单             相关代码请参考TiExampleOrder.cpp

    getchar();
    printf("输入回车, 测试报价\n");
    getchar();
    example.TESTQUOTE();        //询价、报价         相关代码请参考TiExampleQuote.cpp

    getchar();
    printf("输入回车, 测试行权\n");
    getchar();
    example.TESTEXERCISE();     //行权               相关代码请参考TiExampleExercise.cpp
    
    getchar();
    printf("输入回车, 测试QUERY异步查询\n");
    getchar();
    example.TESTQUERY();        //异步查询           相关代码请参考TiExampleQuery.cpp

    getchar();
    printf("输入回车, 测试组合和锁仓\n");
    getchar();
    example.TESTOTHER();        //组合、锁仓、出入金推送  相关代码请参考TiExampleOther.cpp

    example._api->Release();

    return 0;
}
