
#ifndef TIEXAMPLE_H_
#define TIEXAMPLE_H_
/*  TiExample.h
*   TITD DEMO程序
*/
#include <stdio.h>
#include "string.h"
#include <string>
#include <iostream>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <unistd.h>
#include "TiTdApi.h"


using namespace titd;

extern bool _bIsConnet;
extern bool _bIsLogin;

/*     用户测试须知
*      测试前请修改或检查：
*      ① 宏定义中的配置信息
*/


#define TESTFUT_OPT                                      
#define TESTSTOCK

                                                        //init函数初始化时使用
#define RECVIP      "172.18.18.131"                     //使用titdapi所在的服务器的地址
#define FRONTADD    "udp://219.0.0.5:7567"              //交易服务的地址，由经济商提供

                                                        //ReqUserLogin做客户登录时使用
#define USERID 		"100000000001"                      //登录用户
#define PASSWORD    "123456"                            //登录密码
#define APPID       "test_appid"                        //APPID
#define AUTHCODE    "TIIDESJFLGY"                       //认证码


class CExampleSpi : public CTiTdSpi
{
public:
	CExampleSpi(){
		_api = NULL;
		_LocalOrderNo = 1;
        _requestID = 1;
        _lastPrvSequenceNo = 0;
	};
	virtual ~CExampleSpi(){};

public:
///当客户端与交易后台建立起通信连接时（还未登录前），该方法被调用。
        virtual void OnConnected();

        ///当客户端与交易后台通信连接断开时，该方法被调用。当发生这个情况后，API会自动重新连接，客户端可不做处理。
        ///@param nReason 错误原因
        ///        0x1001 网络读失败
        ///        0x1002 网络写失败
        ///        0x2001 接收心跳超时
        ///        0x2002 发送心跳失败
        ///        0x2003 收到错误报文
        virtual void OnDisconnected(int nReason);

        ///用户登录应答
        virtual void OnRspUserLogin(CTdRspUserLoginField& pRspUserLogin, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///用户退出应答
        virtual void OnRspUserLogout(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///用户密码修改应答
        virtual void OnRspUserPasswordUpdate(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///股票报单应答
        virtual void OnRspStockInsert(CTdStockInsertRspField& pStockInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///股票撤单应答
        virtual void OnRspStockCancel(CTdOrderCancelRspField& pStockCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

         ///股票非交易业务报单应答
        virtual void OnRspBusinessInsert(CTdBusinessInsertRspField& pStockInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///股票非交易业务撤单应答
        virtual void OnRspBusinessCancel(CTdOrderCancelRspField& pStockCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///证券锁定应答
        virtual void OnRspStockLock(CTdStockLockRspField& pStockLock, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///期权,期货报单应答
        virtual void OnRspOptionsInsert(CTdOrderInsertRspField& pOptionsInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///期权,期货撤单应答
        virtual void OnRspOptionsCancel(CTdOrderCancelRspField& pOptionsCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///期权,期货报价应答
        virtual void OnRspQuoteInsert(CTdQuoteInsertRspField& pQuoteInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///期权,期货撤销报价应答
        virtual void OnRspQuoteCancel(CTdOrderCancelRspField& pQuoteCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///询价应答
        virtual void OnRspForQuote(CTdForQuoteRspField& pForQuote, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///行权应答
        virtual void OnRspExercise(CTdExerciseRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///组合行权应答
        virtual void OnRspCombExercise(CTdCombExerciseRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///撤销行权应答
        virtual void OnRspExerciseCancel(CTdOrderCancelRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///客户申请组合应答
        virtual void OnRspMarginCombAction(CTdMarginCombActionRspField& pMarginCombAction, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///股票报单查询应答
        virtual void OnRspQryStockOrder(CTdRspQryStockOrderField& pOrder, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///股票非交易报单查询应答
        virtual void OnRspQryBusinessOrder(CTdRspQryBusinessOrderField& pOrder, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///期权,期货报单查询应答
        virtual void OnRspQryOptionsOrder(CTdRspQryOptionsOrderField& pOrder, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///报价查询应答
        virtual void OnRspQryQuoteOrder(CTdRspQryQuoteOrderField& pQuote, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///查询行权应答
        virtual void OnRspQryExercise(CTdRspQryExerciseField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///查询组合行权应答
        virtual void OnRspQryCombExercise(CTdRspQryCombExerciseField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///股票成交查询应答
        virtual void OnRspQryStockTrade(CTdRspQryStockTradeField& pTrade, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///期权,期货成交查询应答
        virtual void OnRspQryOptionsTrade(CTdRspQryOptionsTradeField& pTrade, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///期权,期货持仓查询应答
        virtual void OnRspQryOptionsPosition(CTdRspQryOptionsPositionField& pPosition, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///股票持仓查询应答
        virtual void OnRspQryStockPosition(CTdRspQryStockPositionField& pPosition, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///组合持仓查询应答
        virtual void OnRspQryCombPosition(CTdRspQryCombPositionField& pPosi, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///从服务端获取资金应答
        virtual void OnRspQryAccount(CTdRspQryAccountField& pAccount, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///行情查询应答
        virtual void OnRspQryMarketData(CTdRspQryMarketDataField& pMarketData, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///通知查询应答
        virtual void OnRspQryNotify(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

        ///期权,期货委托回报
        virtual void OnRtnOptionsOrder(CTdOptionsOrderRtnField& pOrder);

        ///股票委托回报
        virtual void OnRtnStockOrder(CTdStockOrderRtnField& pOrder);

        ///股票非交易业务委托回报
        virtual void OnRtnBusinessOrder(CTdBusinessOrderRtnField& pOrder);

        ///报价回报
        virtual void OnRtnQuoteOrder(CTdQuoteOrderRtnField& pQuote);

        ///期权,期货成交回报
        virtual void OnRtnOptionsTrade(CTdOptionsTradeRtnField& pTrade);

        ///股票成交回报
        virtual void OnRtnStockTrade(CTdStockTradeRtnField& pTrade);

        ///股票非交易业务成交回报
        virtual void OnRtnBusinessTrade(CTdBusinessTradeRtnField& pTrade);

        ///行权回报
        virtual void OnRtnExercise(CTdExerciseRtnField& pExercise);

        ///出入金通知
        virtual void OnRtnWithdrawDeposit(CTdWithdrawDepositRtnField& pWithdrawDeposit);

        ///客户申请组合通知
        virtual void OnRtnMarginCombAction(CTdMarginCombActionRtnField& pMarginCombAction);

        ///询价通知
        virtual void OnRtnForQuote(CTdForQuoteRtnField& pForQuote);

        ///合约状态变化通知
        virtual void OnRtnInstrumentStatus(CTdInstrumentStatusRtnField& pStatus);

        ///用户验证应答
        virtual void OnRspUserAuthentication(CTdRspUserAuthenField& pUserInfo, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

 public:
    void TESTINIT();          //初始化
    void AUTHER();            //密码认证
    void TESTLOGIN();         //客户登录
    void TESTGET();           //同步查询
    void TESTQUERY();         //异步查询
    void TESTORDER();         //报单
    void TESTQUOTE();         //询价、报价
    void TESTEXERCISE();      //行权
    void TESTOTHER();         //组合等
   
 public:
    void initFromIni();         //api初始化 - 通过配置文件
    void initFromParam();       //api初始化 - 通过函数参数

    void userauthen();          //密码认证
    void login();               //客户登录          
    void logout();              //客户登出
    void updatepwd();           //更新密码

    void getGetClient();        //同步查询 - 获取客户信息
    void getGetFront();         //同步查询 - 获取前置
    void getGetInstrument();    //同步查询 - 获取合约信息
    void getGetRate();          //同步查询 - 获取手续费率
    void getGetOptMargi();      //同步查询 - 获取保证金率
    void getGetAccount();       //同步查询 - 获取初始资金

    void qryQryStockOrder();	//报单查询 - 股票报单
    void qryQryOptionsOrder();  //报单查询 - 期权、期货报单	
    void qryQryQuoteOrder();	//报价查询
    void qryQryExec();			//行权查询
    void qryQryCombExec();      //组合行权查询
    void qryQryStockTrade();	//成交查询 - 股票成交
    void qryQryOptionsTrade();  //成交查询 - 期权、期货成交
    void qryQryStockPosition();	//持仓查询 - 股票持仓
    void qryQryOptionsPosition();//持仓查询- 期权、期货持仓
    void qryQryCombPosi();      //持仓查询 - 组合持仓
    void qryQryAccount();		//资金查询
    void qryQryMarketData();	//行情查询
    void qryQryNotify();		//查询通知
    void qrybusinessOrder();    //股票非交易业务委托查询

    void optionOrderInsert();    //期权、期货报单
    void stockOrderInsert();     //股票报单
    void optionOrderCancel();    //期权、期货报单撤销
    void stockOrderCancel();     //股票报单撤销

    void businessOrderInsert();  //股票非交易业务报单
    void businessOrderCancel();  //股票非交易业务撤销

    void forquoteInsert();       //询价
    void quoteInsert();          //报价
    void quotecancle();          //报价撤销

    void exercise();             //行权
    void combexercise();         //组合行权
    void exercisecancel();       //行权撤销

	void marginCombAction();     //申请组合
    void stockLock();            //申请锁仓
      
public:
	CTiTdApi* _api;

	int _LocalOrderNo;          //本地号，在OnRspUserLogin中返回的MaxLocalOrderNo基础上递增或置0
    int _lastPrvSequenceNo;     //私有流序号，在OnRspUserLogin中返回此次登录后的起始私有流序号
    int _requestID;             //无要求，用户自行维护

private:
    char _clientid[11];
    int  _clientno;
    char _instrumentid[31];
    int  _instrumentno;
    char _exchangeid;
};

#endif
