﻿/*  TiExampleExercise.cpp
*   行权DEMO
* 
*   行权相关的注意点：
*   ① 组合行权撤销与普通行权共用函数ReqExerciseCancel。
*   ② 组合行权分推送两笔行权通知OnRtnExercise。
*      两笔OnRtnExercise中的OrderSysId不一样，用户若要用OrderSysId撤销组合行权，可用任意一个OrderSysId填入ReqExerciseCancel请求中，组合行权的两个单腿就会一起撤销。
*   ③ 关于行权冻资、冻仓问题，对于上交所、深交所etf期权：
*      如果行看涨期权，TITD会冻结行权所需资金；
*      如果行看跌期权，TITD暂不做冻结操作(行看跌期权，要求有相对应的现货持仓要求)。
*/
#include "TiExample.h"

void CExampleSpi::TESTEXERCISE()
{
    exercise();         //行权             对应的应答为OnRspExercise
    combexercise();     //组合行权         对应的应答为OnRspCombExercise      
    exercisecancel();   //行权撤销         对应的应答为OnRspExerciseCancel(只有行权错误时应答)   对应的通知为OnRtnExercise(行权成功发送OnRtnExercise)   
}

//行权
void CExampleSpi::exercise()
{
    CTdExerciseReqField req = { 0 };
    req.ClientNo = 1;			//交易编码序号
    req.InstrumentNo = 248;	    //合约序号
    req.LocalOrderNo = 0;	    //会员内部订单编号
    req.Volume = 1;				//申报数量
    req.OwnerType = TD_OWNER_Per;	//订单所有类型
    req.ExchangeId = _exchangeid;//交易所代码

    int iRet = _api->ReqExercise(&req, _requestID++);
    printf("ReqExercise(行权请求), requestID:%d|ret:%d\n", _requestID - 1, iRet);
    printf("ReqExercise(行权请求), ClientNo:%d|InstrumentNo:%d|LocalOrderNo:%d|Volume:%d|OwnerType:%d|ExchangeId:%d\n\n",
        req.ClientNo,                 //交易编码序号
        req.InstrumentNo,             //合约序号
        req.LocalOrderNo,             //会员内部订单编号
        req.Volume,                   //申报数量
        req.OwnerType,                //订单所有类型
        req.ExchangeId);               //交易所代码
}

void CExampleSpi::OnRspExercise(CTdExerciseRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("OnRspExercise(行权响应):RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
        "ClientNo:%d|InstrumentNo:%d|LocalOrderNo:%d|Volume:%d|"
        "OwnerType:%d|ExchangeId:%d|FrontNo:%d|SessionNo:%d|OrderSysId:%s\n\n",
        nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
        pExercise.ClientNo,                 //交易编码序号
        pExercise.InstrumentNo,             //合约序号
        pExercise.LocalOrderNo,             //会员内部订单编号
        pExercise.Volume,                   //申报数量
        pExercise.OwnerType,                //订单所有类型
        pExercise.ExchangeId,               //交易所代码
        pExercise.FrontNo,                  //处理本次报单的实际席位序号
        pExercise.SessionNo,                //发送该报单的session
        pExercise.OrderSysId);               //交易所订单编号);
};

void CExampleSpi::OnRtnExercise(CTdExerciseRtnField& pExercise)
{
    if (1 != pExercise.SequenceNo - _lastPrvSequenceNo)
    {
        printf("!!!!!err seq:%d|new:%d|old:%d|\n", __LINE__, pExercise.SequenceNo, _lastPrvSequenceNo);
    }
    
    _lastPrvSequenceNo = pExercise.SequenceNo;
    printf("行权通知 - OnRtnExercise: SequenceNo:%d\n", pExercise.SequenceNo);
    printf("FrontNo:%d|SequenceNo:%d|RequestNo:%d|SessionNo:%d|ClientNo:%d|InstrumentNo:%d|LocalOrderNo:%d|"
    "ClientId:%s|InstrumentId:%s|ExchangeId:%d|Volume:%d|OwnerType:%d|OrdStatus:%d|ExerciseTime:%d|OrderSysId:%s|UserId:%s\n\n",
        pExercise.FrontNo,                 //处理本次报单的实际席位序号
        pExercise.SequenceNo,              //回报序号(私有流序号每个交易日连续)
        pExercise.RequestNo,               //报单请求编号
        pExercise.SessionNo,               //原始报单session
        pExercise.ClientNo,
        pExercise.InstrumentNo,
        pExercise.LocalOrderNo,
        pExercise.ClientId,
        pExercise.InstrumentId,
        pExercise.ExchangeId,              //交易所代码
        pExercise.Volume,                  //申报数量
        pExercise.OwnerType,               //订单所有类型
        pExercise.OrdStatus,
        pExercise.ExerciseTime,            //行权成功时间 
        pExercise.OrderSysId,              //交易所订单编号
        pExercise.UserId);                  //原始报单交易用户代码
}

//组合行权
void CExampleSpi::combexercise()
{
    CTdCombExerciseReqField req = { 0 };

    req.ClientNo = 1;		              //交易编码序号
    req.LocalOrderNo = 0;	              //会员内部订单编号
    req.Volume = 1;                       //申报数量
    req.LegInstrumentNo1 = 248;           //腿1合约序号
    req.LegVolume1 = 1;                   //腿1申报数量
    req.LegInstrumentNo2 = 249;           //腿2合约序号
    req.LegVolume2 = 1;                   //腿2申报数量
    req.OwnerType = TD_OWNER_Per;         //订单所有类型
    req.ExchangeId = _exchangeid;     //交易所代码

    int iRet = _api->ReqCombExercise(&req, _requestID++);
    printf("ReqCombExercise(组合行权请求), requestID:%d|ret:%d\n", _requestID - 1, iRet);
    printf("ReqCombExercise(组合行权请求), ClientNo:%d|LocalOrderNo:%d|Volume:%d|LegInstrumentNo1:%d|LegVolume1:%d|LegInstrumentNo2:%d|LegVolume2:%d|OwnerType:%d|ExchangeId:%d\n\n",
        req.ClientNo,                   //交易编码序号
        req.LocalOrderNo,               //会员内部订单编号
        req.Volume,                     //申报数量
        req.LegInstrumentNo1,           //腿1合约序号
        req.LegVolume1,                 //腿1申报数量
        req.LegInstrumentNo2,           //腿2合约序号
        req.LegVolume2,                 //腿2申报数量
        req.OwnerType,                  //订单所有类型
        req.ExchangeId);                 //交易所代码
}

void CExampleSpi::OnRspCombExercise(CTdCombExerciseRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("OnRspCombExercise(组合行权响应):RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|ClientNo:%d|LocalOrderNo:%d|Volume:%d|LegInstrumentNo1:%d|"
        "LegVolume1:%d|LegInstrumentNo2:%d|LegVolume2:%d|OwnerType:%d|ExchangeId:%d|FrontNo:%d|SessionNo:%d\n\n",
        nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
        pExercise.ClientNo,                   //交易编码序号
        pExercise.LocalOrderNo,               //会员内部订单编号
        pExercise.Volume,                     //申报数量
        pExercise.LegInstrumentNo1,           //腿1合约序号
        pExercise.LegVolume1,                 //腿1申报数量
        pExercise.LegInstrumentNo2,           //腿2合约序号
        pExercise.LegVolume2,                 //腿2申报数量
        pExercise.OwnerType,                  //订单所有类型
        pExercise.ExchangeId,                 //交易所代码
        pExercise.FrontNo,                    //处理本次报单的实际席位序号
        pExercise.SessionNo);                 //发送该报单的session);
};

//行权撤销/组合行权撤销
void CExampleSpi::exercisecancel()
{
    CTdOrderCancelReqField req = { 0 };
    req.OriSessionNo = 2480;       	    //原始报单的sessionno如果是通过LocalOrderNo撤单，需要填写，不填写则默认撤销本次登录后的LocalOrderNo
    req.OriLocalOrderNo = 1;    		//原始交易客户方订单编号
    strcpy(req.OrderSysId, "");         //交易所订单编号(OrigLocalOrderNo和OrderSysId任意一个即可)
    int iRet = _api->ReqExerciseCancel(&req, _requestID++);
    printf("ReqExerciseCancel(行权撤销请求), requestID:%d|ret:%d\n", _requestID - 1, iRet);
    printf("ReqExerciseCancel(行权撤销请求), OriSessionNo:%d|OriLocalOrderNo:%d|OrderSysId:%s\n\n",
        req.OriSessionNo,       //原始报单的sessionno如果是通过LocalOrderNo撤单，需要填写，不填写则默认撤销本次登录后的LocalOrderNo
        req.OriLocalOrderNo,    //原始交易客户方订单编号
        req.OrderSysId);         //交易所订单编号(OrigLocalOrderNo和OrderSysId任意一个即可，当OriLocalOrderNo、OrderSysId都填写时，以OriLocalOrderNo为准)
}

void CExampleSpi::OnRspExerciseCancel(CTdOrderCancelRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("OnRspCombExercise(行权撤销响应):RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
        "OriSessionNo:%d|OriLocalOrderNo:%d|OrderSysId:%s|SessionNo:%d\n\n",
        nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
        pExercise.OriSessionNo,        //原始报单的sessionno
        pExercise.OriLocalOrderNo,     //原始交易客户方订单编号
        pExercise.OrderSysId,          //交易所订单编号
        pExercise.SessionNo);          //发送该报单的session
};

