﻿/*  TiExampleGet.cpp
*   同步查询DEMO
* 
*   TITD的查询分两种：
*   1、以Qry为开头的异步查询
*   2、以Get为开头的同步查询
* 
*   本文为Get开头的同步查询demo。
* 
*   以下为同步查询的有关说明：
* 
*   1、同步查询从本地数据库查询，同步查询到的数据都为基础化数据，盘中不做更新。
​*   2、同步查询函数有同样固定的格式：前面0-n个参数为查询过滤参数，最后一个引用参数为查询输出参数。
​*   3、Get类函数不会对输出参数做初始化，客户在获取各类信息之前，请对要存放输出的变量做初始化，以防获取到错误数据。
*   4、同步查询一共有6类，分别为获取客户信息、获取交易前置、获取合约信息、获取手续费信息、获取保证金。
*   5、ClientNo、InstrumentNo同一交易日是不变的，但是不同交易日不保证都一样，用户每日交易前，请重新获取当日的ClientNo、InstrumentNo。
*/

#include "TiExample.h"
#include <iostream>

void CExampleSpi::TESTGET()
{  
    getGetClient();    //同步查询 - 获取客户信息
    getGetFront();     //同步查询 - 获取前置
    getGetInstrument();//同步查询 - 获取合约信息
    getGetRate();      //同步查询 - 获取手续费率
    getGetOptMargi();  //同步查询 - 获取保证金率
    getGetAccount();   //同步查询 - 获取初始资金
}

void CExampleSpi::getGetClient()
{
  
    printf("同步查询 - 获取客户信息 - 获取所有客户信息列表 \n");
    TdRspQryClientList output;
    output.clear();
    _api->GetClientList(output);
    for (TdRspQryClientList::iterator iter = output.begin(); iter != output.end(); iter++)
    {
        std::cout << iter->ClientId << " | " << iter->ClientNo << " | " << (int)iter->ClientType << " | " << (int)iter->ExchangeId << " | " << (int)iter->Status << std::endl << std::endl;
        
        strcpy(_clientid, iter->ClientId);
        _clientno = iter->ClientNo;
        _exchangeid = iter->ExchangeId;
    }
        
    
    printf("同步查询 - 获取客户信息 - 按交易编码获取单个客户信息 \n");
    CTdRspQryClientField client = { 0 };
    _api->GetClientInfo(_clientid, client);
    std::cout << "---" << _clientid << std::endl;
    std::cout << client.ClientId << " | " << client.ClientNo << " | " << (int)client.ClientType << " | " << (int)client.ExchangeId << " | " << (int)client.Status << std::endl << std::endl;


    printf("同步查询 - 获取客户信息 - 按clientNo获取单个客户信息 \n");
    CTdRspQryClientField client1 = { 0 };
    _api->GetClientInfo(_clientno, client1);
    std::cout << "---" << _clientno << std::endl;
    std::cout << client1.ClientId << " | " << client1.ClientNo << " | " << (int)client1.ClientType << " | " << (int)client1.ExchangeId << " | " << (int)client1.Status << std::endl << std::endl;


    printf("同步查询 - 获取客户信息 - 按交易编码获取clientNo \n");
    int clientNo = 0;
    _api->GetClientNo(_clientid, clientNo);
    std::cout << "---" << _clientid << std::endl;
    std::cout << clientNo << std::endl << std::endl;
}

void CExampleSpi::getGetFront()
{
    printf("同步查询 - 获取交易前置 - 获取所有交易前置列表\n");
    TdRspQryFrontFieldList output;
    output.clear();
    _api->GetFrontList(output);
    for (TdRspQryFrontFieldList::iterator iter = output.begin(); iter != output.end(); iter++)
        std::cout << (int)iter->FrontNo << " | " << (int)iter->ExchangeId << " | " << (int)iter->PartyType << " | " << iter->PartyId << std::endl << std::endl;
}

void CExampleSpi::getGetInstrument()
{
    printf("同步查询 - 获取合约信息 - 获取所有合约信息列表\n");
    TdRspQryInstrumentFieldList output;
    output.clear();
    _api->GetInstrumentList(output);
    for (TdRspQryInstrumentFieldList::iterator iter = output.begin(); iter != output.end(); iter++)
    {
        std::cout << iter->InstrumentNo << " | " << iter->InstrumentId << " | " << (int)iter->ExchangeId << " | " << iter->InstrumentName << " | " << iter->ProductId << " | " << iter->UnderlyingInstrId << " | " <<
        iter->ProductType << " | " << iter->OptionsType << " | " << iter->Volumemultiple << " | " << iter->DeliveryYear << " | " << iter->DeliveryMonth << " | " << iter->AdvanceMonth << " | " <<
        (int)iter->TradeStatus << " | " << iter->CreateDate << " | " << iter->OpenDate << " | " << iter->ExpireDate << " | " << iter->StartdelivDate << " | " << iter->EnddelivDate << " | " << iter->BasisPrice << " | " <<
        iter->StrikePrice << " | " << iter->MaxMarketOrderVolume << " | " << iter->MinMarketOrderVolume << " | " << iter->MaxLimitOrderVolume << " | " << iter->MinLimitOrderVolume << " | " <<
        iter->PriceTick << " | " << iter->LastPrice << " | " << iter->SettlementPrice << " | " << iter->UpperLimitPrice << " | " << iter->LowerLimitPrice << std::endl << std::endl;

        strcpy(_instrumentid, iter->InstrumentId);
        _instrumentno = iter->InstrumentNo;

        break;
    }
        
    printf("同步查询 - 获取合约信息 - 按InstrumentID获取合约信息\n");
    CTdRspQryInstrumentField field = {0};
    _api->GetInstrumentInfo(_instrumentid, field);
    std::cout << "---" << _instrumentid << std::endl;
    std::cout << field.InstrumentNo << " | " << field.InstrumentId << " | " << (int)field.ExchangeId << " | " << field.InstrumentName << " | " << field.ProductId << " | " << field.UnderlyingInstrId << " | " <<
        field.ProductType << " | " << field.OptionsType << " | " << field.Volumemultiple << " | " << field.DeliveryYear << " | " << field.DeliveryMonth << " | " << field.AdvanceMonth << " | " <<
        (int)field.TradeStatus << " | " << field.CreateDate << " | " << field.OpenDate << " | " << field.ExpireDate << " | " << field.StartdelivDate << " | " << field.EnddelivDate << " | " << field.BasisPrice << " | " <<
        field.StrikePrice << " | " << field.MaxMarketOrderVolume << " | " << field.MinMarketOrderVolume << " | " << field.MaxLimitOrderVolume << " | " << field.MinLimitOrderVolume << " | " <<
        field.PriceTick << " | " << field.LastPrice << " | " << field.SettlementPrice << " | " << field.UpperLimitPrice << " | " << field.LowerLimitPrice << std::endl << std::endl;

    printf("同步查询 - 获取合约信息 - 按InstrumentNo获取合约信息\n");
    field = { 0 };
    _api->GetInstrumentInfo(_instrumentno, field);
    std::cout << "---" << _instrumentno << std::endl;
    std::cout << field.InstrumentNo << " | " << field.InstrumentId << " | " << (int)field.ExchangeId << " | " << field.InstrumentName << " | " << field.ProductId << " | " << field.UnderlyingInstrId << " | " <<
        field.ProductType << " | " << field.OptionsType << " | " << field.Volumemultiple << " | " << field.DeliveryYear << " | " << field.DeliveryMonth << " | " << field.AdvanceMonth << " | " <<
        (int)field.TradeStatus << " | " << field.CreateDate << " | " << field.OpenDate << " | " << field.ExpireDate << " | " << field.StartdelivDate << " | " << field.EnddelivDate << " | " << field.BasisPrice << " | " <<
        field.StrikePrice << " | " << field.MaxMarketOrderVolume << " | " << field.MinMarketOrderVolume << " | " << field.MaxLimitOrderVolume << " | " << field.MinLimitOrderVolume << " | " <<
        field.PriceTick << " | " << field.LastPrice << " | " << field.SettlementPrice << " | " << field.UpperLimitPrice << " | " << field.LowerLimitPrice << std::endl << std::endl;

    printf("同步查询 - 获取合约信息 - 按InstrumentID获取InstrumentNo\n");
    int instrumentNo = 0;
    _api->GetInstrumentNo(_instrumentid, instrumentNo);
    std::cout << "---" << _instrumentid << std::endl;
    std::cout << instrumentNo << std::endl << std::endl;
}

void CExampleSpi::getGetRate()
{
    printf("同步查询 - 获取手续费率信息 - 获取所有手续费率列表\n");
    TdRspQryRateFieldList output;
    output.clear();
    // _api->GetRateList(output);
    // for (TdRspQryRateFieldList::iterator iter = output.begin(); iter != output.end(); iter++)
    // {
    //     std::cout << iter->ClientNo << " | "
    //         << iter->ClientId << " | "
    //         << iter->InstrumentNo << " | "
    //         << iter->InstrumentId << " | "         ///合约代码
    //         << iter->OpenByMoney << " | "          //开仓手续费率
    //         << iter->OpenByVolume << " | "         //开仓手续费
    //         << iter->CloseByMoney << " | "         //平仓手续费率
    //         << iter->CloseByVolume << " | "        //平仓手续费
    //         << iter->CloseTodayByMoney << " | "    //平今手续费率
    //         << iter->CloseTodayByVolume << " | "   //平今手续费
    //         << iter->OpenMax << " | "              //开仓最大
    //         << iter->OpenMin << " | "              //开仓最小
    //         << iter->CloseMax << " | "             //平仓最大
    //         << iter->CloseMin << " | " << std::endl << std::endl;           //平仓最小
    // }

    CTdRspQryRateField rate = { 0 };
    printf("同步查询 - 获取手续费率信息 - 按交易编码、合约号获取手续费率\n");
    _api->GetRateInfo(_clientid, _instrumentid, rate);
    std::cout << "---" << _clientid << _instrumentid << std::endl;
    std::cout << rate.ClientNo << " | " << rate.ClientId << " | " << rate.InstrumentNo << " | " << rate.InstrumentId << " | " << rate.OpenByMoney << " | "
        << rate.OpenByVolume << " | " << rate.CloseByMoney << " | " << rate.CloseByVolume << " | " << rate.CloseTodayByMoney << " | " << rate.CloseTodayByVolume << " | "
        << rate.OpenMax << " | " << rate.OpenMin << " | " << rate.CloseMax << " | " << rate.CloseMin << " | " << std::endl << std::endl;

    printf("同步查询 - 获取手续费率信息 - 按clientNo、InstrumentNo获取手续费率\n");
    rate = { 0 };
    _api->GetRateInfo(_clientno, _instrumentno, rate);
    std::cout << "---" << _clientno << _instrumentno << std::endl;
    std::cout << rate.ClientNo << " | " << rate.ClientId << " | " << rate.InstrumentNo << " | " << rate.InstrumentId << " | " << rate.OpenByMoney << " | "
        << rate.OpenByVolume << " | " << rate.CloseByMoney << " | " << rate.CloseByVolume << " | " << rate.CloseTodayByMoney << " | " << rate.CloseTodayByVolume << " | "
        << rate.OpenMax << " | " << rate.OpenMin << " | " << rate.CloseMax << " | " << rate.CloseMin << " | " << std::endl << std::endl;
}

void CExampleSpi::getGetOptMargi()
{
    /// <summary>
    /// 获取期权保证金率
    /// </summary>
    // printf(" 11 同步查询 - 获取期权保证金率信息 - 获取所有期权保证金率列表\n");
    // TdRspQryOptMarginFieldList output;
    // output.clear();
    // _api->GetOptMarginList(output);
    // for (TdRspQryOptMarginFieldList::iterator iter = output.begin(); iter != output.end(); iter++)
    //     std::cout << iter->ClientNo << " | " << iter->ClientId << " | " << iter->InstrumentNo << " | " << iter->InstrumentId << " | "
    //     << iter->Param1 << " | " << iter->Param2 << " | " << iter->MarginRate << " | " << std::endl << std::endl;

    printf("同步查询 - 获取期权保证金率信息 - 按交易编码、合约号获取期权保证金率\n");
    CTdRspQryOptMarginField margin = { 0 };
    _api->GetOptMarginInfo(_clientid, _instrumentid, margin);
    std::cout << "---" << _clientid << _instrumentid << std::endl;
    std::cout << margin.ClientNo << " | " << margin.ClientId << " | " << margin.InstrumentNo << " | " << margin.InstrumentId << " | "
        << margin.Param1 << " | " << margin.Param2 << " | " << margin.MarginRate << " | " << std::endl << std::endl;

    printf("同步查询 - 获取期权保证金率信息 - 按clientNo、InstrumentNo获取期权保证金率\n");
    margin = { 0 };
    _api->GetOptMarginInfo(_clientno, _instrumentno, margin);
    std::cout << "---" << _clientno << _instrumentno << std::endl;
    std::cout << margin.ClientNo << " | " << margin.ClientId << " | " << margin.InstrumentNo << " | " << margin.InstrumentId << " | "
        << margin.Param1 << " | " << margin.Param2 << " | " << margin.MarginRate << " | " << std::endl << std::endl;


    /// <summary>
    /// 获取期货保证金率
    /// </summary>
    // printf(" 14 同步查询 - 获取期货保证金率信息 - 获取所有期货保证金率列表\n");
    // TdRspQryFutMarginFieldList output2;
    // output2.clear();
    // _api->GetFutMarginList(output2);
    // for (TdRspQryFutMarginFieldList::iterator iter = output2.begin(); iter != output2.end(); iter++)
    //     std::cout << iter->ClientNo << " | " << iter->ClientId << " | " << iter->InstrumentNo << " | " << iter->InstrumentId << " | "
    //     << iter->LongbyMoney << " | " << iter->LongbyVolume << " | " << iter->ShortbyMoney << " | " << iter->ShortbyVolume << " | " << std::endl << std::endl;

    printf("同步查询 - 获取期货保证金率信息 - 按交易编码、合约号获取期货保证金率\n");
    CTdRspQryFutMarginField margin2 = { 0 };
    _api->GetFutMarginInfo(_clientid, _instrumentid, margin2);
    std::cout << "---" << _clientid << _instrumentid << std::endl;
    std::cout << margin2.ClientNo << " | " << margin2.ClientId << " | " << margin2.InstrumentNo << " | " << margin2.InstrumentId << " | "
        << margin2.LongbyMoney << " | " << margin2.LongbyVolume << " | " << margin2.ShortbyMoney << " | " << margin2.ShortbyVolume << " | " << std::endl << std::endl;

    printf("同步查询 - 获取期货保证金率信息 - 按clientNo、InstrumentNo获取期货保证金率\n");
    margin2 = { 0 };
    _api->GetFutMarginInfo(_clientno, _instrumentno, margin2);
    std::cout << "---" << _clientno << _instrumentno << std::endl;
    std::cout << margin2.ClientNo << " | " << margin2.ClientId << " | " << margin2.InstrumentNo << " | " << margin2.InstrumentId << " | "
        << margin2.LongbyMoney << " | " << margin2.LongbyVolume << " | " << margin2.ShortbyMoney << " | " << margin2.ShortbyVolume << " | " << std::endl << std::endl;
}

void CExampleSpi::getGetAccount()
{
    printf("同步查询 - 获取资金信息(非实时)\n");
    CTdRspQryAccountField output;
    _api->GetAccount((char*)USERID, output);
    printf("获取资金:AccountId:%s|Prebalance:%lf|DistribFund:%lf|Balance:%lf|Commi:%lf|FutMargin:%lf|OptMargin:%lf|CombMargin:%lf|CloseProfit:%lf|"
        "PosiProfit:%lf|Premium:%lf|Deposit:%lf|Withdraw:%lf|FrozenMargin:%lf|FrozenPremium:%lf|FrozenCommi:%lf|EntryFees:%lf|BuyPremium:%lf\n\n",
        output.AccountId, output.Prebalance, output.DistribFund, output.Balance, output.Commi, output.FutMargin, output.OptMargin,
        output.CombMargin, output.CloseProfit, output.PosiProfit, output.Premium, output.Deposit, output.Withdraw, output.FrozenMargin, output.FrozenPremium,
        output.FrozenCommi, output.EntryFees, output.BuyPremium);
}
