﻿/*  TiExampleInit.cpp
*   交易初始化DEMO
*
*   TITD初始化连接为Init函数，该函数有两种实现方式：通过配置文件初始化，通过函数参数初始化。
*   具体调用示例，请参考本文件。
*
*   Init函数指定了用户使用TITD的各项参数配置，包括网卡类型、地址，公有流、私有流接收方式，绑定的cpuid等。
*   Init函数中指定的UserId用于API自动产生跟用户名相关的三个文件**Private.con、**Public.con、**TraderApiresume.con，记录交易中需要本地记录的内容。
*       真正报撤单等交易中用到的UserId，为ReqUserLogin中指定的UserId。
*       用户使用时，请将这两个UserId设成同一个。
*   Init发出，即表示发送了连接请求。若连接成功，用户会收到OnConnected。
*
*/
#include "TiExample.h"

void CExampleSpi::AUTHER()
{
    userauthen();
}

void CExampleSpi::TESTINIT()
{
                            //initFromIni、initFromParam两种初始化方式任选其一
    //initFromIni();          //api初始化 - 通过配置文件       无对应的应答       如连接成功, 有通知OnConnected
    initFromParam();      //api初始化 - 通过函数参数       无对应的应答       如连接成功, 有通知OnConnected
}

void CExampleSpi::userauthen()
{
    CTdReqUserAuthenField req={0};
    strcpy(req.UserId, USERID);          // 交易用户代码
    strcpy(req.Password, PASSWORD);          // 交易用户代码

    int iRet = _api->ReqUserAuthentication(&req, _requestID++);
    printf("userauthen,requestID:%d|ret:%d\n\n", _requestID - 1, iRet);
}

///用户验证应答
void CExampleSpi::OnRspUserAuthentication(CTdRspUserAuthenField& pUserInfo, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("OnRspUserAuthentication:%s\n\n", pUserInfo.UserId);
}

void CExampleSpi::initFromIni()
{
    int iRet = _api->Init("./demo/titdapi.ini");
    printf("initFromIni, ret:%d\n\n", iRet);
}

void CExampleSpi::initFromParam()
{
    CTdConfigInfoField cfgInfo = { 0 };
    strcpy(cfgInfo.UserId, USERID);           // 交易用户代码(该用户名和登录时用的用户名相同)
    cfgInfo.NicType = 1;                    // 网卡类型; 目前系统支持以下几种; 1:普通socket;2:Solarflare; 3:Exablaze;
    strcpy(cfgInfo.SendNicName, "");        // 发送请求的网卡名称(可以与RecvNicName一样)
    strcpy(cfgInfo.RecvNicName, "");        // 接收请求的网卡名称(可以与SendNicName一样)
    strcpy(cfgInfo.RecvNicIp, RECVIP);      // 接收请求的网卡IP
    cfgInfo.RecvNicPort = 0;                // 接收请求的网卡端口(如果不设置系统会自动分配端口进行数据接收)
    cfgInfo.SubPrivateType = 2;             // 私有流订阅模式
    cfgInfo.SubPublicType = 0;              // 公共流订阅模式
    strcpy(cfgInfo.FrontAddress, FRONTADD);   // 交易服务器网络地址
    cfgInfo.RecvDataCpuId = -1;              // 接收网络数据的线程cpuid(-1不绑定cpu)
    cfgInfo.DealDataCpuId = -1;              // 处理网络数据的线程cpuid(-1不绑定cpu)
    cfgInfo.MaxRecvDataSize = 512;          // 接收数据缓存的大小(单位为M,如果不填入默认大小为512M)
    cfgInfo.IsLog = 1;                      // 是否记录日志
    cfgInfo.timeOut = 3;                    // 超时时间默认为3秒
    cfgInfo.LockFree = 1;                   // 设置成无锁
    int iRet = _api->Init(cfgInfo);

    printf("\n");
    printf("Init from struct\n");
    printf("UserId: %s ", cfgInfo.UserId);              printf("交易用户代码(该用户名和登录时用的用户名相同\n");
    printf("NicType: %d ",cfgInfo.NicType);             printf("网卡类型; 目前系统支持以下几种; 1:普通socket;2:Solarflare; 3:Exablaze\n");
    printf("SendNicName: %s ", cfgInfo.SendNicName);    printf("发送请求的网卡名称,可以与RecvNicName一样\n");
    printf("RecvNicName: %s ", cfgInfo.RecvNicName);    printf("接收应答的网卡名称,可以与SendNicName一样\n");
    printf("RecvNicIp: %s ", cfgInfo.RecvNicIp);        printf("接收应答的网卡IP\n");
    printf("RecvNicPort: %d ", cfgInfo.RecvNicPort);    printf("接收应答的网卡端口,如果不设置系统会自动分配端口进行数据接收\n");
    printf("SubPrivateType: %d ", cfgInfo.SubPrivateType);        printf("私有流订阅模式\n");
    printf("                         0:不订阅私有流\n");
    printf("                         1:从本交易日开始重传\n");
    printf("                         2:从上次收到的续传\n");
    printf("                         3:只传送登录后私有流的内容\n");
    printf("SubPublicType: %d ", cfgInfo.SubPublicType);         printf("公共流订阅模式\n");
    printf("                         0:不订阅公有流\n");
    printf("                         3:订阅公有流\n");
    printf("FrontAddress: %s ", cfgInfo.FrontAddress);          printf("交易服务器网络地址\n");
    printf("网络地址的格式为：“protocol://ipaddress:port”，如：”tcp://127.0.0.1:17001”。\n");
    printf("“tcp”代表传输协议，“127.0.0.1”代表服务器地址。”17001”代表服务器端口号。\n");
    printf("RecvDataCpuId: %d ", cfgInfo.RecvDataCpuId);         printf("接收网络数据的线程cpuid, -1不绑定cpu\n");
    printf("DealDataCpuId: %d ", cfgInfo.DealDataCpuId);         printf("处理网络数据的线程cpuid, -1不绑定cpu\n");
    printf("MaxRecvDataSize: %d ", cfgInfo.MaxRecvDataSize);     printf("接收数据缓存的大小,单位为M,如果不填入默认大小为512M\n");
    printf("IsLog: %d ", cfgInfo.IsLog);                printf("是否记录日志\n");
    printf("timeOut: %d ", cfgInfo.timeOut);  printf("超时时间默认为3秒\n");
    printf("LockFree: %d \n", cfgInfo.LockFree);
    printf("\n");
    
    printf("Req Init return:%d\n\n", iRet);
}

void CExampleSpi::OnConnected()
{
    printf("OnConnected\n\n");
    _bIsConnet = true;
}

void CExampleSpi::OnDisconnected(int nReason)
{
    printf("OnDisconnected:%#x\n\n", nReason);
}
