﻿/*  TiExampleLogin.cpp
*   客户登录、登出、密码更新DEMO
*/
#include "TiExample.h"

void CExampleSpi::TESTLOGIN()
{
    login();               //客户登录    对应应答为OnRspUserLogin        
    // logout();              //客户登出    对应应答为OnRspUserLogout
    // updatepwd();           //更新密码    对应应答为OnRspUserPasswordUpdate
}

void CExampleSpi::login()
{
    CTdReqUserLoginField req = { 0 };
    strcpy(req.UserId, USERID);			    // 交易用户代码
    strcpy(req.Password, PASSWORD);		    // 密码
    strcpy(req.ProtocolInfo, "");		    // 协议信息
    strcpy(req.UserProductInfo, "");		// 用户端产品信息
    strcpy(req.AppId, APPID);		// appid
    strcpy(req.AppIdIdentify, AUTHCODE);// appid验证码
    int iRet = _api->ReqUserLogin(&req, _requestID++);
    printf("ReqUserLogin: requestID:%d|ret:%d\n", _requestID - 1, iRet);
    printf("ReqUserLogin: UserId:%s|Password:%s|ProtocolInfo:%s|UserProductInfo:%s|AppId:%s|AppIdIdentify:%s\n\n", 
    req.UserId,          // 交易用户代码
    req.Password,        // 密码    
    req.ProtocolInfo,    // 协议信息    
    req.UserProductInfo, // 用户端产品信息        
    req.AppId,           // appid    
    req.AppIdIdentify);   // appid验证码
}

void CExampleSpi::OnRspUserLogin(CTdRspUserLoginField& pRspUserLogin, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("OnRspUserLogin:%d|errorid:%d|SessionNo:%d|最新SequenceNo:%d|TradingDay:%s|LoginTime:%d|MaxLocalOrderNo:%d|UserId:%s|tradingSystemName:%s|ActionDay:%s\n\n",
        nRequestID, pRspInfo.ErrorId, pRspUserLogin.SessionNo, pRspUserLogin.SequenceNo,
        pRspUserLogin.TradingDay,        // 交易日
        pRspUserLogin.LoginTime,         // 登录成功时间
        pRspUserLogin.MaxLocalOrderNo,   // 最大会员内部订单编号
        pRspUserLogin.UserId,            // 交易用户代码
        pRspUserLogin.TradingSystemName, // 交易系统名称
        pRspUserLogin.ActionDay);        // 业务发生日期);

    _lastPrvSequenceNo = pRspUserLogin.SequenceNo;
    _LocalOrderNo = pRspUserLogin.MaxLocalOrderNo;

    char s[100];
    time_t rawtime = pRspUserLogin.LoginTime;
    struct tm* timeinfo = localtime(&rawtime);
    strftime(s, sizeof(s), "%Y-%m-%d %H:%M:%S", timeinfo);
    printf("登录时间:%s\n\n", s);

    if (0 == pRspInfo.ErrorId)
    {
    	_bIsLogin = true;
    }
}

void CExampleSpi::logout()
{
    int iRet = _api->ReqUserLogout(_requestID++);
    printf("ReqUserLogout:%d|ret:%d",
    _requestID - 1, iRet);
}

void CExampleSpi::OnRspUserLogout(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("OnRspUserLogout:RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d\n\n",
    nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast);
}

void CExampleSpi::updatepwd()
{
    CTdUserPasswordUpdateField req = { 0 };
    strcpy(req.OldPassword, "123456");
    strcpy(req.NewPassword, "123456");
    int iRet = _api->ReqUserPasswordUpdate(&req, _requestID++);
    printf("请求密码更新:%d|ret:%d|OldPassword:%s|NewPassword:%s\n\n", 
    _requestID - 1, iRet,
    req.OldPassword,
    req.NewPassword);
}


void CExampleSpi::OnRspUserPasswordUpdate(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("OnRspUserPasswordUpdate:%d|errorid:%d|ErrorMsg:%s\n\n", 
    nRequestID, 
    pRspInfo.ErrorId, 
    pRspInfo.ErrorMsg);
}
