﻿/*  TiExampleOrder.cpp
*   报单DEMO
*
*   TITD报单、撤单区分Stock接口，Options接口。
*   Stock接口，    用于上交所、深交所股票现货报单
*   Options接口，  用于四大期货交易所的期货、期权品种，以及上交所、深交所期权品种。
*
*   报单请求和应答中常见序号的说明如下：
*   1、requestID：    TITD不做非重复性与递增要求，该值由客户自行维护，Rsp或Rtn中原样返回请求中的值，Rtn中对应名字为RequestNo。
*   2、LocalOrderNo： LocalOrderNo有两种选择，客户维护改字段或不维护改字段。
*                     ① 若维护该字段，可以用LocalOrderNo撤单，在请求到达交易所之前就能撤单。
*                        要求在本session内唯一且递增，OnRspUserLogin中返回的MaxLocalOrderNo为本次登录后的最小LocalOrderNo值，要求在此基础上递增。
*                     ② 若不维护该字段，则直接填0。此时不能用LocalOrderNo撤单。
*                     Rsp或Rtn中原样返回请求中的值。若非本系统订单，该值返回给客户统一为0。
*   3、FrontNo：      FrontNo发送选择：
*                     ① 指定席位。从GetFrontList获取当前TITD系统可连接席位，从中选择一个席位，下单时指定。
*                     ② 不指定席位。填0或者不填该值，TITD分配报单席位。
*                     返回实际处理席位。特殊情况：处理的席位非当前TITD系统所用的席位，如非TITD系统下单席位统一为1。
*   4、SequenceNo：   私有流序号，报单请求中不指定。
*                     私有流号统一编码，当日交易日内针对UserID从1开始递增且连续，若不连续表示丢包。SequenceNo每交易日清空，OnRspUserLogin中会返回上一私有流序号。
*   5、SessionNo：    Rtn中返回对应的原始报单请求发出的SessionNo，若非TITD系统报单，则统一为0。
*   6、UserId：       Rtn中返回对应的原始报单或撤单请求发出的UserId，若非TITD系统报单，则统一为0。
*                     注意：若当前为“已撤单”委托回报，且报单和撤单非同一UserId，则“已撤单”状态的Rtn中返回的为报单请求发出的UserId。
*/
#include "TiExample.h"

void CExampleSpi::TESTORDER()
{
#ifdef TESTFUT_OPT
    optionOrderInsert();         //期权报单             对应应答为OnRspOptionsInsert(报单有错误才应答)      对应的通知OnRtnOptionsOrder、OnRtnOptionsTrade
    sleep(1);
    optionOrderCancel();         //期权报单撤销         对应应答为OnRspOptionsCancel(报单撤销有错误才应答)  对应的通知OnRtnOptionsOrder
#endif

#ifdef TESTSTOCK
    stockOrderInsert();          //报单报单             对应应答为OnRspStockInsert(报单有错误才应答)       对应的通知OnRtnStockOrder、OnRtnStockTrade
    sleep(1);
    stockOrderCancel();          //股票报单撤销         对应应答为OnRspStockCancel(报单撤销有错误才应答)    对应的通知OnRtnStockOrder
    sleep(1);
    businessOrderInsert();       //股票非交易业务报单    对应应答为OnRspBusinessInsert(报单有错误才应答)    对应的通知OnRtnBusinessOrder、OnRtnBusinessTrade
    sleep(1);
    businessOrderCancel();       //股票非交易业务撤销    对应应答为OnRspBusinessCancel(报单有错误才应答)    对应的通知OnRtnBusinessOrder
#endif
}

//期货、期权报单
void CExampleSpi::optionOrderInsert()
{
    CTdOrderInsertReqField req = { 0 };

    req.ClientNo = _clientno;			// 交易编码序号
    req.InstrumentNo = _instrumentno;	            // 合约序号
    req.LocalOrderNo = _LocalOrderNo++;	// 会员内部订单编号
    req.PriceType = TD_PriceType_Market;	// 报单价格条件限价单,事价单等
    req.Side = TD_SIDE_Buy;				// 买卖方向
    req.OffsetFlag = TD_OC_Open;		// 开平标记
    req.HedgeFlag = TD_HF_Speculation;	// 投机套保标记
    req.TimeInForce = TD_TimeInForce_IOC;// 订单有效时间类型
    req.CoveredOrUncovered = TD_Covered_Uncovered;//备兑标签
    req.VolumeCondition = TD_VC_AV;     //成交量类型
    req.TrigCondition = TD_CC_Immediately;	//触发条件
    req.Volume = 1;				        //数量
    req.MinVolume = 0;				    //最小成交量
    req.Price = 0.045;					//价格
    req.StopPrice = 0;				    //止损价
    req.OwnerType = TD_OWNER_Per;		//订单所有类型
    req.ExchangeId = _exchangeid;	        //交易所代码
    req.FrontNo = 0;			        //不选席位填0

    int iRet = _api->ReqOptionsInsert(&req, _requestID++);
    printf("ReqOptionsInsert(期货、期权报单请求), requestID:%d|ret:%d\n", _requestID - 1, iRet);
    printf("ReqOptionsInsert(期货、期权报单请求), ClientNo:%d|InstrumentNo:%d|LocalOrderNo:%d|PriceType:%d|Side:%d|OffsetFlag:%d|HedgeFlag:%d|TimeInForce:%d|"
    "CoveredOrUncovered:%d|VolumeCondition:%d|TrigCondition:%d|Volume:%d|MinVolume:%d|Price:%lf|StopPrice:%lf|OwnerType:%d|ExchangeId:%d|FrontNo:%d\n",
     req.ClientNo,            // 交易编码序号
     req.InstrumentNo,        // 合约序号
     req.LocalOrderNo,        // 会员内部订单编号
     req.PriceType,           // 报单价格条件
     req.Side,                // 买卖方向
     req.OffsetFlag,          // 开平标记
     req.HedgeFlag,           // 投机套保标记
     req.TimeInForce,         // 订单有效时间类型
     req.CoveredOrUncovered, //备兑标签
     req.VolumeCondition,    //成交量类型
     req.TrigCondition,        //触发条件
     req.Volume,               //数量
     req.MinVolume,            //最小成交量
     req.Price,                //价格
     req.StopPrice,            //止损价
     req.OwnerType,            //订单所有类型
     req.ExchangeId,           //交易所代码
     req.FrontNo);              // 处理本次报单的席位序号
                                                    ///  当所填的序号在系统中不存在时系统会优选最佳席位进行报单,否则,根据用户所选席位进行报单
}

void CExampleSpi::OnRspOptionsInsert(CTdOrderInsertRspField& pOptionsInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("OnRspOptionsInsert(期货、期权报单响应):RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
    "ClientNo:%d|InstrumentNo:%d|LocalOrderNo:%d|PriceType:%d|"
    "Side:%d|OffsetFlag:%d|HedgeFlag:%d|TimeInForce:%d|CoveredOrUncovered:%d|VolumeCondition:%d|TrigCondition:%d|Volume:%d|MinVolume:%d|Price:%lf|StopPrice:%lf|"
    "OwnerType:%d|ExchangeId:%d|FrontNo:%d|SessionNo:%d|OrderSysId:%s\n",
    nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
    pOptionsInsert.ClientNo,        //交易编码序号
    pOptionsInsert.InstrumentNo,    //合约序号
    pOptionsInsert.LocalOrderNo,    //会员内部订单编号
    pOptionsInsert.PriceType,       //报单价格条件
    pOptionsInsert.Side,            //买卖方向
    pOptionsInsert.OffsetFlag,      //开平标记
    pOptionsInsert.HedgeFlag,       //投机套保标记
    pOptionsInsert.TimeInForce,     //订单有效时间类型
    pOptionsInsert.CoveredOrUncovered,    //备兑标签
    pOptionsInsert.VolumeCondition,       //成交量类型
    pOptionsInsert.TrigCondition,    //触发条件
    pOptionsInsert.Volume,           //数量
    pOptionsInsert.MinVolume,        //最小成交量
    pOptionsInsert.Price,            //价格
    pOptionsInsert.StopPrice,        //止损价
    pOptionsInsert.OwnerType,        //订单所有类型
    pOptionsInsert.ExchangeId,       //交易所代
    pOptionsInsert.FrontNo,          //处理本次报单的实际席位序号
    pOptionsInsert.SessionNo,        //发送该报单的session
    pOptionsInsert.OrderSysId);       //交易所订单编号
}

void CExampleSpi::OnRtnOptionsOrder(CTdOptionsOrderRtnField& pOrder)
{
    if (1 != pOrder.SequenceNo - _lastPrvSequenceNo)
    {
        printf("!!!!!err seq:%d|new:%d|old:%d|\n", __LINE__, pOrder.SequenceNo, _lastPrvSequenceNo);
    }

    _lastPrvSequenceNo = pOrder.SequenceNo;
    printf("期货、期权委托通知 - OnRtnOptionsOrder: SequenceNo:%d\n", pOrder.SequenceNo);
    printf("FrontNo:%d,RequestNo:%d,SessionNo:%d,ClientNo:%d,InstrumentNo:%d,"
        "ClientId:%s,InstrumentId:%s,ExchangeId:%d,UserId:%s,PriceType:%d,"
        "Side:%d,OffsetFlag:%d,HedgeFlag:%d,TimeInForce:%d,CoveredOrUncovered:%d,"
        "VolumeCondition:%d,TrigCondition:%d,Volume:%d,MinVolume:%d,Price:%lf,StopPrice:%lf,"
        "OwnerType:%d,TransTime:%d,LeavesVolume:%d,CancelVolume:%d\n"
        "---SequenceNo:%d, OrderSysId:%s, OrdStatus:%d, LocalOrderNo:%d----\n",
        pOrder.FrontNo, pOrder.RequestNo, pOrder.SessionNo, pOrder.ClientNo, pOrder.InstrumentNo,
        pOrder.ClientId, pOrder.InstrumentId, pOrder.ExchangeId, pOrder.UserId, pOrder.PriceType,
        pOrder.Side, pOrder.OffsetFlag, pOrder.HedgeFlag, pOrder.TimeInForce, pOrder.CoveredOrUncovered,
        pOrder.VolumeCondition, pOrder.TrigCondition, pOrder.Volume, pOrder.MinVolume, pOrder.Price, pOrder.StopPrice,
        pOrder.OwnerType, pOrder.OrderTime, pOrder.LeavesVolume, pOrder.CancelVolume,
        pOrder.SequenceNo, pOrder.OrderSysId, pOrder.OrdStatus, pOrder.LocalOrderNo);
}

void CExampleSpi::OnRtnOptionsTrade(CTdOptionsTradeRtnField& pTrade)
{
    if (1 != pTrade.SequenceNo - _lastPrvSequenceNo)
    {
        printf("!!!!!err seq:%d|new:%d|old:%d|\n", __LINE__, pTrade.SequenceNo, _lastPrvSequenceNo);
    }

    _lastPrvSequenceNo = pTrade.SequenceNo;
    printf("期货、期权成交通知 - OnRtnOptionsTrade: SequenceNo:%d\n", pTrade.SequenceNo);
    printf("FrontNo:%d,SequenceNo:%d,SessionNo:%d,ClientNo:%d,InstrumentNo:%d,"
        "ClientId:%s,InstrumentId:%s,ExchangeId:%d,PriceType:%d,Side:%d,"
        "OffsetFlag:%d,HedgeFlag:%d,TimeInForce:%d,CoveredOrUncovered:%d,VolumeCondition:%d,"
        "TrigCondition:%d,OwnerType:%d,TradePrice:%lf,TradeVolume:%d,LeavesVolume:%d,TradeTime:%d,UserId:%s\n"
        "---RequestNo:%d,OrderSysId:%s,TradeId:%s,LocalOrderNo:%d---\n\n",
        pTrade.FrontNo, pTrade.SequenceNo, pTrade.SessionNo, pTrade.ClientNo, pTrade.InstrumentNo,
        pTrade.ClientId, pTrade.InstrumentId, pTrade.ExchangeId, pTrade.PriceType, pTrade.Side,
        pTrade.OffsetFlag, pTrade.HedgeFlag, pTrade.TimeInForce, pTrade.CoveredOrUncovered, pTrade.VolumeCondition,
        pTrade.TrigCondition, pTrade.OwnerType, pTrade.TradePrice, pTrade.TradeVolume, pTrade.LeavesVolume, pTrade.TradeTime, pTrade.UserId,
        pTrade.RequestNo, pTrade.OrderSysId, pTrade.TradeId, pTrade.LocalOrderNo);
}

//期权撤销
void CExampleSpi::optionOrderCancel()
{
    CTdOrderCancelReqField req = { 0 };

    req.OriSessionNo = 3842;			            //原始报单的sessionno如果是通过LocalOrderNo撤单，需要填写，不填写则默认撤销本次登录后的LocalOrderNo
    req.OriLocalOrderNo = 2;			            //原始交易客户方订单编号
    strcpy(req.OrderSysId, "852341");				//交易所订单编号(OrigLocalOrderNo和OrderSysId任意一个即可)

    int iRet = _api->ReqOptionsCancel(&req, _requestID++);
    printf("ReqOptionsCancel(期货、期权撤单请求), requestID:%d|ret:%d\n", _requestID - 1, iRet);
    printf("ReqOptionsCancel(期货、期权撤单请求), OriSessionNo:%d|OriLocalOrderNo:%d|OrderSysId:%s\n\n",
    req.OriSessionNo,        //原始报单的sessionno如果是通过LocalOrderNo撤单，需要填写，不填写则默认撤销本次登录后的LocalOrderNo
    req.OriLocalOrderNo,     //原始交易客户方订单编号
    req.OrderSysId);         //交易所订单编号(OrigLocalOrderNo和OrderSysId任意一个即可，当OriLocalOrderNo、OrderSysId都填写时，以OriLocalOrderNo为准)
}

void CExampleSpi::OnRspOptionsCancel(CTdOrderCancelRspField& pOptionsCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("OnRspOptionsCancel(期货、期权撤单响应):RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
        "OriSessionNo:%d|OriLocalOrderNo:%d|OrderSysId:%s|SessionNo:%d\n\n", 
    nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
    pOptionsCancel.OriSessionNo,        //原始报单的sessionno
    pOptionsCancel.OriLocalOrderNo,     //原始交易客户方订单编号
    pOptionsCancel.OrderSysId,          //交易所订单编号
    pOptionsCancel.SessionNo);           //发送该报单的session
}

//股票现货报单
void CExampleSpi::stockOrderInsert()
{
    CTdStockInsertReqField req = { 0 };
    req.ClientNo = _clientno;			//交易编码序号
    req.InstrumentNo = _instrumentno;	        //合约序号
    req.LocalOrderNo = _LocalOrderNo++; //会员内部订单编号
    req.PriceType = TD_PriceType_Limit; //报单价格条件
    req.Side = TD_SIDE_Buy;;            //买卖方向
    req.TimeInForce = TD_TimeInForce_GFD;//订单有效时间类型
    req.Volume = 100;                     //数量
    req.Price = 3.14;                   //价格
    req.OwnerType = TD_OWNER_Per;       //订单所有类型
    req.ExchangeId = _exchangeid;          //交易所代码
    req.FrontNo = 0;                    //不选席位填0
    int iRet = _api->ReqStockInsert(&req, _requestID++);

    printf("ReqStockInsert(股票报单请求), requestID:%d|ret:%d\n", _requestID - 1, iRet);
    printf("ReqStockInsert(股票报单请求), ClientNo:%d|InstrumentNo:%d|LocalOrderNo:%d|PriceType:%d|Side:%d|TimeInForce:%d|Volume:%d|Price:%lf|OwnerType:%d|ExchangeId:%d|FrontNo:%d\n\n",
    req.ClientNo,                   //交易编码序号
    req.InstrumentNo,               //合约序号
    req.LocalOrderNo,               //会员内部订单编号
    req.PriceType,                  //报单价格条件
    req.Side,                       //买卖方向
    req.TimeInForce,                //订单有效时间类型
    req.Volume,                     //数量
    req.Price,                      //价格
    req.OwnerType,                  //订单所有类型
    req.ExchangeId,                 //交易所代码
        ///处理本次报单的席位序号,当所填的序号在系统中不存在时系统会优选最佳席位进行报单,否则,根据用户所选席位进行报单
    req.FrontNo);
}

void CExampleSpi::OnRspStockInsert(CTdStockInsertRspField& pStockInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("OnRspStockInsert(股票报单响应):RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
    "ClientNo:%d|InstrumentNo:%d|LocalOrderNo:%d|PriceType:%d|Side:%d|TimeInForce:%d|Volume:%d|Price:%lf|OwnerType:%d|ExchangeId:%d|FrontNo:%d|SessionNo:%d|OrderSysId:%s\n\n",
        nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
        pStockInsert.ClientNo,                   //交易编码序号
        pStockInsert.InstrumentNo,               //合约序号
        pStockInsert.LocalOrderNo,               //会员内部订单编号
        pStockInsert.PriceType,                  //报单价格条件
        pStockInsert.Side,                       //买卖方向
        pStockInsert.TimeInForce,                //订单有效时间类型
        pStockInsert.Volume,                     //数量
        pStockInsert.Price,                      //价格
        pStockInsert.OwnerType,                  //订单所有类型
        pStockInsert.ExchangeId,                 //交易所代码
        pStockInsert.FrontNo,                    //处理本次报单的实际席位序号
        pStockInsert.SessionNo,                  //发送该报单的session
        pStockInsert.OrderSysId);                 //交易所订单编号
}

void CExampleSpi::OnRtnStockOrder(CTdStockOrderRtnField& pOrder)
{
    if (1 != pOrder.SequenceNo - _lastPrvSequenceNo)
    {
        printf("!!!!!err seq:%d|new:%d|old:%d|\n", __LINE__, pOrder.SequenceNo, _lastPrvSequenceNo);
    }

    _lastPrvSequenceNo = pOrder.SequenceNo;
    printf("股票委托通知 - OnRtnStockOrder: SequenceNo:%d\n", pOrder.SequenceNo);
    printf("FrontNo:%d,SequenceNo:%d,RequestNo:%d,SessionNo:%d,ClientNo:%d,InstrumentNo:%d,LocalOrderNo:%d,ClientId:%s,UserId:%s,InstrumentId:%s,ExchangeId:%d,"
        "PriceType:%d,Side:%d,TimeInForce:%d,OwnerType:%d,OrdStatus:%d,Price:%lf,Volume:%d,OrderTime:%d,OrderSysId:%s,LeavesVolume:%d,CancelVolume:%d\n\n",
        pOrder.FrontNo, pOrder.SequenceNo, pOrder.RequestNo, pOrder.SessionNo, pOrder.ClientNo, pOrder.InstrumentNo, pOrder.LocalOrderNo, pOrder.ClientId, pOrder.UserId,
        pOrder.InstrumentId, pOrder.ExchangeId, pOrder.PriceType, pOrder.Side, pOrder.TimeInForce, pOrder.OwnerType, pOrder.OrdStatus, pOrder.Price, pOrder.Volume,
        pOrder.OrderTime, pOrder.OrderSysId, pOrder.LeavesVolume, pOrder.CancelVolume);
}

void CExampleSpi::OnRtnStockTrade(CTdStockTradeRtnField& pTrade)
{
    if (1 != pTrade.SequenceNo - _lastPrvSequenceNo)
    {
        printf("!!!!!err seq:%d|new:%d|old:%d|\n", __LINE__, pTrade.SequenceNo, _lastPrvSequenceNo);
    }

    _lastPrvSequenceNo = pTrade.SequenceNo;
    printf("股票成交通知 - OnRtnStockTrade: SequenceNo:%d\n", pTrade.SequenceNo);
    printf("FrontNo:%d,SequenceNo:%d,RequestNo:%d,SessionNo:%d,ClientNo:%d,InstrumentNo:%d,LocalOrderNo:%d,ClientId:%s,InstrumentId:%s,ExchangeId:%d,Side:%d,TradePrice:%lf,"
        "TradeVolume:%d,LeavesVolume:%d,TradeTime:%d,OrderSysId:%s,TradeId:%s,UserId:%s\n\n",
        pTrade.FrontNo, pTrade.SequenceNo, pTrade.RequestNo, pTrade.SessionNo, pTrade.ClientNo, pTrade.InstrumentNo, pTrade.LocalOrderNo, pTrade.ClientId, pTrade.InstrumentId,
        pTrade.ExchangeId, pTrade.Side, pTrade.TradePrice, pTrade.TradeVolume, pTrade.LeavesVolume, pTrade.TradeTime, pTrade.OrderSysId, pTrade.TradeId, pTrade.UserId);
}

//股票报单撤销
void CExampleSpi::stockOrderCancel()
{
    CTdOrderCancelReqField req = { 0 };

    req.OriSessionNo = 3842;			            //原始报单的sessionno如果是通过LocalOrderNo撤单，需要填写，不填写则默认撤销本次登录后的LocalOrderNo
    req.OriLocalOrderNo = 2;			            //原始交易客户方订单编号
    strcpy(req.OrderSysId, "852341");				//交易所订单编号(OrigLocalOrderNo和OrderSysId任意一个即可)

    int iRet = _api->ReqStockCancel(&req, _requestID++);
    printf("ReqStockCancel(股票撤单请求), requestID:%d|ret:%d\n", _requestID - 1, iRet);
    printf("ReqStockCancel, OriSessionNo:%d|OriLocalOrderNo:%d|OrderSysId:%s\n\n",
    req.OriSessionNo,        //原始报单的sessionno如果是通过LocalOrderNo撤单，需要填写，不填写则默认撤销本次登录后的LocalOrderNo
    req.OriLocalOrderNo,     //原始交易客户方订单编号
    req.OrderSysId);         //交易所订单编号(OrigLocalOrderNo和OrderSysId任意一个即可，当OriLocalOrderNo、OrderSysId都填写时，以OriLocalOrderNo为准)
}
	
void CExampleSpi::OnRspStockCancel(CTdOrderCancelRspField& pStockCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("OnRspStockCancel(股票撤单响应):RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
        "OriSessionNo:%d|OriLocalOrderNo:%d|OrderSysId:%s|SessionNo:%d\n\n", 
    nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
    pStockCancel.OriSessionNo,        //原始报单的sessionno
    pStockCancel.OriLocalOrderNo,     //原始交易客户方订单编号
    pStockCancel.OrderSysId,          //交易所订单编号
    pStockCancel.SessionNo);           //发送该报单的session
}

//股票非交易业务报单
void CExampleSpi::businessOrderInsert()  
{
    CTdBusinessInsertReqField req = { 0 };

    req.BusinessType = TD_Business_SseCRP;              //业务类型
    req.ClientNo = _clientno;                           //交易编码序号
    strcpy(req.InstrumentId, "204001");                 //合约代码
    req.LocalOrderNo = _LocalOrderNo++;                 //会员内部订单编号
    req.Side = TD_SIDE_Sell;                            //买卖方向
    req.Volume = 1000;                                  //数量
    req.Price = 1.0;                                    //价格
    req.ExchangeId = TD_Exchange_Sse;                   //交易所代码
    strcpy(req.DestInstrumentId, "");                   //目标合约代码

    int iRet = _api->ReqBusinessInsert(&req, _requestID++);

    printf("ReqBusinessInsert(股票非交易业务报单请求): requestID:%d|ret:%d\n", _requestID - 1, iRet);
    printf("ReqBusinessInsert(股票非交易业务报单请求): BusinessType:%d|ClientNo:%d|InstrumentId:%s|LocalOrderNo:%d|Side:%d|Volume:%d|Price:%lf|ExchangeId:%d|DestInstrumentId:%s\n\n",
    req.BusinessType,                       //业务类型
    req.ClientNo,                           //交易编码序号
    req.InstrumentId,                       //合约代码
    req.LocalOrderNo,                       //会员内部订单编号
    req.Side,                               //买卖方向
    req.Volume,                             //数量
    req.Price,                              //价格
    req.ExchangeId,                         //交易所代码
    req.DestInstrumentId);                  //目标合约代码);
}

//股票非交易业务撤销
void CExampleSpi::businessOrderCancel()
{
    CTdOrderCancelReqField req = { 0 };

    req.OriSessionNo = 3842;			            //原始报单的sessionno如果是通过LocalOrderNo撤单，需要填写，不填写则默认撤销本次登录后的LocalOrderNo
    req.OriLocalOrderNo = 2;			            //原始交易客户方订单编号
    strcpy(req.OrderSysId, "852341");				//交易所订单编号(OrigLocalOrderNo和OrderSysId任意一个即可)

    int iRet = _api->ReqBusinessCancel(&req, _requestID++);
    printf("ReqStockCancel(股票非交易业务撤单请求), requestID:%d|ret:%d\n", _requestID - 1, iRet);
    printf("ReqStockCancel, OriSessionNo:%d|OriLocalOrderNo:%d|OrderSysId:%s\n\n",
    req.OriSessionNo,        //原始报单的sessionno如果是通过LocalOrderNo撤单，需要填写，不填写则默认撤销本次登录后的LocalOrderNo
    req.OriLocalOrderNo,     //原始交易客户方订单编号
    req.OrderSysId);         //交易所订单编号(OrigLocalOrderNo和OrderSysId任意一个即可，当OriLocalOrderNo、OrderSysId都填写时，以OriLocalOrderNo为准)
}  

///股票非交易业务报单应答
void CExampleSpi::OnRspBusinessInsert(CTdBusinessInsertRspField& pStockInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("OnRspBusinessInsert(股票非交易业务报单响应): RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
    "BusinessType:%d|ClientNo:%d|InstrumentId:%s|LocalOrderNo:%d|Side:%d|Volume:%d|Price:%lf|ExchangeId:%d|SessionNo:%d|OrderSysId:%s|DestInstrumentId:%s\n\n",
    nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
    pStockInsert.BusinessType,               //业务类型
    pStockInsert.ClientNo,                   //交易编码序号
    pStockInsert.InstrumentId,               //合约代码
    pStockInsert.LocalOrderNo,               //会员内部订单编号
    pStockInsert.Side,                       //买卖方向
    pStockInsert.Volume,                     //数量
    pStockInsert.Price,                      //价格
    pStockInsert.ExchangeId,                 //交易所代码
    pStockInsert.SessionNo,                  //发送该报单的session
    pStockInsert.OrderSysId,                 //交易所订单编号
    pStockInsert.DestInstrumentId);          //目标合约代码
}

///股票非交易业务撤单应答
void CExampleSpi::OnRspBusinessCancel(CTdOrderCancelRspField& pStockCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("OnRspBusinessCancel(股票非交易业务撤单响应):RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
    "OriSessionNo:%d|OriLocalOrderNo:%d|OrderSysId:%s|SessionNo:%d\n\n",
    nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
    pStockCancel.OriSessionNo,        //原始报单的sessionno
    pStockCancel.OriLocalOrderNo,     //原始交易客户方订单编号
    pStockCancel.OrderSysId,          //交易所订单编号
    pStockCancel.SessionNo);           //发送该报单的session);
}

///股票非交易业务委托回报
void CExampleSpi::OnRtnBusinessOrder(CTdBusinessOrderRtnField& pOrder) 
{
    if (1 != pOrder.SequenceNo - _lastPrvSequenceNo)
    {
        printf("!!!!!err seq:%d|new:%d|old:%d|\n", __LINE__, pOrder.SequenceNo, _lastPrvSequenceNo);
    }

    _lastPrvSequenceNo = pOrder.SequenceNo;
    printf("OnRtnBusinessOrder(股票非交易业务委托通知): SequenceNo:%d\n", pOrder.SequenceNo);
    printf("BusinessType:%d|SequenceNo:%d|RequestNo:%d|SessionNo:%d|ClientNo:%d|LocalOrderNo:%d|ClientId:%s|UserId:%s|InstrumentId:%s"
    "ExchangeId:%d|Side:%d|OrdStatus:%d|Price:%lf|Volume:%d|OrderTime:%d|OrderSysId:%s|LeavesVolume:%d|CancelVolume:%d|DestInstrumentId:%s",
        pOrder.BusinessType,           //业务类型
        pOrder.SequenceNo,             //回报序号(私有流序号每个交易日连续)
        pOrder.RequestNo,              //报单请求编号
        pOrder.SessionNo,              //原始报单session
        pOrder.ClientNo,
        pOrder.LocalOrderNo,
        pOrder.ClientId,
        pOrder.UserId,                 //原始报单交易用户代码
        pOrder.InstrumentId,
        pOrder.ExchangeId,             //交易所代码
        pOrder.Side,                   //买卖方向
        pOrder.OrdStatus,              //订单状态
        pOrder.Price,                  //价格
        pOrder.Volume,                 //数量
        pOrder.OrderTime,              //委托时间
        pOrder.OrderSysId,             //交易所报单编号
        pOrder.LeavesVolume,           //订单剩余数量(交易所返回字段,每个交易所的含义不同)
        pOrder.CancelVolume,           //订单撤销数量
        pOrder.DestInstrumentId);      //目标合约代码
}

///股票非交易业务成交回报
void CExampleSpi::OnRtnBusinessTrade(CTdBusinessTradeRtnField& pTrade)
{
    if (1 != pTrade.SequenceNo - _lastPrvSequenceNo)
    {
        printf("!!!!!err seq:%d|new:%d|old:%d|\n", __LINE__, pTrade.SequenceNo, _lastPrvSequenceNo);
    }

    _lastPrvSequenceNo = pTrade.SequenceNo;
    printf("OnRtnBusinessTrade(股票非交易业务成交通知): SequenceNo:%d\n", pTrade.SequenceNo);
    printf("BusinessType:%d|SequenceNo:%d|RequestNo:%d|SessionNo:%d|ClientNo:%d|LocalOrderNo:%d|ClientId:%s|InstrumentId:%s"
    "ExchangeId:%d|Side:%d|TradePrice:%lf|TradeVolume:%d|LeavesVolume:%d|TradeTime:%d|OrderSysId:%s|TradeId:%s|UserId:%s|DestInstrumentId:%s\n\n",
        pTrade.BusinessType,           //业务类型
        pTrade.SequenceNo,             //回报序号(私有流序号每个交易日连续)
        pTrade.RequestNo,              //报单请求编号
        pTrade.SessionNo,              //原始报单session
        pTrade.ClientNo,
        pTrade.LocalOrderNo,
        pTrade.ClientId,
        pTrade.InstrumentId,
        pTrade.ExchangeId,             //交易所代码
        pTrade.Side,                   //买卖方向
        pTrade.TradePrice,             //成交价格
        pTrade.TradeVolume,            //成交数量
        pTrade.LeavesVolume,           //本次成交后申报余额数量
        pTrade.TradeTime,              //成交时间
        pTrade.OrderSysId,             //交易所报单编号
        pTrade.TradeId,                //成交编号
        pTrade.UserId,                 //原始报单交易用户代码
        pTrade.DestInstrumentId);           //目标合约代码
}