﻿/*  TiExampleOther.cpp
*   组合、锁定、出入金通知DEMO
*   OnRtnWithdrawDeposit为柜台主动推送的私有流
*   OnRtnInstrumentStatus为公有流
*/
#include "TiExample.h"

void CExampleSpi::TESTOTHER()
{
    marginCombAction();     //申请组合     对应应答为OnRspMarginCombAction(组合正确或错误都会应答)      对应的通知OnRtnMarginCombAction
    stockLock();            //申请锁仓     对应应答为OnRspStockLock(锁仓正确或错误都会应答)             无对应通知
}

//申请组合/申请解除组合
void CExampleSpi::marginCombAction()
{
    CTdMarginCombActionField req = { 0 };

    req.ClientNo = 1;			    		// 交易编码序号
    req.LocalOrderNo = _LocalOrderNo++;	    // 会员内部订单编号
    req.Volume = 2;				            //申报数量
    req.Side = TD_Comb_Combed;				//组合与拆分组合标记,组合策略为“ZBD”时，组合与拆分方向只能为组合
    strcpy(req.CombId, "CNSJC");			//组合策略编码:目前为7种组合策略：CNSJC、PXSJC、PNSJC、CXSJC、KS、KKS、ZBD
    strcpy(req.CombInstId, "");			    //组合编码。组合申报时，该字段为空格；拆分申报时，填写拟拆分组合的组合编码
    req.ExchangeId = TD_Exchange_Sse;		//交易所代码
    req.OwnerType = TD_OWNER_Per;
    req.NoLeges = 2;						//成分合约数，取值不超过4，后接重复组（组合腿数）
    req.item[0].LegInstrumentNo = 1;
    req.item[0].LegSide = TD_LegSide_Long;			//合约方向
    req.item[0].CoveredOrUncovered = TD_Covered_Uncovered;// 备兑标签
    req.item[0].LegVolume = 2;				//申报数量(腿1数量，目前7种组合策略，腿1数量和申报数量保持一致)
    req.item[1].LegInstrumentNo = 2;        //_api->GetInstrumentNo("10003677",req.item[1].LegInstrumentNo);
    req.item[1].LegSide = TD_LegSide_Short;	//合约方向
    req.item[1].CoveredOrUncovered = TD_Covered_Uncovered;// 备兑标签
    req.item[1].LegVolume = 2;				//申报数量(腿2数量，目前7种组合策略，腿2数量和申报数量保持一致)

    int iRet = _api->ReqMarginCombAction(&req, _requestID++);
    printf("ReqMarginCombAction,requestID:%d|ret:%d\n", _requestID - 1, iRet);
    printf("ReqMarginCombAction: combId:%s|combinstid:%s|%d|%d|%c|%c|%c\n\n",
    		req.CombId, req.CombInstId, req.item[0].LegInstrumentNo, req.item[1].LegInstrumentNo, req.item[0].LegSide, req.item[1].LegSide, req.Side);
}

void CExampleSpi::OnRspMarginCombAction(CTdMarginCombActionRspField& pMarginCombAction, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("OnRspMarginCombAction:RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
    "LocalOrderNo:%d|CombId:%s|CombInstId:%s|FrontNo:%d|ExchangeId:%d|SessionNo:%d|OwnerType:%d|NoLeges:%d|item0:%d|%d|%c|%d|item1:%d|%d|%c|%d|\n\n",
        nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
        pMarginCombAction.LocalOrderNo,
        pMarginCombAction.CombId,
        pMarginCombAction.CombInstId,
        pMarginCombAction.FrontNo, 
        pMarginCombAction.ExchangeId,
        pMarginCombAction.SessionNo,
        pMarginCombAction.OwnerType,
        pMarginCombAction.NoLeges,
        pMarginCombAction.item[0].CoveredOrUncovered,
        pMarginCombAction.item[0].LegInstrumentNo,
        pMarginCombAction.item[0].LegSide,
        pMarginCombAction.item[0].LegVolume,
        pMarginCombAction.item[1].CoveredOrUncovered,
        pMarginCombAction.item[1].LegInstrumentNo,
        pMarginCombAction.item[1].LegSide,
        pMarginCombAction.item[1].LegVolume);
}

void CExampleSpi::OnRtnMarginCombAction(CTdMarginCombActionRtnField& pMarginCombAction)
{
    if (1 != pMarginCombAction.SequenceNo - _lastPrvSequenceNo)
    {
        printf("!!!!!err seq:%d|new:%d|old:%d\n", __LINE__, pMarginCombAction.SequenceNo, _lastPrvSequenceNo);
    }

    _lastPrvSequenceNo = pMarginCombAction.SequenceNo;
    printf("组合通知 - OnRtnMarginCombAction:%d\n", pMarginCombAction.SequenceNo);
    printf("FrontNo:%d,SequenceNo:%d,RequestNo:%d,SessionNo:%d,ClientNo:%d,LocalOrderNo:%d,ClientId:%s,UserId:%s,ExchangeId:%d,Side:%c,NoLeges:%d,Volume:%d,CombId:%s,"
        "CombInstId:%s,OwnerType:%d,CombActionTime:%d,OrderSysId:%s,ComMargin:%lf,LegInstrumentNo:%d,LegInstrumentId:%s,LegSide:%c,CoveredOrUncovered:%d,"
        "LegVolume:%d,LegInstrumentNo:%d,LegInstrumentId:%s,LegSide:%c,CoveredOrUncovered:%d,LegVolume:%d\n\n",
        pMarginCombAction.FrontNo, pMarginCombAction.SequenceNo, pMarginCombAction.RequestNo, pMarginCombAction.SessionNo, pMarginCombAction.ClientNo, pMarginCombAction.LocalOrderNo,
        pMarginCombAction.ClientId, pMarginCombAction.UserId, pMarginCombAction.ExchangeId, pMarginCombAction.Side, pMarginCombAction.NoLeges, pMarginCombAction.Volume,
        pMarginCombAction.CombId, pMarginCombAction.CombInstId, pMarginCombAction.OwnerType, pMarginCombAction.CombActionTime,
        pMarginCombAction.OrderSysId, pMarginCombAction.ComMargin, pMarginCombAction.item[0].LegInstrumentNo, pMarginCombAction.item[0].LegInstrumentId,
        pMarginCombAction.item[0].LegSide, pMarginCombAction.item[0].CoveredOrUncovered, pMarginCombAction.item[0].LegVolume, pMarginCombAction.item[1].LegInstrumentNo,
        pMarginCombAction.item[1].LegInstrumentId, pMarginCombAction.item[1].LegSide, pMarginCombAction.item[1].CoveredOrUncovered, pMarginCombAction.item[1].LegVolume);
}

//申请锁仓
void CExampleSpi::stockLock()
{
    CTdStockLockReqField req = { 0 };
    req.ClientNo = _clientno;			    // 交易编码序号
    req.InstrumentNo = 1;	                // 合约序号
    req.LocalOrderNo = _LocalOrderNo++;     // 会员内部订单编号
    req.Locked = TD_LOCK_Lock;              // 锁定标志撤销
    req.Volume = 10000;                     // 数量
    req.ExchangeId = _exchangeid;              // 交易所代码
    req.FrontNo = 0;                        // 不选席位填0

    int iRet = _api->ReqStockLock(&req, _requestID++);
    printf("ReqStockLock,requestID:%d|ret:%d\n", _requestID - 1, iRet);
    printf("ReqStockLock: ClientNo:%d|InstrumentNo:%d|LocalOrderNo:%d|Locked:%d|Volume:%d|ExchangeId:%d|FrontNo:%d\n\n",
    req.ClientNo,			    // 交易编码序号
    req.InstrumentNo,	        // 合约序号
    req.LocalOrderNo,           // 会员内部订单编号
    req.Locked,                 // 锁定标志撤销
    req.Volume,                 // 数量
    req.ExchangeId,             // 交易所代码
    req.FrontNo);               // 不选席位填0
}

void CExampleSpi::OnRspStockLock(CTdStockLockRspField& pStockLock, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("OnRspStockLock:RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
    "ClientNo:%d|InstrumentNo:%d|LocalOrderNo:%d|Locked:%d|Volume:%d|ExchangeId:%d|FrontNo:%d|SessionNo:%d|OrderSysId:%s\n\n",
        nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
        pStockLock.ClientNo,                 //交易编码序号
        pStockLock.InstrumentNo,             //合约序号
        pStockLock.LocalOrderNo,             //会员内部订单编号
        pStockLock.Locked,                   //锁定标志
        pStockLock.Volume,                   //数量
        pStockLock.ExchangeId,               //交易所代码
        pStockLock.FrontNo,                  //处理本次报单的实际席位序号
        pStockLock.SessionNo,                //发送该报单的session
        pStockLock.OrderSysId);               //交易所订单编号
}

//私有流 - 出入金通知
void CExampleSpi::OnRtnWithdrawDeposit(CTdWithdrawDepositRtnField& pWithdrawDeposit)
{
    if (1 != pWithdrawDeposit.SequenceNo - _lastPrvSequenceNo)
    {
        printf("!!!!!err seq:%d|new:%d|old:%d|\n", __LINE__, pWithdrawDeposit.SequenceNo, _lastPrvSequenceNo);
    }

    _lastPrvSequenceNo = pWithdrawDeposit.SequenceNo;
    printf("出入金通知 - OnRtnWithdrawDeposit:%d\n", pWithdrawDeposit.SequenceNo);
    printf("FrontNo:%d|SequenceNo:%d|AccountId:%d|ClientId:%s|Deposit:%lf|Withdraw:%lf\n\n",
        pWithdrawDeposit.FrontNo,
        pWithdrawDeposit.SequenceNo,             //回报序号(私有流序号每个交易日连续)
        pWithdrawDeposit.AccountId,              //资金帐户
        pWithdrawDeposit.ClientId,               //交易编码
        pWithdrawDeposit.Deposit,                //入金金额
        pWithdrawDeposit.Withdraw);               //出金金额
}

//公有流 - 合约状态变化的通知
void CExampleSpi::OnRtnInstrumentStatus(CTdInstrumentStatusRtnField& pStatus)
{
    printf("合约状态变化的通知 - OnRtnInstrumentStatus: InstrumentNo:%d|InstrumentId:%s|ExchangeId:%d|ProductId:%s|InstStatus:%d\n\n",
        pStatus.InstrumentNo,
        pStatus.InstrumentId,           //合约代码
        pStatus.ExchangeId,             //交易所代码
        pStatus.ProductId,              //产品代码
        pStatus.InstStatus);            //合约状态);
}
