﻿/*  TiExampleQuery.cpp
*   异步查询DEMO
*
*   TITD的查询分两种：
*   1、以Qry为开头的异步查询
*   2、以Get为开头的同步查询
*
*   本文为Qry开头的异步查询demo。
*
*   以下为异步查询的有关说明：
*
*   1、异步查询的数据会根据客户的操作，做实时的更新。客户可以根据异步查询中的相关函数查询到最新的持仓、资金、委托等。
​*   2、所有的异步查询应答（除查询通知应答），都有四个参数。
*       参数一：查询到的数据
*       参数二：pRspInfo     响应信息，若查询有错误，相关错误信息会在这个参数中
*       参数三：nRequestID   为对应的的查询请求发出的nRequestID
*       参数四：bIsLast      为true代表最后一条数据，bIsLast为true时第一个参数为空，仅告诉用户此查询应答发送结束。
​*   3、TITD所有的异步查询请求都以ReqQry开头，查询应答都以OnRspQry开头。
*   4、异步查询一共有8类，分别为报单查询、报价查询、行权查询、成交查询、持仓查询、资金查询、行情查询和通知查询。
*   5、查询通知ReqQryNotify对应的应答OnRspQryNotify, 仅表示查询通知请求是否成功发送。查询通知成功后，TITD柜台会通过OnRtn***重新发送符合查询条件的私有流。
*/
#include "TiExample.h"

void CExampleSpi::TESTQUERY()
{
    qryQryStockOrder();	    //报单查询 - 股票报单           对应应答为OnRspQryStockOrder
    qryQryOptionsOrder();   //报单查询 - 期权、期货报单     对应应答为OnRspQryOptionsOrder
    qryQryQuoteOrder();	    //报价查询                      对应应答为OnRspQryQuoteOrder
    qryQryExec();			//行权查询                      对应应答为OnRspQryExercise   
    qryQryCombExec();       //组合行权查询                  对应应答为OnRspQryCombExercise
    qryQryStockTrade(); 	//成交查询 - 股票成交           对应应答为OnRspQryStockTrade
    qryQryOptionsTrade();   //成交查询 - 期权、期货成交     对应应答为OnRspQryOptionsTrade
    qryQryStockPosition();	//持仓查询 - 股票持仓           对应应答为OnRspQryStockPosition
    qryQryOptionsPosition();//持仓查询 - 期权、期货持仓     对应应答为OnRspQryOptionsPosition
    qryQryCombPosi();       //持仓查询 - 组合持仓           对应应答为OnRspQryCombPosition
    qryQryAccount();		//资金查询                      对应应答为OnRspQryAccount
    qryQryMarketData();	    //行情查询                      对应应答为OnRspQryMarketData
    qryQryNotify();		    //查询通知                      对应应答为OnRspQryNotify
    qrybusinessOrder();     //非交易业务报单查询             对应的应答为OnRspQryBusinessOrder
}

void CExampleSpi::qryQryStockOrder()
{
    CTdQryStockOrderField req = { 0 };
    strcpy(req.ClientId, _clientid);         /// [交易编码]
    strcpy(req.InstrumentId, _instrumentid);	    /// [合约编码]
    strcpy(req.OrderSysID, "");             /// [交易所报单编号] 默认值:0或空 表示不过滤报单编号
    int iRet = _api->ReqQryStockOrder(&req, _requestID++);
    printf("查询股票报单请求:requestID:%d|ret:%d|ClientId:%s|InstrumentId:%s|OrderSysID:%s|BegTime:%d|EndTime:%d|Side:%d|OrdStatus:%d|LimitSession:%d|LimitUserId:%d\n\n", 
        _requestID - 1, iRet,
    	req.ClientId, 
        req.InstrumentId, 
        req.OrderSysID, 
        req.BegTime,                /// [起始时间]       默认值:0 0表示不设起始时间
        req.EndTime,                /// [结束时间]       默认值:0 0表示不设结束时间
        req.Side,                   /// [买卖方向]
        req.OrdStatus,              /// [订单状态]        默认值:0 表示不过滤订单状态
        req.LimitSession,           /// [限制当前session] 默认值:0 0表示不限制
        req.LimitUserId);           /// [限制当前UserId]  默认值:0 0表示不限制
}

void CExampleSpi::OnRspQryStockOrder(CTdRspQryStockOrderField& pOrder, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("查询股票报单响应:RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|RequestNo:%d|ClientId:%s|InstrumentId:%s|ClientNo:%d|InstrumentNo:%d|"
    "LocalOrderNo:%d|PriceType:%d|Side:%d|TimeInForce:%d|Volume:%d|Price:%lf|OwnerType:%d|ExchangeId:%d|FrontNo:%d|SessionNo:%d|OrdStatus:%d|TransTime:%d|OrderSysId:%s|UserId:%s\n\n",
        nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
        pOrder.RequestNo,              //报单请求编号
        pOrder.ClientId,
        pOrder.InstrumentId,
        pOrder.ClientNo,               //交易编码序号
        pOrder.InstrumentNo,           //合约序号
        pOrder.LocalOrderNo,           //会员内部订单编号
        pOrder.PriceType,              //报单价格条件
        pOrder.Side,                   //买卖方向
        pOrder.TimeInForce,            //订单有效时间类型
        pOrder.Volume,                 //数量
        pOrder.Price,                  //价格
        pOrder.OwnerType,              //订单所有类型
        pOrder.ExchangeId,             //交易所代码
        pOrder.FrontNo,                //处理本次报单的实际席位序号
        pOrder.SessionNo,              //发送该报单的session
        pOrder.OrdStatus,              //订单状态
        pOrder.TransTime,              //发生时间
        pOrder.OrderSysId,             //交易所订单编号
        pOrder.UserId);                 //原始报单交易用户代码
    
}

void CExampleSpi::qryQryOptionsOrder()
{
    CTdQryOptionsOrderField req = { 0 };
    strcpy(req.ClientId, _clientid);         /// [交易编码]
    strcpy(req.InstrumentId, _instrumentid);	    /// [合约编码]
    strcpy(req.OrderSysID, "");		        /// [交易所报单编号] 默认值:0或空格表示不过滤报单编号
    req.BegTime = 140000;			        /// [起始时间]		 0表示不设起始时间. 默认值:0
    req.EndTime = 143000;			        /// [结束时间]       0表示不设结束时间. 默认值:0
    req.Side = TD_SIDE_Sell;		        /// [买卖方向]
    req.OrdStatus = TD_Status_Cancel;		/// [订单状态] 默认值:0表示不过滤订单状态
    req.LimitSession = 0;	                /// [限制当前session] 默认:不限制
    req.LimitUserId = 0;	                /// [限制当前UserId]  默认:不限制

    int iRet = _api->ReqQryOptionsOrder(&req, _requestID++);
    printf("查询期权报单请求:requestID:%d|ret:%d|ClientId:%s|InstrumentId:%s|OrderSysID:%s|BegTime:%d|EndTime:%d|Side:%d|OrdStatus:%d|LimitSession:%d|LimitUserId:%d\n\n", 
        _requestID - 1, iRet,
        req.ClientId,               /// [交易编码]
        req.InstrumentId,           /// [合约编码]
        req.OrderSysID,             /// [交易所报单编号]  默认值:0或空表示不过滤报单编号
        req.BegTime,                /// [起始时间]        默认值:0 0表示不设起始时间
        req.EndTime,                /// [结束时间]        默认值:0 0表示不设结束时间
        req.Side,                   /// [买卖方向]
        req.OrdStatus,              /// [订单状态]        默认值:0 0表示不过滤订单状态
        req.LimitSession,           /// [限制当前session] 默认值:0 0表示不限制
        req.LimitUserId);           /// [限制当前UserId]  默认值:0 0表示不限制
}

void CExampleSpi::OnRspQryOptionsOrder(CTdRspQryOptionsOrderField& pOrder, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("查询期权报单应答:RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|RequestNo:%d|ClientId:%s|InstrumentId:%s|ClientNo:%d|InstrumentNo:%d|LocalOrderNo:%d|PriceType:%d|Side:%d|OffsetFlag:%d|HedgeFlag:%d|"
        "TimeInForce:%d|CoveredOrUncovered:%d|VolumeCondition:%d|TrigCondition:%d|Volume:%d|MinVolume:%d|Price:%lf|StopPrice:%lf|OwnerType:%d|ExchangeId:%d|"
        "FrontNo:%d|SessionNo:%d|OrdStatus:%d|TransTime:%d|OrderSysId:%s|UserId:%s\n\n",
        nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
        pOrder.RequestNo,
        pOrder.ClientId, 
        pOrder.InstrumentId, 
        pOrder.ClientNo, 
        pOrder.InstrumentNo, 
        pOrder.LocalOrderNo, 
        pOrder.PriceType, pOrder.Side,
        pOrder.OffsetFlag, 
        pOrder.HedgeFlag, 
        pOrder.TimeInForce, 
        pOrder.CoveredOrUncovered, 
        pOrder.VolumeCondition, 
        pOrder.TrigCondition, 
        pOrder.Volume,
        pOrder.MinVolume, 
        pOrder.Price, 
        pOrder.StopPrice, 
        pOrder.OwnerType, 
        pOrder.ExchangeId, 
        pOrder.FrontNo, 
        pOrder.SessionNo, 
        pOrder.OrdStatus,
        pOrder.TransTime, 
        pOrder.OrderSysId, 
        pOrder.UserId);
}

void CExampleSpi::qryQryQuoteOrder()
{
    CTdQryQuoteOrderField req = { 0 };
    strcpy(req.ClientId, _clientid);
    int iRet = _api->ReqQryQuoteOrder(&req, _requestID++);
    printf("查询报价请求:requestID:%d|ret:%d|ClientId:%s|InstrumentId:%s|BidOrderId:%s|AskOrderId:%s|BegTime:%d|EndTime:%d|BidStatus:%d|AskStatus:%d|LimitSession:%d|LimitUserId:%d\n\n", 
    _requestID - 1, iRet,
    req.ClientId,               /// [交易编码]
    req.InstrumentId,           /// [合约编码]
    req.OrderSysID,             /// [交易所报单编号] 默认值:0 0或空表示不过滤报单编号
    req.BidOrderId,             /// [交易所报单编号] 默认值:0 0或空表示不过滤报单编号
    req.AskOrderId,             /// [交易所报单编号] 默认值:0 0或空表示不过滤报单编号
    req.BegTime,                /// [起始时间]       默认值:0 0表示不设起始时间. 
    req.EndTime,                /// [结束时间]       默认值:0 0表示不设结束时间. 
    req.BidStatus,              /// [买方状态]       默认值:0 0表示不过滤订单状态
    req.AskStatus,              /// [卖方状态]       默认值:0 0表示不过滤订单状态
    req.LimitSession,           /// [限制当前session] 默认值:0 0表示不限制
    req.LimitUserId);            /// [限制当前UserId]  默认值:0 0表示不限制
}

void CExampleSpi::OnRspQryQuoteOrder(CTdRspQryQuoteOrderField& pQuote, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("查询报价应答:RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|RequestNo:%d|"
    "ClientId:%s|InstrumentId:%s|ClientNo:%d|InstrumentNo:%d|LocalOrderNo:%d|QuoteReqId:%s|BidPx:%lf|AskPx:%lf|BidSize:%d|AskSize:%d|BidOffsetFlag:%d|AskOffsetFlag:%d"
    "OwnerType:%d|ExchangeId:%d|FrontNo:%d|SessionNo:%d|OrderSysId:%s|BidOrderId:%s|AskOrderId:%s|BidStatus:%d|AskStatus:%d|TransTime:%d|UserId:%s\n\n",
    nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
    pQuote.RequestNo,              //报单请求编号
    pQuote.ClientId,
    pQuote.InstrumentId,
    pQuote.ClientNo,               //交易编码序号
    pQuote.InstrumentNo,           //合约序号
    pQuote.LocalOrderNo,           //会员内部订单编号
    pQuote. QuoteReqId,             //报价请求ID,预留字段,当报价是对请求的响应时，填写报价请求的ID
    pQuote.BidPx,                  //买报价
    pQuote.AskPx,                  //卖报价
    pQuote.BidSize,                //买数量
    pQuote.AskSize,                //卖数量
    pQuote.BidOffsetFlag,          //平仓标识
    pQuote.AskOffsetFlag,          //平仓标识
    pQuote.OwnerType,              //订单所有类型
    pQuote.ExchangeId,             //交易所代码
    pQuote.FrontNo,                //处理本次报单的实际席位序号
    pQuote.SessionNo,              //发送该报单的session     
    pQuote.OrderSysId,             //交易所订单编号
    pQuote.BidOrderId,             //买方交易所订单编号
    pQuote.AskOrderId,             //卖方交易所订单编号
    pQuote.BidStatus,              //买方状态
    pQuote.AskStatus,              //卖方状态
    pQuote.TransTime,              //发生时间
    pQuote.UserId);                 //原始报单交易用户代码
}

void CExampleSpi::qryQryExec()
{
    CTdQryExerciseField req = { 0 };
    strcpy(req.ClientId, _clientid);
    int iRet = _api->ReqQryExercise(&req, _requestID++);
    printf("查询行权请求:requestID:%d|ret:%d|ClientId:%s|InstrumentId:%s|OrderSysID:%s|BegTime:%d|EndTime:%d|OrdStatus:%d\n\n", 
        _requestID - 1, iRet,
        req.ClientId,               /// [交易编码]
        req.InstrumentId,           /// [合约编码]    默认值:0 0或空表示查询所有合约
        req.OrderSysID,             /// [交易所报单编号]默认值:0或空表示不过滤报单编号
        req.BegTime,                /// [起始时间]    默认值:0 0表示不设起始时间 
        req.EndTime,                /// [结束时间]    默认值:0 0表示不设结束时间
        req.OrdStatus);             /// [订单状态]    默认值:0 0表示不过滤订单状态);
}

void CExampleSpi::OnRspQryExercise(CTdRspQryExerciseField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("查询行权应答:RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d"
    "ClientNo:%d|InstrumentNo:%d|ClientId:%s|InstrumentId:%s|LocalOrderNo:%d|Volume:%d|OwnerType:%d|ExchangeId:%d|"
    "FrontNo:%d|SessionNo:%d|OrdStatus:%d|TransTime:%d|OrderSysId:%s|UserId:%s\n\n",
    nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
    pExercise.ClientNo,               //交易编码序号
    pExercise.InstrumentNo,           //合约序号
    pExercise.ClientId,               //交易编码
    pExercise.InstrumentId,           //合约编码
    pExercise.LocalOrderNo,           //会员内部订单编号
    pExercise.Volume,                 //申报数量
    pExercise.OwnerType,              //订单所有类型
    pExercise.ExchangeId,             //交易所代码
    pExercise.FrontNo,                //处理本次报单的实际席位序号
    pExercise.SessionNo,              //发送该报单的session
    pExercise.OrdStatus,              //订单状态
    pExercise.TransTime,              //发生时间
    pExercise.OrderSysId,             //交易所订单编号
    pExercise.UserId);                //原始报单交易用户代码
};

void CExampleSpi::qryQryCombExec()
{
    CTdQryCombExerciseField req = { 0 };
    strcpy(req.ClientId, _clientid);
    int iRet = _api->ReqQryCombExercise(&req, _requestID++);
    printf("查询组合行权请求:requestID:%d|ret:%d|ClientId:%s|InstrumentId1:%s|InstrumentId2:%s|OrderSysID:%s|BegTime:%d|EndTime:%d|OrdStatus:%d\n\n", 
        _requestID - 1, iRet,
        req.ClientId,               /// [交易编码]
        req.InstrumentId1,          /// [合约编码1]  默认值:0 0或空表示不过滤第一个合约
        req.InstrumentId2,          /// [合约编码2]  默认值:0 0或空表示不过滤第二个合约
        req.OrderSysID,             /// [交易所报单编号]默认值:0 0或空表示不过滤报单编号
        req.BegTime,                /// [起始时间]   默认值:0 0表示不设起始时间 
        req.EndTime,                /// [结束时间]   默认值:0 0表示不设结束时间 
        req.OrdStatus);              /// [订单状态]   默认值:0 0表示不过滤订单状态
}

void CExampleSpi::OnRspQryCombExercise(CTdRspQryCombExerciseField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("查询组合行权应答:RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
        "ClientNo:%d|ClientId:%s|LocalOrderNo:%d|Volume:%d|LegInstrumentNo1:%d|InstrumentId1:%s|LegVolume1:%d|LegInstrumentNo2:%d|InstrumentId2:%s|LegVolume2:%d|"
        "OwnerType:%d|ExchangeId:%d|FrontNo:%d|SessionNo:%d|OrdStatus:%d|TransTime:%d|OrderSysId:%s|UserId:%s\n\n",
        nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
        pExercise.ClientNo,               //交易编码序号
        pExercise.ClientId,               //交易编码
        pExercise.LocalOrderNo,           //会员内部订单编号
        pExercise.Volume,                 //申报数量
        pExercise.LegInstrumentNo1,       //腿1合约序号
        pExercise.InstrumentId1,          //腿1合约号
        pExercise.LegVolume1,             //腿1申报数量
        pExercise.LegInstrumentNo2,       //腿2合约序号
        pExercise.InstrumentId2,          //腿2合约号
        pExercise.LegVolume2,             //腿2申报数量
        pExercise.OwnerType,              //订单所有类型
        pExercise.ExchangeId,             //交易所代码
        pExercise.FrontNo,                //处理本次报单的实际席位序号
        pExercise.SessionNo,              //发送该报单的session
        pExercise.OrdStatus,              //订单状态
        pExercise.TransTime,              //发生时间
        pExercise.OrderSysId,             //交易所订单编号
        pExercise.UserId);                //原始报单交易用户代码
}

void CExampleSpi::qryQryStockTrade()
{
    CTdQryStockTradeField req = { 0 };
    strcpy(req.ClientId, _clientid);
    int iRet = _api->ReqQryStockTrade(&req, _requestID++);
    printf("查询股票成交请求:requestID:%d|ret:%d|ClientId:%s|InstrumentId:%s|OrderSysID:%s|TradeId:%s|BegSeqNo:%d|EndSeqNo:%d|BegTime:%d|EndTime:%d|Side:%d|LimitSession:%d|LimitUserId:%d\n\n", 
    _requestID - 1, iRet,
    req.ClientId,               /// [交易编码]
    req.InstrumentId,           /// [合约编码]
    req.OrderSysID,             /// [交易所报单编号] 默认值:0或空表示不过滤报单编号
    req.TradeId,                /// [成交编号]
    req.BegSeqNo,               /// [起始回报流序号] 默认值:0 0表示不设起始要求 
    req.EndSeqNo,               /// [结束回报流序号] 默认值:0 0表示不设结束要求 
    req.BegTime,                /// [起始时间]       默认值:0 0表示不设起始时间 
    req.EndTime,                /// [结束时间]       默认值:0 0表示不设结束时间
    req.Side,                   /// [买卖方向]
    req.LimitSession,           /// [限制当前session] 默认值:0 0表示不限制
    req.LimitUserId);           /// [限制当前UserId]  默认值:0 0表示不限制
}

void CExampleSpi::OnRspQryStockTrade(CTdRspQryStockTradeField& pTrade, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("查询股票成交应答:RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d"
        "FrontNo:%d|SequenceNo:%d|RequestNo:%d|SessionNo:%d|ClientNo:%d|InstrumentNo:%d|LocalOrderNo:%d|ClientId:%s|"
        "InstrumentId:%s|ExchangeId:%d|Side:%d|TradePrice:%lf|TradeVolume:%d|LeavesVolume:%d|TradeTime:%d|OrderSysId:%s|TradeId:%s|UserId:%s\n\n",
        nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
        pTrade.FrontNo,                //处理本次报单的实际席位序号
        pTrade.SequenceNo,             //回报序号(私有流序号每个交易日连续)
        pTrade.RequestNo,              //报单请求编号
        pTrade.SessionNo,              //原始报单session
        pTrade.ClientNo,
        pTrade.InstrumentNo,
        pTrade.LocalOrderNo,
        pTrade.ClientId,
        pTrade.InstrumentId,
        pTrade.ExchangeId,             //交易所代码
        pTrade.Side,                   //买卖方向
        pTrade.TradePrice,             //成交价格
        pTrade.TradeVolume,            //成交数量
        pTrade.LeavesVolume,           //本次成交后申报余额数量
        pTrade.TradeTime,              //成交时间
        pTrade.OrderSysId,             //交易所报单编号
        pTrade.TradeId,                //成交编号
        pTrade.UserId);                 //原始报单交易用户代码
}

void CExampleSpi::qryQryOptionsTrade()
{
    CTdQryOptionsTradeField req = { 0 };
    strcpy(req.ClientId, _clientid);
    int iRet = _api->ReqQryOptionsTrade(&req, _requestID++);
    printf("ReqQryOptionsTrade:requestID:%d|ret:%d|ClientId:%s|InstrumentId:%s|OrderSysID:%s|TradeId:%s|BegSeqNo:%d|EndSeqNo:%d|BegTime:%d|EndTime:%d|Side:%d|LimitSession:%d|LimitUserId:%d\n\n", 
    _requestID - 1, iRet,
    req.ClientId,               /// [交易编码]
    req.InstrumentId,           /// [合约编码]
    req.OrderSysID,             /// [交易所报单编号] 默认值:0或空表示不过滤报单编号
    req.TradeId,                /// [成交编号]
    req.BegSeqNo,               /// [起始回报流序号] 默认值:0 0表示不设起始要求 
    req.EndSeqNo,               /// [结束回报流序号] 默认值:0 0表示不设结束要求 
    req.BegTime,                /// [起始时间]       默认值:0 0表示不设起始时间 
    req.EndTime,                /// [结束时间]       默认值:0 0表示不设结束时间
    req.Side,                   /// [买卖方向]
    req.LimitSession,           /// [限制当前session] 默认值:0 0表示不限制
    req.LimitUserId);           /// [限制当前UserId]  默认值:0 0表示不限制
}

void CExampleSpi::OnRspQryOptionsTrade(CTdRspQryOptionsTradeField& pTrade, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("期权成交查询应答:RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
        "FrontNo:%d|SequenceNo:%d|RequestNo:%d|LocalOrderNo:%d|SessionNo:%d|ClientNo:%d|InstrumentNo:%d|ClientId:%s|InstrumentId:%s|ExchangeId:%d|"
        "PriceType:%d|Side:%d|OffsetFlag:%d|HedgeFlag:%d|TimeInForce:%d|CoveredOrUncovered:%d|VolumeCondition:%d|TrigCondition:%d|"
        "OwnerType:%d|TradePrice:%f|TradeVolume:%d|LeavesVolume:%d|TransTime:%d|OrderSysId:%s|TradeId:%s|UserId:%s\n\n",
        nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
        pTrade.FrontNo,
        pTrade.SequenceNo,             //回报序号
        pTrade.RequestNo,              //报单请求编号
        pTrade.LocalOrderNo,
        pTrade.SessionNo,              //原始报单session
        pTrade.ClientNo,
        pTrade.InstrumentNo,
        pTrade.ClientId,
        pTrade.InstrumentId,
        pTrade.ExchangeId,             //交易所代码
        pTrade.PriceType,              //报单价格条件限价单事价单等
        pTrade.Side,                   //买卖方向
        pTrade.OffsetFlag,             //开平标记
        pTrade.HedgeFlag,              //投机套保标记
        pTrade.TimeInForce,         //有效期类型
        pTrade.CoveredOrUncovered,  //备兑标签
        pTrade.VolumeCondition,     //成交量类型
        pTrade.TrigCondition,       //触发条件
        pTrade.OwnerType,           //订单所有类型
        pTrade.TradePrice,          //成交价格
        pTrade.TradeVolume,         //成交数量
        pTrade.LeavesVolume,        //本次成交后申报余额数量
        pTrade.TransTime,          //成交时间
        pTrade.OrderSysId,          //交易所报单编号
        pTrade.TradeId,             //成交编号
        pTrade.UserId);             //原始报单交易用户代码
}

void CExampleSpi::qryQryStockPosition()
{
    CTdQryStockPositionField req = { 0 };
    strcpy(req.ClientId, _clientid);
    int iRet = _api->ReqQryStockPosition(&req, _requestID++);
    printf("股票持仓查询请求:requestID:%d|ret:%d|_clientid:%s|InstrumentId:%s\n", 
    _requestID - 1, iRet,
    req.ClientId,
    req.InstrumentId);
}

void CExampleSpi::OnRspQryStockPosition(CTdRspQryStockPositionField& pPosition, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("股票持仓查询应答:RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
    "ClientNo:%d|InstrumentNo:%d|ClientId:%s|InstrumentId:%s|ExchangeId:%d|"
    "YdPosition:%d|Position:%d|TodayPosition:%d|FrozenVolume:%d|BuyTradeVolume:%d|SellTradeVolume:%d|Price:%lf|LockVolume:%d|FrozenLock:%d\n\n",
        nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
        pPosition.ClientNo,
        pPosition.InstrumentNo,
        pPosition.ClientId,
        pPosition.InstrumentId,
        pPosition.ExchangeId,           /// 交易所代码
        pPosition.YdPosition,           /// 上日持仓
        pPosition.Position,             /// 总持仓
        pPosition.TodayPosition,        /// 今日持仓
        pPosition.FrozenVolume,         /// 冻结数量
        pPosition.BuyTradeVolume,       /// 当日买成交量
        pPosition.SellTradeVolume,      /// 当日卖成交量
        pPosition.Price,                /// 持仓价格
        pPosition.LockVolume,           /// 锁仓数量(已经被锁定的可用于备兑开仓的数量)
        pPosition.FrozenLock);           /// 锁仓冻结数量(解锁时冻结的数量)
}

void CExampleSpi::qryQryOptionsPosition()
{
    CTdQryOptionsPositionField req = { 0 };
    strcpy(req.ClientId, _clientid);
    int iRet = _api->ReqQryOptionsPosition(&req, _requestID++);
    printf("期权持仓查询请求:requestID:%d|ret:%d|ClientId:%s|InstrumentId:%s|Side:%d|CoveredOrUn:%d\n", 
        _requestID - 1, iRet,
        req.ClientId,                 /// <交易编码>     必填项:不填返回错误提醒
        req.InstrumentId,             /// [合约编码]     默认值:0 0或空表示查询所有合约
        req.Side,                     /// [买卖方向]     默认值:0 0表示不限制买卖方向
        req.CoveredOrUn);             /// [备兑标记]     默认值:0 0表示不限制备兑标记
}

void CExampleSpi::OnRspQryOptionsPosition(CTdRspQryOptionsPositionField& pPosition, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("期权持仓查询应答:RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
        "ClientNo:%d|InstrumentNo:%d|ClientId:%s|InstrumentId:%s|ExchangeId:%d|Converd:%d|Side:%d|YdPosition:%d|Position:%d|TodayPosition:%d|"
        "FrozenVolume:%d|BuyTradeVolume:%d|SellTradeVolume:%d|Price:%lf|UseMargin:%lf\n\n",
        nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
        pPosition.ClientNo, 
        pPosition.InstrumentNo, 
        pPosition.ClientId, 
        pPosition.InstrumentId, 
        pPosition.ExchangeId, 
        pPosition.Converd, 
        pPosition.Side,
        pPosition.YdPosition, 
        pPosition.Position, 
        pPosition.TodayPosition, 
        pPosition.FrozenVolume, 
        pPosition.BuyTradeVolume, 
        pPosition.SellTradeVolume, 
        pPosition.Price, 
        pPosition.UseMargin);
}

void CExampleSpi::qryQryCombPosi()
{
    CTdQryCombPositionField req = { 0 };
    strcpy(req.ClientId, _clientid);
    int iRet = _api->ReqQryCombPosition(&req, _requestID++);
    printf("查询组合持仓请求:requestID:%d|ret:%d|ClientId:%s|CombID:%s|CombInstId:%s\n", 
    _requestID - 1, iRet,
    req.ClientId,               /// <交易编码>   必填项:不填返回错误提醒
    req.CombID,                 /// [组合策略编码]   默认值:空 空表示查询所有组合类型, 目前为7种组合策略：CNSJC、PXSJC、PNSJC、CXSJC、KS、KKS、ZBD
    req.CombInstId);            /// [组合编码]       默认值:空 空表示查询所有组合持仓);
}

void CExampleSpi::OnRspQryCombPosition(CTdRspQryCombPositionField& pPosi, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("查询组合持仓应答:RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
        "ClientNo:%d|ClientId:%s|ExchangeId:%d|CombId:%s|CombInstId:%s|Volume:%d|FrozenVolume:%d|ComMargin:%f|NoLeges:%d|item0:%d %s %c %d %d|item1:%d %s %c %d %d|item2:%d %s %c %d %d|item3:%d %s %c %d %d\n\n",
        nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
        pPosi.ClientNo,
        pPosi.ClientId,
        pPosi.ExchangeId,			/// 交易所代码
        pPosi.CombId,				/// 组合策略编码:目前为7种组合策略：CNSJC、PXSJC、PNSJC、CXSJC、KS、KKS、ZBD
        pPosi.CombInstId,			/// 组合编码。组合申报时，该字段为空格；拆分申报时，填写拟拆分组合的组合编码
        pPosi.Volume,				/// 持仓数量
        pPosi.FrozenVolume,			/// 冻结数量
        pPosi.ComMargin,			/// 优惠的保证金
        pPosi.NoLeges,				/// 成分合约数，取值不超过4，后接重复组
        pPosi.item[0].LegInstrumentNo,		//合约编码
        pPosi.item[0].LegInstrumentId,		//合约编码
        pPosi.item[0].LegSide,				//合约方向
        pPosi.item[0].CoveredOrUncovered,   //备兑标签
        pPosi.item[0].LegVolume,			//申报数量
        pPosi.item[1].LegInstrumentNo,		//合约编码
        pPosi.item[1].LegInstrumentId,		//合约编码
        pPosi.item[1].LegSide,				//合约方向
        pPosi.item[1].CoveredOrUncovered,   //备兑标签
        pPosi.item[1].LegVolume,			//申报数量
        pPosi.item[2].LegInstrumentNo,		//合约编码
        pPosi.item[2].LegInstrumentId,		//合约编码
        pPosi.item[2].LegSide,				//合约方向
        pPosi.item[2].CoveredOrUncovered,   //备兑标签
        pPosi.item[2].LegVolume,			//申报数量
        pPosi.item[3].LegInstrumentNo,		//合约编码
        pPosi.item[3].LegInstrumentId,		//合约编码
        pPosi.item[3].LegSide,				//合约方向
        pPosi.item[3].CoveredOrUncovered,   //备兑标签
        pPosi.item[3].LegVolume);			//申报数量
};

void CExampleSpi::qryQryAccount()
{
    CTdQryAccountField req = { 0 };
    strcpy(req.AccountId, USERID);
    int iRet = _api->ReqQryAccount(&req, _requestID++);
    printf("查询资金请求:requestID:%d|ret:%d|AccountId:%s\n\n", 
    _requestID - 1, iRet,
    req.AccountId);
}

void CExampleSpi::OnRspQryAccount(CTdRspQryAccountField& pAccount, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("资金查询应答:RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
        "AccountId:%s|Prebalance:%lf|DistribFund:%lf|Balance:%lf|Commi:%lf|FutMargin:%lf|OptMargin:%lf|CombMargin:%lf|CloseProfit:%lf|"
        "PosiProfit:%lf|Premium:%lf|Deposit:%lf|Withdraw:%lf|FrozenMargin:%lf|FrozenPremium:%lf|FrozenCommi:%lf|EntryFees:%lf|BuyPremium:%lf\n\n",
        nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
        pAccount.AccountId, 
        pAccount.Prebalance, 
        pAccount.DistribFund, 
        pAccount.Balance, 
        pAccount.Commi, 
        pAccount.FutMargin, 
        pAccount.OptMargin,
        pAccount.CombMargin, 
        pAccount.CloseProfit, 
        pAccount.PosiProfit, 
        pAccount.Premium, 
        pAccount.Deposit, 
        pAccount.Withdraw, 
        pAccount.FrozenMargin, 
        pAccount.FrozenPremium,
        pAccount.FrozenCommi, 
        pAccount.EntryFees, 
        pAccount.BuyPremium);
}

void CExampleSpi::qryQryMarketData()
{
    CTdQryMarketDataField req = { 0 };
    req.InstrumentNo = _instrumentno;
    int iRet = _api->ReqQryMarketData(&req, _requestID++);
    printf("查询行情请求:requestID:%d|ret:%d|InstrumentNo:%d|InstrumentId:%s\n\n", 
        _requestID - 1, iRet,
        req.InstrumentNo,         //{合约No}
        req.InstrumentId);        //{合约代码}
}

void CExampleSpi::OnRspQryMarketData(CTdRspQryMarketDataField& pMarketData, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("查询行情应答:RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
        "InstrumentNo:%d|InstrumentId:%s|LastPrice:%lf|SettlementPrice:%lf|UpperlimitPrice:%lf|LowerlimitPrice:%lf\n\n",
        nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
        pMarketData.InstrumentNo,        //合约No
        pMarketData.InstrumentId,        //合约代码
        pMarketData.LastPrice,           //最新价
        pMarketData.SettlementPrice,     //昨日结算价
        pMarketData.UpperlimitPrice,     //涨停板价格
        pMarketData.LowerlimitPrice);     //跌停板价格
}

void CExampleSpi::qryQryNotify()
{
    CTdQryNotifyField req = { 0 };
    int iRet = _api->ReqQryNotify(&req, _requestID++);
    printf("查询通知请求:requestID:%d|ret:%d|BegSeqNo:%d|EndSeqNo:%d\n\n", 
    _requestID - 1, iRet,
    req.BegSeqNo,           /// [起始回报流序号] 默认值:0 0表示不设起始要求 
    req.EndSeqNo);           /// [结束回报流序号] 默认值:0 0表示不设结束要求 
}

void CExampleSpi::OnRspQryNotify(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("查询通知应答:RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d\n\n", 
    nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast);
}

void CExampleSpi::qrybusinessOrder()
{
    CTdQryBusinessOrderField req = { 0 };
    int iRet = _api->ReqQryBusinessOrder(&req, _requestID++);
    printf("股票非交易业务报单查询:requestID:%d|ret:%d\n\n", 
    _requestID - 1, iRet); 
}

void CExampleSpi::OnRspQryBusinessOrder(CTdRspQryBusinessOrderField& pOrder, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("股票非交易业务报单查询应答:RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d\n\n"
    "BusinessType:%d|RequestNo:%d|ClientId:%s|InstrumentId:%s|ClientNo:%d|LocalOrderNo:%d|"
    "Side:%d|Volume:%d|Price:%lf|ExchangeId:%d|FrontNo:%d|SessionNo:%d|OrdStatus:%d|TransTime:%d|OrderSysId:%s|UserId:%s|DestInstrumentId:%s\n\n", 
    nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
    pOrder.BusinessType,          //业务类型
    pOrder.RequestNo,              //报单请求编号
    pOrder.ClientId,
    pOrder.InstrumentId,
    pOrder.ClientNo,               //交易编码序号
    pOrder.LocalOrderNo,           //会员内部订单编号
    pOrder.Side,                   //买卖方向
    pOrder.Volume,                 //数量
    pOrder.Price,                  //价格
    pOrder.ExchangeId,             //交易所代码
    pOrder.FrontNo,                //处理本次报单的实际席位序号
    pOrder.SessionNo,              //发送该报单的session
    pOrder.OrdStatus,              //订单状态
    pOrder.TransTime,              //发生时间
    pOrder.OrderSysId,             //交易所订单编号
    pOrder.UserId,                 //原始报单交易用户代码
    pOrder.DestInstrumentId);           //目标合约代码
}