﻿/*  TiExampleQuote.cpp
*   报价、询价DEMO
*
*   OnRtnForQuote询价通知，为主动推送的共有流
*   询价通知只有做市商账号，且在初始化的时候设置了接收公有流，才能收到。
*/
#include "TiExample.h"

void CExampleSpi::TESTQUOTE()
{
    forquoteInsert();       //询价         对应应答为OnRspForQuote(询价发出后的响应，表示询价已正常发出)   
    sleep(1);
    quoteInsert();          //报价         对应应答为OnRspQuoteInsert(报价有错误应答)         对应的通知OnRtnQuoteOrder、OnRtnOptionsOrder(TiExampleOrder.cpp中)  
    sleep(1);
    quotecancle();          //报价撤销     对应应答为OnRspQuoteCancel(报价撤销有错误应答)     报价撤销成功，发送报单已撤销的委托回报OnRtnOptionsOrder(TiExampleOrder.cpp中) 
}

//询价
void CExampleSpi::forquoteInsert()
{
    CTdForQuoteReqField req = { 0 };

    req.ClientNo = _clientno;                //交易编码序号
    req.InstrumentNo = _instrumentno;              //合约序号
    req.LocalOrderNo = _LocalOrderNo++;     //会员内部订单编号
    req.OwnerType = TD_OWNER_Per;           //订单所有类型
    req.ExchangeId = _exchangeid;              //交易所代码

    int iRet = _api->ReqForQuote(&req, _requestID++);
    printf("ReqForQuote(询价请求), requestID:%d|ret:%d\n", _requestID - 1, iRet);
    printf("ReqForQuote(询价请求), ClientNo:%d|InstrumentNo:%d|LocalOrderNo:%d|OwnerType:%d|ExchangeId:%d\n\n",
    req.ClientNo,               //交易编码序号
    req.InstrumentNo,           //合约序号
    req.LocalOrderNo,           //会员内部订单编号
    req.OwnerType,              //订单所有类型
    req.ExchangeId);            //交易所代码
}

void CExampleSpi::OnRspForQuote(CTdForQuoteRspField& pForQuote, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("OnRspForQuote(询价响应), RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
    "ClientNo:%d|InstrumentNo:%d|LocalOrderNo:%d|OwnerType:%d|ExchangeId:%d|FrontNo:%d|SessionNo:%d|QuoteReqId:%s\n\n",
        nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
        pForQuote.ClientNo,                  //交易编码序号
        pForQuote.InstrumentNo,              //合约序号
        pForQuote.LocalOrderNo,              //会员内部订单编号
        pForQuote.OwnerType,                 //订单所有类型
        pForQuote.ExchangeId,                //交易所代码
        pForQuote.FrontNo,                   //处理本次报单的实际席位序号
        pForQuote.SessionNo,                 //发送该报单的session
        pForQuote.QuoteReqId);                //报价请求ID
}

//公有流 - 询价通知（做市商收取询价通知后做应价）
void CExampleSpi::OnRtnForQuote(CTdForQuoteRtnField& pForQuote)
{
    printf("询价通知 - OnRtnForQuote: InstrumentNo:%d|InstrumentId:%s|ExchangeId:%d|QuoteReqId:%s\n\n",
        pForQuote.InstrumentNo,
        pForQuote.InstrumentId,
        pForQuote.ExchangeId,             //交易所代码
        pForQuote.QuoteReqId);             //报价请求ID
}

//报价
void CExampleSpi::quoteInsert()
{
    CTdQuoteInsertReqField req = { 0 };
    req.ClientNo = _clientno;                    //交易编码序号
    req.InstrumentNo = _instrumentno;                  //合约序号
    req.LocalOrderNo = _LocalOrderNo++;         //会员内部订单编号
    //TdQuoteReqIDType      QuoteReqId;         //报价请求ID,预留字段,当报价是对请求的响应时，填写报价请求的ID
    req.BidPx = 0.1;                            //买报价
    req.AskPx = 0.2;                            //卖报价
    req.BidSize = 3;                            //买数量
    req.AskSize = 4;                            //卖数量
    req.BidOffsetFlag = TD_OC_Open;             //平仓标识
    req.AskOffsetFlag = TD_OC_Close;            //平仓标识
    req.OwnerType = TD_OWNER_Per;               //订单所有类型
    req.ExchangeId = _exchangeid;                  //交易所代码
    req.FrontNo = 0;

    int iRet = _api->ReqQuoteInsert(&req, _requestID++);
    printf("ReqQuoteInsert(报价请求), requestID:%d|ret:%d\n", _requestID - 1, iRet);
    printf("ReqQuoteInsert(报价请求), ClientNo:%d|InstrumentNo:%d|LocalOrderNo:%d|QuoteReqId:%s|BidPx:%lf|AskPx:%lf|BidSize:%d|AskSize:%d|BidOffsetFlag:%d|AskOffsetFlag:%d|OwnerType:%d|ExchangeId:%d|FrontNo:%d\n\n",
        req.ClientNo,                   //交易编码序号
        req.InstrumentNo,               //合约序号
        req.LocalOrderNo,               //会员内部订单编号
        req.QuoteReqId,                 //报价请求ID,预留字段,当报价是对请求的响应时，填写报价请求的ID
        req.BidPx,                      //买报价
        req.AskPx,                      //卖报价
        req.BidSize,                    //买数量
        req.AskSize,                    //卖数量
        req.BidOffsetFlag,              //平仓标识
        req.AskOffsetFlag,              //平仓标识
        req.OwnerType,                  //订单所有类型
        req.ExchangeId,                 //交易所代码
        req.FrontNo);
}

void CExampleSpi::OnRspQuoteInsert(CTdQuoteInsertRspField& pQuoteInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("OnRspQuoteInsert(报价响应), RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
    "ClientNo:%d|InstrumentNo:%d|LocalOrderNo:%d|QuoteReqId:%s|BidPx:%lf|AskPx:%lf"
    "BidSize:%d|AskSize:%d|BidOffsetFlag:%d|AskOffsetFlag:%d|OwnerType:%d|ExchangeId:%d|"
    "FrontNo:%d|SessionNo:%d|OrderSysId:%s|BidOrderId:%s|AskOrderId:%s\n\n",
        nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
        pQuoteInsert.ClientNo,            //交易编码序号
        pQuoteInsert.InstrumentNo,        //合约序号
        pQuoteInsert.LocalOrderNo,        //会员内部订单编号
        pQuoteInsert.QuoteReqId,          //报价请求ID,预留字段,当报价是对请求的响应时，填写报价请求的ID
        pQuoteInsert.BidPx,               //买报价
        pQuoteInsert.AskPx,               //卖报价
        pQuoteInsert.BidSize,             //买数量
        pQuoteInsert.AskSize,             //卖数量
        pQuoteInsert.BidOffsetFlag,       //平仓标识
        pQuoteInsert.AskOffsetFlag,       //平仓标识
        pQuoteInsert.OwnerType,           //订单所有类型
        pQuoteInsert.ExchangeId,          //交易所代码
        pQuoteInsert.FrontNo,             //处理本次报单的实际席位序号
        pQuoteInsert.SessionNo,           //发送该报单的session
        pQuoteInsert.OrderSysId,          //交易所订单编号
        pQuoteInsert.BidOrderId,          //买方交易所订单编号
        pQuoteInsert.AskOrderId);         //卖方交易所订单编号
}

//报价撤销
void CExampleSpi::quotecancle()
{
    CTdOrderCancelReqField req = { 0 };

    req.OriSessionNo = 3842;			            //原始报单的sessionno如果是通过LocalOrderNo撤单，需要填写，不填写则默认撤销本次登录后的LocalOrderNo
    req.OriLocalOrderNo = 2;			            //原始交易客户方订单编号
    strcpy(req.OrderSysId, "852341");				//交易所订单编号(OrigLocalOrderNo和OrderSysId任意一个即可)

    int iRet = _api->ReqQuoteCancel(&req, _requestID++);
    printf("ReqQuoteCancel(报价撤销请求), requestID:%d|ret:%d\n", _requestID - 1, iRet);
    printf("ReqQuoteCancel(报价撤销请求), OriSessionNo:%d|OriLocalOrderNo:%d|OrderSysId:%s\n\n",
    req.OriSessionNo,        //原始报单的sessionno如果是通过LocalOrderNo撤单，需要填写，不填写则默认撤销本次登录后的LocalOrderNo
    req.OriLocalOrderNo,     //原始交易客户方订单编号
    req.OrderSysId);         //交易所订单编号(OrigLocalOrderNo和OrderSysId任意一个即可，当OriLocalOrderNo、OrderSysId都填写时，以OriLocalOrderNo为准)
}

void CExampleSpi::OnRspQuoteCancel(CTdOrderCancelRspField& pQuoteCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    printf("OnRspQuoteCancel(报价撤销响应), RequestID:%d|ErrorId:%d|ErrorMsg:%s|bIsLast:%d|"
    "OriSessionNo:%d|OriLocalOrderNo:%d|OrderSysId:%s|SessionNo:%d\n\n",
        nRequestID, pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast,
        pQuoteCancel.OriSessionNo,        //原始报单的sessionno
        pQuoteCancel.OriLocalOrderNo,     //原始交易客户方订单编号
        pQuoteCancel.OrderSysId,          //交易所订单编号
        pQuoteCancel.SessionNo);           //发送该报单的session
}

void CExampleSpi::OnRtnQuoteOrder(CTdQuoteOrderRtnField& pQuote)
{
    if (1 != pQuote.SequenceNo - _lastPrvSequenceNo)
    {
        printf("!!!!!err seq:%d|new:%d|old:%d|\n", __LINE__, pQuote.SequenceNo, _lastPrvSequenceNo);
    }

    _lastPrvSequenceNo = pQuote.SequenceNo;
    printf("报价通知 - OnRtnQuoteOrder:%d\n", pQuote.SequenceNo);
    printf("FrontNo:%d|SequenceNo:%d|RequestNo:%d|SessionNo:%d|ClientNo:%d|InstrumentNo:%d|LocalOrderNo:%d|"
    "ClientId:%s|InstrumentId:%s|ExchangeId:%d|UserId:%s|QuoteReqId:%s|BidPx:%lf|AskPx:%lf|BidSize:%d|AskSize:%d|"
    "BidOffsetFlag:%d|AskOffsetFlag:%d|OwnerType:%d|OrderSysId:%s|BidOrderId:%s|AskOrderId:%s|OrdStatus:%d|OrderTime:%d\n\n", 
        pQuote.FrontNo,                //处理本次报单的实际席位序号
        pQuote.SequenceNo,             //回报序号(私有流序号每个交易日连续)
        pQuote.RequestNo,              //报单请求编号
        pQuote.SessionNo,              //原始报单session
        pQuote.ClientNo,
        pQuote.InstrumentNo,
        pQuote.LocalOrderNo,
        pQuote.ClientId,
        pQuote.InstrumentId,
        pQuote.ExchangeId,             //交易所代码
        pQuote.UserId,                 //原始报单交易用户代码
        pQuote.QuoteReqId,             //报价请求ID,预留字段,当报价是对请求的响应时，填写报价请求的ID
        pQuote.BidPx,                  //买报价
        pQuote.AskPx,                  //卖报价
        pQuote.BidSize,                //买数量
        pQuote.AskSize,                //卖数量
        pQuote.BidOffsetFlag,          //平仓标识
        pQuote.AskOffsetFlag,          //平仓标识
        pQuote.OwnerType,              //订单所有类型
        pQuote.OrderSysId,             //交易所订单编号
        pQuote.BidOrderId,             //买方交易所订单编号
        pQuote.AskOrderId,             //卖方交易所订单编号
        pQuote.OrdStatus,              //当前订单状态
        pQuote.OrderTime);              //委托时间
}
