#ifndef _CC_SINGLETON_H_
#define _CC_SINGLETON_H_

#include <mutex>
#include <new>

namespace CC{

template <typename T>
class Singleton
{
public:

    static inline T* GetInstance()
    {
        std::lock_guard<std::mutex> lock(_Mutex);
        if (!_pIns)
            _pIns = new(std::nothrow) T;
        return _pIns;
    }

    static inline void Release()
    {
        std::lock_guard<std::mutex> lock(_Mutex);
        if (_pIns)
        { 
            delete _pIns;
            _pIns = nullptr;
        }
    }

protected:

    Singleton() = default;
    virtual ~Singleton() = default;

private:

    static T* _pIns;
    static std::mutex _Mutex;
};

template<typename T>
T* Singleton<T>::_pIns = nullptr;

template<typename T>
std::mutex Singleton<T>::_Mutex;

}

#endif
