#include "getconfig.h"
#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <time.h>
#include <vector>

/*函数名称：getSubstr()
函数功能：以空格为分隔符分割字段
版本号：20120201
参数1：const string originstr 	要分割的字符串
参数2：int subn	要提取第几段
参数3：string delims		指定分隔符，默认是空格
返回值：截取出来的字段*/
string getSubstr(const string originstr, int subn, string delims)
{
	string str = originstr;
	string::size_type pbegin = 0;	//指向字符串要截取的开始位置
	string::size_type pend = 0;		//指向字符串要截取的结束位置
	for (int i = 1; i <= subn; i++)
	{
		pbegin = str.find_first_not_of(delims, pend);	//以上一次结束位置为起点寻找第一个不是分隔符的位置，作为新的起点
		if (str.find(delims, pend + 1) == string::npos) //如果没找到分隔符则认为是最后一段了。
		{
			if (i < subn) return "";		//如果已经搜索到最后一段了，但指定要分割的段数超出了界限，则返回空值。
			pend = str.length() + 1; break;	//把结束位置设置为字符串最后位置
		}
		pend = str.find(delims, pbegin);
	}
	str = str.substr(pbegin, pend - pbegin);		//截取字符串
	return str;
}
/*函数名称：getConfig()
函数功能：获取配置文件ini中相应大标题title下指定配置字段cfgname的值
参数1：string title		大标题[***]
参数2：string cfgName		大标题下的配置字段
返回值：配置文件ini中相应大标题title下指定配置字段cfgname的值
*/
string getConfig(string title, string cfgName)
{
	const char* INIFile = "config.ini";
	ifstream inifile(INIFile);
	if (!inifile.is_open())
	{
		cerr << "Could not open " << INIFile << endl;
		inifile.clear();
		exit(-1);
	}
	string strtmp, strtitle, strcfgname, returnValue;
	int flag = 0;
	while (getline(inifile, strtmp, '\n'))
	{
		if (strtmp.substr(0, 1) == "#")	continue;	//过滤注释		
		if (flag == 0)
		{
			if (strtmp.find(title) != string::npos)
			{
				if (strtmp.substr(0, 1) == "[")
				{
					if (strtmp.find("]") == string::npos) 	break;	//缺失“]”退出
					strtitle = strtmp.substr(1);
					strtitle = strtitle.erase(strtitle.find("]"));
					if (strtitle == title)		//找到大标题设置标志位为1，这样就不再找下一个大标题了
					{
						flag = 1;
						continue;
					}
				}
			}
		}
		if (flag == 1)
		{
			if (strtmp.substr(0, 1) == "[")	break;	//如果遇到下一个[]号说明当前大标题对应的配置字段搜索完毕，结束搜索。
			if (strtmp.find(cfgName) != string::npos)
			{
				if (strtmp.find("=") == string::npos)	break;	//缺失“=”退出
				strcfgname = strtmp;
				strcfgname = strcfgname.erase(strcfgname.find("="));
				if (strcfgname == cfgName)		//找到大标题相应的字段后，返回值
				{
					returnValue = strtmp.substr(strtmp.find("=") + 1);
					if(std::string::npos != returnValue.find('\r'))
					{
						returnValue.erase(returnValue.find('\r'));
					}

					return returnValue;
				}
				else continue;
			}
		}
	}
	cout << "配置文件错误：没找到" << title << "对应配置项" << cfgName << "！" << endl;
	cin.ignore();
	cin.get();
	exit(-1);
}
