#include "subtitdspi.h"
#include "ccdeclare.h"


////当客户端与交易后台建立起通信连接时（还未登录前），该方法被调用。
void CSubTiTdSpi::OnConnected()
{	
	Logs->Trace("OnConnected");
	Logs->Trace("----------");
}

///当客户端与交易后台通信连接断开时，该方法被调用。当发生这个情况后，API会自动重新连接，客户端可不做处理。
///@param nReason 错误原因
///        0x1001 网络读失败
///        0x1002 网络写失败
///        0x2001 接收心跳超时
///        0x2002 发送心跳失败
///        0x2003 收到错误报文
void CSubTiTdSpi::OnDisconnected(int nReason)
{
	Logs->Trace("OnDisconnected");
	Logs->Info("nReason:{:0x}", nReason);
	Logs->Trace("----------");
}

///用户登录应答
void CSubTiTdSpi::OnRspUserLogin(CTdRspUserLoginField& pRspUserLogin, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspUserLogin");
	Logs->Info("ErrorId:{}, ErrorMsg:{}, bIsLast:{}",pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast);
	Logs->Info("SessionNo:{}, TradingDay:{}, LoginTime:{}, MaxLocalOrderNo:{}, UserId:{}, TradingSystemName:{}, SequenceNo:{}, ActionDay:{}",
				pRspUserLogin.SessionNo,         // 本次登录的session
				pRspUserLogin.TradingDay,        // 交易日    
				pRspUserLogin.LoginTime,         // 登录成功时间    
				pRspUserLogin.MaxLocalOrderNo,   // 最大会员内部订单编号    
				pRspUserLogin.UserId,            // 交易用户代码        
				pRspUserLogin.TradingSystemName, // 交易系统名称        
				pRspUserLogin.SequenceNo,        // 当前用户接收的私有流最新序号        
				pRspUserLogin.ActionDay);        // 业务发生日期
	
	char s[100];
	time_t rawtime = pRspUserLogin.LoginTime;
	struct tm* timeinfo = localtime(&rawtime);
	strftime(s, sizeof(s), "%Y-%m-%d %H:%M:%S", timeinfo);
	printf("登录时间:%s\n", s);
		
	Logs->Trace("----------");
}

///用户退出应答
void CSubTiTdSpi::OnRspUserLogout(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspUserLogout");
	Logs->Info("ErrorId:{}, ErrorMsg:{}, bIsLast:{}",pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast);
	Logs->Trace("----------");
}

///用户密码修改应答
void CSubTiTdSpi::OnRspUserPasswordUpdate(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspUserPasswordUpdate");
	Logs->Info("ErrorId:{}, ErrorMsg:{}, bIsLast:{}",pRspInfo.ErrorId, pRspInfo.ErrorMsg, bIsLast);
	Logs->Trace("----------");
}

/*
报单相关的函数对应的OnRsp

只有错误的时候才响应的函数
1、OnRspStockInsert
2、OnRspStockCancel
3、OnRspStockLock
4、OnRspOptionsInsert
5、OnRspOptionsCancel
6、OnRspQuoteInsert
7、OnRspQuoteCancel
8、OnRspExercise
9、OnRspCombExercise
10、OnRspExerciseCancel
11、OnRspMarginCombAction
用Logs.Error红色显示

正确错误都应答的函数
1、OnRspForQuote(询价应答，询价正确也应答是为了让用户知道询价已有效报入)
用Logs.Warn颜色显示(跟回报一样颜色)

其他
Logs->Info    查询回报等
Logs->Trace   请求等
*/

///股票报单应答
void CSubTiTdSpi::OnRspStockInsert(CTdStockInsertRspField& pStockInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{


	Logs->Trace("OnRspStockInsert");

	Logs->Error("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);

	Logs->Error("ClientNo:{}, InstrumentNo:{}, LocalOrderNo:{}, PriceType:{:d}, Side:{:d}, TimeInForce:{:d},Volume:{},"                    
				"Price:{}, OwnerType:{:d}, ExchangeId:{:d}, FrontNo:{:d}, SessionNo:{}, OrderSysId:{}",                 
				pStockInsert.ClientNo,                //交易编码序号
				pStockInsert.InstrumentNo,               //合约序号
				pStockInsert.LocalOrderNo,               //会员内部订单编号
				pStockInsert.PriceType,                 //报单价格条件
				pStockInsert.Side,                      //买卖方向
				pStockInsert.TimeInForce,                //订单有效时间类型
				pStockInsert.Volume,                     //数量
				pStockInsert.Price,                      //价格
				pStockInsert.OwnerType,                  //订单所有类型
				pStockInsert.ExchangeId,                 //交易所代码
				pStockInsert.FrontNo,                    //处理本次报单的实际席位序号
				pStockInsert.SessionNo,                  //发送该报单的session
				pStockInsert.OrderSysId);                 //交易所订单编号
	Logs->Trace("----------");
};

///股票撤单应答
void CSubTiTdSpi::OnRspStockCancel(CTdOrderCancelRspField& pStockCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspStockCancel");
	
	Logs->Error("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", 
		pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);
	
	Logs->Error("OriSessionNo:{}, OriLocalOrderNo:{}, OrderSysId:{}, SessionNo:{}",
		pStockCancel.OriSessionNo,        //原始报单的sessionno
		pStockCancel.OriLocalOrderNo,     //原始交易客户方订单编号
		pStockCancel.OrderSysId,          //交易所订单编号
		pStockCancel.SessionNo);           //发送该报单的session

	Logs->Trace("----------");
};

///证券锁定应答
void CSubTiTdSpi::OnRspStockLock(CTdStockLockRspField& pStockLock, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) 
{
	Logs->Trace("OnRspStockLock");
		
	Logs->Error("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);
	Logs->Error("ClientNo:{}, InstrumentNo:{}, LocalOrderNo:{}, Locked:{:d}, Volume:{}, ExchangeId:{:d}, "
	"FrontNo:{:d}, SessionNo:{}, OrderSysId:{}",
	pStockLock.ClientNo,                 //交易编码序号
	pStockLock.InstrumentNo,             //合约序号
	pStockLock.LocalOrderNo,             //会员内部订单编号
	pStockLock.Locked,                   //锁定标志
	pStockLock.Volume,                   //数量
	pStockLock.ExchangeId,               //交易所代码
	pStockLock.FrontNo,                  //处理本次报单的实际席位序号
	pStockLock.SessionNo,                //发送该报单的session
	pStockLock.OrderSysId);               //交易所订单编号

	Logs->Trace("----------");
};

///期权,期货报单应答
void CSubTiTdSpi::OnRspOptionsInsert(CTdOrderInsertRspField& pOptionsInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{


	Logs->Trace("OnRspOptionsInsert");
		
		Logs->Error("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", 
		pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);

		Logs->Error("ClientNo:{}, InstrumentNo:{}, LocalOrderNo:{}, PriceType:{:d}, Side:{:d}, "
		"OffsetFlag:{:d}, HedgeFlag:{:d}, TimeInForce:{:d}, CoveredOrUncovered:{:d}, "
		"VolumeCondition:{:d}, TrigCondition:{:d}, Volume:{}, MinVolume:{}, Price:{}, StopPrice:{}, "
		"OwnerType:{:d}, ExchangeId:{:d}, FrontNo:{:d}, SessionNo:{}, OrderSysId:{}",

			pOptionsInsert.ClientNo,        //交易编码序号
			pOptionsInsert.InstrumentNo,    //合约序号
			pOptionsInsert.LocalOrderNo,    //会员内部订单编号
			pOptionsInsert.PriceType,       //报单价格条件
			pOptionsInsert.Side,            //买卖方向
			pOptionsInsert.OffsetFlag,      //开平标记
			pOptionsInsert.HedgeFlag,       //投机套保标记
			pOptionsInsert.TimeInForce,     //订单有效时间类型
			pOptionsInsert.CoveredOrUncovered,    //备兑标签
			pOptionsInsert.VolumeCondition,       //成交量类型
			pOptionsInsert.TrigCondition,    //触发条件
			pOptionsInsert.Volume,           //数量
			pOptionsInsert.MinVolume,        //最小成交量
			pOptionsInsert.Price,            //价格
			pOptionsInsert.StopPrice,        //止损价
			pOptionsInsert.OwnerType,        //订单所有类型
			pOptionsInsert.ExchangeId,       //交易所代
			pOptionsInsert.FrontNo,          //处理本次报单的实际席位序号
			pOptionsInsert.SessionNo,        //发送该报单的session
			pOptionsInsert.OrderSysId);       //交易所订单编号
		
	Logs->Trace("----------");
};

///期权,期货撤单应答
void CSubTiTdSpi::OnRspOptionsCancel(CTdOrderCancelRspField& pOptionsCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspOptionsCancel");
		
		Logs->Error("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", 
		pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);
		
		Logs->Error("OriSessionNo:{},OriLocalOrderNo:{},OrderSysId:{},SessionNo:{}",
		    pOptionsCancel.OriSessionNo,        //原始报单的sessionno
        	pOptionsCancel.OriLocalOrderNo,     //原始交易客户方订单编号
        	pOptionsCancel.OrderSysId,          //交易所订单编号
        	pOptionsCancel.SessionNo);           //发送该报单的session
	
	Logs->Trace("----------");
};

///期权,期货报价应答
void CSubTiTdSpi::OnRspQuoteInsert(CTdQuoteInsertRspField& pQuoteInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) 
{
	Logs->Trace("OnRspQuoteInsert");
		
		Logs->Error("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", 
		pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);
		
		Logs->Error("ClientNo:{}, InstrumentNo:{}, LocalOrderNo:{}, QuoteReqId:{}, BidPx:{}, AskPx:{}, "
		"BidSize:{}, AskSize:{}, BidOffsetFlag:{:d}, AskOffsetFlag:{:d}, OwnerType:{:d}, ExchangeId:{:d}, FrontNo:{:d}, "
		"SessionNo:{}, OrderSysId:{}, BidOrderId:{}, AskOrderId:{}",
		    pQuoteInsert.ClientNo,            //交易编码序号
			pQuoteInsert.InstrumentNo,        //合约序号
			pQuoteInsert.LocalOrderNo,        //会员内部订单编号
			pQuoteInsert.QuoteReqId,          //报价请求ID,预留字段,当报价是对请求的响应时，填写报价请求的ID
			pQuoteInsert.BidPx,               //买报价
			pQuoteInsert.AskPx,               //卖报价
			pQuoteInsert.BidSize,             //买数量
			pQuoteInsert.AskSize,             //卖数量
			pQuoteInsert.BidOffsetFlag,       //平仓标识
			pQuoteInsert.AskOffsetFlag,       //平仓标识
			pQuoteInsert.OwnerType,           //订单所有类型
			pQuoteInsert.ExchangeId,          //交易所代码
			pQuoteInsert.FrontNo,             //处理本次报单的实际席位序号
			pQuoteInsert.SessionNo,           //发送该报单的session
			pQuoteInsert.OrderSysId,          //交易所订单编号
			pQuoteInsert.BidOrderId,          //买方交易所订单编号
			pQuoteInsert.AskOrderId);         //卖方交易所订单编号

	Logs->Trace("----------");
};

///期权,期货撤销报价应答
void CSubTiTdSpi::OnRspQuoteCancel(CTdOrderCancelRspField& pQuoteCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) 
{
	Logs->Trace("OnRspQuoteCancel");
		
		Logs->Error("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", 
		pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);
		
		Logs->Error("OriSessionNo:{},OriLocalOrderNo:{},OrderSysId:{},SessionNo:{}",
		pQuoteCancel.OrderSysId,        //原始报单的sessionno
		pQuoteCancel.OriLocalOrderNo,     //原始交易客户方订单编号
		pQuoteCancel.OrderSysId,          //交易所订单编号
		pQuoteCancel.SessionNo);          //发送该报单的session
	
	Logs->Trace("----------");
};

///询价应答
void CSubTiTdSpi::OnRspForQuote(CTdForQuoteRspField& pForQuote, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) 
{
	Logs->Trace("OnRspForQuote");
		
	Logs->Error("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);

	Logs->Error("ClientNo:{}, InstrumentNo:{}, LocalOrderNo:{}, OwnerType:{:d}, ExchangeId:{:d}, FrontNo:{:d}, SessionNo:{}, QuoteReqId:{}",
		pForQuote.ClientNo,                  //交易编码序号
        pForQuote.InstrumentNo,              //合约序号
        pForQuote.LocalOrderNo,              //会员内部订单编号
        pForQuote.OwnerType,                 //订单所有类型
        pForQuote.ExchangeId,                //交易所代码
        pForQuote.FrontNo,                   //处理本次报单的实际席位序号
        pForQuote.SessionNo,                 //发送该报单的session
        pForQuote.QuoteReqId);               //报价请求ID
		
	Logs->Trace("----------");
};

///行权应答
void CSubTiTdSpi::OnRspExercise(CTdExerciseRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspExercise");
		
	Logs->Error("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", 
	pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);
	
	Logs->Error("ClientNo:{}, InstrumentNo:{}, LocalOrderNo:{}, Volume:{}, OwnerType:{:d}, ExchangeId:{:d}, FrontNo:{:d}, SessionNo:{}, OrderSysId:{}",
			pExercise.ClientNo,                 //交易编码序号
			pExercise.InstrumentNo,             //合约序号
			pExercise.LocalOrderNo,             //会员内部订单编号
			pExercise.Volume,                   //申报数量
			pExercise.OwnerType,                //订单所有类型
			pExercise.ExchangeId,               //交易所代码
			pExercise.FrontNo,                  //处理本次报单的实际席位序号
			pExercise.SessionNo,                //发送该报单的session
			pExercise.OrderSysId);              //交易所订单编号
	
	Logs->Trace("----------");
};

///组合行权应答
void CSubTiTdSpi::OnRspCombExercise(CTdCombExerciseRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspCombExercise");
		
	Logs->Error("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", 
	pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);
	
	Logs->Error("ClientNo:{}, LocalOrderNo:{}, Volume:{}, LegInstrumentNo1:{}, LegVolume1:{}, LegInstrumentNo2:{}, LegVolume2:{}, OwnerType:{:d}, ExchangeId:{:d}, FrontNo:{:d}, SessionNo:{}",
			pExercise.ClientNo,                   //交易编码序号
			pExercise.LocalOrderNo,               //会员内部订单编号
			pExercise.Volume,                     //申报数量
			pExercise.LegInstrumentNo1,           //腿1合约序号
			pExercise.LegVolume1,                 //腿1申报数量
			pExercise.LegInstrumentNo2,           //腿2合约序号
			pExercise.LegVolume2,                 //腿2申报数量
			pExercise.OwnerType,                  //订单所有类型
			pExercise.ExchangeId,                 //交易所代码
			pExercise.FrontNo,                    //处理本次报单的实际席位序号
			pExercise.SessionNo);                 //发送该报单的session
	
	Logs->Trace("----------");
};

///撤销行权应答
void CSubTiTdSpi::OnRspExerciseCancel(CTdOrderCancelRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspExerciseCancel");
	
	Logs->Error("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", 
	pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);
	
	Logs->Error("OriSessionNo:{}, OriLocalOrderNo:{}, OrderSysId:{}, 	SessionNo:{}", 
			pExercise.OriSessionNo,        //原始报单的sessionno
			pExercise.OriLocalOrderNo,     //原始交易客户方订单编号
			pExercise.OrderSysId,          //交易所订单编号
			pExercise.SessionNo);          //发送该报单的session
	
	Logs->Trace("----------");
};

///客户申请组合应答
void CSubTiTdSpi::OnRspMarginCombAction(CTdMarginCombActionRspField& pMarginCombAction, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspMarginCombAction");
		
		Logs->Error("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", 
		pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);
		
		Logs->Error("ClientNo:{},LocalOrderNo:{},Volume:{}, Side:{},CombId:{}, CombInstId:{},OwnerType:{:d}, ExchangeId:{:d},FrontNo:{:d},SessionNo:{}, NoLeges:{}\n"
				"InstrumentNo:{}, LegSide:{}, {:d}, {} \n"
				"InstrumentNo:{}, LegSide:{}, {:d}, {} \n",
				// "InstrumentNo:{}, LegSide:{}, {:d}, {} \n"
				// "InstrumentNo:{}, LegSide:{}, {:d}, {} \n",
		pMarginCombAction.ClientNo,               //交易编码序号
        pMarginCombAction.LocalOrderNo,           //会员内部订单编号
        pMarginCombAction.Volume,                 //申报数量(拆分组合的时候需要填入拆分的数量，组合的时候该字段无效)
        pMarginCombAction.Side,                   //组合与拆分组合标记,组合策略为“ZBD”时，组合与拆分方向只能为组合
        pMarginCombAction.CombId,                 //组合策略编码:目前为7种组合策略：CNSJC、PXSJC、PNSJC、CXSJC、KS、KKS、ZBD
        pMarginCombAction.CombInstId,             //组合编码。组合申报成功时返回组合的组合编码
        pMarginCombAction.OwnerType,              //订单所有类型
        pMarginCombAction.ExchangeId,             //交易所代码
        pMarginCombAction.FrontNo,                //处理本次报单的实际席位序号
        pMarginCombAction.SessionNo,              //发送该报单的session
        pMarginCombAction.NoLeges,                                    //成分合约数，取值不超过4，后接重复组
		pMarginCombAction.item[0].LegInstrumentNo,          //合约编码
        pMarginCombAction.item[0].LegSide,                  //合约方向
        pMarginCombAction.item[0].CoveredOrUncovered,    //备兑标签
        pMarginCombAction.item[0].LegVolume, 
		pMarginCombAction.item[1].LegInstrumentNo,          //合约编码
        pMarginCombAction.item[1].LegSide,                  //合约方向
        pMarginCombAction.item[1].CoveredOrUncovered,    //备兑标签
        pMarginCombAction.item[1].LegVolume); 
		// pMarginCombAction.item[2].LegInstrumentNo,          //合约编码
        // pMarginCombAction.item[2].LegSide,                  //合约方向
        // pMarginCombAction.item[2].CoveredOrUncovered,    //备兑标签
        // pMarginCombAction.item[2].LegVolume, 
		// pMarginCombAction.item[3].LegInstrumentNo,          //合约编码
        // pMarginCombAction.item[3].LegSide,                  //合约方向
        // pMarginCombAction.item[3].CoveredOrUncovered,    //备兑标签
        // pMarginCombAction.item[3].LegVolume 

	Logs->Trace("----------");
};

/*
*  异步查询相关的函数
*
*
*
*
*/


///股票报单查询应答
void CSubTiTdSpi::OnRspQryStockOrder(CTdRspQryStockOrderField& pOrder, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspQryStockOrder");
	Logs->Info("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);
	    
	Logs->Info("RequestNo:{}, ClientId:{},InstrumentId:{}, ClientNo:{},InstrumentNo:{},LocalOrderNo:{},PriceType:{:d},Side:{:d},TimeInForce:{:d}, "
	"Volume:{},Price:{},OwnerType:{:d},ExchangeId:{:d},FrontNo:{:d},SessionNo:{},OrdStatus:{:d},TransTime:{},OrderSysId:{},UserId:{}",
		pOrder.RequestNo,              //报单请求编号
        pOrder.ClientId,
        pOrder.InstrumentId,
        pOrder.ClientNo,               //交易编码序号
        pOrder.InstrumentNo,           //合约序号
        pOrder.LocalOrderNo,           //会员内部订单编号
        pOrder.PriceType,              //报单价格条件
        pOrder.Side,                   //买卖方向
        pOrder.TimeInForce,            //订单有效时间类型
        pOrder.Volume,                 //数量
        pOrder.Price,                  //价格
        pOrder.OwnerType,              //订单所有类型
        pOrder.ExchangeId,             //交易所代码
        pOrder.FrontNo,                //处理本次报单的实际席位序号
        pOrder.SessionNo,              //发送该报单的session
        pOrder.OrdStatus,              //订单状态
        pOrder.TransTime,              //发生时间
        pOrder.OrderSysId,             //交易所订单编号
        pOrder.UserId);                 //原始报单交易用户代码
	Logs->Trace("----------");
};

///期权,期货报单查询应答
void CSubTiTdSpi::OnRspQryOptionsOrder(CTdRspQryOptionsOrderField& pOrder, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspQryOptionsOrder");

	Logs->Info("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", 
		pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);


//	char s[100];
//	time_t rawtime = pOrder.TransTime;
//	struct tm* timeinfo = localtime(&rawtime);
//	strftime(s, sizeof(s), "%Y-%m-%d %H:%M:%S", timeinfo);

	Logs->Info("RequestNo:{},ClientId:{}, InstrumentId:{}, ClientNo:{}, InstrumentNo:{}, LocalOrderNo:{}, PriceType:{:d}, Side:{:d}, OffsetFlag:{:d}, HedgeFlag:{:d}, TimeInForce:{:d}, " 
		"CoveredOrUncovered:{:d}, VolumeCondition:{:d}, TrigCondition:{:d}, Volume:{}, MinVolume:{}, Price:{}, StopPrice:{}, OwnerType:{:d}, ExchangeId:{:d}, FrontNo:{:d}, "
        "SessionNo:{}, OrdStatus:{:d}, TransTime:{}, OrderSysId:{}, UserId:{}",
		pOrder.RequestNo,              //报单请求编号
        pOrder.ClientId,
        pOrder.InstrumentId,
        pOrder.ClientNo,               //交易编码序号
        pOrder.InstrumentNo,           //合约序号
        pOrder.LocalOrderNo,           //会员内部订单编号
        pOrder.PriceType,              //报单价格条件
        pOrder.Side,                   //买卖方向
        pOrder.OffsetFlag,             //开平标记
        pOrder.HedgeFlag,              //投机套保标记
        pOrder.TimeInForce,           //订单有效时间类型
        pOrder.CoveredOrUncovered,    //备兑标签
        pOrder.VolumeCondition,       //成交量类型
        pOrder.TrigCondition,          //触发条件
        pOrder.Volume,                 //数量
        pOrder.MinVolume,              //最小成交量
        pOrder.Price,                  //价格
        pOrder.StopPrice,              //止损价
        pOrder.OwnerType,              //订单所有类型
        pOrder.ExchangeId,             //交易所代
        pOrder.FrontNo,                //处理本次报单的实际席位序号
        pOrder.SessionNo,              //发送该报单的session
        pOrder.OrdStatus,              //订单状态
		pOrder.TransTime,             //发生时间
        pOrder.OrderSysId,             //交易所订单编号
        pOrder.UserId);                 //原始报单交易用户代码

	    
	Logs->Trace("----------");
};

///报价查询应答
void CSubTiTdSpi::OnRspQryQuoteOrder(CTdRspQryQuoteOrderField& pQuote, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspQryQuoteOrder");
	Logs->Info("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);
	Logs->Info("RequestNo:{}, ClientId:{}, InstrumentId:{}, ClientNo:{}, InstrumentNo:{}, LocalOrderNo:{}, QuoteReqId:{}, BidPx:{}, "
    "AskPx:{}, BidSize:{}, AskSize:{}, BidOffsetFlag:{:d}, AskOffsetFlag:{:d}, OwnerType:{:d}, ExchangeId:{:d}, FrontNo:{:d},"
    "SessionNo:{}, OrderSysId:{}, BidOrderId:{}, AskOrderId:{}, BidStatus:{:d}, AskStatus:{:d}, TransTime:{}, UserId:{}",
	pQuote.RequestNo,
	pQuote.ClientId,
	pQuote.InstrumentId,
	pQuote.ClientNo,
	pQuote.InstrumentNo,
	pQuote.LocalOrderNo,
	pQuote.QuoteReqId,
	pQuote.BidPx,
	pQuote.AskPx,
	pQuote.BidSize,
	pQuote.AskSize,
	pQuote.BidOffsetFlag,
	pQuote.AskOffsetFlag,
	pQuote.OwnerType,
	pQuote. ExchangeId,
	pQuote.FrontNo,
	pQuote.SessionNo,
	pQuote.OrderSysId,
	pQuote.BidOrderId,
	pQuote.AskOrderId,
	pQuote.BidStatus,
	pQuote.AskStatus,
	pQuote.TransTime,
	pQuote.UserId);
	Logs->Trace("----------");
};

///查询行权应答
void CSubTiTdSpi::OnRspQryExercise(CTdRspQryExerciseField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspQryExercise");
	Logs->Info("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);

	Logs->Info("ClientNo:{}, InstrumentNo:{}, ClientId:{}, InstrumentId:{}, LocalOrderNo:{}, Volume:{}, OwnerType:{:d}, ExchangeId:{:d}, FrontNo:{}, "
			"SessionNo:{}, OrdStatus:{:d}, TransTime:{}, OrderSysId:{}, UserId:{}",
	pExercise.ClientNo,               //交易编码序号
	pExercise.InstrumentNo,           //合约序号
    pExercise.ClientId,               //交易编码
    pExercise.InstrumentId,           //合约编码
    pExercise.LocalOrderNo,           //会员内部订单编号
    pExercise.Volume,                 //申报数量
    pExercise.OwnerType,              //订单所有类型
    pExercise.ExchangeId,             //交易所代码
    pExercise.FrontNo,                //处理本次报单的实际席位序号
    pExercise.SessionNo,              //发送该报单的session
    pExercise.OrdStatus,              //订单状态
    pExercise.TransTime,              //发生时间
    pExercise.OrderSysId,             //交易所订单编号
    pExercise.UserId);                 //原始报单交易用户代码
	Logs->Trace("----------");
};

///查询组合行权应答
void CSubTiTdSpi::OnRspQryCombExercise(CTdRspQryCombExerciseField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspQryCombExercise");
	Logs->Info("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);

	Logs->Info("ClientNo:{}, ClientId:{}, LocalOrderNo:{}, Volume:{}, LegInstrumentNo1:{}, InstrumentId1:{}, LegVolume1:{}, "
			"LegInstrumentNo2:{}, InstrumentId2:{}, LegVolume2:{}, "
			"OwnerType:{:d}, ExchangeId:{:d}, FrontNo:{}, SessionNo:{}, OrdStatus:{:d}, TransTime:{}, OrderSysId:{}, UserId:{}",
	pExercise.ClientNo,               //交易编码序号
	pExercise.ClientId,               //交易编码
	pExercise.LocalOrderNo,           //会员内部订单编号
	pExercise.Volume,                 //申报数量
	pExercise.LegInstrumentNo1,       //腿1合约序号
	pExercise.InstrumentId1,          //腿1合约号
	pExercise.LegVolume1,             //腿1申报数量
	pExercise.LegInstrumentNo2,       //腿2合约序号
	pExercise.InstrumentId2,          //腿2合约号
	pExercise.LegVolume2,             //腿2申报数量
	pExercise.OwnerType,              //订单所有类型
	pExercise.ExchangeId,             //交易所代码
	pExercise.FrontNo,                //处理本次报单的实际席位序号
	pExercise.SessionNo,              //发送该报单的session
	pExercise.OrdStatus,              //订单状态
	pExercise.TransTime,              //发生时间
	pExercise.OrderSysId,             //交易所订单编号
	pExercise.UserId);                 //原始报单交易用户代码
	Logs->Trace("----------");
};

///股票成交查询应答
void CSubTiTdSpi::OnRspQryStockTrade(CTdRspQryStockTradeField& pTrade, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspQryStockTrade");
	Logs->Info("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);

	Logs->Info("FrontNo:{}, SequenceNo:{}, RequestNo:{}, SessionNo:{}, ClientNo:{}, InstrumentNo:{}, LocalOrderNo:{}, ClientId:{}, InstrumentId:{}, ExchangeId:{}, "
	"Side:{}, TradePrice:{}, TradeVolume:{}, LeavesVolume:{}, TradeTime:{}, OrderSysId:{}, TradeId:{}, UserId:{}",
	pTrade.FrontNo,                //处理本次报单的实际席位序号
    pTrade.SequenceNo,             //回报序号(私有流序号每个交易日连续)
    pTrade.RequestNo,              //报单请求编号
    pTrade.SessionNo,              //原始报单session
    pTrade.ClientNo,
    pTrade.InstrumentNo,
    pTrade.LocalOrderNo,
    pTrade.ClientId,
    pTrade.InstrumentId,
    pTrade.ExchangeId,             //交易所代码
    pTrade.Side,                   //买卖方向
    pTrade.TradePrice,             //成交价格
    pTrade.TradeVolume,            //成交数量
    pTrade.LeavesVolume,           //本次成交后申报余额数量
    pTrade.TradeTime,              //成交时间
    pTrade.OrderSysId,             //交易所报单编号
    pTrade.TradeId,                //成交编号
    pTrade.UserId);               //原始报单交易用户代码
	
	Logs->Trace("----------");
};

///期权,期货成交查询应答
void CSubTiTdSpi::OnRspQryOptionsTrade(CTdRspQryOptionsTradeField& pTrade, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspQryOptionsTrade");

	Logs->Info("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", 
		pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);

	Logs->Info("RequestNo:{}, FrontNo:{:d}, SequenceNo:{}, LocalOrderNo:{} SessionNo:{}, ClientNo:{}, InstrumentNo:{}, ClientId:{}, InstrumentId:{}, "
        "ExchangeId:{:d}, PriceType:{:d}, Side:{:d}, OffsetFlag:{:d}, HedgeFlag:{:d}, TimeInForce:{:d}, CoveredOrUncovered:{:d}, VolumeCondition:{:d}, "
        "TrigCondition:{:d}, OwnerType:{:d}, TradePrice:{}, TradeVolume:{},LeavesVolume:{}, TransTime:{}, OrderSysId:{}, TradeId:{}, UserId:{}",

		pTrade.RequestNo,              //报单请求编号
		pTrade.FrontNo,
        pTrade.SequenceNo,             //回报序号
        pTrade.LocalOrderNo,
        pTrade.SessionNo,              //原始报单session
        pTrade.ClientNo,
        pTrade.InstrumentNo,
        pTrade.ClientId,
        pTrade.InstrumentId,
        pTrade.ExchangeId,             //交易所代码
        pTrade.PriceType,              //报单价格条件
        pTrade.Side,                   //买卖方向
        pTrade.OffsetFlag,             //开平标记
        pTrade.HedgeFlag,              //投机套保标记
        pTrade.TimeInForce,         //有效期类型
        pTrade.CoveredOrUncovered,  //备兑标签
        pTrade.VolumeCondition,     //成交量类型
        pTrade.TrigCondition,       //触发条件
        pTrade.OwnerType,           //订单所有类型
        pTrade.TradePrice,          //成交价格
        pTrade.TradeVolume,         //成交数量
        pTrade.LeavesVolume,        //本次成交后申报余额数量
        pTrade.TransTime,           //成交时间
        pTrade.OrderSysId,          //交易所报单编号
        pTrade.TradeId,             //成交编号
        pTrade.UserId);              //原始报单交易用户代码);

	Logs->Trace("----------");
};

///股票持仓查询应答
void CSubTiTdSpi::OnRspQryStockPosition(CTdRspQryStockPositionField& pPosition, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspQryStcokPosition");
	Logs->Info("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);

	Logs->Info("ClientNo:{},InstrumentNo:{},ClientId:{},InstrumentId:{},ExchangeId:{:d}, YdPosition:{}, "
			"Position:{}, TodayPosition:{}, FrozenVolume:{}, BuyTradeVolume:{}, SellTradeVolume:{}, Price:{}, "
			"LockVolume:{},FrozenLock:{}",
			pPosition.ClientNo,
			pPosition.InstrumentNo,
			pPosition.ClientId,
			pPosition.InstrumentId,
			pPosition.ExchangeId,           /// 交易所代码
			pPosition.YdPosition,           /// 上日持仓
			pPosition.Position,             /// 总持仓
			pPosition.TodayPosition,        /// 今日持仓
			pPosition.FrozenVolume,         /// 冻结数量
			pPosition.BuyTradeVolume,       /// 当日买成交量
			pPosition.SellTradeVolume,      /// 当日卖成交量
			pPosition.Price,                /// 持仓价格
			pPosition.LockVolume,           /// 锁仓数量(已经被锁定的可用于备兑开仓的数量)
			pPosition.FrozenLock);           /// 锁仓冻结数量(解锁时冻结的数量)

	totalPostionAccount += pPosition.Price * pPosition.Position;
	if(bIsLast)
	{
		Logs->Info("持仓总权益: {}", totalPostionAccount);
		totalPostionAccount = 0;
	}

	Logs->Trace("----------");
};

///期权,期货持仓查询应答
void CSubTiTdSpi::OnRspQryOptionsPosition(CTdRspQryOptionsPositionField& pPosition, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspQryOptionsPosition");

	Logs->Info("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", 
		pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);

	Logs->Info("ClientNo:{}, InstrumentNo:{}, ClientId:{}, InstrumentId:{}, ExchangeId:{:d}, Converd:{:d}, "
        "Side:{:d}, YdPosition:{}, Position:{}, TodayPosition:{}, FrozenVolume:{}, BuyTradeVolume:{}, SellTradeVolume:{}, Price:{}, UseMargin:{}",
		pPosition.ClientNo,
        pPosition.InstrumentNo,
        pPosition.ClientId,
        pPosition.InstrumentId,
        pPosition.ExchangeId,         /// 交易所代码
        pPosition.Converd,            /// 备兑标记
        pPosition.Side,               /// 买卖方向
        pPosition.YdPosition,         /// 上日持仓
        pPosition.Position,           /// 总持仓
        pPosition.TodayPosition,      /// 今日持仓
        pPosition.FrozenVolume,       /// 冻结数量
        pPosition.BuyTradeVolume,     /// 当日买成交量
        pPosition.SellTradeVolume,    /// 当日卖成交量
        pPosition.Price,              /// 持仓价格
        pPosition.UseMargin);          /// 占用的保证金(权利金));

	Logs->Trace("----------");
};

///组合持仓查询应答
void CSubTiTdSpi::OnRspQryCombPosition(CTdRspQryCombPositionField& pPosi, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspQryCombPosition");
	Logs->Info("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);

	Logs->Trace("ClientNo:{}, ClientId:{}, ExchangeId:{:d}, CombId:{}, CombInstId:{}, Volume:{}, "
				"FrozenVolume:{}, ComMargin:{},NoLeges:{}\n"
            	"InstrumentNo:{}, InstrumentId:{}, Side:{}, CoveredOrUncovered:{:d}, Volume:{}\n"
				"InstrumentNo:{}, InstrumentId:{}, Side:{}, CoveredOrUncovered:{:d}, Volume:{}\n",
				// "InstrumentNo:{}, InstrumentId:{}, Side:{}, CoveredOrUncovered:{:d}, Volume:{}\n"
				// "InstrumentNo:{}, InstrumentId:{}, Side:{}, CoveredOrUncovered:{:d}, Volume:{}\n",
        pPosi.ClientNo,
        pPosi.ClientId,
        pPosi.ExchangeId,           /// 交易所代码
        pPosi.CombId,               /// 组合策略编码:目前为7种组合策略：CNSJC、PXSJC、PNSJC、CXSJC、KS、KKS、ZBD
        pPosi.CombInstId,           /// 组合编码。组合申报时，该字段为空格；拆分申报时，填写拟拆分组合的组合编码
        pPosi.Volume,               /// 持仓数量
        pPosi.FrozenVolume,         /// 冻结数量
        pPosi.ComMargin,            /// 优惠的保证金
        pPosi.NoLeges,                                /// 成分合约数，取值不超过4，后接重复组
        pPosi.item[0].LegInstrumentNo,          //合约编码
		pPosi.item[0].LegInstrumentId,
        pPosi.item[0].LegSide,                  //合约方向
        pPosi.item[0].CoveredOrUncovered,    //备兑标签
        pPosi.item[0].LegVolume,
        pPosi.item[1].LegInstrumentNo,          //合约编码
		pPosi.item[1].LegInstrumentId,
        pPosi.item[1].LegSide,                  //合约方向
        pPosi.item[1].CoveredOrUncovered,    //备兑标签
        pPosi.item[1].LegVolume); 
        // pPosi.item[2].LegInstrumentNo,          //合约编码
		// pPosi.item[0].LegInstrumentId,
        // pPosi.item[2].LegSide,                  //合约方向
        // pPosi.item[2].CoveredOrUncovered,    //备兑标签
        // pPosi.item[2].LegVolume,
        // pPosi.item[3].LegInstrumentNo,          //合约编码
		// pPosi.item[0].LegInstrumentId,
        // pPosi.item[3].LegSide,                  //合约方向
        // pPosi.item[3].CoveredOrUncovered,    //备兑标签
        // pPosi.item[3].LegVolume);         //交易所订单编号(OrigLocalOrderNo和OrderSysId任意一个即可));
	Logs->Trace("----------");
};

///从服务端获取资金应答
void CSubTiTdSpi::OnRspQryAccount(CTdRspQryAccountField& pAccount, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspQryAccount");

	Logs->Info("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);

	Logs->Info("AccountId:{}, Prebalance:{}, DistribFund:{}, Balance:{}, Commi:{}, "
            "FutMargin:{}, OptMargin:{}, CombMargin:{}, CloseProfit:{}, PosiProfit:{}, "
            "Premium:{}, Deposit:{}, Withdraw:{}, FrozenMargin:{}, FrozenPremium:{}, "
            "FrozenCommi:{}, EntryFees:{}, BuyPremium:{}",
         pAccount.AccountId,                /// 资金帐号
         pAccount.Prebalance,                   /// 上次结算准备金
         pAccount.DistribFund,                  /// 本系统分配资金(起初本系统的最大可用)
         pAccount.Balance,                      /// 结算准备金
         pAccount.Commi,                        /// 手续费
         pAccount.FutMargin,                    /// 当前期货保证金总额
         pAccount.OptMargin,                    /// 当前期权保证金总额
         pAccount.CombMargin,                   /// 当前保证金优惠总额
         pAccount.CloseProfit,                  /// 平仓盈亏
         pAccount.PosiProfit,                   /// 持仓盈亏(浮动盈亏)
         pAccount.Premium,                      /// 期权权利金收支(如果是现货账户则保存开仓时的持仓金额)
         pAccount.Deposit,                      /// 入金金额
         pAccount.Withdraw,                     /// 出金金额
         pAccount.FrozenMargin,                 /// 冻结的保证金
         pAccount.FrozenPremium,                /// 冻结的权利金
         pAccount.FrozenCommi,                  /// 冻结的手续费
         pAccount.EntryFees,                    /// 当日申报费用
         pAccount.BuyPremium);                  /// 权力仓当前占用的权利金(如果是现货账户则表示持仓占用的金额)

	Logs->Trace("----------");
};

///行情查询应答
void CSubTiTdSpi::OnRspQryMarketData(CTdRspQryMarketDataField& pMarketData, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspQryMarketData");
	Logs->Info("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);

	Logs->Info("InstrumentNo:{}, InstrumentId:{}, LastPrice:{}, SettlementPrice:{}, UpperlimitPrice:{}, LowerlimitPrice:{}", 
	    pMarketData.InstrumentNo,        //合约No
        pMarketData.InstrumentId,        //合约代码
        pMarketData.LastPrice,           //最新价
        pMarketData.SettlementPrice,     //昨日结算价
        pMarketData.UpperlimitPrice,     //涨停板价格
        pMarketData.LowerlimitPrice);    //跌停板价格
	Logs->Trace("----------");
};

///通知查询应答
void CSubTiTdSpi::OnRspQryNotify(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspQryNotify");
	Logs->Info("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);
	Logs->Trace("----------");
};


///股票非交易业务报单应答
void CSubTiTdSpi::OnRspBusinessInsert(CTdBusinessInsertRspField& pStockInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{


	Logs->Trace("OnRspBusinessInsert");
	Logs->Info("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);
	
}

///股票非交易业务撤单应答
void CSubTiTdSpi::OnRspBusinessCancel(CTdOrderCancelRspField& pStockCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspBusinessCancel");
	Logs->Info("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);

	Logs->Info("OriSessionNo:{}, OriLocalOrderNo:{}, OrderSysId:{}, SessionNo:{}",
		pStockCancel.OriSessionNo,        //原始报单的sessionno
		pStockCancel.OriLocalOrderNo,     //原始交易客户方订单编号
		pStockCancel.OrderSysId,          //交易所订单编号
		pStockCancel.SessionNo);           //发送该报单的session);
	Logs->Trace("----------");
}

///股票非交易报单查询应答
void CSubTiTdSpi::OnRspQryBusinessOrder(CTdRspQryBusinessOrderField& pOrder, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
	Logs->Trace("OnRspQryBusinessOrder");
	Logs->Info("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);

	Logs->Info("BusinessType:{:d}, RequestNo:{}, ClientId:{}, InstrumentId:{}, ClientNo:{}, LocalOrderNo:{}, Side:{:d}, Volume:{}, "
	"Price:{}, ExchangeId:{:d}, FrontNo:{}, SessionNo:{}, OrdStatus:{:d}, TransTime:{}, OrderSysId:{}, UserId:{}, DestInstrumentId:{}",
		pOrder.BusinessType,//业务类型
		pOrder.RequestNo,//报单请求编号
		pOrder.ClientId,
		pOrder.InstrumentId,
		pOrder.ClientNo,//交易编码序号
		pOrder.LocalOrderNo,//会员内部订单编号
		//TdPriceTypeTypePriceType,//报单价格条件
		pOrder.Side,//买卖方向
		//TdTimeInForceTypeTimeInForce,//订单有效时间类型
		pOrder.Volume,//数量
		pOrder.Price,//价格
		//TdOwnerTypeTypeOwnerType,//订单所有类型
		pOrder.ExchangeId,//交易所代码
		pOrder.FrontNo,//处理本次报单的实际席位序号
		pOrder.SessionNo,//发送该报单的session
		pOrder.OrdStatus,//订单状态
		pOrder.TransTime,//发生时间
		pOrder.OrderSysId,//交易所订单编号
		pOrder.UserId,//原始报单交易用户代码
		pOrder.DestInstrumentId);//目标合约代码),
	Logs->Trace("----------");
}

///股票非交易业务委托回报
void CSubTiTdSpi::OnRtnBusinessOrder(CTdBusinessOrderRtnField& pOrder)
{
	Logs->Trace("OnRtnBusinessOrder");
//	Logs->Info("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);

	Logs->Info("BusinessType:{:d}, SequenceNo:{}, RequestNo:{}, SessionNo:{}, ClientNo:{}, LocalOrderNo:{}, ClientId:{}"
	"UserId:{}, InstrumentId:{}, ExchangeId:{:d}, Side:{:d}, OrdStatus:{:d}, Price:{}, Volume:{}, "
	"OrderTime:{}, OrderSysId:{}, LeavesVolume:{}, CancelVolume:{}",
	pOrder.BusinessType,//业务类型
	pOrder.SequenceNo,//回报序号(私有流序号每个交易日连续)
	pOrder.RequestNo,//报单请求编号
	pOrder.SessionNo,//原始报单session
	pOrder.ClientNo,
	pOrder.LocalOrderNo,
	pOrder.ClientId,
	pOrder.UserId,//原始报单交易用户代码
	pOrder.InstrumentId,
	pOrder.ExchangeId,//交易所代码
	//TdPriceTypeTypePriceType,//报单价格条件
	pOrder.Side,//买卖方向
	//TdTimeInForceTypeTimeInForce,//有效期类型
	//TdOwnerTypeTypeOwnerType,//订单所有类型
	pOrder.OrdStatus,//订单状态
	pOrder.Price,//价格
	pOrder.Volume,//数量
	pOrder.OrderTime,//委托时间
	pOrder.OrderSysId,//交易所报单编号
	pOrder.LeavesVolume,//订单剩余数量(交易所返回字段,每个交易所的含义不同)
	pOrder.CancelVolume,//订单撤销数量
    pOrder.DestInstrumentId);           //目标合约代码);
	Logs->Trace("----------\n");
}

///股票非交易业务成交回报
void CSubTiTdSpi::OnRtnBusinessTrade(CTdBusinessTradeRtnField& pTrade)
{
	Logs->Trace("OnRtnBusinessTrade");
//	Logs->Info("ErrorId:{}, ErrorMsg:{}, nRequestID:{}, bIsLast:{}", pRspInfo.ErrorId, pRspInfo.ErrorMsg, nRequestID, bIsLast);

	Logs->Info("BusinessType:{:d}, SequenceNo:{}, RequestNo:{}, SessionNo:{}, ClientNo:{}, LocalOrderNo:{}, ClientId:{}"
	"InstrumentId:{}, ExchangeId:{:d}, Side:{:d}, TradePrice:{}, TradeVolume:{}, LeavesVolume:{}, TradeTime:{}, OrderSysId:{}, TradeId:{}, UserId:{}, DestInstrumentId:{}",
	pTrade.BusinessType,//业务类型
	pTrade.SequenceNo,//回报序号(私有流序号每个交易日连续)
	pTrade.RequestNo,//报单请求编号
	pTrade.SessionNo,//原始报单session
	pTrade.ClientNo,
	pTrade.LocalOrderNo,
	pTrade.ClientId,
	pTrade.InstrumentId,
	pTrade.ExchangeId,//交易所代码
	pTrade.Side,//买卖方向
	pTrade.TradePrice,//成交价格
	pTrade.TradeVolume,//成交数量
	pTrade.LeavesVolume,//本次成交后申报余额数量
	pTrade.TradeTime,//成交时间
	pTrade.OrderSysId,//交易所报单编号
	pTrade.TradeId,//成交编号
	pTrade.UserId,//原始报单交易用户代码
	pTrade.DestInstrumentId);//目标合约代码),
	Logs->Trace("----------\n");
}

/*
*  回报相关的函数
*
*
*
*
*/


///期权,期货委托回报
void CSubTiTdSpi::OnRtnOptionsOrder(CTdOptionsOrderRtnField& pOrder)
{


	Logs->Trace("OnRtnOptionsOrder");

	Logs->Warn("FrontNo:{:d}, SequenceNo:{}, RequestNo:{}, SessionNo:{},  ClientNo:{},  InstrumentNo:{},  LocalOrderNo:{},  ClientId:{},  InstrumentId:{},  ExchangeId:{:d},  PriceType:{:d},  Side:{:d},  TimeInForce:{:d},  OwnerType:{:d},  OrdStatus:{:d},  Price:{},  Volume:{},  OrderTime:{},  OrderSysId:{},  LeavesVolume:{},  CancelVolume:{},  MinVolume:{},  StopPrice:{}, OffsetFlag:{:d},  HedgeFlag:{:d}, CoveredOrUncovered:{:d},  VolumeCondition:{:d},  TrigCondition:{:d}, UserId:{}",
		pOrder.FrontNo,            //处理本次报单的实际席位序号
        pOrder.SequenceNo,             //回报序号(私有流序号每个交易日连续)
        pOrder.RequestNo,              //报单请求编号
        pOrder.SessionNo,              //原始报单session
        pOrder.ClientNo,
        pOrder.InstrumentNo,
        pOrder.LocalOrderNo,
        pOrder.ClientId,
        pOrder.InstrumentId,
        pOrder.ExchangeId,             //交易所代码
        pOrder.PriceType,              //报单价格条件
        pOrder. Side,                   //买卖方向
        pOrder.TimeInForce,            //订单有效时间类型
        pOrder.OwnerType,              //订单所有类型
        pOrder.OrdStatus,              //当前订单的状态
        pOrder.Price,                  //价格
        pOrder.Volume,                 //数量
        pOrder.OrderTime,              //委托时间
        pOrder.OrderSysId,             //交易所订单编号
        pOrder.LeavesVolume,           //订单剩余数量(交易所返回字段,每个交易所的含义不同)
        pOrder.CancelVolume,           //订单撤销数量
        pOrder.MinVolume,              //最小成交量
        pOrder.StopPrice,              //止损价    
        pOrder.OffsetFlag,             //开平标记
        pOrder.HedgeFlag,              //投机套保标记    
        pOrder.CoveredOrUncovered,    //备兑标签
        pOrder.VolumeCondition,       //成交量类型
        pOrder.TrigCondition,          //触发条件    
        pOrder.UserId);                 //原始报单交易用户代码
	Logs->Trace("----------\n");
};

///股票委托回报
void CSubTiTdSpi::OnRtnStockOrder(CTdStockOrderRtnField& pOrder)
{


	Logs->Trace("OnRtnStockOrder");
	    Logs->Warn("FrontNo:{:d},  SequenceNo:{},  RequestNo:{},  SessionNo:{},  ClientNo:{},  InstrumentNo:{},  LocalOrderNo:{},  ClientId:{},  UserId:{},  InstrumentId:{},  ExchangeId:{:d}, "
		"PriceType:{:d},  Side:{:d},  TimeInForce:{:d},  OwnerType:{:d},  OrdStatus:{:d},  Price:{},  Volume:{},  OrderTime:{},  OrderSysId:{},  LeavesVolume:{},  CancelVolume:{}",
		pOrder.FrontNo,                //处理本次报单的实际席位序号
        pOrder.SequenceNo,             //回报序号(私有流序号每个交易日连续)
        pOrder.RequestNo,              //报单请求编号
        pOrder.SessionNo,              //原始报单session
        pOrder.ClientNo,
        pOrder.InstrumentNo,
        pOrder.LocalOrderNo,
        pOrder.ClientId,
        pOrder.UserId,                 //原始报单交易用户代码
        pOrder.InstrumentId,
        pOrder.ExchangeId,             //交易所代码
        pOrder.PriceType,              //报单价格条件
        pOrder.Side,                   //买卖方向
        pOrder.TimeInForce,            //有效期类型
        pOrder.OwnerType,              //订单所有类型
        pOrder.OrdStatus,              //订单状态
        pOrder.Price,                  //价格
        pOrder.Volume,                 //数量
        pOrder.OrderTime,              //委托时间
        pOrder.OrderSysId,             //交易所报单编号
        pOrder.LeavesVolume,           //订单剩余数量(交易所返回字段,每个交易所的含义不同)
        pOrder.CancelVolume);           //订单撤销数量
	Logs->Trace("----------\n");
};

///报价回报
void CSubTiTdSpi::OnRtnQuoteOrder(CTdQuoteOrderRtnField& pQuote)
{
	Logs->Trace("OnRtnQuoteOrder");
	Logs->Warn("FrontNo:{:d}, SequenceNo:{}, RequestNo:{}, SessionNo:{},  ClientNo:{}, InstrumentNo:{},  LocalOrderNo:{},  ClientId:{},   InstrumentId:{}, "
			"ExchangeId:{:d}, UserId:{}, QuoteReqId(预留字段):{}, BidPx:{}, AskPx:{}, BidSize:{}, AskSize:{}, BidOffsetFlag:{:d}, AskOffsetFlag:{:d}, OwnerType:{:d}, OrderSysId:{}, "
			"BidOrderId:{}, AskOrderId:{}, OrdStatus:{:d}, OrderTim:{}",
	pQuote.FrontNo,                //处理本次报单的实际席位序号
	pQuote.SequenceNo,             //回报序号(私有流序号每个交易日连续)
	pQuote.RequestNo,              //报单请求编号
	pQuote.SessionNo,              //原始报单session
	pQuote.ClientNo,
	pQuote.InstrumentNo,
	pQuote.LocalOrderNo,
	pQuote.ClientId,
	pQuote.InstrumentId,
	pQuote.ExchangeId,             //交易所代码
	pQuote.UserId,                 //原始报单交易用户代码
	pQuote.QuoteReqId,             //报价请求ID,预留字段,当报价是对请求的响应时，填写报价请求的ID
	pQuote.BidPx,                  //买报价
	pQuote.AskPx,                  //卖报价
	pQuote.BidSize,                //买数量
	pQuote.AskSize,                //卖数量
	pQuote.BidOffsetFlag,          //平仓标识
	pQuote.AskOffsetFlag,          //平仓标识
	pQuote.OwnerType,              //订单所有类型
	pQuote.OrderSysId,             //交易所订单编号
	pQuote.BidOrderId,             //买方交易所订单编号
	pQuote.AskOrderId,             //卖方交易所订单编号
	pQuote.OrdStatus,              //当前订单状态
	pQuote.OrderTime);              //委托时间
	Logs->Trace("----------\n");
};

///期权,期货成交回报
void CSubTiTdSpi::OnRtnOptionsTrade(CTdOptionsTradeRtnField& pTrade)
{
	Logs->Trace("OnRtnOptionsTrade");
	    Logs->Warn("FrontNo:{:d},  SequenceNo:{},  RequestNo:{},  SessionNo:{},  ClientNo:{},"
		"InstrumentNo:{},  LocalOrderNo:{},  ClientId:{},  InstrumentId:{},  ExchangeId:{:d},  "
		"PriceType:{:d},  Side:{:d},  OffsetFlag:{:d},  HedgeFlag:{:d},  TimeInForce:{:d},  CoveredOrUncovered:{:d}, "
		"VolumeCondition:{:d},  TrigCondition:{:d},  OwnerType:{:d},  TradePrice:{},  TradeVolume:{},  LeavesVolume:{},  TradeTime:{},  OrderSysId:{},  TradeId:{},  UserId:{}",

		pTrade.FrontNo,                //处理本次报单的实际席位序号
        pTrade.SequenceNo,             //回报序号(私有流序号每个交易日连续)
        pTrade.RequestNo,              //报单请求编号
        pTrade.SessionNo,              //原始报单session
        pTrade.ClientNo,
        pTrade.InstrumentNo,
        pTrade.LocalOrderNo,
        pTrade.ClientId,
        pTrade.InstrumentId,
        pTrade.ExchangeId,             //交易所代码
        pTrade.PriceType,              //报单价格条件
        pTrade.Side,                   //买卖方向
        pTrade.OffsetFlag,             //开平标记
        pTrade.HedgeFlag,              //投机套保标记
        pTrade.TimeInForce,           //订单有效时间类型
        pTrade.CoveredOrUncovered,    //备兑标签
        pTrade.VolumeCondition,       //成交量类型
        pTrade.TrigCondition,          //触发条件
        pTrade.OwnerType,              //订单所有类型
        pTrade.TradePrice,             //成交价格
        pTrade.TradeVolume,            //成交数量
        pTrade.LeavesVolume,           //本次成交后申报余额数量
        pTrade.TradeTime,              //成交时间
        pTrade.OrderSysId,             //交易所报单编号
        pTrade.TradeId,                //成交编号
        pTrade.UserId);                 //原始报单交易用户代码
	Logs->Trace("----------\n");
};

///股票成交回报
void CSubTiTdSpi::OnRtnStockTrade(CTdStockTradeRtnField& pTrade)
{
	Logs->Trace("OnRtnStockTrade");
		Logs->Warn("FrontNo:{:d}, SequenceNo:{}, RequestNo:{}, SessionNo:{}, ClientNo:{}, "
              	"InstrumentNo:{}, LocalOrderNo:{}, ClientId:{},InstrumentId:{}, "
				"ExchangeId:{:d}, Side:{:d}, TradePrice:{}, TradeVolume:{}, LeavesVolume:{}, TradeTime:{}, OrderSysId:{}, TradeId:{}, UserId:{}",
		        pTrade.FrontNo,                //处理本次报单的实际席位序号
				pTrade.SequenceNo,             //回报序号(私有流序号每个交易日连续)
				pTrade.RequestNo,              //报单请求编号
				pTrade.SessionNo,              //原始报单session
				pTrade.ClientNo,
				pTrade.InstrumentNo,
				pTrade.LocalOrderNo,
				pTrade.ClientId,
				pTrade.InstrumentId,
				pTrade.ExchangeId,             //交易所代码
				pTrade.Side,                   //买卖方向
				pTrade.TradePrice,             //成交价格
				pTrade.TradeVolume,            //成交数量
				pTrade.LeavesVolume,           //本次成交后申报余额数量
				pTrade.TradeTime,              //成交时间
				pTrade.OrderSysId,             //交易所报单编号
				pTrade.TradeId,                //成交编号
				pTrade.UserId);                //原始报单交易用户代码
	Logs->Trace("----------\n");
};

///股票非交易业务成交回报
//void CSubTiTdSpi::OnRtnBusinessTrade(CTdBusinessTradeRtnField& pTrade)
//{
//	Logs->Trace("OnRtnBusinessTrade");
//	    Logs->Warn("BusinessType:{}, SequenceNo:{}, RequestNo:{}, SessionNo:{}, ClientNo:{}, LocalOrderNo:{}, ClientId:{}, InstrumentId:{}, ExchangeId:{:d}, Side:{:d}, TradePrice:{}, TradeVolume:{}, LeavesVolume:{}, TradeTime:{}, OrderSysId:{}, TradeId:{}, UserId:{}, DestInstrumentId:{}",
//
//				pTrade.BusinessType,          //业务类型
//				pTrade.SequenceNo,             //回报序号(私有流序号每个交易日连续)
//				pTrade.RequestNo,              //报单请求编号
//				pTrade.SessionNo,              //原始报单session
//				pTrade.ClientNo,
//				pTrade.LocalOrderNo,
//				pTrade.ClientId,
//				pTrade.InstrumentId,
//				pTrade.ExchangeId,             //交易所代码
//				pTrade.Side,                   //买卖方向
//				pTrade.TradePrice,             //成交价格
//				pTrade.TradeVolume,            //成交数量
//				pTrade.LeavesVolume,           //本次成交后申报余额数量
//				pTrade.TradeTime,              //成交时间
//				pTrade.OrderSysId,             //交易所报单编号
//				pTrade.TradeId,                //成交编号
//				pTrade.UserId,                 //原始报单交易用户代码
//				pTrade.DestInstrumentId);      //目标合约代码
//
//	Logs->Trace("----------");
//};

///行权回报
void CSubTiTdSpi::OnRtnExercise(CTdExerciseRtnField& pExercise) 
{
	Logs->Trace("OnRtnExercise");
	Logs->Warn("FrontNo:{:d}, SequenceNo:{}, RequestNo:{}, SessionNo:{}, ClientNo:{}, InstrumentNo:{}, LocalOrderNo:{}, ClientId:{}, InstrumentId:{}, ExchangeId:{:d}, 	Volume:{}, 	OwnerType:{:d}, OrdStatus:{:d}, ExerciseTime:{}, OrderSysId:{}, UserId:{}",
				pExercise.FrontNo,
				pExercise.SequenceNo,              //回报序号(私有流序号每个交易日连续)
				pExercise.RequestNo,               //报单请求编号
				pExercise.SessionNo,               //原始报单session
				pExercise.ClientNo,
				pExercise.InstrumentNo,
				pExercise.LocalOrderNo,
				pExercise.ClientId,
				pExercise.InstrumentId,
				pExercise.ExchangeId,              //交易所代码
				pExercise.Volume,                  //申报数量
				pExercise.OwnerType,               //订单所有类型
				pExercise.OrdStatus,
				pExercise.ExerciseTime,            //行权成功时间 
				pExercise.OrderSysId,              //交易所订单编号
				pExercise.UserId);                  //原始报单交易用户代码
	Logs->Trace("----------\n");
};

///出入金通知
void CSubTiTdSpi::OnRtnWithdrawDeposit(CTdWithdrawDepositRtnField& pWithdrawDeposit) 
{
	Logs->Trace("OnRtnWithdrawDeposit");
	Logs->Trace("----------\n");
};

///客户申请组合通知
void CSubTiTdSpi::OnRtnMarginCombAction(CTdMarginCombActionRtnField& pMarginCombAction) 
{
	Logs->Trace("OnRtnMarginCombAction");

	Logs->Warn("FrontNo:{:d}, SequenceNo:{}, RequestNo:{},SessionNo:{}, ClientNo:{}, LocalOrderNo:{}, "
				"ClientId:{}, UserId:{},ExchangeId:{:d},Side:{},NoLeges:{}, Volume:{},"   
				"CombId:{}, CombInstId:{}, OwnerType:{:d}, CombActionTime:{},OrderSysId:{}, ComMargin:{} \n"
				"InstrumentNo:{}, InstrumentId:{}, Side:{}, CoveredOrUncovered:{:d}, Volume:{}\n"
				"InstrumentNo:{}, InstrumentId:{}, Side:{}, CoveredOrUncovered:{:d}, Volume:{}\n",
				// "InstrumentNo:{}, InstrumentId:{}, Side:{}, CoveredOrUncovered:{:d}, Volume:{}\n"
				// "InstrumentNo:{}, InstrumentId:{}, Side:{}, CoveredOrUncovered:{:d}, Volume:{}\n",
		pMarginCombAction.FrontNo,                //处理本次报单的实际席位序号
        pMarginCombAction.SequenceNo,             //回报序号(私有流序号每个交易日连续)
        pMarginCombAction.RequestNo,              //报单请求编号
        pMarginCombAction.SessionNo,              //原始报单session
        pMarginCombAction.ClientNo,               //交易编码序号
        pMarginCombAction.LocalOrderNo,           //会员内部订单编号
        pMarginCombAction.ClientId,               //交易编码
        pMarginCombAction.UserId,                 //原始报单交易用户代码
        pMarginCombAction.ExchangeId,             //交易所代码
        pMarginCombAction.Side,                   //组合与拆分组合标记,组合策略为“ZBD”时，组合与拆分方向只能为组合
        pMarginCombAction.NoLeges,                //成分合约数，取值不超过4，后接重复组
        pMarginCombAction.Volume,                 //申报数量(拆分组合的时候需要填入拆分的数量，组合的时候该字段无效)    
        pMarginCombAction.CombId,                 //组合策略编码:目前为7种组合策略：CNSJC、PXSJC、PNSJC、CXSJC、KS、KKS、ZBD
        pMarginCombAction.CombInstId,             //组合编码。组合申报成功时返回组合的组合编码
        pMarginCombAction.OwnerType,              //订单所有类型
        pMarginCombAction.CombActionTime,         //组合、解组合成功时间      
        pMarginCombAction.OrderSysId,             //交易所报单编号
        pMarginCombAction.ComMargin,              //组合或拆分后保证金的变化值(组合为正拆分为负)
		 		pMarginCombAction.item[0].LegInstrumentNo,          //合约编码
        pMarginCombAction.item[0].LegInstrumentId,          //合约编码
        pMarginCombAction.item[0].LegSide,                  //合约方向
        pMarginCombAction.item[0].CoveredOrUncovered,    //备兑标签
        pMarginCombAction.item[0].LegVolume, 
				pMarginCombAction.item[1].LegInstrumentNo,          //合约编码
        pMarginCombAction.item[1].LegInstrumentId,          //合约编码
        pMarginCombAction.item[1].LegSide,                  //合约方向
        pMarginCombAction.item[1].CoveredOrUncovered,    //备兑标签
        pMarginCombAction.item[1].LegVolume); 
		// 		pMarginCombAction.item[2].LegInstrumentNo,          //合约编码
        // pMarginCombAction.item[2].LegInstrumentId,          //合约编码
        // pMarginCombAction.item[2].LegSide,                  //合约方向
        // pMarginCombAction.item[2].CoveredOrUncovered,    //备兑标签
        // pMarginCombAction.item[2].LegVolume, 
		// 		pMarginCombAction.item[3].LegInstrumentNo,          //合约编码
        // pMarginCombAction.item[3].LegInstrumentId,          //合约编码
        // pMarginCombAction.item[3].LegSide,                  //合约方向
        // pMarginCombAction.item[3].CoveredOrUncovered,    //备兑标签
        // pMarginCombAction.item[3].LegVolume
    
	Logs->Trace("----------\n");
};

///询价通知
void CSubTiTdSpi::OnRtnForQuote(CTdForQuoteRtnField& pForQuote) 
{
	Logs->Trace("OnRtnForQuote");
	Logs->Trace("----------\n");
};

///合约状态变化通知
void CSubTiTdSpi::OnRtnInstrumentStatus(CTdInstrumentStatusRtnField& pStatus) 
{
	Logs->Trace("OnRtnInstrumentStatus");
	Logs->Warn("InstrumentNo:{}, InstrumentId:{}, ExchangeId:{:d}, ProductId:{}, InstStatus:{:d}",
	pStatus.InstrumentNo,
	pStatus.InstrumentId,           //合约代码
	pStatus.ExchangeId,             //交易所代码
	pStatus.ProductId,              //产品代码
	pStatus.InstStatus);            //合约状态)
	Logs->Trace("----------\n");
};
