
#ifndef _SUBTITDSPI_H_
#define _SUBTITDSPI_H_

#include <stdio.h>
#include "string.h"
#include "TiTdApi.h"

using namespace titd;

class CSubTiTdSpi : public CTiTdSpi
{
public:
	CSubTiTdSpi()
	{
		totalPostionAccount = 0;
	};

	virtual ~CSubTiTdSpi(){};

public:
	////当客户端与交易后台建立起通信连接时（还未登录前），该方法被调用。
	virtual void OnConnected();

	///当客户端与交易后台通信连接断开时，该方法被调用。当发生这个情况后，API会自动重新连接，客户端可不做处理。
	///@param nReason 错误原因
	///        0x1001 网络读失败
	///        0x1002 网络写失败
	///        0x2001 接收心跳超时
	///        0x2002 发送心跳失败
	///        0x2003 收到错误报文
	virtual void OnDisconnected(int nReason);

	///用户登录应答
	virtual void OnRspUserLogin(CTdRspUserLoginField& pRspUserLogin, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///用户退出应答
	virtual void OnRspUserLogout(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///用户密码修改应答
	virtual void OnRspUserPasswordUpdate(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///股票报单应答
	virtual void OnRspStockInsert(CTdStockInsertRspField& pStockInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///股票撤单应答
	virtual void OnRspStockCancel(CTdOrderCancelRspField& pStockCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///股票非交易业务报单应答
	virtual void OnRspBusinessInsert(CTdBusinessInsertRspField& pStockInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///股票非交易业务撤单应答
	virtual void OnRspBusinessCancel(CTdOrderCancelRspField& pStockCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///股票非交易报单查询应答
	virtual void OnRspQryBusinessOrder(CTdRspQryBusinessOrderField& pOrder, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///股票非交易业务委托回报
	virtual void OnRtnBusinessOrder(CTdBusinessOrderRtnField& pOrder);

	///股票非交易业务成交回报
	virtual void OnRtnBusinessTrade(CTdBusinessTradeRtnField& pTrade);

	///证券锁定应答
	virtual void OnRspStockLock(CTdStockLockRspField& pStockLock, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///期权,期货报单应答
	virtual void OnRspOptionsInsert(CTdOrderInsertRspField& pOptionsInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///期权,期货撤单应答
	virtual void OnRspOptionsCancel(CTdOrderCancelRspField& pOptionsCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///期权,期货报价应答
	virtual void OnRspQuoteInsert(CTdQuoteInsertRspField& pQuoteInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) ;

	///期权,期货撤销报价应答
	virtual void OnRspQuoteCancel(CTdOrderCancelRspField& pQuoteCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) ;

	///询价应答
	virtual void OnRspForQuote(CTdForQuoteRspField& pForQuote, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) ;

	///行权应答
	virtual void OnRspExercise(CTdExerciseRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///组合行权应答
	virtual void OnRspCombExercise(CTdCombExerciseRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///撤销行权应答
	virtual void OnRspExerciseCancel(CTdOrderCancelRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///客户申请组合应答
	virtual void OnRspMarginCombAction(CTdMarginCombActionRspField& pMarginCombAction, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///股票报单查询应答
	virtual void OnRspQryStockOrder(CTdRspQryStockOrderField& pOrder, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///期权,期货报单查询应答
	virtual void OnRspQryOptionsOrder(CTdRspQryOptionsOrderField& pOrder, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///报价查询应答
	virtual void OnRspQryQuoteOrder(CTdRspQryQuoteOrderField& pQuote, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///查询行权应答
	virtual void OnRspQryExercise(CTdRspQryExerciseField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///查询组合行权应答
	virtual void OnRspQryCombExercise(CTdRspQryCombExerciseField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///股票成交查询应答
	virtual void OnRspQryStockTrade(CTdRspQryStockTradeField& pTrade, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///期权,期货成交查询应答
	virtual void OnRspQryOptionsTrade(CTdRspQryOptionsTradeField& pTrade, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///股票持仓查询应答
	virtual void OnRspQryStockPosition(CTdRspQryStockPositionField& pPosition, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///期权,期货持仓查询应答
	virtual void OnRspQryOptionsPosition(CTdRspQryOptionsPositionField& pPosition, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///组合持仓查询应答
	virtual void OnRspQryCombPosition(CTdRspQryCombPositionField& pPosi, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///从服务端获取资金应答
	virtual void OnRspQryAccount(CTdRspQryAccountField& pAccount, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///行情查询应答
	virtual void OnRspQryMarketData(CTdRspQryMarketDataField& pMarketData, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///通知查询应答
	virtual void OnRspQryNotify(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);

	///期权,期货委托回报
	virtual void OnRtnOptionsOrder(CTdOptionsOrderRtnField& pOrder);

	///股票委托回报
	virtual void OnRtnStockOrder(CTdStockOrderRtnField& pOrder);

	///报价回报
	virtual void OnRtnQuoteOrder(CTdQuoteOrderRtnField& pQuote);

	///期权,期货成交回报
	virtual void OnRtnOptionsTrade(CTdOptionsTradeRtnField& pTrade);

	///股票成交回报
	virtual void OnRtnStockTrade(CTdStockTradeRtnField& pTrade);

	///行权回报
	virtual void OnRtnExercise(CTdExerciseRtnField& pExercise) ;

	///出入金通知
	virtual void OnRtnWithdrawDeposit(CTdWithdrawDepositRtnField& pWithdrawDeposit) ;

	///客户申请组合通知
	virtual void OnRtnMarginCombAction(CTdMarginCombActionRtnField& pMarginCombAction) ;

	///询价通知
	virtual void OnRtnForQuote(CTdForQuoteRtnField& pForQuote);

	///合约状态变化通知
	virtual void OnRtnInstrumentStatus(CTdInstrumentStatusRtnField& pStatus);

private:
      
	double totalPostionAccount; // 持仓成本
};

#endif /* TITDSPI_H_ */
