#include <iostream>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <user.h>

#include "ccdeclare.h"
CC::CLog* Logs = nullptr;

using namespace std;

#define PRECISION 0.0001


int main()
{
 	// 日志初始化
    string path;
    if (!Logs)
    {
        //日志实例
        Logs = CC::Singleton<CC::CLog>::GetInstance();
        if (Logs == nullptr)
        {
            return 0;
        }

        auto clevel = CC::CLog::trace;   //控制台日志
        auto flevel = CC::CLog::trace;	 //文件日志
        if (!Logs->Init(clevel, flevel, "./cclog"))  //初始化日志实例
        {
            return 0;
        }

        //Logs->FlushEvery(3);
        Logs->FlushOn(CC::CLog::trace);
    }

    CUser *pUser = new CUser;

    pUser->GetApiVersion();
    pUser->Init();
    pUser->ReqUserLogin(); //登录

    pUser->Auth();
    getchar();

mainmenu: system("clear");  
    std::cout << std::endl;
	std::cout << "1.get查询测试" << std::endl;
	std::cout << "2.query查询测试" << std::endl;
	std::cout << "3.报单测试 - 股票现货" << std::endl;
    std::cout << "4.报单测试 - 期货、期权" << std::endl;
    std::cout << "5.其他测试" << std::endl;
    std::cout << "0.release并退出" << std::endl;
    
    int menumode;
    std::cin >> menumode;
    system("clear");

    switch (menumode)
    {
    case 1://1.get查询测试
    {
        while (true)
        {   
            //1.get查询测试菜单
            {
            std::cout << std::endl;
            std::cout << "1.get - GetClientList(查客户)" << std::endl;
            std::cout << "2.get - GetClientInfo(from id)" << std::endl;
            std::cout << "3.get - GetClientInfo(from no)" << std::endl;
            std::cout << "4.get - GetClientNo(getno)" << std::endl;
            std::cout << std::endl;
            std::cout << "5.get - GetFrontList(查前置)" << std::endl;
            std::cout << std::endl;
            std::cout << "6.get - GetInstrumentList(查合约)" << std::endl;
            std::cout << "7.get - GetInstrumentInfo(from id)" << std::endl;
            std::cout << "8.get - GetInstrumentInfo(from no)" << std::endl;
            std::cout << "9.get - GetInstrumentNo(getno)" << std::endl;
            std::cout << std::endl;
            std::cout << "10.get - GetRateList(查手续费)" << std::endl;
            std::cout << "11.get - GetRateInfo(from id)" << std::endl;
            std::cout << "12.get - GetRateInfo(from no)" << std::endl;
            std::cout << std::endl;
            std::cout << "13.get - GetOptMarginList(查保证金率)" << std::endl;
            std::cout << "14.get - GetOptMarginInfo(from id)" << std::endl;
            std::cout << "15.get - GetOptMarginInfo(from no)" << std::endl;
            std::cout << std::endl;
            std::cout << "16.get - GetFutMarginList(查保证金率)" << std::endl;
            std::cout << "17.get - GetFutMarginInfo(from id)" << std::endl;
            std::cout << "18.get - GetFutMarginInfo(from no)" << std::endl;
            std::cout << std::endl;
            std::cout << "19.get - GetAccount(查初始资金/客户登录成功时的资金)" << std::endl;
            std::cout << std::endl;
            std::cout << "0. 返回上一层"<< std::endl;
            std::cout << std::endl;
            }

            std::cin >> menumode;
            switch (menumode)
            {
                //同步查询
                case 1:
                {
                    pUser->GetClientList();
                    getchar(); getchar();
                    break;
                }
                case 2:
                {
                    pUser->GetClientInfo_fromid();
                    getchar(); getchar();
                    break;
                }
                case 3:
                {
                    pUser->GetClientInfo_fromno();
                    getchar(); getchar();
                    break;
                }
                case 4:
                {
                    pUser->GetClientNo();
                    getchar(); getchar();
                    break;
                }
                case 5:
                {
                    pUser->GetFrontList();
                    getchar(); getchar();
                    break;
                }
                case 6:
                {
                    pUser->GetInstrumentList();
                    getchar(); getchar();
                    break;
                }
                case 7:
                {
                    pUser->GetInstrumentInfo_fromid();
                    getchar(); getchar();
                    break;
                }
                case 8:
                {
                    pUser->GetInstrumentInfo_fromno();
                    getchar(); getchar();
                    break;
                }
                case 9:
                {
                    pUser->GetInstrumentNo();
                    getchar(); getchar();
                    break;
                }
                case 10:
                {
                    pUser->GetRateList();
                    getchar(); getchar();
                    break;
                }
                case 11:
                {
                    pUser->GetRateInfo_fromid();
                    getchar(); getchar();
                    break;
                }
                case 12:
                {
                    pUser->GetRateInfo_fromno();
                    getchar(); getchar();
                    break;
                }
                case 13:
                {
                    pUser->GetOptMarginList();
                    getchar(); getchar();
                    break;
                }
                case 14:
                {
                    pUser->GetOptMarginInfo_fromid();
                    getchar(); getchar();
                    break;
                }
                case 15:
                {
                    pUser->GetOptMarginInfo_fromno();
                    getchar(); getchar();
                    break;
                }
                case 16:
                {
                    pUser->GetFutMarginList();
                    getchar(); getchar();
                    break;
                }
                case 17:
                {
                    pUser->GetFutMarginInfo_fromid();
                    getchar(); getchar();
                    break;
                }
                case 18:
                {
                    pUser->GetFutMarginInfo_fromno();
                    getchar(); getchar();
                    break;
                }
                case 19:
                {
                    pUser->GetAccount();
                    getchar(); getchar();
                    break;
                }
                case 0:
                {
                    goto mainmenu;
                    break;
                }
                default:
                {
                    std::cout << "没有该选项，请重新选择"<< std::endl;
                    continue;
                }
            }
        }
        
        break;
    }
        
    case 2://2.query查询测试
    {
        while (true)
        {
            {
                std::cout << std::endl;
                std::cout << "1.qry - ReqQryStockOrder(查股票委托)" << std::endl;
                std::cout << "2.qry - ReqQryBusinessOrder(查非交易委托)" << std::endl;
                std::cout << "3.qry - ReqQryOptionsOrder(查委托)" << std::endl;
                std::cout << "4.qry - ReqQryQuoteOrder(查报价委托)" << std::endl;
                std::cout << "5.qry - ReqQryExercise(查行权委托)" << std::endl;
                std::cout << "6.qry - ReqQryCombExercise(查组合行权委托)" << std::endl;
                std::cout << "7.qry - ReqQryStockTrade(查成交)" << std::endl;
                std::cout << "8.qry - ReqQryOptionsTrade(查成交)" << std::endl;  
                std::cout << "9.qry - ReqQryStcokPosition(查持仓)" << std::endl;
                std::cout << "10.qry - ReqQryOptionsPosition(查持仓)" << std::endl;
                std::cout << "11.qry - ReqQryCombPosition(查组合持仓)" << std::endl;
                std::cout << "12.qry - ReqQryAccount(查询资金)" << std::endl;
                std::cout << "13.qry - ReqQryMarketData(查行情)" << std::endl;
                std::cout << "14.qry - ReqQryNotify(查回报)" << std::endl;
                std::cout << "15.qry - ReqQryBusinessOrder(查非交易委托)" << std::endl;
                std::cout << "0. 返回上一层"<< std::endl;
                std::cout << std::endl;
            }

            std::cin >> menumode;
            switch (menumode)
            {
                case 1:
                {
                    pUser->ReqQryStockOrder();
                    getchar(); getchar();
                    break;
                }
                case 2:
                {
                    pUser->ReqQryBusinessOrder();
                    getchar(); getchar();
                    break;
                }
                case 3:
                {
                    pUser->ReqQryOptionsOrder();
                    getchar(); getchar();
                    break;
                }
                case 4:
                {
                    pUser->ReqQryQuoteOrder();
                    getchar(); getchar();
                    break;
                }
                case 5:
                {
                    pUser->ReqQryExercise();
                    getchar(); getchar();
                    break;
                }
                case 6:
                {
                    pUser->ReqQryCombExercise();
                    getchar(); getchar();
                    break;
                }
                case 7:
                {
                    pUser->ReqQryStockTrade();
                    getchar(); getchar();
                    break;
                }
                case 8:
                {
                    pUser->ReqQryOptionsTrade();
                    getchar(); getchar();
                    break;
                }
                case 9:
                {
                    pUser->ReqQryStockPosition();
                    getchar(); getchar();
                    break;
                }
                case 10:
                {
                    pUser->ReqQryOptionsPosition();
                    getchar(); getchar();
                    break;
                }
                case 11:
                {
                    pUser->ReqQryCombPosition();
                    getchar(); getchar();
                    break;
                }
                case 12:
                {
                    pUser->ReqQryAccount();
                    getchar(); getchar();
                    break;
                }
                case 13:
                {
                    pUser->ReqQryMarketData();
                    getchar(); getchar();
                    break;
                }
                case 14:
                {
                    pUser->ReqQryNotify();
                    getchar(); getchar();
                    break;
                }
                case 15:
                {
                    pUser->ReqQryBusinessOrder();
                    getchar(); getchar();
                    break;
                }
                case 0:
                {
                    goto mainmenu;
                    break;
                }
                default:
                {
                    std::cout << "没有该选项，请重新选择"<< std::endl;
                    continue;
                }
            }
        }
        break;
    }
        
    case 3://3.报单测试 - 股票现货
    {
        pUser->_testsvrtype = 1;

        while (true)
        {
            {
                std::cout << "普通报单测试: " << std::endl;
                std::cout << "1.order - ReqStockInsert    (报单)" << std::endl;
                std::cout << "2.order - ReqStockCancel    (报单撤销)" << std::endl;
                std::cout << "3.order - ReqBusinessInsert (非交易业务报单)" << std::endl;
                std::cout << "4.order - ReqBusinessCancel (非交易业务撤单)" << std::endl;
                std::cout << std::endl;
                std::cout << "5.qry  - ReqQryStockOrder   (查股票委托)" << std::endl;
                std::cout << "6.qry  - ReqQryStockTrade   (查股票成交)" << std::endl;  
                std::cout << "7.qry  - ReqQryStockPosition(查股票持仓)" << std::endl;
                std::cout << "8.qry  - ReqQryAccount      (查询资金)" << std::endl;
                std::cout << "9.qry  - ReqQryBusinessOrder(查非交易委托)" << std::endl;
                std::cout << std::endl;
                std::cout << "循环下单测试选择：" << std::endl;
                std::cout << "10.最新价买报单" << std::endl;
                // std::cout << "11.最新价卖报单" << std::endl;
                // std::cout << "12.最新价买报单" << std::endl;
                std::cout << "13.最新价卖报单" << std::endl;
                std::cout << "14.涨停卖跌停买报单" << std::endl;
                std::cout << "15.涨停卖跌停买报单后马上撤单" << std::endl;
                std::cout << "16.撤销所有在途订单"  << std::endl;
                std::cout << std::endl;
                std::cout << "17.查询在途报单"  << std::endl;
                std::cout << "18.查询在途非交易报单"  << std::endl;
                std::cout << "0. 返回上一层" << std::endl;
                std::cout << std::endl;
            }

            std::cin >> menumode;
            switch (menumode)
            {
                case 1:
                {
                    pUser->ReqStockInsert();
                    getchar(); getchar();
                    break;
                }
                case 2:
                {
                    pUser->ReqStockCancel();
                    getchar(); getchar();
                    break;
                }
                case 3:
                {
                    pUser->ReqBusinessInsert();
                    getchar(); getchar();
                    break;
                }
                case 4:
                {
                    pUser->ReqBusinessCancel();
                    getchar(); getchar();
                    break;
                }
                case 5:
                {
                    pUser->ReqQryStockOrder();
                    getchar(); getchar();
                    break;
                }
                case 6:
                {
                    pUser->ReqQryStockTrade();
                    getchar(); getchar();
                    break;
                }
                case 7:
                {
                    pUser->ReqQryStockPosition();
                    getchar(); getchar();
                    break;
                }
                case 8:
                {
                    pUser->ReqQryAccount();
                    getchar(); getchar();
                    break;
                }
                case 9:
                {
                    pUser->ReqQryBusinessOrder();
                    getchar(); getchar();
                    break;
                }
                case 10:
                {
                    pUser->ReqProgOrder1();
                    getchar(); getchar();
                    break;
                }
                // case 11:
                // {
                //     pUser->ReqProgOrder2();
                //     getchar(); getchar();
                    break;
                // }
                // case 12:
                // {
                //     pUser->ReqProgOrder3();
                //     getchar(); getchar();
                    break;
                // }
                case 13:
                {
                    pUser->ReqProgOrder4();
                    getchar(); getchar();
                    break;
                }
                case 14:
                {
                    pUser->ReqProgOrder5();
                    getchar(); getchar();
                    break;
                }
                case 15:
                {
                    pUser->ReqProgOrder6();
                    getchar(); getchar();
                    break;
                }
                case 16:
                {
                    pUser->ReqCancleAll();
                    getchar(); getchar();
                    break;
                }
                case 17:
                {
                    pUser->ReqQryStockOrder_zt();
                    getchar(); getchar();
                    break;
                }
                case 18:
                {
                    pUser->ReqQryBusinessOrder_zt();
                    getchar(); getchar();
                    break;
                }
                case 0:
                {
                    goto mainmenu;
                    getchar(); getchar();
                    break;
                }
                default:
                {
                    std::cout << "没有该选项，请重新选择"<< std::endl;
                    continue;
                }
            }
        }

        break;
    }

    case 4://4.报单测试 - 期货、期货期权
    {
        pUser->_testsvrtype = 2;

        while (true)
        {
            {
                std::cout << "普通报单测试: " << std::endl;
                std::cout << "1.order - ReqOptionsInsert        (1.报单)" << std::endl;
                std::cout << "2.order - ReqOptionsCancel        (2.报单撤销)" << std::endl;
                std::cout << "3.order - ReqQuoteInsert          (3.报价)" << std::endl;  
                std::cout << "4.order - ReqQuoteCancel          (4.报价撤销)" << std::endl;
                std::cout << "5.order - ReqForQuote             (5.询价)" << std::endl;
                std::cout << "6.order - ReqExercise             (6.行权)" << std::endl;
                std::cout << "7.order - ReqCombExercise         (7.组合行权)" << std::endl;
                std::cout << "8.order - ReqExerciseCancel       (8.行权撤销)" << std::endl;
                std::cout << "9.order - ReqMarginCombAction     (9.组合、解组合)" << std::endl;
                std::cout << "10.order- ReqStockLock            (10.锁仓)" << std::endl;
                std::cout << std::endl;
                std::cout << "11.qry - ReqQryOptionsOrder       (11.查委托)" << std::endl;
                std::cout << "12.qry - ReqQryQuoteOrder         (12.查报价委托)" << std::endl;
                std::cout << "13.qry - ReqQryExercise           (13.查行权委托)" << std::endl;
                std::cout << "14.qry - ReqQryCombExercise       (14.查组合行权委托)" << std::endl;
                std::cout << "15.qry - ReqQryOptionsTrade       (15.查成交)" << std::endl;  
                std::cout << "16.qry - ReqQryOptionsPosition    (16.查持仓)" << std::endl;
                std::cout << "17.qry - ReqQryCombPosition       (17.查组合持仓)" << std::endl;
                std::cout << "18.qry - ReqQryAccount            (18.查询资金)" << std::endl;
                std::cout << "19.qry - ReqQryStockPosition      (19.查股票持仓、查询股票锁仓量)" << std::endl;
                std::cout << std::endl;
                std::cout << "循环下单测试选择：" << std::endl;
                std::cout << "20.最新价买开报单" << std::endl;
                std::cout << "21.最新价卖开报单" << std::endl;
                std::cout << "22.最新价买平报单" << std::endl;
                std::cout << "23.最新价卖平报单" << std::endl;
                std::cout << "24.涨停卖开跌停买开报单" << std::endl;
                std::cout << "25.涨停卖开跌停买开报单后马上撤单" << std::endl;
                std::cout << "26.撤销所有在途订单"  << std::endl;
                std::cout << std::endl;
                std::cout << "27.查询在途报单"  << std::endl;
                std::cout << "28.查询在途报价"  << std::endl;
                std::cout << "0. 返回上一层" << std::endl;
                std::cout << std::endl;
            }

            std::cin >> menumode;
            switch (menumode)
            {
                case 1:
                {
                    pUser->ReqOptionsInsert();
                    getchar(); getchar();
                    break;
                }
                case 2:
                {
                    pUser->ReqOptionsCancel();
                    getchar(); getchar();
                    break;
                }
                case 3:
                {
                    pUser->ReqQuoteInsert();
                    getchar(); getchar();
                    break;
                }
                case 4:
                {
                    pUser->ReqQuoteCancel();
                    getchar(); getchar();
                    break;
                }
                case 5:
                {
                    pUser->ReqForQuote();
                    getchar(); getchar();
                    break;
                }
                case 6:
                {
                    pUser->ReqExercise();
                    getchar(); getchar();
                    break;
                }
                case 7:
                {
                    pUser->ReqCombExercise();
                    getchar(); getchar();
                    break;
                }
                case 8:
                {
                    pUser->ReqExerciseCancel();
                    getchar(); getchar();
                    break;
                }
                case 9:
                {
                    pUser->ReqMarginCombAction();
                    getchar(); getchar();
                    break;
                }
                case 10:
                {
                    pUser->ReqStockLock();
                    getchar(); getchar();
                    break;
                }

                case 11:
                {
                    pUser->ReqQryOptionsOrder();
                    getchar(); getchar();
                    break;
                }
                case 12:
                {
                    pUser->ReqQryQuoteOrder();
                    getchar(); getchar();
                    break;
                }
                case 13:
                {
                    pUser->ReqQryExercise();
                    getchar(); getchar();
                    break;
                }
                case 14:
                {
                    pUser->ReqQryCombExercise();
                    getchar(); getchar();
                    break;
                }
                case 15:
                {
                    pUser->ReqQryOptionsTrade();
                    getchar(); getchar();
                    break;
                }
                case 16:
                {
                    pUser->ReqQryOptionsPosition();
                    getchar(); getchar();
                    break;
                }
                case 17:
                {
                    pUser->ReqQryCombPosition();
                    getchar(); getchar();
                    break;
                }
                case 18:
                {
                    pUser->ReqQryAccount();
                    getchar(); getchar();
                    break;
                }
                case 19:
                {
                    pUser->ReqQryStockPosition();
                    getchar(); getchar();
                    break;
                }
                case 20:
                {
                    pUser->ReqProgOrder1();
                    getchar(); getchar();
                    break;
                }
                case 21:
                {
                    pUser->ReqProgOrder2();
                    getchar(); getchar();
                    break;
                }
                case 22:
                {
                    pUser->ReqProgOrder3();
                    getchar(); getchar();
                    break;
                }
                case 23:
                {
                    pUser->ReqProgOrder4();
                    getchar(); getchar();
                    break;
                }
                case 24:
                {
                    pUser->ReqProgOrder5();
                    getchar(); getchar();
                    break;
                }
                case 25:
                {
                    pUser->ReqProgOrder6();
                    getchar(); getchar();
                    break;
                }
                case 26:
                {
                    pUser->ReqCancleAll();
                    getchar(); getchar();
                    break;
                }
                case 27:
                {
                    pUser->ReqQryOptionsOrder_zt();
                    getchar(); getchar();
                    break;
                }
                case 28:
                {
                    pUser->ReqQryQuoteOrder_zt();
                    getchar(); getchar();
                    break;
                }
                case 0:
                {
                    goto mainmenu;
                    break;
                }
                default:
                {
                    std::cout << "没有该选项，请重新选择"<< std::endl;
                    continue;
                }
            }
        }
        break;
    }

    case 5://5.其他测试
    {
        while (true)
        {
            {
                std::cout << "1. 客户登录" << std::endl;
                std::cout << "2. 密码验证" << std::endl;
                std::cout << std::endl;
                std::cout << "0. 返回上一层" << std::endl;
            }

            std::cin >> menumode;
            switch (menumode)
            {
                case 1:
                {
                    pUser->ReqUserLogin(); //登录
                    getchar(); getchar();
                    break;
                }
                case 0:
                {
                    goto mainmenu;
                    break;
                }
                default:
                {
                    std::cout << "没有该选项，请重新选择"<< std::endl;
                    continue;
                }
            }
        }
    }

    case 0:
    {
        pUser->Release();
        break;
    }

    default:
    {
        goto mainmenu;
        break;
    }

    }//end of switch (menumode)
	return 0;
}