#include "titdapi_req.h"
#include "ccdeclare.h"

int CTiTdApiReq::ReqUserAuthentication(CTdReqUserAuthenField* pReqUserAuthen, int nRequestID)
{
	int irtn = m_pApi->ReqUserAuthentication(pReqUserAuthen, nRequestID);
   return irtn;
}

///创建TraderApi
///@return 创建出的Api
CTiTdApi* CTiTdApiReq::CreateTiTdApi()
{
   m_pApi = CTiTdApi::CreateTiTdApi();
   return m_pApi;
}

///获取系统版本号
///@return 系统标识字符串
const char* CTiTdApiReq::GetApiVersion()
{
	Logs->Trace("GetApiVersion");
	Logs->Trace("**********");

   return(m_pApi->GetApiVersion());
}

///删除接口对象本身
///@remark 不再使用本接口对象时,调用该函数删除接口对象
void CTiTdApiReq::Release()
{
	Logs->Trace("Release");
	Logs->Trace("**********");

   m_pApi->Release();
}

///注册回调接口(该方法必须在Init之前调用)
///@param pSpi 派生自回调接口类的实例
void CTiTdApiReq::RegisterSpi(CTiTdSpi* pSpi)
{
	Logs->Trace("RegisterSpi");
	Logs->Trace("**********");

    m_pApi->RegisterSpi(pSpi);
}

///初始化
///@param cfgInfo：初始化api所用的结构
///@remark 初始化运行环境,只有调用后,接口才开始工作
int CTiTdApiReq::Init(CTdConfigInfoField& cfgInfo)
{
   Logs->Trace("Init from function");
   Logs->Trace("UserId: {} ", cfgInfo.UserId);              Logs->Trace("交易用户代码(该用户名和登录时用的用户名相同");
   Logs->Trace("NicType: {:d} ",cfgInfo.NicType);           Logs->Trace("网卡类型; 目前系统支持以下几种; 1:普通socket;2:Solarflare; 3:Exablaze");
   Logs->Trace("SendNicName: {} ", cfgInfo.SendNicName);    Logs->Trace("发送请求的网卡名称,可以与RecvNicName一样");
   Logs->Trace("RecvNicName: {} ", cfgInfo.RecvNicName);    Logs->Trace("接收应答的网卡名称,可以与SendNicName一样");
   Logs->Trace("RecvNicIp: {} ", cfgInfo.RecvNicIp);        Logs->Trace("接收应答的网卡IP");
   Logs->Trace("RecvNicPort: {} ", cfgInfo.RecvNicPort);    Logs->Trace("接收应答的网卡端口,如果不设置系统会自动分配端口进行数据接收");
   Logs->Trace("SubPrivateType: {:d} ", cfgInfo.SubPrivateType);        Logs->Trace("私有流订阅模式");
                                       Logs->Trace("0:不订阅私有流");
                                       Logs->Trace("1:从本交易日开始重传");
                                       Logs->Trace("2:从上次收到的续传");
                                       Logs->Trace("3:只传送登录后私有流的内容");
   Logs->Trace("SubPublicType: {:d} ", cfgInfo.SubPublicType);         Logs->Trace("公共流订阅模式");
                                       Logs->Trace("0:不订阅公有流");
                                       Logs->Trace("3:订阅公有流");
   Logs->Trace("FrontAddress: {} ", cfgInfo.FrontAddress);      Logs->Trace("交易服务器网络地址");
                                       Logs->Trace("网络地址的格式为：“protocol://ipaddress:port”，如：”tcp://127.0.0.1:17001”。");
                                       Logs->Trace("“tcp”代表传输协议，“127.0.0.1”代表服务器地址。”17001”代表服务器端口号。");
   Logs->Trace("RecvDataCpuId: {} ", cfgInfo.RecvDataCpuId);         Logs->Trace("接收网络数据的线程cpuid, -1不绑定cpu");
   Logs->Trace("DealDataCpuId: {} ", cfgInfo.DealDataCpuId);         Logs->Trace("处理网络数据的线程cpuid, -1不绑定cpu");
   Logs->Trace("MaxRecvDataSize: {} ", cfgInfo.MaxRecvDataSize);       Logs->Trace("接收数据缓存的大小,单位为M,如果不填入默认大小为512M");
   Logs->Trace("IsLog: {} ", cfgInfo.IsLog);                Logs->Trace("是否记录日志");
   Logs->Trace("timeOut: {} ", cfgInfo.timeOut);  Logs->Trace("超时时间默认为3秒");
   Logs->Trace("**********");

   int irtn = m_pApi->Init(cfgInfo);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///初始化
///@param cfgFile：初始化api的配置文件
///@remark 初始化运行环境,只有调用后,接口才开始工作
int CTiTdApiReq::Init(const char* cfgFile)
{
   //Logs->Trace("**********");
	Logs->Trace("Init from file");
	Logs->Trace("**********");

   int irtn = m_pApi->Init(cfgFile);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

/*
* 同步查询
*
*
*
*
*/

///获取交易编码
int CTiTdApiReq::GetClientList(TdRspQryClientList& output)
{
   //Logs->Trace("**********");
	Logs->Trace("GetClientList");
	Logs->Trace("**********");

   int irtn = m_pApi->GetClientList(output);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   
   //查询输出
   Logs->Info("GetClientList");
   for(TdRspQryClientList::iterator iter = output.begin();  iter != output.end(); iter++)
      Logs->Info("ClientId:{}, ClientNo:{}, ClientType:{:d}, ExchangeId:{:d}, Status:{:d}",
      iter->ClientId,
      iter->ClientNo,
      iter->ClientType,
      iter->ExchangeId,
      iter->Status);
   Logs->Trace("----------");   

   return irtn;
}

///根据交易编码获取交易编码信息
//int CTiTdApiReq::GetClientInfo(char* clientId, CTdRspQryClientField& pClient)
int CTiTdApiReq::GetClientInfo(char* clientId)
{
   //Logs->Trace("**********");
	Logs->Trace("GetClientInfo from clientId");
   Logs->Info("clientId:{}", clientId);
	Logs->Trace("**********");

   CTdRspQryClientField output = {0};
   int irtn = m_pApi->GetClientInfo(clientId, output);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }

   //查询输出
   Logs->Info("GetClientInfo");
   Logs->Info("ClientId:{}, ClientNo:{}, ClientType:{:d}, ExchangeId:{:d}, Status:{:d}",
      output.ClientId,
      output.ClientNo,
      output.ClientType,
      output.ExchangeId,
      output.Status);
   Logs->Trace("----------");

   return irtn;
}

///根据交易编码序号获取交易编码信息
//int CTiTdApiReq::GetClientInfo(int clientNo, CTdRspQryClientField& pClient)
int CTiTdApiReq::GetClientInfo(int clientNo)
{
   //Logs->Trace("**********");
	Logs->Trace("GetClientInfo from clientno");
   Logs->Info("clientNo:{}", clientNo);
	Logs->Trace("**********");

   CTdRspQryClientField output = {0};
   int irtn = m_pApi->GetClientInfo(clientNo, output);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }

   //查询输出
   Logs->Info("GetClientInfo");
   Logs->Info("ClientId:{}, ClientNo:{}, ClientType:{:d}, ExchangeId:{:d}, Status:{:d}",
      output.ClientId,
      output.ClientNo,
      output.ClientType,
      output.ExchangeId,
      output.Status);
   Logs->Trace("----------");

   return irtn;
}

///根据交易编码获取交易编码序号
//int CTiTdApiReq::GetClientNo(char *clientId,int &clientNo)
int CTiTdApiReq::GetClientNo(char *clientId)
{
   Logs->Trace("GetClientNo");
   Logs->Info("clientId:{}", clientId);
	Logs->Trace("**********");

   int clientNo=0;
   int irtn = m_pApi->GetClientNo(clientId, clientNo);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   

   //查询输出
   Logs->Trace("GetClientNo");
   Logs->Info("clientNo:{}", clientNo);
   Logs->Trace("----------");

   return irtn;
}

///获取交易前置列表
//int CTiTdApiReq::GetFrontList(TdRspQryFrontFieldList& output)
int CTiTdApiReq::GetFrontList()
{
   //Logs->Trace("**********");
   Logs->Trace("GetFrontList");
	Logs->Trace("**********");

   TdRspQryFrontFieldList output;
   int irtn = m_pApi->GetFrontList(output);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }

   //查询输出
   Logs->Info("GetFrontList");
   for(TdRspQryFrontFieldList::iterator iter = output.begin();  iter != output.end(); iter++)
      Logs->Info("FrontNo:{:d}, ExchangeId:{:d}, PartyType:{:d}, PartyId:{}",
        iter->FrontNo,                //席位序号
        iter->ExchangeId,             //交易所
        iter->PartyType,              //席位类型
        iter->PartyId);                //席位信息);
   Logs->Trace("----------");

   return irtn;
}

///获取合约列表
//int CTiTdApiReq::GetInstrumentList(TdRspQryInstrumentFieldList& output)
int CTiTdApiReq::GetInstrumentList()
{
   //Logs->Trace("**********");
   Logs->Trace("GetInstrumentList");
	Logs->Trace("**********");

   TdRspQryInstrumentFieldList output;
   int irtn = m_pApi->GetInstrumentList(output);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }

   //查询输出
   Logs->Info("GetInstrumentList");
   int i=1;
   for(TdRspQryInstrumentFieldList::iterator iter = output.begin();  iter != output.end(); iter++)
   {
    Logs->Info("InstrumentNo:{}, InstrumentId:{}, ExchangeId:{:d}, InstrumentName:{}, "
            "ProductId:{}, UnderlyingInstrId:{}, ProductType:{}, OptionsType:{}, Volumemultiple:{}, "
            "DeliveryYear:{}, DeliveryMonth:{}, AdvanceMonth:{}, TradeStatus:{:d}, CreateDate:{}, "            
            "OpenDate:{}, ExpireDate:{}, StartdelivDate:{}, EnddelivDate:{}, BasisPrice:{}, StrikePrice:{}, "          
            "MaxMarketOrderVolume:{}, MinMarketOrderVolume:{}, MaxLimitOrderVolume:{}, MinLimitOrderVolume:{},"   
            "PriceTick:{}, LastPrice:{}, SettlementPrice:{}, UpperLimitPrice:{}, LowerLimitPrice:{}, seqnum:{}",
         iter->InstrumentNo,
         iter->InstrumentId,           //合约代码
         iter->ExchangeId,             //交易所代码
         iter->InstrumentName,         //合约名称
         iter->ProductId,              //产品代码
         iter->UnderlyingInstrId,      //标的商品代码
         iter->ProductType,            //产品类型
         iter->OptionsType,            //期权类型
         iter->Volumemultiple,         //合约数量乘数
         iter->DeliveryYear,           //交割年份
         iter->DeliveryMonth,          //交割月
         iter->AdvanceMonth,           //提前月份
         iter->TradeStatus,            //交易权限
         iter->CreateDate,             //创建日
         iter->OpenDate,               //上市日
         iter->ExpireDate,             //到期日
         iter->StartdelivDate,         //开始交割日
         iter->EnddelivDate,           //最后交割日
         iter->BasisPrice,             //挂牌基准价
         iter->StrikePrice,            //行权价格
         iter->MaxMarketOrderVolume,   //市价单最大下单量
         iter->MinMarketOrderVolume,   //市价单最小下单量
         iter->MaxLimitOrderVolume,    //限价单最大下单量
         iter->MinLimitOrderVolume,    //限价单最小下单量
         iter->PriceTick,              //最小变动价位
         //以下为行情信息
         iter->LastPrice,               //最新价
         iter->SettlementPrice,         //昨日结算价
         iter->UpperLimitPrice,         //涨停板价格
         iter->LowerLimitPrice,         //跌停板价格
         i);

      if(i == output.size())
      {
         Logs->Info("------Last, total:{}------", i);
      }

      i++;
   }

   Logs->Trace("----------");

   return irtn;
}

///根据合约编码获取合约信息(期货、期权、现货均可通过该接口查询)
//int CTiTdApiReq::GetInstrumentInfo(char* instrumentId, CTdRspQryInstrumentField& pInstrument)
int CTiTdApiReq::GetInstrumentInfo(char* instrumentId)
{
   //Logs->Trace("**********");
   Logs->Trace("GetInstrumentInfo from instrumentId");
   Logs->Info("instrumentId:{}", instrumentId);
	Logs->Trace("**********");

   CTdRspQryInstrumentField output = {0};
   int irtn = m_pApi->GetInstrumentInfo(instrumentId, output);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }

   //查询输出
   Logs->Info("GetInstrumentInfo");
   Logs->Info("InstrumentNo:{}, InstrumentId:{}, ExchangeId:{:d}, InstrumentName:{}, "
            "ProductId:{}, UnderlyingInstrId:{}, ProductType:{}, OptionsType:{}, Volumemultiple:{}, "
            "DeliveryYear:{}, DeliveryMonth:{}, AdvanceMonth:{}, TradeStatus:{:d}, CreateDate:{}, "            
            "OpenDate:{}, ExpireDate:{}, StartdelivDate:{}, EnddelivDate:{}, BasisPrice:{}, StrikePrice:{}, "          
            "MaxMarketOrderVolume:{}, MinMarketOrderVolume:{}, MaxLimitOrderVolume:{}, MinLimitOrderVolume:{},"   
            "PriceTick:{}, LastPrice:{}, SettlementPrice:{}, UpperLimitPrice:{}, LowerLimitPrice:{}",
         output.InstrumentNo,
         output.InstrumentId,           //合约代码
         output.ExchangeId,             //交易所代码
         output.InstrumentName,         //合约名称
         output.ProductId,              //产品代码
         output.UnderlyingInstrId,      //标的商品代码
         output.ProductType,            //产品类型
         output.OptionsType,            //期权类型
         output.Volumemultiple,         //合约数量乘数
         output.DeliveryYear,           //交割年份
         output.DeliveryMonth,          //交割月
         output.AdvanceMonth,           //提前月份
         output.TradeStatus,            //交易权限
         output.CreateDate,             //创建日
         output.OpenDate,               //上市日
         output.ExpireDate,             //到期日
         output.StartdelivDate,         //开始交割日
         output.EnddelivDate,           //最后交割日
         output.BasisPrice,             //挂牌基准价
         output.StrikePrice,            //行权价格
         output.MaxMarketOrderVolume,   //市价单最大下单量
         output.MinMarketOrderVolume,   //市价单最小下单量
         output.MaxLimitOrderVolume,    //限价单最大下单量
         output.MinLimitOrderVolume,    //限价单最小下单量
         output.PriceTick,              //最小变动价位
         //以下为行情信息
         output.LastPrice,               //最新价
         output.SettlementPrice,         //昨日结算价
         output.UpperLimitPrice,         //涨停板价格
         output.LowerLimitPrice);         //跌停板价格
   Logs->Trace("----------");

   return irtn;
}

///根据合约序号获取合约信息(期货、期权、现货均可通过该接口查询)
//int CTiTdApiReq::GetInstrumentInfo(int instrumentNo, CTdRspQryInstrumentField& pInstrument)
int CTiTdApiReq::GetInstrumentInfo(int instrumentNo)
{
   //Logs->Trace("**********");
   Logs->Trace("GetInstrumentInfo from instrumentNo");
   Logs->Info("instrumentNo:{}", instrumentNo);
   Logs->Trace("**********");

   CTdRspQryInstrumentField output = {0};
   int irtn = m_pApi->GetInstrumentInfo(instrumentNo, output);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }

   //查询输出
   Logs->Info("GetInstrumentInfo");
   Logs->Info("InstrumentNo:{}, InstrumentId:{}, ExchangeId:{:d}, InstrumentName:{}, "
            "ProductId:{}, UnderlyingInstrId:{}, ProductType:{:d}, OptionsType:{:d}, Volumemultiple:{}, "
            "DeliveryYear:{}, DeliveryMonth:{}, AdvanceMonth:{}, TradeStatus:{:d}, CreateDate:{}, "            
            "OpenDate:{}, ExpireDate:{}, StartdelivDate:{}, EnddelivDate:{}, BasisPrice:{}, StrikePrice:{}, "          
            "MaxMarketOrderVolume:{}, MinMarketOrderVolume:{}, MaxLimitOrderVolume:{}, MinLimitOrderVolume:{},"   
            "PriceTick:{}, LastPrice:{}, SettlementPrice:{}, UpperLimitPrice:{}, LowerLimitPrice:{}",
         output.InstrumentNo,
         output.InstrumentId,           //合约代码
         output.ExchangeId,             //交易所代码
         output.InstrumentName,         //合约名称
         output.ProductId,              //产品代码
         output.UnderlyingInstrId,      //标的商品代码
         output.ProductType,            //产品类型
         output.OptionsType,            //期权类型
         output.Volumemultiple,         //合约数量乘数
         output.DeliveryYear,           //交割年份
         output.DeliveryMonth,          //交割月
         output.AdvanceMonth,           //提前月份
         output.TradeStatus,            //交易权限
         output.CreateDate,             //创建日
         output.OpenDate,               //上市日
         output.ExpireDate,             //到期日
         output.StartdelivDate,         //开始交割日
         output.EnddelivDate,           //最后交割日
         output.BasisPrice,             //挂牌基准价
         output.StrikePrice,            //行权价格
         output.MaxMarketOrderVolume,   //市价单最大下单量
         output.MinMarketOrderVolume,   //市价单最小下单量
         output.MaxLimitOrderVolume,    //限价单最大下单量
         output.MinLimitOrderVolume,    //限价单最小下单量
         output.PriceTick,              //最小变动价位
         //以下为行情信息
         output.LastPrice,               //最新价
         output.SettlementPrice,         //昨日结算价
         output.UpperLimitPrice,         //涨停板价格
         output.LowerLimitPrice);         //跌停板价格
   Logs->Trace("----------");

   return irtn;
}

///根据合约编码获取合约序号
//int CTiTdApiReq::GetInstrumentNo(char* instrumentId, int &instrumentNo)
int CTiTdApiReq::GetInstrumentNo(char* instrumentId)
{
   //Logs->Trace("**********");
   Logs->Trace("GetInstrumentNo");
   Logs->Info("instrumentId:{}", instrumentId);
	Logs->Trace("**********");

   int output = 0;
   int irtn = m_pApi->GetInstrumentNo(instrumentId, output);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
  
   //查询输出
   Logs->Info("GetInstrumentNo");
   Logs->Info("InstrumentNo:{}", output);
   Logs->Trace("----------");

   return irtn;
}

///查询手续费信息(期货、期权、现货手续费均可通过该接口查询)
//int CTiTdApiReq::GetRateList(TdRspQryRateFieldList& output)
int CTiTdApiReq::GetRateList()
{
   //Logs->Trace("**********");
   Logs->Trace("GetRateList");
	Logs->Trace("**********");

   TdRspQryRateFieldList output;
   int irtn = m_pApi->GetRateList(output);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }

   //查询输出
   Logs->Info("GetRateList");
   int i=1;
   for(TdRspQryRateFieldList::iterator iter = output.begin();  iter != output.end(); iter++)
   {
      Logs->Info("ClientNo:{}, ClientId:{}, InstrumentNo:{}, InstrumentId:{}, OpenByMoney:{}, "
         "OpenByVolume:{}, CloseByMoney:{}, CloseByVolume:{}, CloseTodayByMoney:{}, CloseTodayByVolume:{}, "
         "OpenMax:{}, OpenMin:{}, CloseMax:{}, CloseMin:{}, seqnum:{}",
         iter->ClientNo,
         iter->ClientId,            //交易编码
         iter->InstrumentNo,
         iter->InstrumentId,        ///合约代码
         iter->OpenByMoney,         //开仓手续费率
         iter->OpenByVolume,        //开仓手续费
         iter->CloseByMoney,        //平仓手续费率
         iter->CloseByVolume,       //平仓手续费
         iter->CloseTodayByMoney,   //平今手续费率
         iter->CloseTodayByVolume,  //平今手续费
         iter->OpenMax,             //开仓单笔最高手续费
         iter->OpenMin,             //开仓单笔最低手续费
         iter->CloseMax,            //平仓单笔最高手续费
         iter->CloseMin,           //平仓单笔最低手续费
         i);

      if(i == output.size())
      {
         Logs->Info("------Last, total:{}------", i);
      }

      i++;
   }
   Logs->Trace("----------");

   return irtn;
}

///根据合约编码获取手续费信息(期货、期权、现货均可通过该接口查询)
//int CTiTdApiReq::GetRateInfo(char* clientId, char* instrumentId, CTdRspQryRateField& pRatet)
int CTiTdApiReq::GetRateInfo(char* clientId, char* instrumentId)
{
   //Logs->Trace("**********");
   Logs->Trace("GetRateInfo from clientId、instrumentId");
   Logs->Info("clientId:{}, instrumentId:{}", clientId, instrumentId);
	Logs->Trace("**********");

   CTdRspQryRateField output = {0};
   int irtn = m_pApi->GetRateInfo(clientId, instrumentId, output);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }

   //查询输出
   Logs->Info("GetRateInfo");
   Logs->Info("ClientNo:{}, ClientId:{}, InstrumentNo:{}, InstrumentId:{}, OpenByMoney:{}, "
         "OpenByVolume:{}, CloseByMoney:{}, CloseByVolume:{}, CloseTodayByMoney:{}, CloseTodayByVolume:{}, "
         "OpenMax:{}, OpenMin:{}, CloseMax:{}, CloseMin:{}",
         output.ClientNo,
         output.ClientId,            //交易编码
         output.InstrumentNo,
         output.InstrumentId,        ///合约代码
         output.OpenByMoney,         //开仓手续费率
         output.OpenByVolume,        //开仓手续费
         output.CloseByMoney,        //平仓手续费率
         output.CloseByVolume,       //平仓手续费
         output.CloseTodayByMoney,   //平今手续费率
         output.CloseTodayByVolume,  //平今手续费
         output.OpenMax,             //开仓单笔最高手续费
         output.OpenMin,             //开仓单笔最低手续费
         output.CloseMax,            //平仓单笔最高手续费
         output.CloseMin);           //平仓单笔最低手续费
   Logs->Trace("----------");

   return irtn;
}

///根据合约序号获取手续费信息(期货、期权、现货均可通过该接口查询)
//int CTiTdApiReq::GetRateInfo(int clientNo, int instrumentNo, CTdRspQryRateField& pRate)
int CTiTdApiReq::GetRateInfo(int clientNo, int instrumentNo)
{
   //Logs->Trace("**********");
   Logs->Trace("GetRateInfo from clientNo、instrumentNo");
   Logs->Info("clientNo:{}, instrumentNo:{}", clientNo, instrumentNo);
	Logs->Trace("**********");

   CTdRspQryRateField output = {0};
   int irtn = m_pApi->GetRateInfo(clientNo, instrumentNo, output);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }

   //查询输出
   Logs->Info("GetRateInfo");
   Logs->Info("ClientNo:{}, ClientId:{}, InstrumentNo:{}, InstrumentId:{}, OpenByMoney:{}, "
         "OpenByVolume:{}, CloseByMoney:{}, CloseByVolume:{}, CloseTodayByMoney:{}, CloseTodayByVolume:{}, "
         "OpenMax:{}, OpenMin:{}, CloseMax:{}, CloseMin:{}",
         output.ClientNo,
         output.ClientId,            //交易编码
         output.InstrumentNo,
         output.InstrumentId,        ///合约代码
         output.OpenByMoney,         //开仓手续费率
         output.OpenByVolume,        //开仓手续费
         output.CloseByMoney,        //平仓手续费率
         output.CloseByVolume,       //平仓手续费
         output.CloseTodayByMoney,   //平今手续费率
         output.CloseTodayByVolume,  //平今手续费
         output.OpenMax,             //开仓单笔最高手续费
         output.OpenMin,             //开仓单笔最低手续费
         output.CloseMax,            //平仓单笔最高手续费
         output.CloseMin);         //平仓单笔最低手续费
   Logs->Trace("----------");

   return irtn;
}

///查询期权保证金
//int CTiTdApiReq::GetOptMarginList(TdRspQryOptMarginFieldList& output)
int CTiTdApiReq::GetOptMarginList()
{
   //Logs->Trace("**********");
   Logs->Trace("GetOptMarginList");
	Logs->Trace("**********");

   TdRspQryOptMarginFieldList output;
   int irtn = m_pApi->GetOptMarginList(output);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }

   //查询输出
   Logs->Info("GetOptMarginList");
   int i=1;
   for(TdRspQryOptMarginFieldList::iterator iter = output.begin();  iter != output.end(); iter++)
   {
      Logs->Info("ClientNo:{}, ClientId:{}, InstrumentNo:{}, InstrumentId:{}, Param1:{}, Param2:{}, MarginRate:{}, seqnum:{}",
         iter->ClientNo,
         iter->ClientId,              //交易编码
         iter->InstrumentNo,
         iter->InstrumentId,          //合约代码
         iter->Param1,                //参数1
         iter->Param2,                //参数2
         iter->MarginRate,            //在交易所基础上收取的比例
         i);
         
         
      if(i == output.size())
      {
         Logs->Info("------Last, total:{}------", i);
      }

      i++;
   }
   Logs->Trace("----------");

   return irtn;
}

///根据合约编码获取期权保证金
//int CTiTdApiReq::GetOptMarginInfo(char* clientId, char* instrumentId, CTdRspQryOptMarginField& pMargin)
int CTiTdApiReq::GetOptMarginInfo(char* clientId, char* instrumentId)
{
   //Logs->Trace("**********");
   Logs->Trace("GetOptMarginInfo from clientId");
   Logs->Info("clientId:{}, instrumentId:{}", clientId, instrumentId);
	Logs->Trace("**********");

   CTdRspQryOptMarginField output = {0};
   int irtn = m_pApi->GetOptMarginInfo(clientId, instrumentId, output);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }

   //查询输出
   Logs->Info("GetOptMarginInfo");
   Logs->Info("ClientNo:{}, ClientId:{}, InstrumentNo:{}, InstrumentId:{}, Param1:{}, Param2:{}, MarginRate:{}",
         output.ClientNo,
         output.ClientId,              //交易编码
         output.InstrumentNo,
         output.InstrumentId,          //合约代码
         output.Param1,                //参数1
         output.Param2,                //参数2
         output.MarginRate);            //在交易所基础上收取的比例
   Logs->Trace("----------");

   return irtn;
}

///根据合约序号获取期权保证金
//int CTiTdApiReq::GetOptMarginInfo(int clientNo, int instrumentNo, CTdRspQryOptMarginField& pMargin)
int CTiTdApiReq::GetOptMarginInfo(int clientNo, int instrumentNo)
{
   //Logs->Trace("**********");
   Logs->Trace("GetOptMarginInfo from clientNo、instrumentNo");
   Logs->Info("clientNo:{}, instrumentNo:{}", clientNo, instrumentNo);
	Logs->Trace("**********");

   CTdRspQryOptMarginField output = {0};
   int irtn = m_pApi->GetOptMarginInfo(clientNo, instrumentNo, output);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }

   //查询输出
   Logs->Info("GetOptMarginInfo");
   Logs->Info("ClientNo:{}, ClientId:{}, InstrumentNo:{}, InstrumentId:{}, Param1:{}, Param2:{}, MarginRate:{}",
         output.ClientNo,
         output.ClientId,              //交易编码
         output.InstrumentNo,
         output.InstrumentId,          //合约代码
         output.Param1,                //参数1
         output.Param2,                //参数2
         output.MarginRate);            //在交易所基础上收取的比例
   Logs->Trace("----------");

   return irtn;
}

///查询期货保证金
//int CTiTdApiReq::GetFutMarginList(TdRspQryFutMarginFieldList& output)
int CTiTdApiReq::GetFutMarginList()
{
   //Logs->Trace("**********");
   Logs->Trace("GetFutMarginList");
	Logs->Trace("**********");

   TdRspQryFutMarginFieldList output;
   int irtn = m_pApi->GetFutMarginList(output);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }

   //查询输出
   Logs->Info("GetFutMarginList");
   int i=1;
   for(TdRspQryFutMarginFieldList::iterator iter = output.begin();  iter != output.end(); iter++)
   {
      Logs->Info("ClientNo:{}, ClientId:{}, InstrumentNo:{}, InstrumentId:{}, LongbyMoney:{}, LongbyVolume:{}, ShortbyMoney:{}, ShortbyVolume:{}, seqnum:{}",
         iter->ClientNo,
         iter->ClientId,           //交易编码
         iter->InstrumentNo,
         iter->InstrumentId,       //合约代码
         iter->LongbyMoney,        //多头保证金率
         iter->LongbyVolume,       //多头保证金费
         iter->ShortbyMoney,       //空头保证金率
         iter->ShortbyVolume,      //空头保证金率 
         i);
   
      if(i == output.size())
      {
         Logs->Info("------Last, total:{}------", i);
      }

      i++;
   }
   Logs->Trace("----------");

   return irtn;
}

///根据合约编码获取期货保证金
//int CTiTdApiReq::GetFutMarginInfo(char* clientId, char* instrumentId, CTdRspQryFutMarginField& pMargin)
int CTiTdApiReq::GetFutMarginInfo(char* clientId, char* instrumentId)
{
   //Logs->Trace("**********");
   Logs->Trace("GetFutMarginInfo from clientId");
   Logs->Info("clientId:{}, instrumentId:{}", clientId, instrumentId);
	Logs->Trace("**********");

   CTdRspQryFutMarginField output = {0};
   int irtn = m_pApi->GetFutMarginInfo(clientId, instrumentId, output);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }

   //查询输出
   Logs->Info("GetFutMarginInfo");
   Logs->Info("ClientNo:{}, ClientId:{}, InstrumentNo:{}, InstrumentId:{}, LongbyMoney:{}, LongbyVolume:{}, ShortbyMoney:{}, ShortbyVolume:{}",
         output.ClientNo,
         output.ClientId,           //交易编码
         output.InstrumentNo,
         output.InstrumentId,       //合约代码
         output.LongbyMoney,        //多头保证金率
         output.LongbyVolume,       //多头保证金费
         output.ShortbyMoney,       //空头保证金率
         output.ShortbyVolume);      //空头保证金率
   Logs->Trace("----------");

   return irtn;
}

///根据合约序号获取期货保证金
//int CTiTdApiReq::GetFutMarginInfo(int clientNo, int instrumentNo, CTdRspQryFutMarginField& pMargin)
int CTiTdApiReq::GetFutMarginInfo(int clientNo, int instrumentNo)
{
   //Logs->Trace("**********");
   Logs->Trace("GetFutMarginInfo from clientNo");
   Logs->Info("clientNo:{}, instrumentNo:{}", clientNo, instrumentNo);
	Logs->Trace("**********");

   CTdRspQryFutMarginField output = {0};
   int irtn = m_pApi->GetFutMarginInfo(clientNo, instrumentNo, output);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }

   //查询输出
   Logs->Info("GetFutMarginInfo");
   Logs->Info("ClientNo:{}, ClientId:{}, InstrumentNo:{}, InstrumentId:{}, LongbyMoney:{}, LongbyVolume:{}, ShortbyMoney:{}, ShortbyVolume:{}",
         output.ClientNo,
         output.ClientId,           //交易编码
         output.InstrumentNo,
         output.InstrumentId,       //合约代码
         output.LongbyMoney,        //多头保证金率
         output.LongbyVolume,       //多头保证金费
         output.ShortbyMoney,       //空头保证金率
         output.ShortbyVolume);      //空头保证金率
   Logs->Trace("----------");

   return irtn;
}

///从本地获取资金信息
//int CTiTdApiReq::GetAccount(char * accountId, CTdRspQryAccountField& pRspPartAccount)
int CTiTdApiReq::GetAccount(char * accountId)
{
   //Logs->Trace("**********");
   Logs->Trace("GetAccount");
   Logs->Info("accountId:{}", accountId);
	Logs->Trace("**********");

   CTdRspQryAccountField output = {0};
   int irtn = m_pApi->GetAccount(accountId, output);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }

   //查询输出
   Logs->Info("GetAccount");
   Logs->Info("AccountId:{}, Prebalance:{}, DistribFund:{}, Balance:{}, Commi:{}, "
            "FutMargin:{}, OptMargin:{}, CombMargin:{}, CloseProfit:{}, PosiProfit:{}, "
            "Premium:{}, Deposit:{}, Withdraw:{}, FrozenMargin:{}, FrozenPremium:{}, "
            "FrozenCommi:{}, EntryFees:{}, BuyPremium:{}",
         output.AccountId,                /// 资金帐号
         output.Prebalance,                   /// 上次结算准备金
         output.DistribFund,                  /// 本系统分配资金(起初本系统的最大可用)
         output.Balance,                      /// 结算准备金
         output.Commi,                        /// 手续费
         output.FutMargin,                    /// 当前期货保证金总额
         output.OptMargin,                    /// 当前期权保证金总额
         output.CombMargin,                   /// 当前保证金优惠总额
         output.CloseProfit,                  /// 平仓盈亏
         output.PosiProfit,                   /// 持仓盈亏(浮动盈亏)
         output.Premium,                      /// 期权权利金收支(如果是现货账户则保存开仓时的持仓金额)
         output.Deposit,                      /// 入金金额
         output.Withdraw,                     /// 出金金额
         output.FrozenMargin,                 /// 冻结的保证金
         output.FrozenPremium,                /// 冻结的权利金
         output.FrozenCommi,                  /// 冻结的手续费
         output.EntryFees,                    /// 当日申报费用
         output.BuyPremium);                  /// 权力仓当前占用的权利金(如果是现货账户则表示持仓占用的金额)
   Logs->Trace("----------");

   return irtn;
}

/*
* 客户登录登出
*
*
*
*
*/

///用户登录请求
int CTiTdApiReq::ReqUserLogin(CTdReqUserLoginField* pReqUserLogin, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqUserLogin");
   Logs->Info("UserId:{}, Password:{}, ProtocolInfo:{}, UserProductInfo:{}, AppId:{}, AppIdIdentify:{}",
		   pReqUserLogin->UserId,         // 本次登录的session
		   pReqUserLogin->Password,        // 交易日
		   pReqUserLogin->ProtocolInfo,         // 登录成功时间
		   pReqUserLogin->UserProductInfo,   // 最大会员内部订单编号
		   pReqUserLogin->AppId,            // 交易用户代码
		   pReqUserLogin->AppIdIdentify);   // 交易系统名称
   Logs->Info("nRequestID:{}", nRequestID);
   Logs->Trace("**********");

   int irtn = m_pApi->ReqUserLogin(pReqUserLogin, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///用户退出请求
int CTiTdApiReq::ReqUserLogout(int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqUserLogout");
   Logs->Info("nRequestID:{}", nRequestID);
	Logs->Trace("**********");

   int irtn = m_pApi->ReqUserLogout(nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///用户密码修改请求
int CTiTdApiReq::ReqUserPasswordUpdate(CTdUserPasswordUpdateField* pUserPasswordUpdate, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqUserPasswordUpdate");
   Logs->Info("nRequestID:{}", nRequestID);
   Logs->Trace("**********");

   int irtn = m_pApi->ReqUserPasswordUpdate(pUserPasswordUpdate, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

/*
* 报单相关的请求
*
*
*
*
*/

///股票报单请求
int CTiTdApiReq::ReqStockInsert(CTdStockInsertReqField* pStockInsert, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqStockInsert");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pStockInsert)
   {
         Logs->Trace("ClientNo:{}, InstrumentNo:{}, LocalOrderNo:{}, PriceType:{:d}, Side:{:d}, TimeInForce:{:d}, Volume:{}, Price:{}, " 
                     "OwnerType:{:d},ExchangeId:{:d},  FrontNo:{:d} ",
               pStockInsert->ClientNo,                   //交易编码序号
               pStockInsert->InstrumentNo,               //合约序号
               pStockInsert->LocalOrderNo,               //会员内部订单编号
               pStockInsert->PriceType,                  //报单价格条件
               pStockInsert->Side,                       //买卖方向
               pStockInsert->TimeInForce,                //订单有效时间类型
               pStockInsert->Volume,                     //数量
               pStockInsert->Price,                      //价格
               pStockInsert->OwnerType,                  //订单所有类型
               pStockInsert->ExchangeId,                 //交易所代码
               pStockInsert->FrontNo);
   }
	Logs->Trace("**********");

   int irtn = m_pApi->ReqStockInsert(pStockInsert, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///股票撤单请求
int CTiTdApiReq::ReqStockCancel(CTdOrderCancelReqField* pStockCancel, int nRequestID)
{
  //Logs->Trace("**********");
   Logs->Trace("ReqStockCancel");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pStockCancel)
   {
         Logs->Trace("OriSessionNo:{},  OriLocalOrderNo:{},  OrderSysId:{}",
               pStockCancel->OriSessionNo,
               pStockCancel->OriLocalOrderNo,
               pStockCancel->OrderSysId);
   }
   Logs->Trace("**********");

   int irtn = m_pApi->ReqStockCancel(pStockCancel, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

// /股票非交易业务报单请求
int CTiTdApiReq::ReqBusinessInsert(CTdBusinessInsertReqField* pStockInsert, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqBusinessInsert");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pStockInsert)
   {
      Logs->Trace("BusinessType:{:d}, ClientNo:{}, InstrumentId:{}, LocalOrderNo:{},Side:{:d}, "
               "Volume:{}, Price:{}, ExchangeId:{:d}, DestInstrumentId:{}",
               pStockInsert->BusinessType,              //业务类型
               pStockInsert->ClientNo,                   //交易编码序号
               pStockInsert->InstrumentId,               //合约代码
               pStockInsert->LocalOrderNo,               //会员内部订单编号
               //TdPriceTypeType     PriceType;          //报单价格条件
               pStockInsert->Side,                       //买卖方向
               //TdTimeInForceType   TimeInForce;        //订单有效时间类型
               pStockInsert->Volume,                     //数量
               pStockInsert->Price,                      //价格
               //TdOwnerTypeType     OwnerType;          //订单所有类型
               pStockInsert->ExchangeId,                 //交易所代码
               pStockInsert->DestInstrumentId);          //目标合约代码
   }
	Logs->Trace("**********");

   int irtn = m_pApi->ReqBusinessInsert(pStockInsert, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

// /股票非交易业务撤单请求
int CTiTdApiReq::ReqBusinessCancel(CTdOrderCancelReqField* pStockCancel, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqBusinessCancel");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pStockCancel)
   {
      Logs->Trace("OriSessionNo:{}, OriLocalOrderNo:{}, OrderSysId:{}",
      pStockCancel->OriSessionNo,       //原始报单的sessionno如果是通过LocalOrderNo撤单，需要填写，不填写则默认撤销本次登录后的LocalOrderNo
      pStockCancel->OriLocalOrderNo,    //原始交易客户方订单编号
      pStockCancel->OrderSysId);         //交易所订单编号(OrigLocalOrderNo和OrderSysId任意一个即可)
   }
	Logs->Trace("**********");

  int irtn = m_pApi->ReqBusinessCancel(pStockCancel, nRequestID);
     if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///证券锁定请求
int CTiTdApiReq::ReqStockLock(CTdStockLockReqField* pStockLock, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqStockLock");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pStockLock)
   {
      // TdClientNoType        ClientNo;                 //交易编码序号
      //   TdInstrumentNoType    InstrumentNo;             //合约序号
      //   TdLocalOrderNoType    LocalOrderNo;             //会员内部订单编号
      //   TdLockType            Locked;                   //锁定标志撤销
      //   TdVolumeType          Volume;                   //数量
      //   TdExchangeIdType      ExchangeId;               //交易所代码
      //   ///处理本次报单的席位序号,当所填的序号在系统中不存在时系统会优选最佳席位进行报单,否则,根据用户所选席位进行报单
      //   TdFrontNoType            FrontNo;
      Logs->Trace("ClientNo:{}, InstrumentNo:{}, LocalOrderNo:{}, Locked:{:d}, Volume:{}, ExchangeId:{:d}, FrontNo:{}",
      pStockLock->ClientNo,
      pStockLock->InstrumentNo,
      pStockLock->LocalOrderNo,
      pStockLock->Locked,
      pStockLock->Volume,
      pStockLock->ExchangeId,
      pStockLock->FrontNo);
   }
   Logs->Trace("**********");

   int irtn = m_pApi->ReqStockLock(pStockLock, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///期权,期货报单请求
int CTiTdApiReq::ReqOptionsInsert(CTdOrderInsertReqField* pOptionsInsert, int nRequestID)
{
  //Logs->Trace("**********");
  Logs->Trace("ReqOptionsInsert");
  Logs->Info("nRequestID:{}", nRequestID);
  if (pOptionsInsert)
  {
      Logs->Trace("ClientNo:{},InstrumentNo:{},LocalOrderNo:{},PriceType:{:d},Side:{:d},OffsetFlag:{:d},HedgeFlag:{:d},TimeInForce:{:d},CoveredOrUncovered:{:d},"
      "VolumeCondition:{:d},TrigCondition:{:d}, Volume:{}, MinVolume:{},Price:{}, StopPrice:{},OwnerType:{:d}, ExchangeId:{:d},FrontNo:{:d}",
                  pOptionsInsert->ClientNo,
                  pOptionsInsert->InstrumentNo,
                  pOptionsInsert->LocalOrderNo,        // 会员内部订单编号
                  pOptionsInsert->PriceType,           // 报单价格条件
                  pOptionsInsert->Side,                // 买卖方向
                  pOptionsInsert->OffsetFlag,          // 开平标记
                  pOptionsInsert->HedgeFlag,           // 投机套保标记
                  pOptionsInsert->TimeInForce,         // 订单有效时间类型
                  pOptionsInsert->CoveredOrUncovered,  //备兑标签
                  pOptionsInsert->VolumeCondition,     //成交量类型
                  pOptionsInsert->TrigCondition,        //触发条件
                  pOptionsInsert->Volume,               //数量
                  pOptionsInsert->MinVolume,            //最小成交量
                  pOptionsInsert->Price,                //价格
                  pOptionsInsert->StopPrice,            //止损价
                  pOptionsInsert->OwnerType,            //订单所有类型
                  pOptionsInsert->ExchangeId,           //交易所代码
                  pOptionsInsert->FrontNo);             // 处理本次报单的席位序号
  }
	Logs->Trace("**********");

   int irtn = m_pApi->ReqOptionsInsert(pOptionsInsert, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///期权,期货撤单请求
int CTiTdApiReq::ReqOptionsCancel(CTdOrderCancelReqField* pOptionsCancel, int nRequestID)
{
  //Logs->Trace("**********");
  Logs->Trace("ReqOptionsCancel");
  Logs->Info("nRequestID:{}", nRequestID);
  if (pOptionsCancel)
  {
      Logs->Trace("OriSessionNo:{}, OriLocalOrderNo:{}, OrderSysId:{}",
          pOptionsCancel->OriSessionNo,       //原始报单的sessionno如果是通过LocalOrderNo撤单，需要填写，不填写则默认撤销本次登录后的LocalOrderNo
          pOptionsCancel->OriLocalOrderNo,    //原始交易客户方订单编号
          pOptionsCancel->OrderSysId);         //交易所订单编号(OrigLocalOrderNo和OrderSysId任意一个即可));
  }
  Logs->Trace("**********");

   //int irtn = 322;
   int irtn = m_pApi->ReqOptionsCancel(pOptionsCancel, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///期权,期货报价请求
int CTiTdApiReq::ReqQuoteInsert(CTdQuoteInsertReqField* pQuoteInsert, int nRequestID)
{
  //Logs->Trace("**********");
  Logs->Trace("ReqQuoteInsert");
  Logs->Info("nRequestID:{}", nRequestID);
  if (pQuoteInsert)
  {
      Logs->Trace("ClientNo:{}, InstrumentNo:{}, LocalOrderNo:{}, QuoteReqId:{}, BidPx:{}, AskPx:{}, BidSize:{}, AskSize:{}, BidOffsetFlag:{:d}, AskOffsetFlag:{:d}, OwnerType:{:d}, ExchangeId:{:d}, FrontNo:{:d}",
                  pQuoteInsert->ClientNo,            //交易编码序号
                  pQuoteInsert->InstrumentNo,        //合约序号
                  pQuoteInsert->LocalOrderNo,        //会员内部订单编号
                  pQuoteInsert->QuoteReqId,          //报价请求ID,预留字段,当报价是对请求的响应时，填写报价请求的ID
                  pQuoteInsert->BidPx,               //买报价
                  pQuoteInsert->AskPx,               //卖报价
                  pQuoteInsert->BidSize,             //买数量
                  pQuoteInsert->AskSize,             //卖数量
                  pQuoteInsert->BidOffsetFlag,       //平仓标识
                  pQuoteInsert->AskOffsetFlag,       //平仓标识
                  pQuoteInsert->OwnerType,           //订单所有类型
                  pQuoteInsert->ExchangeId,          //交易所代码
                  pQuoteInsert->FrontNo);
  }
	Logs->Trace("**********");

   int irtn = m_pApi->ReqQuoteInsert(pQuoteInsert, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///期权,期货撤销报价请求
int CTiTdApiReq::ReqQuoteCancel(CTdOrderCancelReqField* pQuoteCancel, int nRequestID)
{
  //Logs->Trace("**********");
  Logs->Trace("ReqQuoteCancel");
  Logs->Info("nRequestID:{}", nRequestID);
  if (pQuoteCancel)
  {
      Logs->Trace("OriSessionNo:{}, OriLocalOrderNo:{}, OrderSysId:{}",
		   pQuoteCancel->OriSessionNo,       //原始报单的sessionno如果是通过LocalOrderNo撤单，需要填写，不填写则默认撤销本次登录后的LocalOrderNo
		   pQuoteCancel->OriLocalOrderNo,    //原始交易客户方订单编号
		   pQuoteCancel->OrderSysId);         //交易所订单编号(OrigLocalOrderNo和OrderSysId任意一个即可));
  }
	Logs->Trace("**********");

   int irtn = m_pApi->ReqQuoteCancel(pQuoteCancel, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///询价请求
int CTiTdApiReq::ReqForQuote(CTdForQuoteReqField* pForQuote, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqForQuote");
   Logs->Info("nRequestID:{}", nRequestID);
	Logs->Trace("**********");

   int irtn = m_pApi->ReqForQuote(pForQuote, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///行权请求
int CTiTdApiReq::ReqExercise(CTdExerciseReqField* pExercise, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqExercise");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pExercise)
   {
      Logs->Trace("ClientNo:{}, InstrumentNo:{}, LocalOrderNo:{}, Volume:{}, OwnerType:{:d}, ExchangeId:{:d}",
            pExercise->ClientNo,                 //交易编码序号
            pExercise->InstrumentNo,             //合约序号
            pExercise->LocalOrderNo,             //会员内部订单编号
            pExercise->Volume,                   //申报数量
            pExercise->OwnerType,                //订单所有类型
            pExercise->ExchangeId);              //交易所代码
   }
   Logs->Trace("**********");

   int irtn = m_pApi->ReqExercise(pExercise, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///组合行权请求
int CTiTdApiReq::ReqCombExercise(CTdCombExerciseReqField* pExercise, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqCombExercise");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pExercise)
   {
         Logs->Trace("ClientNo:{}, LocalOrderNo:{}, Volume:{}, LegInstrumentNo1:{}, LegVolume1:{}, LegInstrumentNo2:{}, LegVolume2:{}, OwnerType:{:d}, ExchangeId:{:d}",
            pExercise->ClientNo,                   //交易编码序号
            pExercise->LocalOrderNo,               //会员内部订单编号
            pExercise->Volume,                     //申报数量
            pExercise->LegInstrumentNo1,           //腿1合约序号
            pExercise->LegVolume1,                 //腿1申报数量
            pExercise->LegInstrumentNo2,           //腿2合约序号
            pExercise->LegVolume2,                 //腿2申报数量
            pExercise->OwnerType,                  //订单所有类型
            pExercise->ExchangeId);                 //交易所代码
   }
	Logs->Trace("**********");

   int irtn = m_pApi->ReqCombExercise(pExercise, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///撤销行权请求
int CTiTdApiReq::ReqExerciseCancel(CTdOrderCancelReqField* pExerciseCancel, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqExerciseCancel");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pExerciseCancel)
   {
         Logs->Trace("OriSessionNo:{}, OriLocalOrderNo:{}, OrderSysId:{}",
            pExerciseCancel->OriSessionNo,       //原始报单的sessionno如果是通过LocalOrderNo撤单，需要填写，不填写则默认撤销本次登录后的LocalOrderNo
            pExerciseCancel->OriLocalOrderNo,    //原始交易客户方订单编号
            pExerciseCancel->OrderSysId);         //交易所订单编号(OrigLocalOrderNo和OrderSysId任意一个即可));
   }
	Logs->Trace("**********");

   int irtn = m_pApi->ReqExerciseCancel(pExerciseCancel, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///客户申请组合请求
int CTiTdApiReq::ReqMarginCombAction(CTdMarginCombActionField* pMarginCombAction, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqMarginCombAction");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pMarginCombAction)
   {
      Logs->Trace("ClientNo:{}, LocalOrderNo:{}, Volume:{}, Side:{}, CombId:{},CombInstId:{},  OwnerType:{:d}, ExchangeId:{:d},NoLeges:{}\n"
            "InstrumentNo:{}, LegSide:{}, CoveredOrUncovered:{:d}, LegVolume:{} \n"
				"InstrumentNo:{}, LegSide:{}, CoveredOrUncovered:{:d}, LegVolume:{} \n",
				// "InstrumentNo:{}, LegSide:{}, {:d}, {} \n"
				// "InstrumentNo:{}, LegSide:{}, {:d}, {} \n",
         pMarginCombAction->ClientNo,                 //交易编码序号
         pMarginCombAction->LocalOrderNo,             //会员内部订单编号
         pMarginCombAction->Volume,                   //申报数量(拆分组合的时候需要填入拆分的数量，组合的时候该字段无效)
         pMarginCombAction->Side,                     //组合与拆分组合标记,组合策略为“ZBD”时，组合与拆分方向只能为组合
         pMarginCombAction->CombId,                   //组合策略编码:目前为7种组合策略：CNSJC、PXSJC、PNSJC、CXSJC、KS、KKS、ZBD
         pMarginCombAction->CombInstId,               //组合编码。组合申报时，该字段为空格；拆分申报时，填写拟拆分组合的组合编码
         pMarginCombAction->OwnerType,                //订单所有类型
         pMarginCombAction->ExchangeId,               //交易所代码
         pMarginCombAction->NoLeges,                                    //成分合约数，取值不超过4，后接重复组
         pMarginCombAction->item[0].LegInstrumentNo,          //合约编码
         pMarginCombAction->item[0].LegSide,                  //合约方向
         pMarginCombAction->item[0].CoveredOrUncovered,    //备兑标签
         pMarginCombAction->item[0].LegVolume,
         pMarginCombAction->item[1].LegInstrumentNo,          //合约编码
         pMarginCombAction->item[1].LegSide,                  //合约方向
         pMarginCombAction->item[1].CoveredOrUncovered,    //备兑标签
         pMarginCombAction->item[1].LegVolume);
         // pMarginCombAction->item[2].LegInstrumentNo,          //合约编码
         // pMarginCombAction->item[2].LegSide,                  //合约方向
         // pMarginCombAction->item[2].CoveredOrUncovered,    //备兑标签
         // pMarginCombAction->item[2].LegVolume,
         // pMarginCombAction->item[3].LegInstrumentNo,          //合约编码
         // pMarginCombAction->item[3].LegSide,                  //合约方向
         // pMarginCombAction->item[3].CoveredOrUncovered,    //备兑标签
         // pMarginCombAction->item[3].LegVolume);         //交易所订单编号(OrigLocalOrderNo和OrderSysId任意一个即可));
   }
	Logs->Trace("**********");

   int irtn = m_pApi->ReqMarginCombAction(pMarginCombAction, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

/*
* 异步查询相关的请求
*
*
*
*
*/
///股票报单查询请求
int CTiTdApiReq::ReqQryStockOrder(CTdQryStockOrderField* pQryOrder, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqQryStockOrder");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pQryOrder)
   {
         Logs->Trace("ClientId:{}, InstrumentId:{}, OrderSysID:{}, BegTime:{}, EndTime:{}, Side:{:d}, OrdStatus:{:d}, LimitSession:{:d}, LimitUserId:{:d}",
         pQryOrder->ClientId,               /// [交易编码]
         pQryOrder->InstrumentId,           /// [合约编码]
         pQryOrder->OrderSysID,             /// [交易所报单编号] 默认值:0或空格 表示不过滤报单编号
         pQryOrder->BegTime,                /// [起始时间]       默认值:0 0表示不设起始时间
         pQryOrder->EndTime,                /// [结束时间]       默认值:0 0表示不设结束时间
         pQryOrder->Side,                   /// [买卖方向]
         pQryOrder->OrdStatus,              /// [订单状态]        默认值:0 表示不过滤订单状态
         pQryOrder->LimitSession,           /// [限制当前session] 默认值:0 0表示不限制
         pQryOrder->LimitUserId);            /// [限制当前UserId]  默认值:0 0表示不限制
   }
	Logs->Trace("**********");

   int irtn = m_pApi->ReqQryStockOrder(pQryOrder, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///股票非交易业务报单查询请求
int CTiTdApiReq::ReqQryBusinessOrder(CTdQryBusinessOrderField* pQryOrder, int nRequestID)
{
  //Logs->Trace("**********");
  Logs->Trace("ReqQryBusinessOrder");
  Logs->Info("nRequestID:{}", nRequestID);
  if (pQryOrder)
  {
      Logs->Trace("ClientId:{}, InstrumentId:{}, OrderSysID:{}, BegTime:{}, EndTime:{},Side:{:d}, OrdStatus:{:d}, LimitSession:{:d}, LimitUserId:{:d}",
      pQryOrder->ClientId,               /// [交易编码]
      pQryOrder->InstrumentId,           /// [合约编码]
      pQryOrder->OrderSysID,             /// [交易所报单编号] 默认值:0或空格 表示不过滤报单编号
      pQryOrder->BegTime,                /// [起始时间]       默认值:0 0表示不设起始时间
      pQryOrder->EndTime,                /// [结束时间]       默认值:0 0表示不设结束时间
      pQryOrder->Side,                   /// [买卖方向]
      pQryOrder->OrdStatus,              /// [订单状态]        默认值:0 表示不过滤订单状态
      pQryOrder->LimitSession,           /// [限制当前session] 默认值:0 0表示不限制
      pQryOrder->LimitUserId);            /// [限制当前UserId]  默认值:0 0表示不限制
  }
	Logs->Trace("**********");

   int irtn = m_pApi->ReqQryBusinessOrder(pQryOrder, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///期权,期货报单查询请求
int CTiTdApiReq::ReqQryOptionsOrder(CTdQryOptionsOrderField* pQryOrder, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqQryOptionsOrder");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pQryOrder)
   {
         Logs->Trace("ClientId:{},InstrumentId:{}, OrderSysID:{},BegTime:{},EndTime:{}, Side:{:d},OrdStatus:{:d},LimitSession:{:d},LimitUserId:{:d}",
         pQryOrder->ClientId,               /// [交易编码]
         pQryOrder->InstrumentId,           /// [合约编码]
         pQryOrder->OrderSysID,             /// [交易所报单编号] 默认值:0或空格 表示不过滤报单编号
         pQryOrder->BegTime,                /// [起始时间]       默认值:0 0表示不设起始时间
         pQryOrder->EndTime,                /// [结束时间]       默认值:0 0表示不设结束时间
         pQryOrder->Side,                   /// [买卖方向]
         pQryOrder->OrdStatus,              /// [订单状态]        默认值:0 表示不过滤订单状态
         pQryOrder->LimitSession,           /// [限制当前session] 默认值:0 0表示不限制
         pQryOrder->LimitUserId);            /// [限制当前UserId]  默认值:0 0表示不限制
   }
   Logs->Trace("**********");

   int irtn = m_pApi->ReqQryOptionsOrder(pQryOrder, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///报价查询请求
int CTiTdApiReq::ReqQryQuoteOrder(CTdQryQuoteOrderField* pQryQuote, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqQryQuoteOrder");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pQryQuote)
   {
         Logs->Trace("ClientId:{}, InstrumentId:{}, OrderSysID:{}, BidOrderId:{}, AskOrderId:{}, BegTime:{}, EndTime:{}, BidStatus:{:d}, AskStatus:{:d}, LimitSession:{:d}, LimitUserId:{:d}",
         pQryQuote->ClientId,               /// [交易编码]
         pQryQuote->InstrumentId,           /// [合约编码]
         pQryQuote->OrderSysID,             /// [交易所报单编号] 默认值:0或空格 表示不过滤报单编号
         pQryQuote->BidOrderId,
         pQryQuote->AskOrderId,
         pQryQuote->BegTime,                /// [起始时间]       默认值:0 0表示不设起始时间
         pQryQuote->EndTime,                /// [结束时间]       默认值:0 0表示不设结束时间
         pQryQuote->BidStatus,              /// [订单状态]        默认值:0 表示不过滤订单状态
		   pQryQuote->AskStatus,
         pQryQuote->LimitSession,           /// [限制当前session] 默认值:0 0表示不限制
         pQryQuote->LimitUserId);            /// [限制当前UserId]  默认值:0 0表示不限制
   }
   Logs->Trace("**********");

   int irtn = m_pApi->ReqQryQuoteOrder(pQryQuote, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

//行权查询请求
int CTiTdApiReq::ReqQryExercise(CTdQryExerciseField* pExercise, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqQryExercise");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pExercise)
   {
      Logs->Trace("ClientId:{}, InstrumentId:{}, OrderSysID:{}, BegTime:{}, EndTime:{}, OrdStatus:{:d}",
         pExercise->ClientId,               /// <交易编码>    必填项:不填返回错误提醒
         pExercise->InstrumentId,           /// [合约编码]    默认值:0 0或空格表示查询所有合约
         pExercise->OrderSysID,             /// [交易所报单编号]默认值:0或空格表示不过滤报单编号
         pExercise->BegTime,                /// [起始时间]    默认值:0 0表示不设起始时间
         pExercise->EndTime,                /// [结束时间]    默认值:0 0表示不设结束时间
         pExercise->OrdStatus);               /// [订单状态]    默认值:0 0表示不过滤订单状态
   }
	Logs->Trace("**********");

   int irtn = m_pApi->ReqQryExercise(pExercise, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

//组合行权查询请求
int CTiTdApiReq::ReqQryCombExercise(CTdQryCombExerciseField* pExercise, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqQryCombExercise");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pExercise)
   {
         Logs->Trace("ClientId:{}, InstrumentId1:{}, InstrumentId2:{}, OrderSysID:{}, BegTime:{}, EndTime:{}, OrdStatus:{:d}",
         pExercise->ClientId,               /// <交易编码>   必填项:不填返回错误提醒
         pExercise->InstrumentId1,          /// [合约编码1]  默认值:0 0或空格表示不过滤第一个合约
         pExercise->InstrumentId2,          /// [合约编码2]  默认值:0 0或空格表示不过滤第二个合约
         pExercise->OrderSysID,             /// [交易所报单编号]默认值:0 0或空格表示不过滤报单编号
         pExercise->BegTime,                /// [起始时间]   默认值:0 0表示不设起始时间
         pExercise->EndTime,                /// [结束时间]   默认值:0 0表示不设结束时间
         pExercise->OrdStatus);              /// [订单状态]   默认值:0 0表示不过滤订单状态
   }
	Logs->Trace("**********");

   int irtn = m_pApi->ReqQryCombExercise(pExercise, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///股票成交查询请求
int CTiTdApiReq::ReqQryStockTrade(CTdQryStockTradeField* pQryTrade, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqQryStockTrade");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pQryTrade)
   {
         Logs->Trace("ClientId:{}, InstrumentId:{}, OrderSysID:{}, TradeId:{}, BegSeqNo:{}, EndSeqNo:{}, BegTime:{}, EndTime:{}, Side:{:d}, LimitSession:{:d}, LimitUserId:{:d}",
         pQryTrade->ClientId,               /// [交易编码]
         pQryTrade->InstrumentId,           /// [合约编码]
         pQryTrade->OrderSysID,             /// [交易所报单编号]默认值:0或空格表示不过滤报单编号
         pQryTrade->TradeId,                /// [成交编号]
         pQryTrade->BegSeqNo,               /// [起始回报流序号] 默认值:0 0表示不设起始要求
         pQryTrade->EndSeqNo,               /// [结束回报流序号] 默认值:0 0表示不设结束要求
         pQryTrade->BegTime,                /// [起始时间]       默认值:0 0表示不设起始时间
         pQryTrade->EndTime,                /// [结束时间]       默认值:0 0表示不设结束时间
         pQryTrade->Side,                   /// [买卖方向]
         pQryTrade->LimitSession,           /// [限制当前session] 默认值:0 0表示不限制
         pQryTrade->LimitUserId);            /// [限制当前UserId]  默认值:0 0表示不限制
   }
	Logs->Trace("**********");

   int irtn = m_pApi->ReqQryStockTrade(pQryTrade, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///期权,期货成交查询请求
int CTiTdApiReq::ReqQryOptionsTrade(CTdQryOptionsTradeField* pQryTrade, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqQryOptionsTrade");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pQryTrade)
   {
         Logs->Trace("ClientId:{}, InstrumentId:{}, OrderSysID:{}, TradeId:{}, BegSeqNo:{}, EndSeqNo:{}, BegTime:{}, EndTime:{}, Side:{:d}, LimitSession:{:d}, LimitUserId:{:d}",
         pQryTrade->ClientId,               /// [交易编码]
         pQryTrade->InstrumentId,           /// [合约编码]
         pQryTrade->OrderSysID,             /// [交易所报单编号]默认值:0或空格表示不过滤报单编号
         pQryTrade->TradeId,                /// [成交编号]
         pQryTrade->BegSeqNo,               /// [起始回报流序号] 默认值:0 0表示不设起始要求
         pQryTrade->EndSeqNo,               /// [结束回报流序号] 默认值:0 0表示不设结束要求
         pQryTrade->BegTime,                /// [起始时间]       默认值:0 0表示不设起始时间
         pQryTrade->EndTime,                /// [结束时间]       默认值:0 0表示不设结束时间
         pQryTrade->Side,                   /// [买卖方向]
         pQryTrade->LimitSession,           /// [限制当前session] 默认值:0 0表示不限制
         pQryTrade->LimitUserId);            /// [限制当前UserId]  默认值:0 0表示不限制
   }
	Logs->Trace("**********");

   int irtn = m_pApi->ReqQryOptionsTrade(pQryTrade, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///股票持仓查询请求
int CTiTdApiReq::ReqQryStockPosition(CTdQryStockPositionField* pQryPosition, int nRequestID)
{
   Logs->Trace("**********");
   Logs->Trace("ReqQryStockPosition");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pQryPosition)
   {
         Logs->Trace("ClientId:{}, InstrumentId:{}",
         pQryPosition->ClientId,            /// <交易编码>   必填项:不填返回错误提醒
         pQryPosition->InstrumentId);        /// [合约编码]   默认值:0 0或空格表示查询所有合约
   }
	Logs->Trace("**********");

   int irtn = m_pApi->ReqQryStockPosition(pQryPosition, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///期权,期货持仓查询请求
int CTiTdApiReq::ReqQryOptionsPosition(CTdQryOptionsPositionField* pQryPosition, int nRequestID)
{
   Logs->Trace("**********");
   Logs->Trace("ReqQryOptionsPosition");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pQryPosition)
   {
         Logs->Trace("ClientId:{}, InstrumentId:{}, Side:{:d}, CoveredOrUn:{}",
         pQryPosition->ClientId,                 /// <交易编码>     必填项:不填返回错误提醒
         pQryPosition->InstrumentId,             /// [合约编码]     默认值:0 0或空格表示查询所有合约
         pQryPosition->Side,                     /// [买卖方向]     默认值:0 0表示不限制买卖方向
         pQryPosition->CoveredOrUn);             /// [备兑标记]     默认值:0 0表示不限制备兑标记
   }
	Logs->Trace("**********");

   int irtn = m_pApi->ReqQryOptionsPosition(pQryPosition, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///组合持仓查询请求
int CTiTdApiReq::ReqQryCombPosition(CTdQryCombPositionField* pQryPosi, int nRequestID)
{
   Logs->Trace("**********");
   Logs->Trace("ReqQryCombPosition");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pQryPosi)
   {
         Logs->Trace("ClientId:{}, CombID:{}, CombInstId:{}",
         pQryPosi->ClientId,               /// <交易编码>   必填项:不填返回错误提醒
         pQryPosi->CombID,                 /// [组合类型]   默认值:0 0或空格表示查询所有组合类型, 目前为7种组合策略：CNSJC、PXSJC、PNSJC、CXSJC、KS、KKS、ZBD
         pQryPosi->CombInstId);             /// [组合编码]   默认值:0 0或空格表示查询所有组合持仓
   }
	Logs->Trace("**********");

   int irtn = m_pApi->ReqQryCombPosition(pQryPosi, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///从服务端获取资金信息
int CTiTdApiReq::ReqQryAccount(CTdQryAccountField* pQryPartAccount, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqQryAccount");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pQryPartAccount)
   {
         Logs->Trace("AccountId:{}",
         pQryPartAccount->AccountId);
   }
	Logs->Trace("**********");

   int irtn = m_pApi->ReqQryAccount(pQryPartAccount, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///查询行情
int CTiTdApiReq::ReqQryMarketData(CTdQryMarketDataField* pQryMarketData, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqQryMarketData");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pQryMarketData)
   {
         Logs->Trace("InstrumentNo:{}, InstrumentId:{}",
         pQryMarketData->InstrumentNo,         //{合约No}
         pQryMarketData->InstrumentId);        //{合约代码}
   }
	Logs->Trace("**********");

   int irtn = m_pApi->ReqQryMarketData(pQryMarketData, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}

///查询通知
int CTiTdApiReq::ReqQryNotify(CTdQryNotifyField* pQryNotify, int nRequestID)
{
   //Logs->Trace("**********");
   Logs->Trace("ReqQryNotify");
   Logs->Info("nRequestID:{}", nRequestID);
   if (pQryNotify)
   {
         Logs->Trace("BegSeqNo:{}, EndSeqNo:{}",
         pQryNotify->BegSeqNo,
         pQryNotify->EndSeqNo);
   }
	Logs->Trace("**********");

	int irtn = m_pApi->ReqQryNotify(pQryNotify, nRequestID);
   if (irtn != 0)
   {
      Logs->Trace("请求发送失败:{}", irtn);
   }
   return irtn;
}
