#ifndef _TITDAPI_REQ_H_
#define _TITDAPI_REQ_H_

#include "TiTdApi.h"
using namespace titd;

class CTiTdApiReq
{
public:
	CTiTdApiReq(){};
	~CTiTdApiReq(){};

public:
   CTiTdApi *m_pApi;

public:
   ///创建TraderApi
   ///@return 创建出的Api
   CTiTdApi* CreateTiTdApi();

   ///获取系统版本号
   ///@return 系统标识字符串
   const char* GetApiVersion();

   ///删除接口对象本身
   ///@remark 不再使用本接口对象时,调用该函数删除接口对象
   virtual void Release();

   ///注册回调接口(该方法必须在Init之前调用)
   ///@param pSpi 派生自回调接口类的实例
   virtual void RegisterSpi(CTiTdSpi* pSpi);

   ///初始化
   ///@param cfgInfo：初始化api所用的结构
   ///@remark 初始化运行环境,只有调用后,接口才开始工作
   virtual int Init(CTdConfigInfoField& cfgInfo);

   ///初始化
   ///@param cfgFile：初始化api的配置文件
   ///@remark 初始化运行环境,只有调用后,接口才开始工作
   virtual int Init(const char* cfgFile);

   ///获取交易编码
   virtual int GetClientList(TdRspQryClientList& output);

   ///根据交易编码获取交易编码信息
   //virtual int GetClientInfo(char* clientId, CTdRspQryClientField& pClient);
   virtual int GetClientInfo(char* clientId);

   ///根据交易编码序号获取交易编码信息
   //virtual int GetClientInfo(int clientNo, CTdRspQryClientField& pClient);
   virtual int GetClientInfo(int clientNo);

   ///根据交易编码获取交易编码序号
   //virtual int GetClientNo(char *clientId,int &clientNo);
   virtual int GetClientNo(char *clientId);

   ///获取交易前置列表
   //virtual int GetFrontList(TdRspQryFrontFieldList& output);
   virtual int GetFrontList();

   ///获取合约列表
   //virtual int GetInstrumentList(TdRspQryInstrumentFieldList& output);
   virtual int GetInstrumentList();

   ///根据合约编码获取合约信息(期货、期权、现货均可通过该接口查询)
   //virtual int GetInstrumentInfo(char* instrumentId, CTdRspQryInstrumentField& pInstrument);
   virtual int GetInstrumentInfo(char* instrumentId);

   ///根据合约序号获取合约信息(期货、期权、现货均可通过该接口查询)
   //virtual int GetInstrumentInfo(int instrumentNo, CTdRspQryInstrumentField& pInstrument);
   virtual int GetInstrumentInfo(int instrumentNo);

   ///根据合约编码获取合约序号
   //virtual int GetInstrumentNo(char* instrumentId, int &instrumentNo);
   virtual int GetInstrumentNo(char* instrumentId);

   ///查询手续费信息(期货、期权、现货手续费均可通过该接口查询)
   //virtual int GetRateList(TdRspQryRateFieldList& output);
   virtual int GetRateList();

   ///根据合约编码获取手续费信息(期货、期权、现货均可通过该接口查询)
   //virtual int GetRateInfo(char* clientId, char* instrumentId, CTdRspQryRateField& pRatet);
   virtual int GetRateInfo(char* clientId, char* instrumentId);

   ///根据合约序号获取手续费信息(期货、期权、现货均可通过该接口查询)
   //virtual int GetRateInfo(int clientNo, int instrumentNo, CTdRspQryRateField& pRate);
   virtual int GetRateInfo(int clientNo, int instrumentNo);

   ///查询期权保证金
   //virtual int GetOptMarginList(TdRspQryOptMarginFieldList& output);
   virtual int GetOptMarginList();

   ///根据合约编码获取期权保证金
   //virtual int GetOptMarginInfo(char* clientId, char* instrumentId, CTdRspQryOptMarginField& pMargin);
   virtual int GetOptMarginInfo(char* clientId, char* instrumentId);

   ///根据合约序号获取期权保证金
   //virtual int GetOptMarginInfo(int clientNo, int instrumentNo, CTdRspQryOptMarginField& pMargin);
   virtual int GetOptMarginInfo(int clientNo, int instrumentNo);

   ///查询期货保证金
   //virtual int GetFutMarginList(TdRspQryFutMarginFieldList& output);
   virtual int GetFutMarginList();

   ///根据合约编码获取期货保证金
   //virtual int GetFutMarginInfo(char* clientId, char* instrumentId, CTdRspQryFutMarginField& pMargin);
   virtual int GetFutMarginInfo(char* clientId, char* instrumentId);

   ///根据合约序号获取期货保证金
   //virtual int GetFutMarginInfo(int clientNo, int instrumentNo, CTdRspQryFutMarginField& pMargin);
   virtual int GetFutMarginInfo(int clientNo, int instrumentNo);

   ///从本地获取资金信息
   //virtual int GetAccount(char * accountId, CTdRspQryAccountField& pRspPartAccount);
   virtual int GetAccount(char * accountId);

   ///用户登录请求
   virtual int ReqUserLogin(CTdReqUserLoginField* pReqUserLogin, int nRequestID);

   ///用户退出请求
   virtual int ReqUserLogout(int nRequestID);

   ///用户密码修改请求
   virtual int ReqUserPasswordUpdate(CTdUserPasswordUpdateField* pUserPasswordUpdate, int nRequestID);

   ///股票报单请求
   virtual int ReqStockInsert(CTdStockInsertReqField* pStockInsert, int nRequestID);

   ///股票撤单请求
   virtual int ReqStockCancel(CTdOrderCancelReqField* pStockCancel, int nRequestID);

   ///股票非交易业务报单请求
   virtual int ReqBusinessInsert(CTdBusinessInsertReqField* pStockInsert, int nRequestID);

   ///股票非交易业务撤单请求
   virtual int ReqBusinessCancel(CTdOrderCancelReqField* pStockCancel, int nRequestID);

   ///证券锁定请求
   virtual int ReqStockLock(CTdStockLockReqField* pStockLock, int nRequestID);

   ///期权,期货报单请求
   virtual int ReqOptionsInsert(CTdOrderInsertReqField* pOptionsInsert, int nRequestID);

   ///期权,期货撤单请求
   virtual int ReqOptionsCancel(CTdOrderCancelReqField* pOptionsCancel, int nRequestID);

   ///期权,期货报价请求
   virtual int ReqQuoteInsert(CTdQuoteInsertReqField* pQuoteInsert, int nRequestID);

   ///期权,期货撤销报价请求
   virtual int ReqQuoteCancel(CTdOrderCancelReqField* pQuoteCancel, int nRequestID);

   ///询价请求
   virtual int ReqForQuote(CTdForQuoteReqField* pForQuote, int nRequestID);

   ///行权请求
   virtual int ReqExercise(CTdExerciseReqField* pExercise, int nRequestID);

   ///组合行权请求
   virtual int ReqCombExercise(CTdCombExerciseReqField* pExercise, int nRequestID);

   ///撤销行权请求
   virtual int ReqExerciseCancel(CTdOrderCancelReqField* pExerciseCancel, int nRequestID);

   ///客户申请组合请求
   virtual int ReqMarginCombAction(CTdMarginCombActionField* pMarginCombAction, int nRequestID);

   ///股票报单查询请求
   virtual int ReqQryStockOrder(CTdQryStockOrderField* pQryOrder, int nRequestID);

   ///股票非交易业务报单查询请求
   virtual int ReqQryBusinessOrder(CTdQryBusinessOrderField* pQryOrder, int nRequestID);

   ///期权,期货报单查询请求
   virtual int ReqQryOptionsOrder(CTdQryOptionsOrderField* pQryOrder, int nRequestID);

   ///报价查询请求
   virtual int ReqQryQuoteOrder(CTdQryQuoteOrderField* pQryQuote, int nRequestID);

   //行权查询请求
   virtual int ReqQryExercise(CTdQryExerciseField* pExercise, int nRequestID);

   //组合行权查询请求
   virtual int ReqQryCombExercise(CTdQryCombExerciseField* pExercise, int nRequestID);

   ///股票成交查询请求
   virtual int ReqQryStockTrade(CTdQryStockTradeField* pQryTrade, int nRequestID);

   ///期权,期货成交查询请求
   virtual int ReqQryOptionsTrade(CTdQryOptionsTradeField* pQryTrade, int nRequestID);

   ///股票持仓查询请求
   virtual int ReqQryStockPosition(CTdQryStockPositionField* pQryPosition, int nRequestID);

   ///期权,期货持仓查询请求
   virtual int ReqQryOptionsPosition(CTdQryOptionsPositionField* pQryPosition, int nRequestID);

   ///组合持仓查询请求
   virtual int ReqQryCombPosition(CTdQryCombPositionField* pQryPosi, int nRequestID);

   ///从服务端获取资金信息
   virtual int ReqQryAccount(CTdQryAccountField* pQryPartAccount, int nRequestID);

   ///查询合约状态
   //virtual int ReqQryInstrumentStatus(CTdQryInstrumentStatusField* QryInstrumentStatus, int nRequestID);

   ///查询行情
   virtual int ReqQryMarketData(CTdQryMarketDataField* pQryMarketData, int nRequestID);

   ///查询通知
   virtual int ReqQryNotify(CTdQryNotifyField* pQryNotify, int nRequestID);

   ///用户验证请求
   virtual int ReqUserAuthentication(CTdReqUserAuthenField* pReqUserAuthen, int nRequestID);
};

#endif
