#include "user.h"
#include "ccdeclare.h"

void CUser::Init()
{
	m_pTraderApi->CreateTiTdApi();
	m_pTraderApi->RegisterSpi(this);
	m_pTraderApi->Init("./config.ini");

	sem_wait(&m_Init_signal);
}

void CUser::GetApiVersion()
{
    char version[100] = {0};
	strcpy(version, CTiTdApi::GetApiVersion());
	Logs->Warn("api version: {}", version);
}

void CUser::GetClientList()
{
    TdRspQryClientList output;
    m_pTraderApi->GetClientList(output);

    for (auto it : output)
    {
        if (it.ExchangeId == m_exchangeID)
        {
           _clientno = it.ClientNo;
           strcpy(_clientid, it.ClientId) ;
        }
    }
};

void CUser::GetClientInfo_fromid()
{
    m_pTraderApi->GetClientInfo(_clientid);

#ifdef TEST_ERRORSTR
    //m_pTraderApi->GetClientInfo((char*)0);
    m_pTraderApi->GetClientInfo(TEST_ERRORSTR);
#endif
};

void CUser::GetClientInfo_fromno()
{
    m_pTraderApi->GetClientInfo(_clientno);

#ifdef TEST_ERRORSTR
    m_pTraderApi->GetClientInfo(0);
    m_pTraderApi->GetClientInfo(-100);
    m_pTraderApi->GetClientInfo(100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100);
    m_pTraderApi->GetClientInfo(2147483647);
    m_pTraderApi->GetClientInfo(4294967297);
#endif
};

void CUser::GetClientNo()
{
    m_pTraderApi->GetClientNo(_clientid);

#ifdef TEST_ERRORSTR
    m_pTraderApi->GetClientNo(TEST_ERRORSTR);
#endif
};

void CUser::GetFrontList()
{
    m_pTraderApi->GetFrontList();
};

void CUser::GetInstrumentList()
{
    m_pTraderApi->GetInstrumentList();
};

void CUser::GetInstrumentInfo_fromid()
{
    m_pTraderApi->GetInstrumentInfo(_instrumentid);

#ifdef TEST_ERRORSTR
    m_pTraderApi->GetInstrumentInfo(TEST_ERRORSTR);
#endif
}

void CUser::GetInstrumentInfo_fromno()
{
    m_pTraderApi->GetInstrumentInfo(_instrumentno);

#ifdef TEST_ERRORSTR
    m_pTraderApi->GetInstrumentInfo(0);
    m_pTraderApi->GetInstrumentInfo(-100);
    m_pTraderApi->GetInstrumentInfo(100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100);
    m_pTraderApi->GetInstrumentInfo(2147483647);
    //m_pTraderApi->GetInstrumentInfo(4294967297);
#endif
};

int CUser::GetInstrumentNo(char* instrumentId)
{
    int instrumentno;
    m_pTraderApi->m_pApi->GetInstrumentNo(instrumentId, instrumentno);
    return instrumentno;
}

void CUser::GetInstrumentNo()
{
    m_pTraderApi->GetInstrumentNo(_instrumentid);

#ifdef TEST_ERRORSTR
    m_pTraderApi->GetInstrumentNo(TEST_ERRORSTR);
#endif
};

void CUser::GetRateList()
{
    m_pTraderApi->GetRateList();
};

void CUser::GetRateInfo_fromid()
{
    m_pTraderApi->GetRateInfo(_clientid,_instrumentid);

#ifdef TEST_ERRORSTR
    m_pTraderApi->GetRateInfo(TEST_ERRORSTR, TEST_ERRORSTR);
#endif
};

void CUser::GetRateInfo_fromno()
{
    m_pTraderApi->GetRateInfo(_clientno,_instrumentno);

#ifdef TEST_ERRORSTR
    m_pTraderApi->GetRateInfo(0,0);
    m_pTraderApi->GetRateInfo(-100, 100);
    m_pTraderApi->GetRateInfo(100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100,
    100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100);
    m_pTraderApi->GetRateInfo(2147483647, 2147483647);
    m_pTraderApi->GetRateInfo(4294967297, 4294967297);
#endif
};

void CUser::GetOptMarginList()
{
    m_pTraderApi->GetOptMarginList();
};

void CUser::GetOptMarginInfo_fromid()
{
    m_pTraderApi->GetOptMarginInfo(_clientid, _instrumentid);

#ifdef TEST_ERRORSTR
    m_pTraderApi->GetOptMarginInfo(TEST_ERRORSTR, TEST_ERRORSTR);
#endif
};

void CUser::GetOptMarginInfo_fromno()
{
    m_pTraderApi->GetOptMarginInfo(_clientno, _instrumentno);

#ifdef TEST_ERRORSTR
    m_pTraderApi->GetOptMarginInfo(0,0);
    m_pTraderApi->GetOptMarginInfo(-100, 100);
    m_pTraderApi->GetOptMarginInfo(100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100,
    100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100);
    m_pTraderApi->GetOptMarginInfo(2147483647, 2147483647);
    m_pTraderApi->GetOptMarginInfo(4294967297, 4294967297);
#endif
};

void CUser::GetFutMarginList()
{
    m_pTraderApi->GetFutMarginList();
};

void CUser::GetFutMarginInfo_fromid()
{
    m_pTraderApi->GetFutMarginInfo(_clientid, _instrumentid);

#ifdef TEST_ERRORSTR
    m_pTraderApi->GetFutMarginInfo(TEST_ERRORSTR, TEST_ERRORSTR);
#endif
};

void CUser::GetFutMarginInfo_fromno()
{
    m_pTraderApi->GetFutMarginInfo(_clientno, _instrumentno);

#ifdef TEST_ERRORSTR
    m_pTraderApi->GetFutMarginInfo(0,0);
    m_pTraderApi->GetFutMarginInfo(-100, 100);
    m_pTraderApi->GetFutMarginInfo(100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100,
    100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100100);
    m_pTraderApi->GetFutMarginInfo(2147483647, 2147483647);
    m_pTraderApi->GetFutMarginInfo(4294967297, 4294967297);
#endif
};

void CUser::GetAccount()
{
    m_pTraderApi->GetAccount(m_AccoutID);

#ifdef TEST_ERRORSTR
    m_pTraderApi->GetAccount(TEST_ERRORSTR);
#endif
};

void CUser::ReqUserLogin()
{
    CTdReqUserLoginField req = {0};
	strcpy(req.UserId, m_UserID);			// 交易用户代码
	strcpy(req.Password,m_Password);		// 密码
	strcpy(req.ProtocolInfo,"");		    // 协议信息
	strcpy(req.UserProductInfo,"");		    // 用户端产品信息
	strcpy(req.AppId, m_AppID);// appid
	strcpy(req.AppIdIdentify, m_AuthCode); // appid验证码

    m_pTraderApi->ReqUserLogin(&req, _requestid++);

	sem_wait(&m_ReqUserLogin_signal);
};

void CUser::Auth()
{
	CTdReqUserAuthenField req;
	strcpy(req.UserId, "8810000018");          // 交易用户代码
	strcpy(req.Password, "123456");        // 密码
	m_pTraderApi->ReqUserAuthentication(&req, _requestid++);
}

void CUser::ReqUserLogout()
{
    m_pTraderApi->ReqUserLogout(_requestid++);
};

void CUser::ReqUserPasswordUpdate()
{
    CTdUserPasswordUpdateField req = {0};
    
#ifndef TEST_ERRORSTR
    std::cout << "请输入旧密码:" << std::endl;
    std::string _OldPassword;
    std::cin >> _OldPassword;
    strcpy(req.OldPassword, _OldPassword.c_str());
    
    std::cout << "请输入新密码:" << std::endl;
    std::string _NewPassword;
    std::cin >> _NewPassword;
    strcpy(req.NewPassword, _NewPassword.c_str());
#endif

#ifdef TEST_ERRORSTR
    strcpy(req.OldPassword,    TEST_ERRORSTR);
    strcpy(req.NewPassword,    TEST_ERRORSTR);
#endif

    m_pTraderApi->ReqUserPasswordUpdate(&req, _requestid++);
};

void CUser::ReqStockInsert()
{
    CTdStockInsertReqField req={0};
    req.ClientNo = _clientno;            //交易编码序号

    //////合约序号
    std::string _Instrument;
    std::cout << "输入合约(instrumentid):" << std::endl;
    std::cin >> _Instrument;
    req.InstrumentNo = GetInstrumentNo((char*)_Instrument.c_str());

    //////报单类型
	std::cout << std::endl;
    std::cout << "请输入报单类型: (回车报限价单,0退出报单)" << std::endl;
    switch (m_exchangeID)
    {
    case 1:
        //SSE - 股票
        std::cout << "1.限价单" << std::endl;
        std::cout << "11.最优5档即时成交剩余撤销" << std::endl;
        std::cout << "12.最优5档即时成交剩余转限价申报" << std::endl;
        std::cout << "13.本方最优价格申报" << std::endl;
        std::cout << "14.对手方最优价格申报" << std::endl;
        break;

    case 2:
        //SZSE - 股票
        std::cout << "1.限价单" << std::endl;
        std::cout << "2.对手方最优价格" << std::endl;
        std::cout << "3.本方最优价格" << std::endl;
        std::cout << "4.最优五档即时成交剩余撤销" << std::endl;
        std::cout << "5.市价单" << std::endl;
        std::cout << "6.全额成交或撤销" << std::endl;
        break;
    
    default:
        std::cout << "没有该交易所, 配置文件中的交易所id为:" << m_exchangeID << std::endl;
        break;
    }

    char inputstr[21];
    std::cin.getline(inputstr, 20);
    if (strcmp(inputstr, "") == 0)
    {
        strcpy(inputstr, "1");
    }
    switch(atoi(inputstr))
    {
        case 0: 
        {
            return;
        }
        case 1: //限价单
        {
            req.PriceType = TD_PriceType_Limit;
            req.TimeInForce = TD_TimeInForce_GFD;
            break;
        }
        case 2: //对手方最优(SZSE)
        {
            req.PriceType = TD_PriceType_Best4;
            req.TimeInForce = TD_TimeInForce_GFD;
            break;
        }
        case 3: //本方最优价格(SZSE)
        {
            req.PriceType = TD_PriceType_Best3;
            req.TimeInForce = TD_TimeInForce_GFD;
            break;
        }
        case 4: //最优五档即时成交剩余撤销(SZSE)
        {
            req.PriceType = TD_PriceType_Best1;
            req.TimeInForce = TD_TimeInForce_IOC;
            break;
        } 
        case 5: //市价单(SZSE)
        {
            req.PriceType = TD_PriceType_Market;
            req.TimeInForce = TD_TimeInForce_IOC;
            break;
        }
        case 6: //全额成交或撤销(SZSE)
        {
            req.PriceType = TD_PriceType_Market;
            req.TimeInForce = TD_TimeInForce_FOK;
            break;
        }
        case 11://最优5档即时成交剩余撤销(SSE)
        {
            req.PriceType = TD_PriceType_Best1;
            //req.TimeInForce = TD_TimeInForce_GFD;
            break;
        }
        case 12://最优5档即时成交剩余转限价申报(SSE)
        {
            req.PriceType = TD_PriceType_Best2;
            //req.TimeInForce = TD_TimeInForce_GFD;
            break;
        }
        case 13://本方最优价格申报(科创板产品)(SSE)
        {
            req.PriceType = TD_PriceType_Best3;
            //req.TimeInForce = TD_TimeInForce_GFD;
            break;
        }
        case 14://对手方最优价格申报(科创板产品)(SSE)
        {
            req.PriceType = TD_PriceType_Best4;
            //req.TimeInForce = TD_TimeInForce_GFD;
            break;
        }
    
        default:
        {
            std::cout << "无此选项" << std::endl;
            return;
        }
    }

    //////买卖方向
    std::cout << "请输入买卖方向(0退出报单):" << std::endl;
    std::cout << "1.买" << std::endl;
    std::cout << "2.卖" << std::endl;
    std::string _side_mode;
    req.Side = 0;
    std::cin >> _side_mode;
    switch(atoi(_side_mode.c_str()))
    {
        case 1:
        {
            req.Side = TD_SIDE_Buy;
            break;
        }
        case 2:
        {
            req.Side = TD_SIDE_Sell;
            break;
        }
        case 0:
        {
            return;
        }

        default:
        {
            std::cout << "无此选项" << std::endl;
            return;
        }
    }

    //////价格
    if (req.PriceType == TD_PriceType_Limit)
    {
        double price1, price2, price3; 
        GetInstPrice(req.InstrumentNo, price1, price2, price3);
        std::cout << _Instrument << " InstrumentNo:" << req.InstrumentNo << " lastprice:" << price1 << " upperLimitPrice" << price2 << " lowerLimitPrice" << price3 << std::endl;

        std::cout << "请输入报单价格: (回车输入最新价,0退出报单)" << std::endl;
        memset(&inputstr, 0, sizeof(inputstr));
        std::cin.getline(inputstr, 20);
        if (strcmp(inputstr, "0") == 0)
        {
            return;
        }
        else if (strcmp(inputstr, "") == 0)
        {
            req.Price = price1;
        }
        else
        {
            req.Price = atof(inputstr);
        }        
    }
    else
    {
        double price1, price2, price3; 
        GetInstPrice(req.InstrumentNo, price1, price2, price3);
        if(req.Side == TD_SIDE_Buy)
        {
            req.Price = price1*1.02;
        }
        else
        {
            req.Price = price1*0.98;
        }
    }

    //////数量
    std::cout << "请输入报单数量:" << std::endl;
    std::string _volume_mode;
    std::cin >> _volume_mode;
    req.Volume = atoi(_volume_mode.c_str());

    req.LocalOrderNo = ++_localno;               //会员内部订单编号
    req.OwnerType = TD_OWNER_Per;      //订单所有类型
    req.ExchangeId = (char)m_exchangeID;     //交易所代码
    req.FrontNo = 0;
    m_pTraderApi->ReqStockInsert(&req, _requestid++);
};

void CUser::ReqStockCancel()
{
    CTdOrderCancelReqField req = {0};
    GetCancelData(req);
    m_pTraderApi->ReqStockCancel(&req, _requestid++);
};

void CUser::ReqBusinessInsert()
{
    CTdBusinessInsertReqField req = {0};

    req.ClientNo = _clientno;                    //交易编码序号
    req.LocalOrderNo = ++_localno;            //会员内部订单编号
    req.ExchangeId = (char)m_exchangeID;          //交易所代码

    std::cout << std::endl;
    std::cout << "请输入业务类型: " << std::endl;
    std::cout << "1.上海发行" << std::endl;
    std::cout << "2.上海配股、科创板配售" << std::endl;
    std::cout << "3.上海配转债" << std::endl;
    std::cout << "4.上海要约预受" << std::endl;
    std::cout << "5.上海要约撤销" << std::endl;
    std::cout << "6.上海开放式基金申购" << std::endl;
    std::cout << "7.上海开放式基金赎回" << std::endl;
    std::cout << "8.上海开放式基金认购" << std::endl;
    std::cout << "9.上海开放式基金转托管 - 暂不支持" << std::endl;
    std::cout << "10.上海开放式基金分红设置 - 暂不支持" << std::endl;
    std::cout << "11.上海开放式基金转换 - 暂不支持" << std::endl;
    std::cout << "12.上海余券划转 - 暂不支持" << std::endl;
    std::cout << "13.上海还券划转 - 暂不支持" << std::endl;
    std::cout << "14.上海担保品划入 - 暂不支持" << std::endl;
    std::cout << "15.上海担保品划出 - 暂不支持" << std::endl;
    std::cout << "16.上海券源划入 - 暂不支持" << std::endl;
    std::cout << "17.上海券源划出 - 暂不支持" << std::endl;
    std::cout << "18.上海质押式回购(逆回购)" << std::endl;
    std::string _BusinessType_mode;
    std::cin >> _BusinessType_mode;
    req.BusinessType = (char)atoi(_BusinessType_mode.c_str());

    std::cout << "请输入合约序号(InstrumentID)" << std::endl;
    std::string InstrumentId;
    std::cin >> InstrumentId;
    strcpy(req.InstrumentId, InstrumentId.c_str());
   
    //9-17有目标合约
    if (req.BusinessType >= 9 && req.BusinessType <= 17)
    {
        std::cout << " 请输入目标合约:" << std::endl;
        std::cout << " 暂不支持该种类型, 已退出。" << std::endl;
        return;
        //TdInstrumentIdType  DestInstrumentId;         //目标合约代码
    }

    //////买卖方向
    //发行1、要约撤销5、开放式基金申购6、开放式基金认购8、开放式基金分红设置10、余券划转12、担保品划入14、券源划入16 填入1买
    //配股2、配转债3、要约预受4、开放式基金赎回7、开放式基金转托管9、开放式基金转换11、还券划转13、担保品划出15、券源划出17 填入2卖
    if (req.BusinessType == 1 ||
    req.BusinessType == 5 ||
    req.BusinessType == 6 ||
    req.BusinessType == 8 ||
    req.BusinessType == 10 ||
    req.BusinessType == 12 ||
    req.BusinessType == 14 ||
    req.BusinessType == 16)
    {
        req.Side = TD_SIDE_Buy;
    }
    else if (req.BusinessType == 2 ||
    req.BusinessType == 3 ||
    req.BusinessType == 4 ||
    req.BusinessType == 7 ||
    req.BusinessType == 9 ||
    req.BusinessType == 11 ||
    req.BusinessType == 13 ||
    req.BusinessType == 15 ||
    req.BusinessType == 17)
    {
        req.Side = TD_SIDE_Sell;
    }
    else //质押式回购(逆回购)
    {
        std::cout << "请输入买卖方向:" << std::endl;
        std::cout << "1.买(正回购方)" << std::endl;
        std::cout << "2.卖(卖逆回购方)" << std::endl;
        std::string _side_mode;
        req.Side = 0;
        std::cin >> _side_mode;
        switch(atoi(_side_mode.c_str()))
        {
            case 1:
            {
                req.Side = TD_SIDE_Buy;
                break;
            }
            case 2:
            {
                req.Side = TD_SIDE_Sell;
                break;
            }

            default:
            {
                std::cout << "无此选项" << std::endl;
                return;
            }
        }
    }

   //////价格
   std::cout << "请输入报单价格:" << std::endl;
   std::string _price;
   std::cin >> _price;
   req.Price = atof(_price.c_str());

   //////数量
   std::cout << "请输入报单数量(质押式回购数量单位为元):" << std::endl;
   std::string _volume_mode;
   std::cin >> _volume_mode;
   req.Volume = atoi(_volume_mode.c_str());

   m_pTraderApi->ReqBusinessInsert(&req, _requestid++);
};

void CUser::ReqBusinessCancel()
{
   CTdOrderCancelReqField req = {0};
   GetCancelData(req);
   m_pTraderApi->ReqBusinessCancel(&req, _requestid++);
};

void CUser::ReqStockLock()
{
	CTdStockLockReqField req = {0};
	req.ClientNo = _clientno;                 //交易编码序号

	std::cout << "请输入现货合约号:" << std::endl;
	std::string _InstrumentNo;                 //合约序号
	std::cin >> _InstrumentNo;
    req.InstrumentNo = atoi(_InstrumentNo.c_str());

    req.LocalOrderNo = ++_localno;             //会员内部订单编号
    
    std::cout << "锁定解锁选择: 1锁定 2解锁" << std::endl;
	std::string _locktype;
	std::cin >> _locktype;
    if (1 == atoi(_locktype.c_str()))
    {
        req.Locked = TD_LOCK_Lock;
    }
    else
    {
        req.Locked = TD_LOCK_UnLock;
    }       
    
    std::cout << "请输入锁定数量:" << std::endl;
    std::string _volume_mode;
    std::cin >> _volume_mode;
    req.Volume = atoi(_volume_mode.c_str());                   
    req.ExchangeId = m_exchangeID;
    ///处理本次报单的席位序号,当所填的序号在系统中不存在时系统会优选最佳席位进行报单,否则,根据用户所选席位进行报单
    req.FrontNo = 0;
	m_pTraderApi->ReqStockLock(&req, _requestid++);
};

void CUser::ReqOptionsInsert()
{
    CTdOrderInsertReqField req={0};
    req.ClientNo = _clientno;                      //交易编码序号

    //////合约序号
    std::string _Instrument;
    std::cout << "输入合约(instrumentid):" << std::endl;
    std::cin >> _Instrument;
    req.InstrumentNo = GetInstrumentNo((char*)_Instrument.c_str());

    //////报单类型
    char _order_mode[21];
	std::cout << std::endl;
	std::cout << "请输入报单类型: (回车报限价单,0退出报单)" << std::endl;
    switch (m_exchangeID)
    {
        case 1:
        //SSE - 期权
        std::cout << "1.限价单" << std::endl;
        std::cout << "8.市价剩余转限价" << std::endl;
        std::cout << "5.市价单" << std::endl;
        std::cout << "7.全额即时限价申报" << std::endl;
        std::cout << "6.全额即时市价申报" << std::endl;
        break;

        case 2:
        //SZSE - 期权
        std::cout << "1.限价单" << std::endl;
        std::cout << "2.对手方最优价格" << std::endl;
        std::cout << "3.本方最优价格" << std::endl;
        std::cout << "4.最优五档即时成交剩余撤销" << std::endl;
        std::cout << "5.市价单" << std::endl;
        std::cout << "6.全额成交或撤销" << std::endl;
        std::cout << "7.全额成交或撤销限价" << std::endl;
        break;

        case 3: //中金所
        std::cout << "1.限价GFD" <<std::endl;
        std::cout << "2.限价FOK" <<std::endl;
        std::cout << "3.限价FAK" <<std::endl;
        std::cout << "4.市价 - 最优一档剩余撤销" <<std::endl;
        std::cout << "5.市价 - 最优一档剩余转限价" <<std::endl;
        std::cout << "6.市价 - 最优五档剩余撤销" <<std::endl;
        std::cout << "7.市价 - 最优五档剩余转限价" <<std::endl;
        break;

    default:
        std::cout << "没有该交易所, 配置文件中的交易所id为:" << m_exchangeID << std::endl;
        break;
    }

    if (m_exchangeID==1 || m_exchangeID==2)
    {
        getchar();
        std::cin.getline(_order_mode, 20);
        if (strcmp(_order_mode, "") == 0)
        {
            strcpy(_order_mode, "1");
        }
        

        switch(atoi(_order_mode))
        {
            case 0: 
            {
                return;
            }
            case 1: //限价单
            {
                req.PriceType = TD_PriceType_Limit;
                req.TimeInForce = TD_TimeInForce_GFD;
                break;
            }
            case 2: //对手方最优(SZSE)
            {
                req.PriceType = TD_PriceType_Best4;
                req.TimeInForce = TD_TimeInForce_GFD;
                break;
            }
            case 3: //本方最优价格(SZSE)
            {
                req.PriceType = TD_PriceType_Best3;
                req.TimeInForce = TD_TimeInForce_GFD;
                break;
            }
            case 4: //最优五档即时成交剩余撤销(SZSE)
            {
                req.PriceType = TD_PriceType_Best1;
                req.TimeInForce = TD_TimeInForce_IOC;
                break;
            } 
            case 5: //市价单(SZSE\SSE)
            {
                req.PriceType = TD_PriceType_Market;
                req.TimeInForce = TD_TimeInForce_IOC;
                break;
            }
            case 6: //全额成交或撤销(SZSE\SSE)
            {
                req.PriceType = TD_PriceType_Market;
                req.TimeInForce = TD_TimeInForce_FOK;
                break;
            }
            case 7: //全额成交或撤销限价(SZSE\SSE)
            {
                req.PriceType = TD_PriceType_Limit;
                req.TimeInForce = TD_TimeInForce_FOK;
                break;
            }
            case 8://市价剩余转限价(SSE)
            {
                req.PriceType = TD_PriceType_Market2Limit;
                req.TimeInForce = TD_TimeInForce_GFD;
                break;
            }
        
            default:
            {
                std::cout << "无此选项" << std::endl;
                return;
            }
        }
    }

    else if (m_exchangeID == 3)
    {
        req.TrigCondition = TD_CC_Immediately;       //触发类型：立即 sse\szse 可不写
        req.StopPrice = 0;                        //止损价 dce、zce有交易所止盈止损单

        getchar();
        std::cin.getline(_order_mode, 20);
        if (strcmp(_order_mode, "") == 0)
        {
            strcpy(_order_mode, "1");
        }
    
        switch(atoi(_order_mode))
        {
            case 0:
            {
                return;
            }
            case 1: //限价单
            {
                req.PriceType = TD_PriceType_Limit;
                req.TimeInForce = TD_TimeInForce_GFD;

                req.VolumeCondition = TD_VC_AV;
                req.MinVolume = 0;
                break;
            }

            case 2: //限价FOK 全部成交否则撤销
            {
                req.PriceType = TD_PriceType_Limit;
                req.TimeInForce = TD_TimeInForce_IOC;

                req.VolumeCondition = TD_VC_CV;
                req.MinVolume = 0;
                break;
            }

            case 3://即时成交剩余撤销 可附加最小成交量
            {
                req.PriceType = TD_PriceType_Limit;
                req.TimeInForce = TD_TimeInForce_IOC;

                // 正常限价IOC
                // req.VolumeCondition = TD_VC_AV;     //任何数量
                // req.MinVolume = 0;

                // 附加最小成交量
                req.VolumeCondition = TD_VC_MV;     //最小数量
                req.MinVolume = 2;
                break;
            }

            case 4: //最优一档即时成交剩余撤销指令
            {
                req.PriceType = TD_PriceType_Best3;
                req.TimeInForce = TD_TimeInForce_IOC;

                req.VolumeCondition = TD_VC_AV;
                req.MinVolume = 0;
                break;
            }
        
            case 5: //最优一档即时成交剩余转限价指令
            {
                req.PriceType = TD_PriceType_Best3;
                req.TimeInForce = TD_TimeInForce_GFD;

                req.VolumeCondition = TD_VC_AV;
                req.MinVolume = 0;
                break;
            }

            case 6: //最优五档即时成交剩余撤销指令
            {
                req.PriceType = TD_PriceType_Best1;
                req.TimeInForce = TD_TimeInForce_IOC;

                req.VolumeCondition = TD_VC_AV;         
                req.MinVolume = 0;
                break;
            }
        
            case 7: //最优五档即时成交剩余转限价指令
            {
                req.PriceType = TD_PriceType_Best1;
                req.TimeInForce = TD_TimeInForce_GFD;

                req.VolumeCondition = TD_VC_AV;
                req.MinVolume = 0;
                break;
            }

            default:
            {
                std::cout << "无此选项" << std::endl;
                return;
            }
        }
    }
    
    else if (m_exchangeID == 4)
    {
        /* code */
    }

    else
    {
        
    }

    //////价格 
    if (req.PriceType == TD_PriceType_Limit)
    {
        double price1, price2, price3; 
        GetInstPrice(req.InstrumentNo, price1, price2, price3);
        std::cout << _Instrument << " InstrumentNo:" << req.InstrumentNo << " lastprice:" << price1 << " upperLimitPrice" << price2 << " lowerLimitPrice" << price3 << std::endl;

        std::cout << "请输入报单价格: (回车输入最新价,0退出报单)" << std::endl;
        char input[21];
        std::cin.getline(input, 20);
        if (strcmp(input, "0") == 0)
        {
            return;
        }
        else if (strcmp(input, "") == 0)
        {
            req.Price = price1;
        }
        else
        {
            req.Price = atof(input);
        }        
    }
    // else
    // {
    //     double price1, price2, price3; 
    //     GetInstPrice(req.InstrumentNo, price1, price2, price3);
    //     if(req.Side == TD_SIDE_Buy)
    //     {
    //         req.Price = price1*1.02;
    //     }
    //     else
    //     {
    //         req.Price = price1*0.98;
    //     }
    // }

    //////买卖方向
    std::cout << "请输入买卖方向(0退出报单):" << std::endl;
    std::cout << "1.买" << std::endl;
    std::cout << "2.卖" << std::endl;
    std::string _side_mode;
    req.Side = 0;
    std::cin >> _side_mode;
    switch(atoi(_side_mode.c_str()))
    {
        case 1:
        {
            req.Side = TD_SIDE_Buy;
            break;
        }
        case 2:
        {
            req.Side = TD_SIDE_Sell;
            break;
        }
        case 0:
        {
            return;
        }

        default:
        {
            std::cout << "无此选项" << std::endl;
            return;
        }
    }

    //////数量
    std::cout << "请输入报单数量:" << std::endl;
    std::string _volume_mode;
    std::cin >> _volume_mode;
    req.Volume = atoi(_volume_mode.c_str());

    //////开平方向
    std::cout << "请输入开平方向(0退出报单):" << std::endl;
    std::cout << "1.开仓" << std::endl;
    std::cout << "2.平仓" << std::endl;
    std::cout << "3.平今" << std::endl;
    std::string _OffsetFlag_mode;
    std::cin >> _OffsetFlag_mode;
    if (1==atoi(_OffsetFlag_mode.c_str()))
    {
        req.OffsetFlag = TD_OC_Open;
    }
    else if(2==atoi( _OffsetFlag_mode.c_str()))
    {
        req.OffsetFlag = TD_OC_Close;
    }
    else if(3==atoi( _OffsetFlag_mode.c_str()))
    {
        req.OffsetFlag = TD_OC_CloseToday;
    }
    else
    {
        return;
    }

    req.HedgeFlag = TD_HF_Speculation;              // 投机套保标记

    std::cout << "请输入备兑非备兑(0退出报单):" << std::endl;
    std::cout << "1.非备兑" << std::endl;
    std::cout << "2.备兑" << std::endl;
    std::string _Covered_mode;
    std::cin >> _Covered_mode;
    if (1==atoi(_Covered_mode.c_str()))
    {
    	req.CoveredOrUncovered = TD_Covered_Uncovered;
    }
    else if(2==atoi(_Covered_mode.c_str()))
    {
    	req.CoveredOrUncovered = TD_Covered_Covered;  //备兑标签
    }
    else
    {
        return;
    }
        
    req.LocalOrderNo = ++_localno;               //会员内部订单编号
    req.OwnerType = TD_OWNER_Per;      //订单所有类型
    req.ExchangeId = (char)m_exchangeID;     //交易所代码
    req.FrontNo = 0;
    m_pTraderApi->ReqOptionsInsert(&req, _requestid++);
};

void CUser::ReqOptionsCancel()
{
    CTdOrderCancelReqField req = {0};
    GetCancelData(req);
    m_pTraderApi->ReqOptionsCancel(&req, _requestid++);
};

void CUser::ReqQuoteInsert()
{
    CTdQuoteInsertReqField req={0};

    req.ClientNo = _clientno;                      //交易编码序号

    //////合约序号
    std::string _Instrument;
    std::cout << "输入合约(instrumentid):" << std::endl;
    std::cin >> _Instrument;
    req.InstrumentNo = GetInstrumentNo((char*)_Instrument.c_str());

    req.LocalOrderNo = ++_localno;               //会员内部订单编号
    //TdQuoteReqIDType      QuoteReqId;          //报价请求ID,预留字段,当报价是对请求的响应时，填写报价请求的ID

    //////数量
    std::cout << "请输入买数量:" << std::endl;
    std::string _volume_mode;
    std::cin >> _volume_mode;
    req.BidSize = atoi(_volume_mode.c_str());
    std::cout << "请输入卖数量:" << std::endl;
    _volume_mode="";
    std::cin >> _volume_mode;
    req.AskSize = atoi(_volume_mode.c_str());

    //////价格 
    std::cout << "请输入买价格:" << std::endl;
    std::string _price;
    std::cin >> _price;
    req.BidPx = atof(_price.c_str());
    std::cout << "请输入卖价格:" << std::endl;
    _price = "";
    std::cin >> _price;
    req.AskPx = atof(_price.c_str());

    //////开平方向
    std::cout << "请输入买开平方向:" << std::endl;
    std::cout << "1.开仓" << std::endl;
    std::cout << "2.平仓" << std::endl;
    std::string _OffsetFlag_mode;
    std::cin >> _OffsetFlag_mode;
    if (1==atoi(_OffsetFlag_mode.c_str()))
    {
        req.BidOffsetFlag = TD_OC_Open;
    }
    else
    {
        req.BidOffsetFlag = TD_OC_Close;
    }
    std::cout << "请输入卖开平方向:" << std::endl;
    std::cout << "1.开仓" << std::endl;
    std::cout << "2.平仓" << std::endl;
    _OffsetFlag_mode = "";
    std::cin >> _OffsetFlag_mode;
    if (1==atoi(_OffsetFlag_mode.c_str()))
    {
        req.AskOffsetFlag = TD_OC_Open;
    }
    else
    {
        req.AskOffsetFlag = TD_OC_Close;
    }
    
    req.OwnerType = TD_OWNER_Per;      //订单所有类型
    req.ExchangeId = (char)m_exchangeID;     //交易所代码
    req.FrontNo = 0;
    m_pTraderApi->ReqQuoteInsert(&req, _requestid++);
};

void CUser::ReqQuoteCancel()
{
    CTdOrderCancelReqField req = {0};
    GetCancelData(req);
    m_pTraderApi->ReqQuoteCancel(&req, _requestid++);
};

void CUser::ReqForQuote()
{

};

void CUser::ReqExercise()
{
    CTdExerciseReqField req = {0};

    req.ClientNo = _clientno;                   //交易编码序号
    req.LocalOrderNo = ++_localno;           //会员内部订单编号
    req.OwnerType = TD_OWNER_Per;                  //订单所有类型
    req.ExchangeId = (char)m_exchangeID;           //交易所代码

    std::cout << "请输入行权数量:" << std::endl;
    std::string _volume;
    std::cin >> _volume;
    req.Volume = atoi(_volume.c_str());
    
    std::cout << "请输入行权合约(instrumentid):" << std::endl;
    std::string _Instrument;
    std::cin >> _Instrument;
    req.InstrumentNo = GetInstrumentNo((char*)_Instrument.c_str());

    m_pTraderApi->ReqExercise(&req, _requestid++);
};

void CUser::ReqCombExercise()
{
    CTdCombExerciseReqField req = {0};

    req.ClientNo = _clientno;                   //交易编码序号
    req.LocalOrderNo = ++_localno;           //会员内部订单编号

    std::cout << "请输入组合行权数量:" << std::endl;
    std::string _volume;
    std::cin >> _volume;
    req.Volume = atoi(_volume.c_str());
    req.LegVolume1 = req.Volume;                 //腿1申报数量
    req.LegVolume2 = req.Volume;                 //腿2申报数量

    std::cout << "请输入组合行权合约1(instrumentid):" << std::endl;
    std::string _instrument1;
    std::cin >> _instrument1;
    req.LegInstrumentNo1 = GetInstrumentNo((char*)_instrument1.c_str());

    std::cout << "请输入组合行权合约2(instrumentid):" << std::endl;
    std::string _instrument2;
    std::cin >> _instrument2;
    req.LegInstrumentNo2 = GetInstrumentNo((char*)_instrument2.c_str());


    req.OwnerType = TD_OWNER_Per;                  //订单所有类型
    req.ExchangeId = (char)m_exchangeID;           //交易所代码

    m_pTraderApi->ReqCombExercise(&req, _requestid++);
};

void CUser::ReqExerciseCancel()
{
    CTdOrderCancelReqField req = {0};
    GetCancelData(req);
    m_pTraderApi->ReqExerciseCancel(&req, _requestid++);
};

void CUser::ReqMarginCombAction()
{
    CTdMarginCombActionField req = {0};

    req.ClientNo = _clientno;                 //交易编码序号
    req.LocalOrderNo = ++_localno;         //会员内部订单编号                          
    
    std::cout << "请输入组合方向:" << std::endl;
    std::cout << "1.组合 2.解组合" << std::endl;
    std::string _side_mode;
    std::cin >> _side_mode;
    switch(atoi(_side_mode.c_str()))
    {
        case 1:
        {
            req.Side = TD_Comb_Combed;
            break;
        }
        case 2:
        {
            req.Side = TD_Comb_UnCombed;
            break;
        }

        default:
        {
            std::cout << "无此选项" << std::endl;
            return;
        }
    }

    std::cout << "请输入组合策略:" << std::endl;
    std::cout << "1.CNSJC 2.PXSJC 3.PNSJC 4.CXSJC 5.KS 6.KKS 7.ZBD" << std::endl;
    std::string _CombId_mode;
    std::cin >> _CombId_mode;
    switch(atoi(_CombId_mode.c_str()))
    {
        case 1:
        {
            std::cout << "CNSJC认购牛市价差,头寸1:低价C,权利 头寸2:高价C,义务" << std::endl;
            strcpy(req.CombId, "CNSJC");
            req.item[0].LegSide = TD_LegSide_Long;
            req.item[1].LegSide = TD_LegSide_Short;
            req.item[0].CoveredOrUncovered = TD_Covered_Uncovered;  //TD_Covered_Uncovered
            req.item[1].CoveredOrUncovered = TD_Covered_Uncovered;  	//TD_Covered_Uncovered
            break;
        }
        case 2:
        {
            std::cout << "PXSJC认沽熊市价差,头寸1:高价P,权利 头寸2:低价P,义务" << std::endl;
            strcpy(req.CombId, "PXSJC");
            req.item[0].LegSide = TD_LegSide_Long;
            req.item[1].LegSide = TD_LegSide_Short;
            req.item[0].CoveredOrUncovered = TD_Covered_Uncovered;  //TD_Covered_Uncovered
            req.item[1].CoveredOrUncovered = TD_Covered_Uncovered;  //TD_Covered_Uncovered
            break;
        }
        case 3:
        {
            std::cout << "PNSJC认购熊市价差,头寸1:低价P,权利 头寸2:高价P,义务" << std::endl;
            strcpy(req.CombId, "PNSJC");
            req.item[0].LegSide = TD_LegSide_Long;
            req.item[1].LegSide = TD_LegSide_Short;
            req.item[0].CoveredOrUncovered = TD_Covered_Uncovered;  //TD_Covered_Uncovered
            req.item[1].CoveredOrUncovered = TD_Covered_Uncovered;  //TD_Covered_Uncovered
            break;
        }
        case 4:
        {
            std::cout << "CXSJC认购熊市价差,头寸1:高价C,权利 头寸2:低价C,义务" << std::endl;
            strcpy(req.CombId, "CXSJC");
            req.item[0].LegSide = TD_LegSide_Long;
            req.item[1].LegSide = TD_LegSide_Short;
            req.item[0].CoveredOrUncovered = TD_Covered_Uncovered;  //TD_Covered_Uncovered
            req.item[1].CoveredOrUncovered = TD_Covered_Uncovered;  //TD_Covered_Uncovered
            break;
        }
        case 5:
        {
            std::cout << "KS跨式空头,头寸1:同价C,义务 头寸2:同价P,义务" << std::endl;
            strcpy(req.CombId, "KS");
            req.item[0].LegSide = TD_LegSide_Short;
            req.item[1].LegSide = TD_LegSide_Short;
            req.item[0].CoveredOrUncovered = TD_Covered_Uncovered; 	//TD_Covered_Uncovered
            req.item[1].CoveredOrUncovered = TD_Covered_Uncovered;  //TD_Covered_Uncovered
            break;
        }
        case 6:
        {
            std::cout << "KKS宽跨式空头,头寸1:高价C,义务 头寸2:低价P,义务" << std::endl;
            strcpy(req.CombId, "KKS");
            req.item[0].LegSide = TD_LegSide_Short;
            req.item[1].LegSide = TD_LegSide_Short;
            req.item[0].CoveredOrUncovered = TD_Covered_Uncovered;  	//TD_Covered_Uncovered
            req.item[1].CoveredOrUncovered = TD_Covered_Uncovered;  //TD_Covered_Uncovered
            break;
        }
        case 7:
        {
            //std::cout << "TITD系统还暂不支持转备兑" << std::endl;
            strcpy(req.CombId, "ZBD");
            req.item[0].LegSide = TD_LegSide_Short;
            //req.item[1].LegSide = TD_LegSide_Short;
            req.item[0].CoveredOrUncovered = TD_Covered_Uncovered;  	//TD_Covered_Uncovered
            //req.item[1].CoveredOrUncovered = TD_Covered_Uncovered;  //TD_Covered_Uncovered
            break;
        }
        // case 8:
        // {
        //     //std::cout << "TITD系统还暂不支持转备兑" << std::endl;
        //     strcpy(req.CombId, "ZXJ");
        //     req.item[0].LegSide = TD_LegSide_Short;
        //     //req.item[1].LegSide = TD_LegSide_Short;
        //     req.item[0].CoveredOrUncovered = TD_Covered_Covered;  	//TD_Covered_Uncovered
        //     //req.item[1].CoveredOrUncovered = TD_Covered_Uncovered;  //TD_Covered_Uncovered
        //     break;
        // }

        default:
        {
            std::cout << "无此选项" << std::endl;
            return;
        }
    }

    std::cout << "请输入头寸1合约号(instrumentno):" << std::endl;
    std::string _instrument1;
    std::cin >> _instrument1;
    req.item[0].LegInstrumentNo = atoi(_instrument1.c_str());    //合约编码

    if( atoi(_CombId_mode.c_str())!=7 && atoi(_CombId_mode.c_str())!=8)
    {
        std::cout << "请输入头寸2合约号(instrumentno):" << std::endl;
        std::string _instrument2;
        std::cin >> _instrument2;
        req.item[1].LegInstrumentNo = atoi(_instrument2.c_str());    //合约编码
    }

    std::cout << "请输入组合解组合数量:" << std::endl;
    std::string _volume;
    std::cin >> _volume;
    req.Volume = atoi(_volume.c_str());
    req.item[0].LegVolume = req.Volume;             //申报数量
    req.item[1].LegVolume = req.Volume;             //申报数量

    if(req.Side == TD_Comb_UnCombed)
    {
        std::cout << "如拆分请输入组合编码:" << std::endl;
        std::string _CombInstId;
        std::cin >> _CombInstId;
        strcpy(req.CombInstId, _CombInstId.c_str());            //组合编码。组合申报时，该字段为空格；拆分申报时，填写拟拆分组合的组合编码
    }

    req.OwnerType = TD_OWNER_Per;                   //订单所有类型
    req.ExchangeId = (char)m_exchangeID;            //交易所代码
    
    req.NoLeges = 1;
    if( atoi(_CombId_mode.c_str())!=7 && atoi(_CombId_mode.c_str())!=8)
    {
        req.NoLeges = 2;                                //成分合约数，取值不超过4，后接重复组
    }
    
    m_pTraderApi->ReqMarginCombAction(&req, _requestid++);
};

void CUser::ReqQryStockOrder()
{
    CTdQryStockOrderField  req = {0};

#ifdef TEST_ERRORSTR
    strcpy(req.ClientId,      TEST_ERRORSTR); 
    strcpy(req.InstrumentId,  TEST_ERRORSTR);
    strcpy(req.OrderSysID,    TEST_ERRORSTR);
#endif

    m_pTraderApi->ReqQryStockOrder(&req, _requestid++);
};

void CUser::ReqQryBusinessOrder()
{
    CTdQryBusinessOrderField req = {0};

#ifdef TEST_ERRORSTR
    strcpy(req.ClientId,      TEST_ERRORSTR); 
    strcpy(req.InstrumentId,  TEST_ERRORSTR);
    strcpy(req.OrderSysID,    TEST_ERRORSTR);
#endif

    m_pTraderApi->ReqQryBusinessOrder(&req, _requestid++);
};

void CUser::ReqQryOptionsOrder()
{
    CTdQryOptionsOrderField req = {0};


#ifdef TEST_ERRORSTR
    strcpy(req.ClientId,      TEST_ERRORSTR); 
    strcpy(req.InstrumentId,  TEST_ERRORSTR);
    strcpy(req.OrderSysID,    TEST_ERRORSTR);
#endif

    m_pTraderApi->ReqQryOptionsOrder(&req, _requestid++);
};

void CUser::ReqQryQuoteOrder()
{
    CTdQryQuoteOrderField req = {0};
    //req.OrdStatus = TD_Status_Success;

#ifdef TEST_ERRORSTR
    strcpy(req.ClientId,      TEST_ERRORSTR);  
    strcpy(req.InstrumentId,  TEST_ERRORSTR);
    strcpy(req.OrderSysID,    TEST_ERRORSTR);
#endif

    m_pTraderApi->ReqQryQuoteOrder(&req, _requestid++);
};

void CUser::ReqQryExercise()
{
    CTdQryExerciseField req = {0};

#ifdef TEST_ERRORSTR
    strcpy(req.ClientId,      TEST_ERRORSTR);
    strcpy(req.InstrumentId,  TEST_ERRORSTR);
    strcpy(req.OrderSysID,    TEST_ERRORSTR);
#endif

    m_pTraderApi->ReqQryExercise(&req, _requestid++);
};

void CUser::ReqQryCombExercise()
{
    CTdQryCombExerciseField req = {0};

#ifdef TEST_ERRORSTR
    strcpy(req.ClientId,       TEST_ERRORSTR);
    strcpy(req.InstrumentId1,  TEST_ERRORSTR);
    strcpy(req.InstrumentId2,  TEST_ERRORSTR);
    strcpy(req.OrderSysID,     TEST_ERRORSTR);
#endif
    m_pTraderApi->ReqQryCombExercise(&req, _requestid++);
};

void CUser::ReqQryStockTrade()
{
    CTdQryStockTradeField req = {0};

#ifdef TEST_ERRORSTR
    strcpy(req.ClientId,      TEST_ERRORSTR);
    strcpy(req.InstrumentId,  TEST_ERRORSTR);
    strcpy(req.OrderSysID,    TEST_ERRORSTR);
    strcpy(req.TradeId,       TEST_ERRORSTR);
#endif

    m_pTraderApi->ReqQryStockTrade(&req, _requestid++);
};

void CUser::ReqQryOptionsTrade()
{
    CTdQryOptionsTradeField req = {0};

#ifdef TEST_ERRORSTR
    strcpy(req.ClientId,      TEST_ERRORSTR);
    strcpy(req.InstrumentId,  TEST_ERRORSTR);
    strcpy(req.OrderSysID,    TEST_ERRORSTR);
    strcpy(req.TradeId,       TEST_ERRORSTR);
#endif

    m_pTraderApi->ReqQryOptionsTrade(&req, _requestid++);
};

void CUser::ReqQryStockPosition()
{
    CTdQryStockPositionField req = {0};

    strcpy(req.ClientId, _clientid);                   /// <交易编码>   必填项:不填返回错误提醒
    // TdInstrumentIdType          InstrumentId;        /// [合约编码]   默认值:0 0或空格表示查询所有合约
#ifdef TEST_ERRORSTR
    strcpy(req.ClientId,  	  TEST_ERRORSTR);
    strcpy(req.InstrumentId,  TEST_ERRORSTR);
#endif

    m_pTraderApi->ReqQryStockPosition(&req, _requestid++);
};

void CUser::ReqQryOptionsPosition()
{
    CTdQryOptionsPositionField req = {0};

    strcpy(req.ClientId, _clientid);                  /// <交易编码>     必填项:不填返回错误提醒
    // TdInstrumentIdType    InstrumentId;             /// [合约编码]     默认值:0 0或空格表示查询所有合约
    // TdSideType            Side;                     /// [买卖方向]     默认值:0 0表示不限制买卖方向
    // TdCoveredOrUncoveredType CoveredOrUn;           /// [备兑标记]     默认值:0 0表示不限制备兑标记
#ifdef TEST_ERRORSTR
    strcpy(req.ClientId,  		TEST_ERRORSTR);
    strcpy(req.InstrumentId,    TEST_ERRORSTR);
#endif

    m_pTraderApi->ReqQryOptionsPosition(&req, _requestid++);
};

void CUser::ReqQryCombPosition()
{
    CTdQryCombPositionField req = {0};

    strcpy(req.ClientId, _clientid);                  /// <交易编码>   必填项:不填返回错误提醒
    // TdCombIDType            CombID;                 /// [组合类型]   默认值:0 0或空格表示查询所有组合类型, 目前为7种组合策略：CNSJC、PXSJC、PNSJC、CXSJC、KS、KKS、ZBD
    // TdOrderSysIDType        CombInstId;             /// [组合编码]   默认值:0 0或空格表示查询所有组合持仓
#ifdef TEST_ERRORSTR
    strcpy(req.ClientId,  TEST_ERRORSTR);
    strcpy(req.CombID,    TEST_ERRORSTR);
    strcpy(req.CombInstId,    TEST_ERRORSTR);
#endif

    m_pTraderApi->ReqQryCombPosition(&req, _requestid++);
};

void CUser::ReqQryAccount()
{
    CTdQryAccountField req = {0};

    strcpy(req.AccountId, m_AccoutID);                  /// <资金帐号>   必填项:不填返回错误提醒
#ifdef TEST_ERRORSTR
    strcpy(req.AccountId,  TEST_ERRORSTR);
#endif

    m_pTraderApi->ReqQryAccount(&req, _requestid++);
};

void CUser::ReqQryMarketData()
{
    CTdQryMarketDataField req = {0};

#ifndef TEST_ERRORSTR                                            //{合约No}、{合约代码}任选其一，两者都填，以合约No为准
    req.InstrumentNo = _instrumentno;         //{合约No}
    // TdInstrumentIdType    InstrumentId;         //{合约代码}
#endif

#ifdef TEST_ERRORSTR
    strcpy(req.InstrumentId,  TEST_ERRORSTR);
#endif
    m_pTraderApi->ReqQryMarketData(&req, _requestid++);
};

void CUser::ReqQryNotify()
{
    CTdQryNotifyField req = {0};
    m_pTraderApi->ReqQryNotify(&req, _requestid++);
};

void CUser::OnConnected()
{
    CSubTiTdSpi::OnConnected();
    sem_post(&m_Init_signal);
}

void CUser::OnDisconnected(int nReason)
{
    CSubTiTdSpi::OnDisconnected(nReason);

    m_loginflag = false;
    _sessionid = 0;
}


///用户登录应答
void CUser::OnRspUserLogin(CTdRspUserLoginField& pRspUserLogin, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    CSubTiTdSpi::OnRspUserLogin(pRspUserLogin, pRspInfo, nRequestID, bIsLast);

	if(pRspInfo.ErrorId != 0)
	{
		m_loginflag = false;
	}
	else
	{
		m_loginflag = true;

        // 获取客户信息
        GetClientList();

        // 记录本次sessionid
        _sessionid = pRspUserLogin.SessionNo;
	}

    if (bIsLast)
	{
		sem_post(&m_ReqUserLogin_signal);
	}
}


// ///用户退出应答
// void CUser::OnRspUserLogout(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

// ///用户密码修改应答
// void CUser::OnRspUserPasswordUpdate(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

// ///股票报单应答
// void CUser::OnRspStockInsert(CTdStockInsertRspField& pStockInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

// ///股票撤单应答
// void CUser::OnRspStockCancel(CTdOrderCancelRspField& pStockCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

// ///证券锁定应答
// void CUser::OnRspStockLock(CTdStockLockRspField& pStockLock, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

// ///期权,期货报单应答
// void CUser::OnRspOptionsInsert(CTdOrderInsertRspField& pOptionsInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

// ///期权,期货撤单应答
// void CUser::OnRspOptionsCancel(CTdOrderCancelRspField& pOptionsCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

// ///期权,期货报价应答
// void CUser::OnRspQuoteInsert(CTdQuoteInsertRspField& pQuoteInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) 
// {
//     CSubTiTdSpi::
// }

// ///期权,期货撤销报价应答
// void CUser::OnRspQuoteCancel(CTdOrderCancelRspField& pQuoteCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) 
// {
//     CSubTiTdSpi::
// }

// ///询价应答
// void CUser::OnRspForQuote(CTdForQuoteRspField& pForQuote, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) 
// {
//     CSubTiTdSpi::
// }

// ///行权应答
// void CUser::OnRspExercise(CTdExerciseRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

// ///组合行权应答
// void CUser::OnRspCombExercise(CTdCombExerciseRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

// ///撤销行权应答
// void CUser::OnRspExerciseCancel(CTdOrderCancelRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

// ///客户申请组合应答
// void CUser::OnRspMarginCombAction(CTdMarginCombActionRspField& pMarginCombAction, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

///股票报单查询应答
void CUser::OnRspQryStockOrder(CTdRspQryStockOrderField& pOrder, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    // if (_qrystkOrderfinish == 0)
    {
        CSubTiTdSpi::OnRspQryStockOrder(pOrder, pRspInfo, nRequestID, bIsLast);
    }
    
    if(!bIsLast)
    {
        _stkOrderList.push_back(pOrder);
    }
    else
    {
        _qrystkOrderfinish = 2;
    }
}

///期权,期货报单查询应答
void CUser::OnRspQryOptionsOrder(CTdRspQryOptionsOrderField& pOrder, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    // if(_qryoptOrderfinish == 0)
    {
        CSubTiTdSpi::OnRspQryOptionsOrder(pOrder, pRspInfo, nRequestID, bIsLast);
    }
    
    if(!bIsLast)
    {
        _optOrderList.push_back(pOrder);
    }
    else
    {
        _qryoptOrderfinish = 2;
    }
}

// ///报价查询应答
// void CUser::OnRspQryQuoteOrder(CTdRspQryQuoteOrderField& pQuote, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

// ///查询行权应答
// void CUser::OnRspQryExercise(CTdRspQryExerciseField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

// ///查询组合行权应答
// void CUser::OnRspQryCombExercise(CTdRspQryCombExerciseField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

// ///股票成交查询应答
// void CUser::OnRspQryStockTrade(CTdRspQryStockTradeField& pTrade, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

// ///期权,期货成交查询应答
// void CUser::OnRspQryOptionsTrade(CTdRspQryOptionsTradeField& pTrade, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

// ///股票持仓查询应答
// void CUser::OnRspQryStcokPosition(CTdRspQryStockPositionField& pPosition, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

// ///期权,期货持仓查询应答
// void CUser::OnRspQryOptionsPosition(CTdRspQryOptionsPositionField& pPosition, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

// ///组合持仓查询应答
// void CUser::OnRspQryCombPosition(CTdRspQryCombPositionField& pPosi, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

///从服务端获取资金应答
void CUser::OnRspQryAccount(CTdRspQryAccountField& pAccount, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    CSubTiTdSpi::OnRspQryAccount(pAccount, pRspInfo, nRequestID, bIsLast);

    //现货资金核对begin
    if ( (m_exchangeID == 1 || m_exchangeID ==2)
    && _testsvrtype == 1)
    {
        Logs->Info("资金核对：");
        double calbalance = 	  pAccount.DistribFund
        - pAccount.Commi
        + pAccount.Premium
        + pAccount.Deposit
        - pAccount.Withdraw
        - pAccount.FrozenMargin
        - pAccount.FrozenCommi;

        Logs->Info("可用资金 balance 计算值:{} 交易服务给出值:{} = ",
        calbalance,
        pAccount.Balance);																						//可用资金 =
        Logs->Info("		  + 本系统分配资金 DistribFund {} ", pAccount.DistribFund); 						 // +本系统分配资金 
        Logs->Info("		  - 手续费 Commi {}", pAccount.Commi); 												// -手续费
        Logs->Info("		  + 资金收支 Premium  {} ", pAccount.Premium); 										// -股票现货买入、卖出资金
        Logs->Info("		  + 入金 Deposit  {} ", pAccount.Deposit); 										    // +入金
        Logs->Info("		  - 出金 Withdraw  {} ", pAccount.Withdraw); 										// -出金
        Logs->Info("		  - 冻结保证金(含非交易业务 - 逆回购冻结资金) FrozenMargin  {} ", pAccount.FrozenMargin); // -冻结保证金（非交易业务 - 逆回购冻结资金） 
        Logs->Info("		  - 冻结手续费(含非交易业务 - 逆回购冻结手续费) FrozenCommi  {}", pAccount.FrozenCommi);  // - 冻结手续费(非交易业务 - 逆回购冻结手续费)

        // Logs->Info("其他："); 					// +浮动亏损（现货系统无）
        // Logs->Info("浮动盈亏 PosiProfit  {}  ", fmin(pAccount.PosiProfit, 0.0)); 					// +浮动亏损（现货系统无）
        // Logs->Info("平仓盈亏 CloseProfit  {}  ", fmin(pAccount.CloseProfit, 0.0)); 					// +平仓亏损（现货系统无）
        double qy = pAccount.Balance + pAccount.PosiProfit + pAccount.FrozenMargin + pAccount.FrozenCommi;
        Logs->Info("资金核对：");
        Logs->Info("权益 {} = ", qy);
        Logs->Info(" + 可用资金 balance {}", pAccount.Balance);
        Logs->Info(" + 浮动盈亏 PosiProfit {}", pAccount.PosiProfit);
        Logs->Info(" + 冻结保证金 FrozenMargin {}", pAccount.FrozenMargin);
        Logs->Info(" + 冻结手续费 FrozenCommi {}", pAccount.FrozenCommi);
        Logs->Info(" + 持仓占用的资金(需要查询持仓计算持仓占用(未计算))", pAccount.FrozenCommi);

        //现货资金核对end
    }
    
    // // opt 股票期权系统资金核对
    // else if ( (m_exchangeID == 1 || m_exchangeID ==2)
    // && _testsvrtype == 2)
    // {
    //     /* code */
    // }
    // // fut 期货系统资金核对
    // else if(m_exchangeID > 2 && _testsvrtype == 2)
    else
    {
        Logs->Info("资金核对：");
        double calbalance = 	  pAccount.DistribFund
        - pAccount.Commi
        + pAccount.Premium
        + fmin(pAccount.PosiProfit, 0.0)
        + pAccount.Deposit
        - pAccount.Withdraw
        - pAccount.FrozenMargin
        - pAccount.FrozenCommi
        - pAccount.FrozenPremium
        - pAccount.FutMargin
        - pAccount.OptMargin
        + pAccount.CombMargin
        + pAccount.CloseProfit
        - pAccount.EntryFees;

        Logs->Info("可用资金 balance 计算值:{} 交易服务给出值:{} = ",
        calbalance,
        pAccount.Balance);																						//可用资金 =
        Logs->Info("		  + 本系统分配资金 DistribFund {} ", pAccount.DistribFund); 						 // +本系统分配资金 
        Logs->Info("		  - 手续费 Commi {}", pAccount.Commi); 												// -手续费
        Logs->Info("		  + 资金收支 Premium  {} ", pAccount.Premium); 										// -买入资金
        Logs->Info("		  + 浮动亏损 fmin(pAccount.PosiProfit, 0.0)  {}  ", fmin(pAccount.PosiProfit, 0.0));// +浮动亏损   (股票期权可用资金的计算就少了浮动亏损)
        Logs->Info("		  + 入金 Deposit  {} ", pAccount.Deposit); 										    // +入金
        Logs->Info("		  - 出金 Withdraw  {} ", pAccount.Withdraw); 										// -出金
        Logs->Info("		  - 冻结保证金 FrozenMargin  {} ", pAccount.FrozenMargin);                          // -冻结保证金
        Logs->Info("		  - 冻结手续费 FrozenCommi  {}", pAccount.FrozenCommi);                             // - 冻结手续费
        Logs->Info("		  - 期货保证金 FrozenMargin  {} ", pAccount.FutMargin);                             // -冻结保证金
        Logs->Info("		  - 期权保证金 FrozenCommi  {}", pAccount.OptMargin);                               // - 冻结手续费
        Logs->Info("		  + 保证金优惠 CombMargin  {}", pAccount.CombMargin);                               // + 保证金优惠
        Logs->Info("		  + 平仓盈亏 CloseProfit  {}", pAccount.CloseProfit);                               // + 平仓盈亏
        Logs->Info("		  - 当日申报费用 EntryFees  {}", pAccount.EntryFees);                               // - 当日申报费用

        //期货系统中
        //期货保证金：保证金不变动，有持仓盈亏。保证金计算历史仓按昨结算保证金、今仓按开仓价算保证金
        //期权保证金：保证金变动（也有单位设置的都取昨结价，就保证金不变动），无持仓盈亏。
    }
}

///行情查询应答
void CUser::OnRspQryMarketData(CTdRspQryMarketDataField& pMarketData, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
{
    
    CSubTiTdSpi::OnRspQryMarketData(pMarketData, pRspInfo, nRequestID, bIsLast);
    
    if(!bIsLast)
    {
        _marketdata = pMarketData;
        _mdfinish = 1;
    }
}

// ///通知查询应答
// void CUser::OnRspQryNotify(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast)
// {
//     CSubTiTdSpi::
// }

// ///期权,期货委托回报
// void CUser::OnRtnOptionsOrder(CTdOptionsOrderRtnField& pOrder)
// {
    
// }

// ///股票委托回报
// void CUser::OnRtnStockOrder(CTdStockOrderRtnField& pOrder)
// {
    
// }

// ///报价回报
// void CUser::OnRtnQuoteOrder(CTdQuoteOrderRtnField& pQuote)
// {
    
// }

// ///期权,期货成交回报
// void CUser::OnRtnOptionsTrade(CTdOptionsTradeRtnField& pTrade)
// {
    
// }

// ///股票成交回报
// void CUser::OnRtnStockTrade(CTdStockTradeRtnField& pTrade)
// {
    
// }

// ///股票非交易业务成交回报
// void CUser::OnRtnBusinessTrade(CTdBusinessTradeRtnField& pTrade) 
// {
    
// }

// ///行权回报
// void CUser::OnRtnExercise(CTdExerciseRtnField& pExercise) 
// {
    
// }

// ///出入金通知
// void CUser::OnRtnWithdrawDeposit(CTdWithdrawDepositRtnField& pWithdrawDeposit) 
// {
    
// }

// ///客户申请组合通知
// void CUser::OnRtnMarginCombAction(CTdMarginCombActionRtnField& pMarginCombAction) 
// {
    
// }

// ///询价通知
// void CUser::OnRtnForQuote(CTdForQuoteRtnField& pForQuote)
// {
    
// }

// ///合约状态变化通知
// void CUser::OnRtnInstrumentStatus(CTdInstrumentStatusRtnField& pStatus)
// {
    
// }

void CUser::ReqQryStockOrder_zt()
{
    CTdQryStockOrderField req = {0};
    strcpy(req.ClientId, _clientid);
    req.OrdStatus = TD_Status_Success;
    m_pTraderApi->ReqQryStockOrder(&req, _requestid++);

    strcpy(req.ClientId, _clientid);
    req.OrdStatus = TD_Status_Trade;
    m_pTraderApi->ReqQryStockOrder(&req, _requestid++);
}

void CUser::ReqQryOptionsOrder_zt()
{
    CTdQryOptionsOrderField req = {0};
    strcpy(req.ClientId, _clientid);
    req.OrdStatus = TD_Status_Success;
    m_pTraderApi->ReqQryOptionsOrder(&req, _requestid++);

    strcpy(req.ClientId, _clientid);
    req.OrdStatus = TD_Status_Trade;
    m_pTraderApi->ReqQryOptionsOrder(&req, _requestid++);
}

void CUser::ReqQryQuoteOrder_zt()
{
    CTdQryQuoteOrderField req = {0};
    strcpy(req.ClientId, _clientid);
    req.BidStatus = TD_Status_Success;
    m_pTraderApi->ReqQryQuoteOrder(&req, _requestid++);

    strcpy(req.ClientId, _clientid);
    req.AskStatus = TD_Status_Success;
    m_pTraderApi->ReqQryQuoteOrder(&req, _requestid++);

    strcpy(req.ClientId, _clientid);
    req.BidStatus = TD_Status_Trade;
    m_pTraderApi->ReqQryQuoteOrder(&req, _requestid++);

    strcpy(req.ClientId, _clientid);
    req.AskStatus = TD_Status_Trade;
    m_pTraderApi->ReqQryQuoteOrder(&req, _requestid++);
}

void CUser::ReqQryBusinessOrder_zt()
{
    CTdQryBusinessOrderField req = {0};
    strcpy(req.ClientId, _clientid);
    req.OrdStatus = TD_Status_Success;
    m_pTraderApi->ReqQryBusinessOrder(&req, _requestid++);

    strcpy(req.ClientId, _clientid);
    req.OrdStatus = TD_Status_Trade;
    m_pTraderApi->ReqQryBusinessOrder(&req, _requestid++);
}
