#ifndef _USER_H
#define _USER_H

#include "subtitdspi.h"
#include "titdapi_req.h"
#include <iostream>
#include <unistd.h>
#include <semaphore.h>
#include "getconfig.h"

//#define TEST_ERROR
//#define TEST_ERRORSTR "\0gg%dhd%t%rhdgd%chg%\0%dcdc"
//#define TEST_ERRORSTR "\%\d23hd%t%rhdgd%chg%\0%dcdc"
//#define TEST_ERRORSTR "%d03756"
//#define TEST_ERRORSTR "ghsdgshggggggggggggggggggggggggggggg%dhd%t%rhdgd%chg%\0%dcdc"
//#define TEST_ERRORSTR   "\0\0%ddgggghd%t%rhdcghsdgshdgd%chg%\0%dcdcghsdgshggggggggggggggggggggggggggggg%dhd%t%rhdgd%chg%\0%dcdc"

class CUser : public CSubTiTdSpi
{
public:
	CUser()
	{
		sem_init(&m_Init_signal, 0, 0);
		sem_init(&m_ReqUserLogin_signal, 0, 0);
		sem_init(&m_ReqQryMarketData_signal, 0, 0);

		m_loginflag = false;

		_requestid = 0;
		_localno   = 0;
		_testsvrtype = 0;

		_qryoptOrderfinish = 0;
		_qrystkOrderfinish = 0;

		memset(&_clientid, 0, sizeof(_clientid));
		_clientno = 0;
		memset(&_instrumentid, 0, sizeof(_instrumentid));
		_instrumentno = 0;

		strncpy(m_UserID, getConfig("config", "UserID").c_str(), sizeof(m_UserID));
		strncpy(m_Password, getConfig("config", "Password").c_str(), sizeof(m_Password));
		strncpy(m_AccoutID, getConfig("config", "AccoutID").c_str(), sizeof(m_AccoutID));
		strncpy(m_AppID, getConfig("config", "AppID").c_str(), sizeof(m_AppID));
		strncpy(m_AuthCode, getConfig("config", "AuthCode").c_str(), sizeof(m_AuthCode));
		m_exchangeID = atoi(getConfig("config", "exchangeID").c_str());

		_sessionid = 0;
		memset(&_marketdata, 0, sizeof(_marketdata));
		// _mdfinish = 0;

		m_pTraderApi = new CTiTdApiReq;
	};
	~CUser() {};

public:
	int  _testsvrtype;							//1 stk 2opt\fut

	bool m_loginflag;

	int _requestid;
	int _localno;
	CTiTdApiReq*  m_pTraderApi;

													//记录
	int							_sessionid;
	CTdRspQryMarketDataField 	_marketdata;
	volatile int 				_mdfinish;
	std::list<CTdRspQryOptionsOrderField> _optOrderList;
	std::list<CTdRspQryStockOrderField>   _stkOrderList;
	int _qryoptOrderfinish;
	int _qrystkOrderfinish;
													//获取
	TdClientIdType 			_clientid;
	TdClientNoType 			_clientno;
	TdInstrumentIdType		_instrumentid;
	TdInstrumentNoType  	_instrumentno;
						
												    //配置
	TdUserIDType			m_UserID;
	TdPasswordType			m_Password;
	TdAccountIDType			m_AccoutID;
	TdAppIdType				m_AppID;
	TdAppIdIdentifyType 	m_AuthCode;
	int m_exchangeID;

public:
	void Init();
	void GetApiVersion();
   
    void GetClientList();
    void GetClientInfo_fromid();
    void GetClientInfo_fromno();
    void GetClientNo();
	void GetFrontList();
	void GetInstrumentList();
	void GetInstrumentInfo_fromid();
	void GetInstrumentInfo_fromno();
	void GetInstrumentNo();
	int  GetInstrumentNo(char* instrumentId);
	void GetRateList();
	void GetRateInfo_fromid();
	void GetRateInfo_fromno();
	void GetOptMarginList();
	void GetOptMarginInfo_fromid();
	void GetOptMarginInfo_fromno();
	void GetFutMarginList();
	void GetFutMarginInfo_fromid();
	void GetFutMarginInfo_fromno();
	void GetAccount();

	void ReqUserLogin();
	void ReqUserLogout();
	void ReqUserPasswordUpdate();

	void ReqStockInsert();
	void ReqStockCancel();
	void ReqBusinessInsert();
	void ReqBusinessCancel();
	void ReqStockLock();
	void ReqOptionsInsert();
	void ReqOptionsCancel();
	void ReqQuoteInsert();
	void ReqQuoteCancel();
	void ReqForQuote();
	void ReqExercise();
	void ReqCombExercise();
	void ReqExerciseCancel();
	void ReqMarginCombAction();

	void ReqQryStockOrder();
	void ReqQryBusinessOrder();
	void ReqQryOptionsOrder();
	void ReqQryQuoteOrder();
	void ReqQryExercise();
	void ReqQryCombExercise();
	void ReqQryStockTrade();
	void ReqQryOptionsTrade();
	void ReqQryStockPosition();
	void ReqQryOptionsPosition();
	void ReqQryCombPosition();
	void ReqQryAccount();
	void ReqQryMarketData();
	void ReqQryNotify();

	void ReqQryStockOrder_zt();
	void ReqQryOptionsOrder_zt();
	void ReqQryQuoteOrder_zt();
	void ReqQryBusinessOrder_zt();

	//其他
	void ReqCombPrepare();		//组合、解组合合约准备

	void Release();

	void Auth();
	//////
	///程序化下单测试相关函数
public:
	void ReqProgOrder1();
	void ReqProgOrder2();
	void ReqProgOrder3();
	void ReqProgOrder4();
	void ReqProgOrder5();
	void ReqProgOrder6();

	void GetInstAndCount(int& instno, int& count);
	void GetInstPrice(int instno, double& lastprice, double& uplimitPrice, double& lowLimitPrice);

public:
	void GetCancelData(CTdOrderCancelReqField& req); //获取撤单数据
	void ReqOptionsInsert_Market(int instrumentNo, char Side, char OffsetFlag, int volume);//市价下单
	void ReqOptionsInsert_Limit(int instrumentNo, char Side, char OffsetFlag, int volume, double price, int& localno); //限价下单
	void ReqStockInsert_Market(int instrumentNo, char Side, int volume, double price);//市价下单
	void ReqStockInsert_Limit(int instrumentNo, char Side, int volume, double price, int& localno); //限价下单
	void ReqCancleWithLocalNo(int localno); //用local撤本次报单
	void ReqCancleWithOrderSysid(char* ordersysid);//用ordersysid撤单
	void ReqCancleAll(); //撤销所有报单

public:
	void OnConnected();
	void OnDisconnected(int nReason);
	void OnRspUserLogin(CTdRspUserLoginField& pRspUserLogin, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspUserLogout(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspUserPasswordUpdate(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspStockInsert(CTdStockInsertRspField& pStockInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspStockCancel(CTdOrderCancelRspField& pStockCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspStockLock(CTdStockLockRspField& pStockLock, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspOptionsInsert(CTdOrderInsertRspField& pOptionsInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspOptionsCancel(CTdOrderCancelRspField& pOptionsCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspQuoteInsert(CTdQuoteInsertRspField& pQuoteInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) ;
	// void OnRspQuoteCancel(CTdOrderCancelRspField& pQuoteCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) ;
	// void OnRspForQuote(CTdForQuoteRspField& pForQuote, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) ;
	// void OnRspExercise(CTdExerciseRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspCombExercise(CTdCombExerciseRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspExerciseCancel(CTdOrderCancelRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspMarginCombAction(CTdMarginCombActionRspField& pMarginCombAction, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	void OnRspQryStockOrder(CTdRspQryStockOrderField& pOrder, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	void OnRspQryOptionsOrder(CTdRspQryOptionsOrderField& pOrder, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspQryQuoteOrder(CTdRspQryQuoteOrderField& pQuote, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspQryExercise(CTdRspQryExerciseField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspQryCombExercise(CTdRspQryCombExerciseField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspQryStockTrade(CTdRspQryStockTradeField& pTrade, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspQryOptionsTrade(CTdRspQryOptionsTradeField& pTrade, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspQryStcokPosition(CTdRspQryStockPositionField& pPosition, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspQryOptionsPosition(CTdRspQryOptionsPositionField& pPosition, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspQryCombPosition(CTdRspQryCombPositionField& pPosi, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	void OnRspQryAccount(CTdRspQryAccountField& pAccount, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	void OnRspQryMarketData(CTdRspQryMarketDataField& pMarketData, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRspQryNotify(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast);
	// void OnRtnOptionsOrder(CTdOptionsOrderRtnField& pOrder);
	// void OnRtnStockOrder(CTdStockOrderRtnField& pOrder);
	// void OnRtnQuoteOrder(CTdQuoteOrderRtnField& pQuote);
	// void OnRtnOptionsTrade(CTdOptionsTradeRtnField& pTrade);
	// void OnRtnStockTrade(CTdStockTradeRtnField& pTrade);
	// void OnRtnBusinessTrade(CTdBusinessTradeRtnField& pTrade) ;
	// void OnRtnExercise(CTdExerciseRtnField& pExercise) ;
	// void OnRtnWithdrawDeposit(CTdWithdrawDepositRtnField& pWithdrawDeposit) ;
	// void OnRtnMarginCombAction(CTdMarginCombActionRtnField& pMarginCombAction) ;
	// void OnRtnForQuote(CTdForQuoteRtnField& pForQuote);
	// void OnRtnInstrumentStatus(CTdInstrumentStatusRtnField& pStatus);

	private:
	sem_t m_Init_signal;
	sem_t m_ReqUserLogin_signal;
	sem_t m_ReqQryMarketData_signal;
};

#endif 
