#include "user.h"
#include "ccdeclare.h"

//最新价买开
void CUser::ReqProgOrder1()
{
    int instno;
    int count;
    GetInstAndCount(instno, count);

    double price1, price2, price3; 
    GetInstPrice(instno, price1, price2, price3);

    int localno;
    for (size_t i = 0; i < count; i++)
    {
        if (_testsvrtype == 1)
        {
            ReqStockInsert_Limit(instno, TD_SIDE_Buy, 1, price1, localno);
        }
        else if(_testsvrtype == 2)
        {
            ReqOptionsInsert_Limit(instno, TD_SIDE_Buy,  TD_OC_Open, 1, price1, localno);
        }
    }
}

//最新价卖开
void CUser::ReqProgOrder2()
{
    int instno;
    int count;
    GetInstAndCount(instno, count);

    double price1, price2, price3; 
    GetInstPrice(instno, price1, price2, price3);

    int localno;
    for (size_t i = 0; i < count; i++)
    {
        if (_testsvrtype == 1)
        {
            std::cout << "stk无卖开" << std::endl;
        }
        else if(_testsvrtype == 2)
        {
            ReqOptionsInsert_Limit(instno, TD_SIDE_Sell,  TD_OC_Open, 1, price1, localno);
        }
    }
}

//最新价买平
void CUser::ReqProgOrder3()
{
    int instno;
    int count;
    GetInstAndCount(instno, count);

    double price1, price2, price3; 
    GetInstPrice(instno, price1, price2, price3);

    int localno;
    for (size_t i = 0; i < count; i++)
    {
        if (_testsvrtype == 1)
        {
            std::cout << "stk无买平" << std::endl;
        }
        else if(_testsvrtype == 2)
        {
            ReqOptionsInsert_Limit(instno, TD_SIDE_Buy,  TD_OC_Close, 1, price1, localno);
        }
    }
}

//最新价卖平
void CUser::ReqProgOrder4()
{
    int instno;
    int count;
    GetInstAndCount(instno, count);

    double price1, price2, price3; 
    GetInstPrice(instno, price1, price2, price3);

    int localno;
    for (size_t i = 0; i < count; i++)
    {
        if (_testsvrtype == 1)
        {
            ReqStockInsert_Limit(instno, TD_SIDE_Sell, 1, price1, localno);
        }
        else if(_testsvrtype == 2)
        {
            ReqOptionsInsert_Limit(instno, TD_SIDE_Sell,  TD_OC_Close, 1, price1, localno);
        }
    }
}

//涨停卖，跌停买
void CUser::ReqProgOrder5()
{
    int instno;
    int count;
    GetInstAndCount(instno, count);

    double price1, price2, price3; 
    GetInstPrice(instno, price1, price2, price3);

    int localno;
    for (size_t i = 0; i < count; i++)
    {
        if (_testsvrtype == 1)
        {
            ReqStockInsert_Limit(instno, TD_SIDE_Sell, 1, price2, localno);
            ReqStockInsert_Limit(instno, TD_SIDE_Buy, 1, price3, localno);  
        }
        else if(_testsvrtype == 2)
        {
            ReqOptionsInsert_Limit(instno, TD_SIDE_Sell,  TD_OC_Open, 1, price2, localno);
            ReqOptionsInsert_Limit(instno, TD_SIDE_Buy, TD_OC_Open, 1, price3, localno);  
        } 
    }
}

//涨停卖，跌停买,报单后马上撤单
void CUser::ReqProgOrder6()
{
    int instno;
    int count;
    GetInstAndCount(instno, count);

    double price1, price2, price3; //last,upper,low
    GetInstPrice(instno, price1, price2, price3);

    int localno;

    char choosemode;
    do
    {
        choosemode = 0;
        for (size_t i = 0; i < count; i++)
        {
            if (_testsvrtype == 1)
            {
                ReqStockInsert_Limit(instno, TD_SIDE_Sell, 1, price2, localno);
                sleep(1);
                ReqCancleWithLocalNo(localno);
                ReqStockInsert_Limit(instno, TD_SIDE_Buy, 1, price3, localno);
                // sleep(1);
                ReqCancleWithLocalNo(localno);
            }
            else if(_testsvrtype == 2)
            {
                ReqOptionsInsert_Limit(instno, TD_SIDE_Sell,  TD_OC_Open, 1, price2, localno);
                // sleep(1);
                ReqCancleWithLocalNo(localno);
                ReqOptionsInsert_Limit(instno, TD_SIDE_Buy,  TD_OC_Open, 1, price3, localno);
                // sleep(1);
                ReqCancleWithLocalNo(localno);
            }
        }

        std::cout << std::endl << std::endl;
        getchar();
        getchar();
        std::cout << "输入q       退出循环下单测试" << std::endl;
        std::cout << "输入其他    继续循环下单测试" << std::endl;
        std::cout << std::endl << std::endl;

        std::cin >> choosemode;
    } while (choosemode != 'q');
}

void CUser::GetInstAndCount(int& instno, int& count)
{
    //////合约序号
    std::string _Instrument;
    std::cout << "输入测试合约(instrumentid):" << std::endl;
    std::cin >> _Instrument;
    instno = GetInstrumentNo((char*)_Instrument.c_str());

    //////报单次数
	std::cout << std::endl;
	std::cout << "请输入报单循环次数: " << std::endl;
    std::cin >> count;

    //////中间是否sleep
    std::cout << std::endl;
    std::cout << "请输入报单循环次数: " << std::endl;
    std::cin >> count;
    return;
}

void CUser::GetInstPrice(int instno, double& lastprice, double& uplimitPrice, double& lowLimitPrice)
{   
    memset(&_marketdata, 0, sizeof(_marketdata));
    _mdfinish = 0;

    CTdQryMarketDataField req = {0};
    req.InstrumentNo = instno;
    int rtn =m_pTraderApi->m_pApi->ReqQryMarketData(&req, 0);
    if(rtn!=0)
    {
        std::cout << "查询行情发送失败:" << rtn << std::endl;
    } 
    
    int i=0;
    for(; i<100; i++)
    {
        usleep(1000);
        if (_mdfinish == 1)
        {
            break;
        }
    }

    if (i >= 100)
    {
        std::cout << "获取行情失败" << instno <<  std::endl;
        memset(&_marketdata, 0, sizeof(_marketdata));
        _mdfinish = 0;
        return;
    }
    
    if(instno == _marketdata.InstrumentNo)
    {
        lastprice = _marketdata.LastPrice;
        uplimitPrice = _marketdata.UpperlimitPrice;
        lowLimitPrice = _marketdata.LowerlimitPrice;
    }

    memset(&_marketdata, 0, sizeof(_marketdata));
    _mdfinish = 0;
    return;
}

void CUser::ReqCancleWithLocalNo(int localno) //用local撤本次session报单
{
    CTdOrderCancelReqField req = {0};
    req.OriLocalOrderNo = localno;
    m_pTraderApi->ReqOptionsCancel(&req, _requestid++);
}

void CUser::ReqCancleWithOrderSysid(char* ordersysid)//用ordersysid撤单
{
    CTdOrderCancelReqField req = {0};
    strcpy(req.OrderSysId, ordersysid);
    m_pTraderApi->ReqOptionsCancel(&req, _requestid++);
}

void CUser::ReqCancleAll() //撤销所有报单
{
    _optOrderList.clear();

    //查询"已报入"状态委托单
    CTdQryOptionsOrderField req = {0};
    strcpy(req.ClientId, _clientid);
    req.OrdStatus = TD_Status_Success;
    int rtn =m_pTraderApi->m_pApi->ReqQryOptionsOrder(&req, 0);
    if(rtn!=0)
    {
        std::cout << "查询委托发送失败:" << rtn << std::endl;
        return;
    } 
    _qryoptOrderfinish = 1;
    
    for(int i=0; i<100; i++)
    {
        usleep(1000);
        if(_qryoptOrderfinish == 2)
        {
            break;
        }
    }
    
    //查询"已报入"状态委托单
    strcpy(req.ClientId, _clientid);
    req.OrdStatus = TD_Status_Trade;
    rtn =m_pTraderApi->m_pApi->ReqQryOptionsOrder(&req, 0);
    if(rtn!=0)
    {
        std::cout << "查询委托发送失败:" << rtn << std::endl;
        return;
    } 
    _qryoptOrderfinish = 1;

    for(int i=0; i<100; i++)
    {
        usleep(1000);
        if(_qryoptOrderfinish  == 2)
        {
            break;
        }
    }

    _qryoptOrderfinish = 0;

    //撤销所有在途订单
    for (auto it : _optOrderList)
    {
        ReqCancleWithOrderSysid(it.OrderSysId);
    }

    return;
}
