﻿#ifndef __TI_TD_API_DATA_STRUCT_H__
#define __TI_TD_API_DATA_STRUCT_H__

/// 查询请求结构选项
/// []选填
/// <>必填
/// {}选其一

#include "TiDataType.h"
#include <list>

namespace titd
{
    ///初始化api的配置详细
    ///网卡为普通socket的时候不需要填入SendNicName和RecvNicName
    struct CTdConfigInfoField
    {
        TdUserIDType    UserId;             // 交易用户代码(该用户名和登录时用的用户名相同)
        char            NicType;            // 网卡类型; 目前系统支持以下几种; 1:普通socket;2:Solarflare; 3:Exablaze;
        char            SendNicName[32];    // 发送请求的网卡名称(可以与RecvNicName一样)
        char            RecvNicName[32];    // 接收应答的网卡名称(可以与SendNicName一样)
        char            RecvNicIp[32];      // 接收应答的网卡IP
        int             RecvNicPort;        // 接收应答的网卡端口(请设置成51100-51200之间的端口，0表示不设置系统会自动分配端口进行数据接收)
        char            SubPrivateType;     // 私有流订阅模式
                                            ///  0:不订阅私有流
                                            ///  1:从本交易日开始重传
                                            ///  2:从上次收到的续传
                                            ///  3:只传送登录后私有流的内容
        char            SubPublicType;      // 公共流订阅模式
                                            ///  0:不订阅公有流                                  
                                            ///  3:订阅公有流
        char            FrontAddress[32];   // 交易服务器网络地址
                                            ///  网络地址的格式为：“protocol://ipaddress:port”，如：”tcp://127.0.0.1:17001”。
                                            ///  “tcp”代表传输协议，“127.0.0.1”代表服务器地址。”17001”代表服务器端口号。
        int             RecvDataCpuId;      // 接收网络数据的线程cpuid(-1不绑定cpu)
        int             DealDataCpuId;      // 处理网络数据的线程cpuid(-1不绑定cpu)
        int             MaxRecvDataSize;    // 接收数据缓存的大小(单位为M,如果不填入默认大小为512M)
        bool            IsLog;              // 是否记录日志
        int             timeOut;            // 超时时间默认为3秒
        int             LockFree;       	// 是否为无锁多线程不安全模式:1:无锁线程不安全; 其他:有锁线程安全(默认为有锁多线程安全但会额外消耗资源和增加报单时间延时)
    };

    ///响应信息
    struct CTdRspInfoField
    {
        TdErrorIDType     ErrorId;         ///错误代码
        TdErrorMsgType    ErrorMsg;        ///错误信息
    };

    ///用户登录请求
    struct CTdReqUserLoginField
    {
        
        TdUserIDType          UserId;          // 交易用户代码
        TdPasswordType        Password;        // 密码    
        TdProtocolInfoType    ProtocolInfo;    // 协议信息    
        TdProductInfoType     UserProductInfo; // 用户端产品信息        
        TdAppIdType           AppId;           // appid    
        TdAppIdIdentifyType   AppIdIdentify;   // appid验证码
    };

    ///用户登录应答
    struct CTdRspUserLoginField
    {
        TdSessionNoType        SessionNo;         // 本次登录的session
        TdDateType             TradingDay;        // 交易日    
        TdIntTimeType          LoginTime;         // 登录成功时间    
        TdLocalOrderNoType     MaxLocalOrderNo;   // 最大会员内部订单编号    
        TdUserIDType            UserId;           // 交易用户代码        
        TdTradingSystemNameType TradingSystemName;// 交易系统名称        
        TdSequenceNoType        SequenceNo;       // 当前用户接收的私有流最新序号        
        TdDateType              ActionDay;        // 业务发生日期
    };

    ///用户验证请求
    struct CTdReqUserAuthenField
    {
        TdUserIDType          UserId;          // 交易用户代码
        TdPasswordType        Password;        // 密码
    };

    ///用户登录应答
    struct CTdRspUserAuthenField
    {   
        TdUserIDType            UserId;           // 交易用户代码
    };

    ///用户口令修改
    struct CTdUserPasswordUpdateField
    {
        TdPasswordType    OldPassword;        // 旧密码
        TdPasswordType    NewPassword;        // 新密码
    };

    ///期权,期货报单请求
    struct CTdOrderInsertReqField
    {
        TdClientNoType        ClientNo;            // 交易编码序号
        TdInstrumentNoType    InstrumentNo;        // 合约序号
        TdLocalOrderNoType    LocalOrderNo;        // 会员内部订单编号
        TdPriceTypeType       PriceType;           // 报单价格条件
        TdSideType            Side;                // 买卖方向
        TdOffsetFlagType      OffsetFlag;          // 开平标记
        TdHedgeFlagType       HedgeFlag;           // 投机套保标记
        TdTimeInForceType     TimeInForce;         // 订单有效时间类型
        TdCoveredOrUncoveredType    CoveredOrUncovered; //备兑标签
        TdVolumeConditionType       VolumeCondition;    //成交量类型
        TdTrigConditionType   TrigCondition;        //触发条件
        TdVolumeType          Volume;               //数量
        TdVolumeType          MinVolume;            //最小成交量
        TdPriceType           Price;                //价格
        TdPriceType           StopPrice;            //止损价
        TdOwnerTypeType       OwnerType;            //订单所有类型
        TdExchangeIdType      ExchangeId;           //交易所代码
        TdFrontNoType         FrontNo;              // 处理本次报单的席位序号
                                                    ///  当所填的序号在系统中不存在时系统会优选最佳席位进行报单,否则,根据用户所选席位进行报单
    };

    ///期权,期货报单应答
    struct CTdOrderInsertRspField
    {
        TdClientNoType          ClientNo;        //交易编码序号
        TdInstrumentNoType      InstrumentNo;    //合约序号
        TdLocalOrderNoType      LocalOrderNo;    //会员内部订单编号
        TdPriceTypeType         PriceType;       //报单价格条件
        TdSideType              Side;            //买卖方向
        TdOffsetFlagType        OffsetFlag;      //开平标记
        TdHedgeFlagType         HedgeFlag;       //投机套保标记
        TdTimeInForceType       TimeInForce;     //订单有效时间类型
        TdCoveredOrUncoveredType    CoveredOrUncovered;    //备兑标签
        TdVolumeConditionType       VolumeCondition;       //成交量类型
        TdTrigConditionType     TrigCondition;    //触发条件
        TdVolumeType            Volume;           //数量
        TdVolumeType            MinVolume;        //最小成交量
        TdPriceType             Price;            //价格
        TdPriceType             StopPrice;        //止损价
        TdOwnerTypeType         OwnerType;        //订单所有类型
        TdExchangeIdType        ExchangeId;       //交易所代
        TdFrontNoType           FrontNo;          //处理本次报单的实际席位序号
        TdSessionNoType         SessionNo;        //发送该报单的session
        TdOrderSysIDType        OrderSysId;       //交易所订单编号
    };

    ///撤单请求
    struct CTdOrderCancelReqField
    {
        TdSessionNoType        OriSessionNo;       //原始报单的sessionno如果是通过LocalOrderNo撤单，需要填写，不填写则默认撤销本次登录后的LocalOrderNo
        TdLocalOrderNoType     OriLocalOrderNo;    //原始交易客户方订单编号
        TdOrderSysIDType       OrderSysId;         //交易所订单编号(OrigLocalOrderNo和OrderSysId任意一个即可，当OriLocalOrderNo、OrderSysId都填写时，以OriLocalOrderNo为准)
    };

    ///撤单应答
    struct CTdOrderCancelRspField
    {
        TdSessionNoType        OriSessionNo;        //原始报单的sessionno
        TdLocalOrderNoType     OriLocalOrderNo;     //原始交易客户方订单编号
        TdOrderSysIDType       OrderSysId;          //交易所订单编号
        TdSessionNoType        SessionNo;           //发送该报单的session
    };

    ///期权,期货报价请求
    struct CTdQuoteInsertReqField
    {
        TdClientNoType        ClientNo;            //交易编码序号
        TdInstrumentNoType    InstrumentNo;        //合约序号
        TdLocalOrderNoType    LocalOrderNo;        //会员内部订单编号
        TdQuoteReqIDType      QuoteReqId;          //报价请求ID,预留字段,当报价是对请求的响应时，填写报价请求的ID
        TdPriceType           BidPx;               //买报价
        TdPriceType           AskPx;               //卖报价
        TdVolumeType          BidSize;             //买数量
        TdVolumeType          AskSize;             //卖数量
        TdOffsetFlagType      BidOffsetFlag;       //平仓标识
        TdOffsetFlagType      AskOffsetFlag;       //平仓标识
        TdOwnerTypeType       OwnerType;           //订单所有类型
        TdExchangeIdType      ExchangeId;          //交易所代码
        ///处理本次报单的席位序号,当所填的序号在系统中不存在时系统会优选最佳席位进行报单,否则,根据用户所选席位进行报单
        TdFrontNoType         FrontNo;
    };

    ///期权,期货报价应答
    struct CTdQuoteInsertRspField
    {
        TdClientNoType        ClientNo;            //交易编码序号
        TdInstrumentNoType    InstrumentNo;        //合约序号
        TdLocalOrderNoType    LocalOrderNo;        //会员内部订单编号
        TdQuoteReqIDType      QuoteReqId;          //报价请求ID,预留字段,当报价是对请求的响应时，填写报价请求的ID
        TdPriceType           BidPx;               //买报价
        TdPriceType           AskPx;               //卖报价
        TdVolumeType          BidSize;             //买数量
        TdVolumeType          AskSize;             //卖数量
        TdOffsetFlagType      BidOffsetFlag;       //平仓标识
        TdOffsetFlagType      AskOffsetFlag;       //平仓标识
        TdOwnerTypeType       OwnerType;           //订单所有类型
        TdExchangeIdType      ExchangeId;          //交易所代码
        TdFrontNoType         FrontNo;             //处理本次报单的实际席位序号
        TdSessionNoType       SessionNo;           //发送该报单的session
        TdOrderSysIDType      OrderSysId;          //交易所订单编号
        TdOrderSysIDType      BidOrderId;          //买方交易所订单编号
        TdOrderSysIDType      AskOrderId;          //卖方交易所订单编号
    };

    struct OmlItem
    {
        TdInstrumentNoType       LegInstrumentNo;       //合约编码
        TdLegSideType            LegSide;               //合约方向
        TdCoveredOrUncoveredType CoveredOrUncovered;    //备兑标签
        TdVolumeType             LegVolume;             //申报数量
    };

    ///客户申请组合请求
    struct CTdMarginCombActionField
    {
        TdClientNoType        ClientNo;                 //交易编码序号
        TdLocalOrderNoType    LocalOrderNo;             //会员内部订单编号
        TdVolumeType          Volume;                   //申报数量
        TdCombType            Side;                     //组合与拆分组合标记,组合策略为“ZBD”时，组合与拆分方向只能为组合
        TdCombIDType          CombId;                   //组合策略编码:目前为7种组合策略：CNSJC、PXSJC、PNSJC、CXSJC、KS、KKS、ZBD
        TdOrderSysIDType      CombInstId;               //组合编码。组合申报时，该字段为空格；拆分申报时，填写拟拆分组合的组合编码
        TdOwnerTypeType       OwnerType;                //订单所有类型
        TdExchangeIdType      ExchangeId;               //交易所代码
        int NoLeges;                                    //成分合约数，取值不超过4，后接重复组
        OmlItem item[4];
    };

    struct OmlItemRtn
    {
        TdInstrumentNoType    LegInstrumentNo;          //合约编码
        TdInstrumentIdType    LegInstrumentId;          //合约编码
        TdLegSideType         LegSide;                  //合约方向
        TdCoveredOrUncoveredType CoveredOrUncovered;    //备兑标签
        TdVolumeType          LegVolume;                //申报数量
    };

    ///客户申请组合应答
    struct CTdMarginCombActionRspField
    {
        TdClientNoType          ClientNo;               //交易编码序号
        TdLocalOrderNoType      LocalOrderNo;           //会员内部订单编号
        TdVolumeType            Volume;                 //申报数量
        TdCombType              Side;                   //组合与拆分组合标记
        TdCombIDType            CombId;                 //组合策略编码:目前为7种组合策略：CNSJC、PXSJC、PNSJC、CXSJC、KS、KKS、ZBD
        TdOrderSysIDType        CombInstId;             //组合编码。组合申报成功时返回组合的组合编码
        TdOwnerTypeType         OwnerType;              //订单所有类型
        TdExchangeIdType        ExchangeId;             //交易所代码
        TdFrontNoType           FrontNo;                //处理本次报单的实际席位序号
        TdSessionNoType         SessionNo;              //发送该报单的session
        int NoLeges;                                    //成分合约数，取值不超过4，后接重复组
        OmlItem item[4];
    };

    ///股票报单请求
    struct CTdStockInsertReqField
    {
        TdClientNoType      ClientNo;                   //交易编码序号
        TdInstrumentNoType  InstrumentNo;               //合约序号
        TdLocalOrderNoType  LocalOrderNo;               //会员内部订单编号
        TdPriceTypeType     PriceType;                  //报单价格条件
        TdSideType          Side;                       //买卖方向
        TdTimeInForceType   TimeInForce;                //订单有效时间类型
        TdVolumeType        Volume;                     //数量
        TdPriceType         Price;                      //价格
        TdOwnerTypeType     OwnerType;                  //订单所有类型
        TdExchangeIdType    ExchangeId;                 //交易所代码
        ///处理本次报单的席位序号,当所填的序号在系统中不存在时系统会优选最佳席位进行报单,否则,根据用户所选席位进行报单
        TdFrontNoType       FrontNo;
    };

    ///股票报单应答
    struct CTdStockInsertRspField
    {
        TdClientNoType      ClientNo;                   //交易编码序号
        TdInstrumentNoType  InstrumentNo;               //合约序号
        TdLocalOrderNoType  LocalOrderNo;               //会员内部订单编号
        TdPriceTypeType     PriceType;                  //报单价格条件
        TdSideType          Side;                       //买卖方向
        TdTimeInForceType   TimeInForce;                //订单有效时间类型
        TdVolumeType        Volume;                     //数量
        TdPriceType         Price;                      //价格
        TdOwnerTypeType     OwnerType;                  //订单所有类型
        TdExchangeIdType    ExchangeId;                 //交易所代码
        TdFrontNoType       FrontNo;                    //处理本次报单的实际席位序号
        TdSessionNoType     SessionNo;                  //发送该报单的session
        TdOrderSysIDType    OrderSysId;                 //交易所订单编号
    };

    ///股票非交易业务报单请求
    struct CTdBusinessInsertReqField
    {
        TdBusinessType      BusinessType;              //业务类型
        TdClientNoType      ClientNo;                   //交易编码序号
        TdInstrumentIdType  InstrumentId;               //合约代码
        TdLocalOrderNoType  LocalOrderNo;               //会员内部订单编号
        //TdPriceTypeType     PriceType;                //报单价格条件
        TdSideType          Side;                       //买卖方向
        //TdTimeInForceType   TimeInForce;              //订单有效时间类型
        TdVolumeType        Volume;                     //数量
        TdPriceType         Price;                      //价格
        //TdOwnerTypeType     OwnerType;                //订单所有类型
        TdExchangeIdType    ExchangeId;                 //交易所代码
        TdInstrumentIdType  DestInstrumentId;           //目标合约代码
    };

    ///股票非交易业务报单应答
    struct CTdBusinessInsertRspField
    {
        TdBusinessType      BusinessType;              //业务类型
        TdClientNoType      ClientNo;                   //交易编码序号
        TdInstrumentIdType  InstrumentId;               //合约代码
        TdLocalOrderNoType  LocalOrderNo;               //会员内部订单编号
        //TdPriceTypeType     PriceType;                //报单价格条件
        TdSideType          Side;                       //买卖方向
        //TdTimeInForceType   TimeInForce;              //订单有效时间类型
        TdVolumeType        Volume;                     //数量
        TdPriceType         Price;                      //价格
        //TdOwnerTypeType     OwnerType;                //订单所有类型
        TdExchangeIdType    ExchangeId;                 //交易所代码
        //TdFrontNoType       FrontNo;                  //处理本次报单的实际席位序号
        TdSessionNoType     SessionNo;                  //发送该报单的session
        TdOrderSysIDType    OrderSysId;                 //交易所订单编号
        TdInstrumentIdType  DestInstrumentId;           //目标合约代码
    };

    ///行权请求
    struct CTdExerciseReqField
    {
        TdClientNoType        ClientNo;                 //交易编码序号
        TdInstrumentNoType    InstrumentNo;             //合约序号
        TdLocalOrderNoType    LocalOrderNo;             //会员内部订单编号
        TdVolumeType          Volume;                   //申报数量
        TdOwnerTypeType       OwnerType;                //订单所有类型
        TdExchangeIdType      ExchangeId;               //交易所代码
    };

    ///行权应答
    struct CTdExerciseRspField
    {
        TdClientNoType        ClientNo;                 //交易编码序号
        TdInstrumentNoType    InstrumentNo;             //合约序号
        TdLocalOrderNoType    LocalOrderNo;             //会员内部订单编号
        TdVolumeType          Volume;                   //申报数量
        TdOwnerTypeType       OwnerType;                //订单所有类型
        TdExchangeIdType      ExchangeId;               //交易所代码
        TdFrontNoType         FrontNo;                  //处理本次报单的实际席位序号
        TdSessionNoType       SessionNo;                //发送该报单的session
        TdOrderSysIDType      OrderSysId;               //交易所订单编号
    };

    ///组合行权请求
    struct CTdCombExerciseReqField
    {
        TdClientNoType      ClientNo;                   //交易编码序号
        TdLocalOrderNoType  LocalOrderNo;               //会员内部订单编号
        TdVolumeType        Volume;                     //申报数量
        TdInstrumentNoType  LegInstrumentNo1;           //腿1合约序号
        TdVolumeType        LegVolume1;                 //腿1申报数量
        TdInstrumentNoType  LegInstrumentNo2;           //腿2合约序号
        TdVolumeType        LegVolume2;                 //腿2申报数量
        TdOwnerTypeType     OwnerType;                  //订单所有类型
        TdExchangeIdType    ExchangeId;                 //交易所代码
    };

    ///组合行权应答
    struct CTdCombExerciseRspField
    {
        TdClientNoType      ClientNo;                   //交易编码序号
        TdLocalOrderNoType  LocalOrderNo;               //会员内部订单编号
        TdVolumeType        Volume;                     //申报数量
        TdInstrumentNoType  LegInstrumentNo1;           //腿1合约序号
        TdVolumeType        LegVolume1;                 //腿1申报数量
        TdInstrumentNoType  LegInstrumentNo2;           //腿2合约序号
        TdVolumeType        LegVolume2;                 //腿2申报数量
        TdOwnerTypeType     OwnerType;                  //订单所有类型
        TdExchangeIdType    ExchangeId;                 //交易所代码
        TdFrontNoType       FrontNo;                    //处理本次报单的实际席位序号
        TdSessionNoType     SessionNo;                  //发送该报单的session
    };

    ///询价请求
    struct CTdForQuoteReqField
    {
        TdClientNoType      ClientNo;                   //交易编码序号
        TdInstrumentNoType  InstrumentNo;               //合约序号
        TdLocalOrderNoType  LocalOrderNo;               //会员内部订单编号
        TdOwnerTypeType     OwnerType;                  //订单所有类型
        TdExchangeIdType    ExchangeId;                 //交易所代码
    };

    ///询价应答
    struct CTdForQuoteRspField
    {
        TdClientNoType       ClientNo;                  //交易编码序号
        TdInstrumentNoType   InstrumentNo;              //合约序号
        TdLocalOrderNoType   LocalOrderNo;              //会员内部订单编号
        TdOwnerTypeType      OwnerType;                 //订单所有类型
        TdExchangeIdType     ExchangeId;                //交易所代码
        TdFrontNoType        FrontNo;                   //处理本次报单的实际席位序号
        TdSessionNoType      SessionNo;                 //发送该报单的session
        TdQuoteReqIDType     QuoteReqId;                //报价请求ID
    };

    ///证券锁定请求
    struct CTdStockLockReqField
    {
        TdClientNoType        ClientNo;                 //交易编码序号
        TdInstrumentNoType    InstrumentNo;             //合约序号
        TdLocalOrderNoType    LocalOrderNo;             //会员内部订单编号
        TdLockType            Locked;                   //锁定标志撤销
        TdVolumeType          Volume;                   //数量
        TdExchangeIdType      ExchangeId;               //交易所代码
        ///处理本次报单的席位序号,当所填的序号在系统中不存在时系统会优选最佳席位进行报单,否则,根据用户所选席位进行报单
        TdFrontNoType            FrontNo;
    };

    ///证券锁定应答
    struct CTdStockLockRspField
    {
        TdClientNoType        ClientNo;                 //交易编码序号
        TdInstrumentNoType    InstrumentNo;             //合约序号
        TdLocalOrderNoType    LocalOrderNo;             //会员内部订单编号
        TdLockType            Locked;                   //锁定标志
        TdVolumeType          Volume;                   //数量
        TdExchangeIdType      ExchangeId;               //交易所代码
        TdFrontNoType         FrontNo;                  //处理本次报单的实际席位序号
        TdSessionNoType       SessionNo;                //发送该报单的session
        TdOrderSysIDType      OrderSysId;               //交易所订单编号
    };

    ///行权通知
    struct CTdExerciseRtnField
    {
        TdFrontNoType          FrontNo;                 //处理本次报单的实际席位序号
        TdSequenceNoType       SequenceNo;              //回报序号(私有流序号每个交易日连续)
        TdRequestNoType        RequestNo;               //报单请求编号
        TdSessionNoType        SessionNo;               //原始报单session
        TdClientNoType         ClientNo;
        TdInstrumentNoType     InstrumentNo;
        TdLocalOrderNoType     LocalOrderNo;
        TdClientIdType         ClientId;
        TdInstrumentIdType     InstrumentId;
        TdExchangeIdType       ExchangeId;              //交易所代码
        TdVolumeType           Volume;                  //申报数量
        TdOwnerTypeType        OwnerType;               //订单所有类型
        TdOrdStatusType        OrdStatus;
        TdIntTimeType          ExerciseTime;            //行权成功时间 
        TdOrderSysIDType       OrderSysId;              //交易所订单编号
        TdUserIDType           UserId;                  //原始报单交易用户代码
    };

    //期权委托回报
    struct CTdOptionsOrderRtnField
    {
        TdFrontNoType           FrontNo;                //处理本次报单的实际席位序号
        TdSequenceNoType        SequenceNo;             //回报序号(私有流序号每个交易日连续)
        TdRequestNoType         RequestNo;              //报单请求编号
        TdSessionNoType         SessionNo;              //原始报单session
        TdClientNoType          ClientNo;
        TdInstrumentNoType      InstrumentNo;
        TdLocalOrderNoType      LocalOrderNo;
        TdClientIdType          ClientId;
        TdInstrumentIdType      InstrumentId;
        TdExchangeIdType        ExchangeId;             //交易所代码
        TdPriceTypeType         PriceType;              //报单价格条件
        TdSideType              Side;                   //买卖方向
        TdTimeInForceType       TimeInForce;            //订单有效时间类型
        TdOwnerTypeType         OwnerType;              //订单所有类型
        TdOrdStatusType         OrdStatus;              //当前订单的状态
        TdPriceType             Price;                  //价格
        TdVolumeType            Volume;                 //数量
        TdIntTimeType           OrderTime;              //委托时间
        TdOrderSysIDType        OrderSysId;             //交易所订单编号
        TdVolumeType            LeavesVolume;           //订单剩余数量(交易所返回字段,每个交易所的含义不同)
        TdVolumeType            CancelVolume;           //订单撤销数量
        TdVolumeType            MinVolume;              //最小成交量
        TdPriceType             StopPrice;              //止损价    
        TdOffsetFlagType        OffsetFlag;             //开平标记
        TdHedgeFlagType         HedgeFlag;              //投机套保标记    
        TdCoveredOrUncoveredType CoveredOrUncovered;    //备兑标签
        TdVolumeConditionType    VolumeCondition;       //成交量类型
        TdTrigConditionType     TrigCondition;          //触发条件    
        TdUserIDType            UserId;                 //原始报单交易用户代码
    };

    //期权成交回报
    struct CTdOptionsTradeRtnField
    {
        TdFrontNoType           FrontNo;                //处理本次报单的实际席位序号
        TdSequenceNoType        SequenceNo;             //回报序号(私有流序号每个交易日连续)
        TdRequestNoType         RequestNo;              //报单请求编号
        TdSessionNoType         SessionNo;              //原始报单session
        TdClientNoType          ClientNo;
        TdInstrumentNoType      InstrumentNo;
        TdLocalOrderNoType      LocalOrderNo;
        TdClientIdType          ClientId;
        TdInstrumentIdType      InstrumentId;
        TdExchangeIdType        ExchangeId;             //交易所代码
        TdPriceTypeType         PriceType;              //报单价格条件
        TdSideType              Side;                   //买卖方向
        TdOffsetFlagType        OffsetFlag;             //开平标记
        TdHedgeFlagType         HedgeFlag;              //投机套保标记
        TdTimeInForceType        TimeInForce;           //订单有效时间类型
        TdCoveredOrUncoveredType CoveredOrUncovered;    //备兑标签
        TdVolumeConditionType    VolumeCondition;       //成交量类型
        TdTrigConditionType     TrigCondition;          //触发条件
        TdOwnerTypeType         OwnerType;              //订单所有类型
        TdPriceType             TradePrice;             //成交价格
        TdVolumeType            TradeVolume;            //成交数量
        TdVolumeType            LeavesVolume;           //本次成交后申报余额数量
        TdIntTimeType           TradeTime;              //成交时间
        TdOrderSysIDType        OrderSysId;             //交易所报单编号
        TdTradeIDType           TradeId;                //成交编号
        TdUserIDType            UserId;                 //原始报单交易用户代码
    };

    //股票委托回报
    struct CTdStockOrderRtnField
    {
        TdFrontNoType           FrontNo;                //处理本次报单的实际席位序号
        TdSequenceNoType        SequenceNo;             //回报序号(私有流序号每个交易日连续)
        TdRequestNoType         RequestNo;              //报单请求编号
        TdSessionNoType         SessionNo;              //原始报单session
        TdClientNoType          ClientNo;
        TdInstrumentNoType      InstrumentNo;
        TdLocalOrderNoType      LocalOrderNo;
        TdClientIdType          ClientId;
        TdUserIDType            UserId;                 //原始报单交易用户代码
        TdInstrumentIdType      InstrumentId;
        TdExchangeIdType        ExchangeId;             //交易所代码
        TdPriceTypeType         PriceType;              //报单价格条件
        TdSideType              Side;                   //买卖方向
        TdTimeInForceType       TimeInForce;            //有效期类型
        TdOwnerTypeType         OwnerType;              //订单所有类型
        TdOrdStatusType         OrdStatus;              //订单状态
        TdPriceType             Price;                  //价格
        TdVolumeType            Volume;                 //数量
        TdIntTimeType           OrderTime;              //委托时间
        TdOrderSysIDType        OrderSysId;             //交易所报单编号
        TdVolumeType            LeavesVolume;           //订单剩余数量(交易所返回字段,每个交易所的含义不同)
        TdVolumeType            CancelVolume;           //订单撤销数量
    };

    //股票成交回报
    struct CTdStockTradeRtnField
    {
        TdFrontNoType           FrontNo;                //处理本次报单的实际席位序号
        TdSequenceNoType        SequenceNo;             //回报序号(私有流序号每个交易日连续)
        TdRequestNoType         RequestNo;              //报单请求编号
        TdSessionNoType         SessionNo;              //原始报单session
        TdClientNoType          ClientNo;
        TdInstrumentNoType      InstrumentNo;
        TdLocalOrderNoType      LocalOrderNo;
        TdClientIdType          ClientId;
        TdInstrumentIdType      InstrumentId;
        TdExchangeIdType        ExchangeId;             //交易所代码
        TdSideType              Side;                   //买卖方向
        TdPriceType             TradePrice;             //成交价格
        TdVolumeType            TradeVolume;            //成交数量
        TdVolumeType            LeavesVolume;           //本次成交后申报余额数量
        TdIntTimeType           TradeTime;              //成交时间
        TdOrderSysIDType        OrderSysId;             //交易所报单编号
        TdTradeIDType           TradeId;                //成交编号
        TdUserIDType            UserId;                 //原始报单交易用户代码
    };

    //股票非交易业务委托回报
    struct CTdBusinessOrderRtnField
    {
        TdBusinessType          BusinessType;          //业务类型
        TdSequenceNoType        SequenceNo;             //回报序号(私有流序号每个交易日连续)
        TdRequestNoType         RequestNo;              //报单请求编号
        TdSessionNoType         SessionNo;              //原始报单session
        TdClientNoType          ClientNo;
        TdLocalOrderNoType      LocalOrderNo;
        TdClientIdType          ClientId;
        TdUserIDType            UserId;                 //原始报单交易用户代码
        TdInstrumentIdType      InstrumentId;
        TdExchangeIdType        ExchangeId;             //交易所代码
        //TdPriceTypeType         PriceType;              //报单价格条件
        TdSideType              Side;                   //买卖方向
        //TdTimeInForceType       TimeInForce;            //有效期类型
        //TdOwnerTypeType         OwnerType;              //订单所有类型
        TdOrdStatusType         OrdStatus;              //订单状态
        TdPriceType             Price;                  //价格
        TdVolumeType            Volume;                 //数量
        TdIntTimeType           OrderTime;              //委托时间
        TdOrderSysIDType        OrderSysId;             //交易所报单编号
        TdVolumeType            LeavesVolume;           //订单剩余数量(交易所返回字段,每个交易所的含义不同)
        TdVolumeType            CancelVolume;           //订单撤销数量
        TdInstrumentIdType  DestInstrumentId;           //目标合约代码
    };

    //股票非交易业务成交回报
    struct CTdBusinessTradeRtnField
    {
        TdBusinessType          BusinessType;          //业务类型
        TdSequenceNoType        SequenceNo;             //回报序号(私有流序号每个交易日连续)
        TdRequestNoType         RequestNo;              //报单请求编号
        TdSessionNoType         SessionNo;              //原始报单session
        TdClientNoType          ClientNo;
        TdLocalOrderNoType      LocalOrderNo;
        TdClientIdType          ClientId;
        TdInstrumentIdType      InstrumentId;
        TdExchangeIdType        ExchangeId;             //交易所代码
        TdSideType              Side;                   //买卖方向
        TdPriceType             TradePrice;             //成交价格
        TdVolumeType            TradeVolume;            //成交数量
        TdVolumeType            LeavesVolume;           //本次成交后申报余额数量
        TdIntTimeType           TradeTime;              //成交时间
        TdOrderSysIDType        OrderSysId;             //交易所报单编号
        TdTradeIDType           TradeId;                //成交编号
        TdUserIDType            UserId;                 //原始报单交易用户代码
        TdInstrumentIdType      DestInstrumentId;           //目标合约代码
    };

    ///出入金通知
    struct CTdWithdrawDepositRtnField
    {
        TdFrontNoType           FrontNo;
        TdSequenceNoType        SequenceNo;             //回报序号(私有流序号每个交易日连续)
        TdAccountIDType         AccountId;              //资金帐户
        TdClientIdType          ClientId;               //交易编码
        TdPriceType             Deposit;                //入金金额
        TdPriceType             Withdraw;               //出金金额
    };

    //合约状态通知
    struct CTdInstrumentStatRtnField
    {
        TdExchangeIdType        ExchangeId;             //交易所代码
        TdInstrumentIdType      InstrumentId;
        char                    InstrumentStatus;
    };

    //报价回报
    struct CTdQuoteOrderRtnField
    {
        TdFrontNoType           FrontNo;                //处理本次报单的实际席位序号
        TdSequenceNoType        SequenceNo;             //回报序号(私有流序号每个交易日连续)
        TdRequestNoType         RequestNo;              //报单请求编号
        TdSessionNoType         SessionNo;              //原始报单session
        TdClientNoType          ClientNo;
        TdInstrumentNoType      InstrumentNo;
        TdLocalOrderNoType      LocalOrderNo;
        TdClientIdType          ClientId;
        TdInstrumentIdType      InstrumentId;
        TdExchangeIdType        ExchangeId;             //交易所代码
        TdUserIDType            UserId;                 //原始报单交易用户代码
        TdQuoteReqIDType        QuoteReqId;             //报价请求ID,预留字段,当报价是对请求的响应时，填写报价请求的ID
        TdPriceType             BidPx;                  //买报价
        TdPriceType             AskPx;                  //卖报价
        TdVolumeType            BidSize;                //买数量
        TdVolumeType            AskSize;                //卖数量
        TdOffsetFlagType        BidOffsetFlag;          //平仓标识
        TdOffsetFlagType        AskOffsetFlag;          //平仓标识
        TdOwnerTypeType         OwnerType;              //订单所有类型
        TdOrderSysIDType        OrderSysId;             //交易所订单编号
        TdOrderSysIDType        BidOrderId;             //买方交易所订单编号
        TdOrderSysIDType        AskOrderId;             //卖方交易所订单编号
        TdOrdStatusType         OrdStatus;              //当前订单状态
        TdIntTimeType           OrderTime;              //委托时间
    };

    ///客户申请组合通知
    struct CTdMarginCombActionRtnField
    {
        TdFrontNoType           FrontNo;                //处理本次报单的实际席位序号
        TdSequenceNoType        SequenceNo;             //回报序号(私有流序号每个交易日连续)
        TdRequestNoType         RequestNo;              //报单请求编号
        TdSessionNoType         SessionNo;              //原始报单session
        TdClientNoType          ClientNo;               //交易编码序号
        TdLocalOrderNoType      LocalOrderNo;           //会员内部订单编号
        TdClientIdType          ClientId;               //交易编码
        TdUserIDType            UserId;                 //原始报单交易用户代码
        TdExchangeIdType        ExchangeId;             //交易所代码
        TdCombType              Side;                   //组合与拆分组合标记,组合策略为“ZBD”时，组合与拆分方向只能为组合
        int                     NoLeges;                //成分合约数，取值不超过4，后接重复组
        TdVolumeType            Volume;                 //申报数量(拆分组合的时候需要填入拆分的数量，组合的时候该字段无效)    
        TdCombIDType            CombId;                 //组合策略编码:目前为7种组合策略：CNSJC、PXSJC、PNSJC、CXSJC、KS、KKS、ZBD
        TdOrderSysIDType        CombInstId;             //组合编码。组合申报成功时返回组合的组合编码
        TdOwnerTypeType         OwnerType;              //订单所有类型
        TdIntTimeType           CombActionTime;         //组合、解组合成功时间      
        TdOrderSysIDType        OrderSysId;             //交易所报单编号
        TdPriceType             ComMargin;              //组合或拆分后保证金的变化值(组合为正拆分为负)
        OmlItemRtn              item[4];
    };


    //询价通知
    struct CTdForQuoteRtnField
    {
        TdInstrumentNoType      InstrumentNo;
        TdInstrumentIdType      InstrumentId;
        TdExchangeIdType        ExchangeId;             //交易所代码
        TdQuoteReqIDType        QuoteReqId;             //报价请求ID
    };

    ///合约状态通知
    struct CTdInstrumentStatusRtnField
    {
        TdInstrumentNoType      InstrumentNo;
        TdInstrumentIdType      InstrumentId;           //合约代码
        TdExchangeIdType        ExchangeId;             //交易所代码
        TdProductIdType         ProductId;              //产品代码
        TdInstStatusType        InstStatus;             //合约状态
    };
    ///股票报单查询请求
    struct CTdQryStockOrderField
    {
                                                        /// 所有过滤条件都不填,就查询当前登录的userid下所带客户的所有报单
        TdClientIdType          ClientId;               /// [交易编码]
        TdInstrumentIdType      InstrumentId;           /// [合约编码]
        TdOrderSysIDType        OrderSysID;             /// [交易所报单编号] 默认值:0或空 表示不过滤报单编号
        TdIntTimeType           BegTime;                /// [起始时间]       默认值:0 0表示不设起始时间
        TdIntTimeType           EndTime;                /// [结束时间]       默认值:0 0表示不设结束时间
        TdSideType              Side;                   /// [买卖方向]
        TdOrdStatusType         OrdStatus;              /// [订单状态]        默认值:0 表示不过滤订单状态
        TdQryLimitType          LimitSession;           /// [限制当前session] 默认值:0 0表示不限制
        TdQryLimitType          LimitUserId;            /// [限制当前UserId]  默认值:0 0表示不限制
    };

    ///股票报单查询应答
    struct CTdRspQryStockOrderField
    {
        TdRequestNoType         RequestNo;              //报单请求编号
        TdClientIdType          ClientId;
        TdInstrumentIdType      InstrumentId;
        TdClientNoType          ClientNo;               //交易编码序号
        TdInstrumentNoType      InstrumentNo;           //合约序号
        TdLocalOrderNoType      LocalOrderNo;           //会员内部订单编号
        TdPriceTypeType         PriceType;              //报单价格条件
        TdSideType              Side;                   //买卖方向
        TdTimeInForceType       TimeInForce;            //订单有效时间类型
        TdVolumeType            Volume;                 //数量
        TdPriceType             Price;                  //价格
        TdOwnerTypeType         OwnerType;              //订单所有类型
        TdExchangeIdType        ExchangeId;             //交易所代码
        TdFrontNoType           FrontNo;                //处理本次报单的实际席位序号
        TdSessionNoType         SessionNo;              //发送该报单的session
        TdOrdStatusType         OrdStatus;              //订单状态
        TdIntTimeType           TransTime;              //发生时间
        TdOrderSysIDType        OrderSysId;             //交易所订单编号
        TdUserIDType            UserId;                 //原始报单交易用户代码
    };

    ///股票非交易业务报单查询请求
    struct CTdQryBusinessOrderField
    {
                                                        /// 所有过滤条件都不填,就查询当前登录的userid下所带客户的所有报单
        TdClientIdType          ClientId;               /// [交易编码]
        TdInstrumentIdType      InstrumentId;           /// [合约编码]
        TdOrderSysIDType        OrderSysID;             /// [交易所报单编号] 默认值:0或空 表示不过滤报单编号
        TdIntTimeType           BegTime;                /// [起始时间]       默认值:0 0表示不设起始时间
        TdIntTimeType           EndTime;                /// [结束时间]       默认值:0 0表示不设结束时间
        TdSideType              Side;                   /// [买卖方向]
        TdOrdStatusType         OrdStatus;              /// [订单状态]        默认值:0 表示不过滤订单状态
        TdQryLimitType          LimitSession;           /// [限制当前session] 默认值:0 0表示不限制
        TdQryLimitType          LimitUserId;            /// [限制当前UserId]  默认值:0 0表示不限制
    };

    ///股票非交易业务报单查询应答
    struct CTdRspQryBusinessOrderField
    {
        TdBusinessType          BusinessType;          //业务类型
        TdRequestNoType         RequestNo;              //报单请求编号
        TdClientIdType          ClientId;
        TdInstrumentIdType      InstrumentId;
        TdClientNoType          ClientNo;               //交易编码序号
        TdLocalOrderNoType      LocalOrderNo;           //会员内部订单编号
        //TdPriceTypeType         PriceType;              //报单价格条件
        TdSideType              Side;                   //买卖方向
        //TdTimeInForceType       TimeInForce;            //订单有效时间类型
        TdVolumeType            Volume;                 //数量
        TdPriceType             Price;                  //价格
        //TdOwnerTypeType         OwnerType;              //订单所有类型
        TdExchangeIdType        ExchangeId;             //交易所代码
        TdFrontNoType           FrontNo;                //处理本次报单的实际席位序号
        TdSessionNoType         SessionNo;              //发送该报单的session
        TdOrdStatusType         OrdStatus;              //订单状态
        TdIntTimeType           TransTime;              //发生时间
        TdOrderSysIDType        OrderSysId;             //交易所订单编号
        TdUserIDType            UserId;                 //原始报单交易用户代码
        TdInstrumentIdType  DestInstrumentId;           //目标合约代码
    };

    ///期权,期货报单查询请求
    struct CTdQryOptionsOrderField
    {
                                                        /// 所有过滤条件都不填,就查询当前登录的userid下所带客户的所有报单
        TdClientIdType          ClientId;               /// [交易编码]
        TdInstrumentIdType      InstrumentId;           /// [合约编码]
        TdOrderSysIDType        OrderSysID;             /// [交易所报单编号]  默认值:0或空表示不过滤报单编号
        TdIntTimeType           BegTime;                /// [起始时间]        默认值:0 0表示不设起始时间
        TdIntTimeType           EndTime;                /// [结束时间]        默认值:0 0表示不设结束时间
        TdSideType              Side;                   /// [买卖方向]
        TdOrdStatusType         OrdStatus;              /// [订单状态]        默认值:0 0表示不过滤订单状态
        TdQryLimitType          LimitSession;           /// [限制当前session] 默认值:0 0表示不限制
        TdQryLimitType          LimitUserId;            /// [限制当前UserId]  默认值:0 0表示不限制
    };

    ///期权,期货报单查询应答
    struct CTdRspQryOptionsOrderField
    {
        TdRequestNoType         RequestNo;              //报单请求编号
        TdClientIdType          ClientId;
        TdInstrumentIdType      InstrumentId;
        TdClientNoType          ClientNo;               //交易编码序号
        TdInstrumentNoType      InstrumentNo;           //合约序号
        TdLocalOrderNoType      LocalOrderNo;           //会员内部订单编号
        TdPriceTypeType         PriceType;              //报单价格条件
        TdSideType              Side;                   //买卖方向
        TdOffsetFlagType        OffsetFlag;             //开平标记
        TdHedgeFlagType         HedgeFlag;              //投机套保标记
        TdTimeInForceType        TimeInForce;           //订单有效时间类型
        TdCoveredOrUncoveredType CoveredOrUncovered;    //备兑标签
        TdVolumeConditionType    VolumeCondition;       //成交量类型
        TdTrigConditionType     TrigCondition;          //触发条件
        TdVolumeType            Volume;                 //数量
        TdVolumeType            MinVolume;              //最小成交量
        TdPriceType             Price;                  //价格
        TdPriceType             StopPrice;              //止损价
        TdOwnerTypeType         OwnerType;              //订单所有类型
        TdExchangeIdType        ExchangeId;             //交易所代
        TdFrontNoType           FrontNo;                //处理本次报单的实际席位序号
        TdSessionNoType         SessionNo;              //发送该报单的session
        TdOrdStatusType         OrdStatus;              //订单状态
        TdIntTimeType           TransTime;              //发生时间
        TdOrderSysIDType        OrderSysId;             //交易所订单编号
        TdUserIDType            UserId;                 //原始报单交易用户代码
    };

    ///报价查询
    struct CTdQryQuoteOrderField
    {
                                                        /// 所有过滤条件都不填,就查询当前登录的userid下所带客户的所有报单
        TdClientIdType          ClientId;               /// [交易编码]
        TdInstrumentIdType      InstrumentId;           /// [合约编码]
        TdOrderSysIDType        OrderSysID;             /// [交易所报单编号] 默认值:0 0或空表示不过滤报单编号
        TdOrderSysIDType        BidOrderId;             /// [交易所报单编号] 默认值:0 0或空表示不过滤报单编号
        TdOrderSysIDType        AskOrderId;             /// [交易所报单编号] 默认值:0 0或空表示不过滤报单编号
        TdIntTimeType           BegTime;                /// [起始时间]       默认值:0 0表示不设起始时间. 
        TdIntTimeType           EndTime;                /// [结束时间]       默认值:0 0表示不设结束时间. 
        TdOrdStatusType         BidStatus;              /// [买方状态]       默认值:0 0表示不过滤订单状态
        TdOrdStatusType         AskStatus;              /// [卖方状态]       默认值:0 0表示不过滤订单状态
        TdQryLimitType          LimitSession;           /// [限制当前session] 默认值:0 0表示不限制
        TdQryLimitType          LimitUserId;            /// [限制当前UserId]  默认值:0 0表示不限制
    };

    ///报价查询应答
    struct CTdRspQryQuoteOrderField
    {
        TdRequestNoType         RequestNo;              //报单请求编号
        TdClientIdType          ClientId;
        TdInstrumentIdType      InstrumentId;
        TdClientNoType          ClientNo;               //交易编码序号
        TdInstrumentNoType      InstrumentNo;           //合约序号
        TdLocalOrderNoType      LocalOrderNo;           //会员内部订单编号
        TdQuoteReqIDType        QuoteReqId;             //报价请求ID,预留字段,当报价是对请求的响应时，填写报价请求的ID
        TdPriceType             BidPx;                  //买报价
        TdPriceType             AskPx;                  //卖报价
        TdVolumeType            BidSize;                //买数量
        TdVolumeType            AskSize;                //卖数量
        TdOffsetFlagType        BidOffsetFlag;          //平仓标识
        TdOffsetFlagType        AskOffsetFlag;          //平仓标识
        TdOwnerTypeType         OwnerType;              //订单所有类型
        TdExchangeIdType        ExchangeId;             //交易所代码
        TdFrontNoType           FrontNo;                //处理本次报单的实际席位序号
        TdSessionNoType         SessionNo;              //发送该报单的session
        TdOrderSysIDType        OrderSysId;             //交易所订单编号
        TdOrderSysIDType        BidOrderId;             //买方交易所订单编号
        TdOrderSysIDType        AskOrderId;             //卖方交易所订单编号
        TdOrdStatusType         BidStatus;              //买方状态
        TdOrdStatusType         AskStatus;              //卖方状态
        TdIntTimeType           TransTime;              //发生时间
        TdUserIDType            UserId;                 //原始报单交易用户代码
    };

    ///股票成交查询
    struct CTdQryStockTradeField
    {
                                                        /// 所有过滤条件都不填,就查询当前登录的userid下所带客户的所有成交
        TdClientIdType          ClientId;               /// [交易编码]
        TdInstrumentIdType      InstrumentId;           /// [合约编码]
        TdOrderSysIDType        OrderSysID;             /// [交易所报单编号] 默认值:0或空表示不过滤报单编号
        TdTradeIDType           TradeId;                /// [成交编号]
        TdSequenceNoType        BegSeqNo;               /// [起始回报流序号] 默认值:0 0表示不设起始要求 
        TdSequenceNoType        EndSeqNo;               /// [结束回报流序号] 默认值:0 0表示不设结束要求 
        TdIntTimeType           BegTime;                /// [起始时间]       默认值:0 0表示不设起始时间 
        TdIntTimeType           EndTime;                /// [结束时间]       默认值:0 0表示不设结束时间
        TdSideType              Side;                   /// [买卖方向]
        TdQryLimitType          LimitSession;           /// [限制当前session] 默认值:0 0表示不限制
        TdQryLimitType          LimitUserId;            /// [限制当前UserId]  默认值:0 0表示不限制
    };

    ///股票成交查询应答
    struct CTdRspQryStockTradeField
    {
        TdFrontNoType           FrontNo;                //处理本次报单的实际席位序号
        TdSequenceNoType        SequenceNo;             //回报序号(私有流序号每个交易日连续)
        TdRequestNoType         RequestNo;              //报单请求编号
        TdSessionNoType         SessionNo;              //原始报单session
        TdClientNoType          ClientNo;
        TdInstrumentNoType      InstrumentNo;
        TdLocalOrderNoType      LocalOrderNo;
        TdClientIdType          ClientId;
        TdInstrumentIdType      InstrumentId;
        TdExchangeIdType        ExchangeId;             //交易所代码
        TdSideType              Side;                   //买卖方向
        TdPriceType             TradePrice;             //成交价格
        TdVolumeType            TradeVolume;            //成交数量
        TdVolumeType            LeavesVolume;           //本次成交后申报余额数量
        TdIntTimeType           TradeTime;              //成交时间
        TdOrderSysIDType        OrderSysId;             //交易所报单编号
        TdTradeIDType           TradeId;                //成交编号
        TdUserIDType            UserId;                 //原始报单交易用户代码
    };

    ///期货、期权成交查询请求
    struct CTdQryOptionsTradeField
    {
                                                        /// 所有过滤条件都不填,就查询当前登录的userid下所带客户的所有成交
        TdClientIdType          ClientId;               /// [交易编码]
        TdInstrumentIdType      InstrumentId;           /// [合约编码]
        TdOrderSysIDType        OrderSysID;             /// [交易所报单编号]默认值:0或空表示不过滤报单编号
        TdTradeIDType           TradeId;                /// [成交编号]
        TdSequenceNoType        BegSeqNo;               /// [起始回报流序号] 默认值:0 0表示不设起始要求  
        TdSequenceNoType        EndSeqNo;               /// [结束回报流序号] 默认值:0 0表示不设结束要求  
        TdIntTimeType           BegTime;                /// [起始时间]       默认值:0 0表示不设起始时间
        TdIntTimeType           EndTime;                /// [结束时间]       默认值:0 0表示不设结束时间  
        TdSideType              Side;                   /// [买卖方向]
        TdQryLimitType          LimitSession;           /// [限制当前session] 默认值:0 0表示不限制
        TdQryLimitType          LimitUserId;            /// [限制当前UserId]  默认值:0 0表示不限制
    };

    ///期货、期权成交查询应答
    struct CTdRspQryOptionsTradeField
    {
        TdFrontNoType           FrontNo;
        TdSequenceNoType        SequenceNo;             //回报序号
        TdRequestNoType         RequestNo;              //报单请求编号
        TdLocalOrderNoType      LocalOrderNo;
        TdSessionNoType         SessionNo;              //原始报单session
        TdClientNoType          ClientNo;
        TdInstrumentNoType      InstrumentNo;
        TdClientIdType          ClientId;
        TdInstrumentIdType      InstrumentId;
        TdExchangeIdType        ExchangeId;             //交易所代码
        TdPriceTypeType         PriceType;              //报单价格条件
        TdSideType              Side;                   //买卖方向
        TdOffsetFlagType        OffsetFlag;             //开平标记
        TdHedgeFlagType         HedgeFlag;              //投机套保标记
        TdTimeInForceType          TimeInForce;         //有效期类型
        TdCoveredOrUncoveredType   CoveredOrUncovered;  //备兑标签
        TdVolumeConditionType      VolumeCondition;     //成交量类型
        TdTrigConditionType        TrigCondition;       //触发条件
        TdOwnerTypeType            OwnerType;           //订单所有类型
        TdPriceType                TradePrice;          //成交价格
        TdVolumeType               TradeVolume;         //成交数量
        TdVolumeType               LeavesVolume;        //本次成交后申报余额数量
        TdIntTimeType              TransTime;           //成交时间
        TdOrderSysIDType           OrderSysId;          //交易所报单编号
        TdTradeIDType              TradeId;             //成交编号
        TdUserIDType               UserId;              //原始报单交易用户代码
    };

    ///期货、期权持仓查询请求
    struct CTdQryOptionsPositionField
    {
        TdClientIdType        ClientId;                 /// <交易编码>     必填项:不填返回错误提醒
        TdInstrumentIdType    InstrumentId;             /// [合约编码]     默认值:0 0或空表示查询所有合约
        TdSideType            Side;                     /// [买卖方向]     默认值:0 0表示不限制买卖方向
        TdCoveredOrUncoveredType CoveredOrUn;           /// [备兑标记]     默认值:0 0表示不限制备兑标记
    };

    ////期货、期权持仓查询应答
    struct CTdRspQryOptionsPositionField
    {
        TdClientNoType              ClientNo;
        TdInstrumentNoType          InstrumentNo;
        TdClientIdType              ClientId;
        TdInstrumentIdType          InstrumentId;
        TdExchangeIdType            ExchangeId;         /// 交易所代码
        TdCoveredOrUncoveredType    Converd;            /// 备兑标记
        TdSideType                  Side;               /// 买卖方向
        TdVolumeType                YdPosition;         /// 上日持仓
        TdVolumeType                Position;           /// 总持仓
        TdVolumeType                TodayPosition;      /// 今日持仓
        TdVolumeType                FrozenVolume;       /// 冻结数量
        TdVolumeType                BuyTradeVolume;     /// 当日买成交量
        TdVolumeType                SellTradeVolume;    /// 当日卖成交量
        TdPriceType                 Price;              /// 持仓价格
        TdMoneyType                 UseMargin;          /// 占用的保证金(权利金)
    };

    //股票持仓查询请求
    struct CTdQryStockPositionField
    {
        TdClientIdType              ClientId;            /// <交易编码>   必填项:不填返回错误提醒
        TdInstrumentIdType          InstrumentId;        /// [合约编码]   默认值:0 0或空表示查询所有合约
    };

    //股票持仓查询应答
    struct CTdRspQryStockPositionField
    {
        TdClientNoType            ClientNo;
        TdInstrumentNoType        InstrumentNo;
        TdClientIdType            ClientId;
        TdInstrumentIdType        InstrumentId;
        TdExchangeIdType          ExchangeId;           /// 交易所代码
        TdVolumeType              YdPosition;           /// 上日持仓
        TdVolumeType              Position;             /// 总持仓
        TdVolumeType              TodayPosition;        /// 今日持仓
        TdVolumeType              FrozenVolume;         /// 冻结数量
        TdVolumeType              BuyTradeVolume;       /// 当日买成交量
        TdVolumeType              SellTradeVolume;      /// 当日卖成交量
        TdPriceType               Price;                /// 持仓价格
        TdVolumeType              LockVolume;           /// 锁仓数量(已经被锁定的可用于备兑开仓的数量)
        TdVolumeType              FrozenLock;           /// 锁仓冻结数量(解锁时冻结的数量)
    };

    //组合持仓查询请求
    struct CTdQryCombPositionField
    {
        TdClientIdType          ClientId;               /// <交易编码>   必填项:不填返回错误提醒
        TdCombIDType            CombID;                 /// [组合策略编码]   默认值:空 空表示查询所有组合类型, 目前为7种组合策略：CNSJC、PXSJC、PNSJC、CXSJC、KS、KKS、ZBD
        TdOrderSysIDType        CombInstId;             /// [组合编码]       默认值:空 空表示查询所有组合持仓
    };

    //组合持仓查询应答
    struct CTdRspQryCombPositionField
    {
        TdClientNoType        ClientNo;
        TdClientIdType        ClientId;
        TdExchangeIdType      ExchangeId;           /// 交易所代码
        TdInstrumentIdType    CombId;               /// 组合策略编码:目前为7种组合策略：CNSJC、PXSJC、PNSJC、CXSJC、KS、KKS、ZBD
        TdOrderSysIDType      CombInstId;           /// 组合编码。组合申报时，该字段为空格；拆分申报时，填写拟拆分组合的组合编码
        TdVolumeType          Volume;               /// 持仓数量
        TdVolumeType          FrozenVolume;         /// 冻结数量
        TdPriceType           ComMargin;            /// 优惠的保证金
        int NoLeges;                                /// 成分合约数，取值不超过4，后接重复组
        OmlItemRtn item[4];
    };

    ///资金查询
    struct CTdQryAccountField
    {
        TdAccountIDType    AccountId;                /// <资金帐号>   必填项:不填返回错误提醒
    };

    ///资金查询应答
    struct CTdRspQryAccountField
    {
        TdAccountIDType    AccountId;                /// 资金帐号
        TdMoneyType    Prebalance;                   /// 昨权益(为资金账号昨日结算后的权益)
        TdMoneyType    DistribFund;                  /// 本系统分配资金(本系统日初初始分配的权益,即日初时的可用+保证金占用)
        TdMoneyType    Balance;                      /// 结算准备金
        TdMoneyType    Commi;                        /// 手续费
        TdMoneyType    FutMargin;                    /// 当前期货保证金总额
        TdMoneyType    OptMargin;                    /// 当前期权保证金总额
        TdMoneyType    CombMargin;                   /// 当前保证金优惠总额
        TdMoneyType    CloseProfit;                  /// 平仓盈亏
        TdMoneyType    PosiProfit;                   /// 持仓盈亏(浮动盈亏)
        TdMoneyType    Premium;                      /// 期权权利金收支(如果是现货账户则保存开仓时的持仓金额)
        TdMoneyType    Deposit;                      /// 入金金额
        TdMoneyType    Withdraw;                     /// 出金金额
        TdMoneyType    FrozenMargin;                 /// 冻结的保证金
        TdMoneyType    FrozenPremium;                /// 冻结的权利金
        TdMoneyType    FrozenCommi;                  /// 冻结的手续费
        TdMoneyType    EntryFees;                    /// 当日申报费用
        TdMoneyType    BuyPremium;                   /// 权力仓当前占用的权利金(如果是现货账户则表示持仓占用的金额)
    };

    ///行权查询请求
    struct CTdQryExerciseField
    {
                                                        /// 所有过滤条件都不填,就查询当前登录的userid下所带客户的所有行权
        TdClientIdType          ClientId;               /// [交易编码]
        TdInstrumentIdType      InstrumentId;           /// [合约编码]    默认值:0 0或空表示查询所有合约
        TdOrderSysIDType        OrderSysID;             /// [交易所报单编号]默认值:0或空表示不过滤报单编号
        TdIntTimeType           BegTime;                /// [起始时间]    默认值:0 0表示不设起始时间 
        TdIntTimeType           EndTime;                /// [结束时间]    默认值:0 0表示不设结束时间
        TdOrdStatusType         OrdStatus;              /// [订单状态]    默认值:0 0表示不过滤订单状态
    };

    ///行权查询应答
    struct CTdRspQryExerciseField
    {
        TdClientNoType          ClientNo;               //交易编码序号
        TdInstrumentNoType      InstrumentNo;           //合约序号
        TdClientIdType          ClientId;               //交易编码
        TdInstrumentIdType      InstrumentId;           //合约编码
        TdLocalOrderNoType      LocalOrderNo;           //会员内部订单编号
        TdVolumeType            Volume;                 //申报数量
        TdOwnerTypeType         OwnerType;              //订单所有类型
        TdExchangeIdType        ExchangeId;             //交易所代码
        TdFrontNoType           FrontNo;                //处理本次报单的实际席位序号
        TdSessionNoType         SessionNo;              //发送该报单的session
        TdOrdStatusType         OrdStatus;              //订单状态
        TdIntTimeType           TransTime;              //发生时间
        TdOrderSysIDType        OrderSysId;             //交易所订单编号
        TdUserIDType            UserId;                 //原始报单交易用户代码
    };

    ///组合行权查询请求
    struct CTdQryCombExerciseField
    {
                                                        /// 所有过滤条件都不填,就查询当前登录的userid下所带客户的所有组合行权
        TdClientIdType          ClientId;               /// [交易编码]
        TdInstrumentIdType      InstrumentId1;          /// [合约编码1]  默认值:0 0或空表示不过滤第一个合约
        TdInstrumentIdType      InstrumentId2;          /// [合约编码2]  默认值:0 0或空表示不过滤第二个合约
        TdOrderSysIDType        OrderSysID;             /// [交易所报单编号]默认值:0 0或空表示不过滤报单编号
        TdIntTimeType           BegTime;                /// [起始时间]   默认值:0 0表示不设起始时间 
        TdIntTimeType           EndTime;                /// [结束时间]   默认值:0 0表示不设结束时间 
        TdOrdStatusType         OrdStatus;              /// [订单状态]   默认值:0 0表示不过滤订单状态
    };

    ///组合行权查询应答
    struct CTdRspQryCombExerciseField
    {
        TdClientNoType          ClientNo;               //交易编码序号
        TdClientIdType          ClientId;               //交易编码
        TdLocalOrderNoType      LocalOrderNo;           //会员内部订单编号
        TdVolumeType            Volume;                 //申报数量
        TdInstrumentNoType      LegInstrumentNo1;       //腿1合约序号
        TdInstrumentIdType      InstrumentId1;          //腿1合约号
        TdVolumeType            LegVolume1;             //腿1申报数量
        TdInstrumentNoType      LegInstrumentNo2;       //腿2合约序号
        TdInstrumentIdType      InstrumentId2;          //腿2合约号
        TdVolumeType            LegVolume2;             //腿2申报数量
        TdOwnerTypeType         OwnerType;              //订单所有类型
        TdExchangeIdType        ExchangeId;             //交易所代码
        TdFrontNoType           FrontNo;                //处理本次报单的实际席位序号
        TdSessionNoType         SessionNo;              //发送该报单的session
        TdOrdStatusType         OrdStatus;              //订单状态
        TdIntTimeType           TransTime;              //发生时间
        TdOrderSysIDType        OrderSysId;             //交易所订单编号
        TdUserIDType            UserId;                 //原始报单交易用户代码
    };

    //查询交易编码应答
    struct CTdRspQryClientField
    {
        TdClientNoType          ClientNo;
        TdClientIdType          ClientId;               // 交易编码
        TdClientType            ClientType;             // 交易编码类型
        TdExchangeIdType        ExchangeId;             // 交易所
        TdTradeStatusType       Status;                 // 交易编码交易状态
    };
    typedef std::list< CTdRspQryClientField>        TdRspQryClientList;

    //查询前置应答
    struct CTdRspQryFrontField
    {
        TdFrontNoType           FrontNo;                //席位序号
        TdExchangeIdType        ExchangeId;             //交易所
        TdPartyTypeType         PartyType;              //席位类型
        TdPartyIdType           PartyId;                //席位信息
    };
    typedef std::list< CTdRspQryFrontField>            TdRspQryFrontFieldList;

    ///合约查询应答
    struct CTdRspQryInstrumentField
    {
        TdInstrumentNoType      InstrumentNo;
        TdInstrumentIdType      InstrumentId;           //合约代码
        TdExchangeIdType        ExchangeId;             //交易所代码
        TdInstrumentNameType    InstrumentName;         //合约名称
        TdProductIdType         ProductId;              //产品代码
        TdInstrumentIdType      UnderlyingInstrId;      //标的商品代码
        TdProductType           ProductType;            //产品类型
        TdCallOrPutType         OptionsType;            //期权类型
        TdIntType               Volumemultiple;         //合约数量乘数
        TdIntType               DeliveryYear;           //交割年份
        TdIntType               DeliveryMonth;          //交割月
        TdIntType               AdvanceMonth;           //提前月份
        TdTradeStatusType       TradeStatus;            //交易权限
        TdDateType              CreateDate;             //创建日
        TdDateType              OpenDate;               //上市日
        TdDateType              ExpireDate;             //到期日
        TdDateType              StartdelivDate;         //开始交割日
        TdDateType              EnddelivDate;           //最后交割日
        TdPriceType             BasisPrice;             //挂牌基准价
        TdPriceType             StrikePrice;            //行权价格
        TdVolumeType            MaxMarketOrderVolume;   //市价单最大下单量
        TdVolumeType            MinMarketOrderVolume;   //市价单最小下单量
        TdVolumeType            MaxLimitOrderVolume;    //限价单最大下单量
        TdVolumeType            MinLimitOrderVolume;    //限价单最小下单量
        TdPriceType             PriceTick;              //最小变动价位
        //以下为行情信息
        TdPriceType            LastPrice;               //最新价
        TdPriceType            SettlementPrice;         //昨日结算价
        TdPriceType            UpperLimitPrice;         //涨停板价格
        TdPriceType            LowerLimitPrice;         //跌停板价格
    };
    typedef std::list<CTdRspQryInstrumentField>        TdRspQryInstrumentFieldList;

    ///费率信息
    struct CTdRateField
    {
        TdClientNoType         ClientNo;
        TdClientIdType         ClientId;            //交易编码
        TdInstrumentNoType     InstrumentNo;
        TdInstrumentIdType     InstrumentId;        ///合约代码
        TdMoneyType            OpenByMoney;         //开仓手续费率
        TdMoneyType            OpenByVolume;        //开仓手续费
        TdMoneyType            CloseByMoney;        //平仓手续费率
        TdMoneyType            CloseByVolume;       //平仓手续费
        TdMoneyType            CloseTodayByMoney;   //平今手续费率
        TdMoneyType            CloseTodayByVolume;  //平今手续费
        TdMoneyType            OpenMax;             //开仓单笔最高手续费
        TdMoneyType            OpenMin;             //开仓单笔最低手续费
        TdMoneyType            CloseMax;            //平仓单笔最高手续费
        TdMoneyType            CloseMin;            //平仓单笔最低手续费
        //
        TdMoneyType           Param1;                //参数1
        TdMoneyType           Param2;                //参数2
        TdMoneyType           MarginRate;            //在交易所基础上收取的比例
        //
        TdMoneyType             LongbyMoney;        //多头保证金率
        TdMoneyType             LongbyVolume;       //多头保证金费
        TdMoneyType             ShortbyMoney;       //空头保证金率
        TdMoneyType             ShortbyVolume;      //空头保证金率
    };
    typedef std::list<CTdRateField>        CTdRateFieldList;

    ///查询手续费应答
    struct CTdRspQryRateField
    {
        TdClientNoType         ClientNo;
        TdClientIdType         ClientId;            //交易编码
        TdInstrumentNoType     InstrumentNo;
        TdInstrumentIdType     InstrumentId;        ///合约代码
        TdMoneyType            OpenByMoney;         //开仓手续费率
        TdMoneyType            OpenByVolume;        //开仓手续费
        TdMoneyType            CloseByMoney;        //平仓手续费率
        TdMoneyType            CloseByVolume;       //平仓手续费
        TdMoneyType            CloseTodayByMoney;   //平今手续费率
        TdMoneyType            CloseTodayByVolume;  //平今手续费
        TdMoneyType            OpenMax;             //开仓单笔最高手续费
        TdMoneyType            OpenMin;             //开仓单笔最低手续费
        TdMoneyType            CloseMax;            //平仓单笔最高手续费
        TdMoneyType            CloseMin;            //平仓单笔最低手续费
    };
    typedef std::list<CTdRspQryRateField>        TdRspQryRateFieldList;

    ///期权保证金应答
    struct CTdRspQryOptMarginField
    {
        TdClientNoType        ClientNo;
        TdClientIdType        ClientId;              //交易编码
        TdInstrumentNoType    InstrumentNo;
        TdInstrumentIdType    InstrumentId;          //合约代码
        TdMoneyType           Param1;                //参数1
        TdMoneyType           Param2;                //参数2
        TdMoneyType           MarginRate;            //在交易所基础上收取的比例
    };
    typedef std::list<CTdRspQryOptMarginField>        TdRspQryOptMarginFieldList;

    ///期货保证金应答
    struct CTdRspQryFutMarginField
    {
        TdClientNoType          ClientNo;
        TdClientIdType          ClientId;           //交易编码
        TdInstrumentNoType      InstrumentNo;
        TdInstrumentIdType      InstrumentId;       //合约代码
        TdMoneyType             LongbyMoney;        //多头保证金率
        TdMoneyType             LongbyVolume;       //多头保证金费
        TdMoneyType             ShortbyMoney;       //空头保证金率
        TdMoneyType             ShortbyVolume;      //空头保证金率
    };
    typedef std::list<CTdRspQryFutMarginField>        TdRspQryFutMarginFieldList;

    ///查询行情请求
    struct CTdQryMarketDataField
    {                                               //{合约No}、{合约代码}任选其一，两者都填，以合约No为准
        TdInstrumentNoType    InstrumentNo;         //{合约No}
        TdInstrumentIdType    InstrumentId;         //{合约代码}
    };

    ///查询行情应答
    struct CTdRspQryMarketDataField
    {
        TdInstrumentNoType     InstrumentNo;        //合约No
        TdInstrumentIdType     InstrumentId;        //合约代码
        TdPriceType            LastPrice;           //最新价
        TdPriceType            SettlementPrice;     //昨日结算价
        TdPriceType            UpperlimitPrice;     //涨停板价格
        TdPriceType            LowerlimitPrice;     //跌停板价格
    };

    ///查询通知请求
    struct CTdQryNotifyField
    {
        TdSequenceNoType        BegSeqNo;           /// [起始回报流序号] 默认值:0 0表示不设起始要求 
        TdSequenceNoType        EndSeqNo;           /// [结束回报流序号] 默认值:0 0表示不设结束要求 
    };
}

#endif
