﻿#ifndef __TI_TD_API_DATA_TYPE_H__
#define __TI_TD_API_DATA_TYPE_H__


namespace titd
{
    enum TI_RESUME_TYPE
    {
        TERT_RESTART = 0,
        TERT_RESUME,
        TERT_QUICK
    };

    /////////////////////////////////////////////////////////////////////////
    ///TdErrorIDType错误代码类型
    /////////////////////////////////////////////////////////////////////////
    typedef int TdErrorIDType;

    /////////////////////////////////////////////////////////////////////////
    ///TdIntType普通的整形类型
    /////////////////////////////////////////////////////////////////////////
    typedef int TdIntType;

    /////////////////////////////////////////////////////////////////////////
    ///TdErrorMsgType错误信息类型
    /////////////////////////////////////////////////////////////////////////
    typedef char TdErrorMsgType[81];

    /////////////////////////////////////////////////////////////////////////
    ///TdTradingSystemNameType交易系统名称类型
    /////////////////////////////////////////////////////////////////////////
    typedef char TdTradingSystemNameType[61];

    /////////////////////////////////////////////////////////////////////////
    ///TdUserIDType登录用户代码类型
    /////////////////////////////////////////////////////////////////////////
    typedef char TdUserIDType[16];

    /////////////////////////////////////////////////////////////////////////
    ///TdAccountIDType资金账户类型
    /////////////////////////////////////////////////////////////////////////
    typedef char TdAccountIDType[16];

    /////////////////////////////////////////////////////////////////////////
    ///TdPasswordType密码类型
    /////////////////////////////////////////////////////////////////////////
    typedef char TdPasswordType[41];

    /////////////////////////////////////////////////////////////////////////
    ///TdProductInfoType产品信息类型
    /////////////////////////////////////////////////////////////////////////
    typedef char TdProductInfoType[41];

    /////////////////////////////////////////////////////////////////////////
    ///TdSessionNoType 登录会话序号类型
    /////////////////////////////////////////////////////////////////////////
    typedef int TdSessionNoType;

    /////////////////////////////////////////////////////////////////////////
    ///TdFrontNoType席位序号类型(每个交易所不同业务的席位序号单独排序，如上交所序号1-N，深交所序号也是1-N)
    /////////////////////////////////////////////////////////////////////////
    typedef char TdFrontNoType;

    /////////////////////////////////////////////////////////////////////////
    ///TdTimeType接受请求时间类型，格式为HHMMSS
    /////////////////////////////////////////////////////////////////////////
    typedef char TdTimeType[13];

    /////////////////////////////////////////////////////////////////////////
    ///TdIntTimeType int格式的时间，格式为HHMMSS
    /////////////////////////////////////////////////////////////////////////
    typedef unsigned int TdIntTimeType;

    /////////////////////////////////////////////////////////////////////////
    ///TdSequenceNoType 私有流编号
    /////////////////////////////////////////////////////////////////////////
    typedef unsigned int TdSequenceNoType;

    /////////////////////////////////////////////////////////////////////////
    ///TdRequestNoType 序号
    /////////////////////////////////////////////////////////////////////////
    typedef unsigned int TdRequestNoType;

    /////////////////////////////////////////////////////////////////////////
    ///TdPartyIdType交易席位Id
    /////////////////////////////////////////////////////////////////////////
    typedef char TdPartyIdType[26];

    /////////////////////////////////////////////////////////////////////////
    ///TdDateType日期类型，格式为YYYYMMDD
    /////////////////////////////////////////////////////////////////////////
    typedef char TdDateType[9];

    /////////////////////////////////////////////////////////////////////////
    ///TdAppIdType AppId类型
    /////////////////////////////////////////////////////////////////////////
    typedef char TdAppIdType[31];

    /////////////////////////////////////////////////////////////////////////
    ///TdAppIdIdentifyType AppId验证码
    /////////////////////////////////////////////////////////////////////////
    typedef char TdAppIdIdentifyType[31];

    /////////////////////////////////////////////////////////////////////////
    ///TdLocalOrderNoType会员内部编号类型
    //如果为0，系统不进行判断，否则在所有申报业务范围内，同一个session内编号必须唯一且递增
    /////////////////////////////////////////////////////////////////////////
    typedef int TdLocalOrderNoType;

    /////////////////////////////////////////////////////////////////////////
    ///TdPriceType价格类型
    /////////////////////////////////////////////////////////////////////////
    typedef double TdPriceType;

    /////////////////////////////////////////////////////////////////////////
    ///TdMoneyType金额类型
    /////////////////////////////////////////////////////////////////////////
    typedef double TdMoneyType;

    /////////////////////////////////////////////////////////////////////////
    ///TdVolumeType数量类型
    /////////////////////////////////////////////////////////////////////////
    typedef int TdVolumeType;

    /////////////////////////////////////////////////////////////////////////
    ///TdClientNoType交易编码序号类型
    /////////////////////////////////////////////////////////////////////////
    typedef int TdClientNoType;

    /////////////////////////////////////////////////////////////////////////
    ///TdClientIdType交易编码类型
    /////////////////////////////////////////////////////////////////////////
    typedef char TdClientIdType[11];

    /////////////////////////////////////////////////////////////////////////
    ///TdInstrumentNoType合约序号类型
    /////////////////////////////////////////////////////////////////////////
    typedef int TdInstrumentNoType;

    /////////////////////////////////////////////////////////////////////////
    ///TdInstrumentIdType合约编码类型
    /////////////////////////////////////////////////////////////////////////
    typedef char TdInstrumentIdType[31];

    /////////////////////////////////////////////////////////////////////////
    ///TdInstrumentNameType合约名称
    /////////////////////////////////////////////////////////////////////////
    typedef char TdInstrumentNameType[31];

    /////////////////////////////////////////////////////////////////////////
    ///TdProductIdType产品代码
    /////////////////////////////////////////////////////////////////////////
    typedef char TdProductIdType[26];

    /////////////////////////////////////////////////////////////////////////
    ///TdProtocolInfoType协议信息类型
    /////////////////////////////////////////////////////////////////////////
    typedef char TdProtocolInfoType[41];

    /////////////////////////////////////////////////////////////////////////
    ///TdOrderSysIDType交易所订单编号类型
    /////////////////////////////////////////////////////////////////////////
    typedef char TdOrderSysIDType[17];

    /////////////////////////////////////////////////////////////////////////
    ///TdQuoteReqIDType报价请求ID类型
    /////////////////////////////////////////////////////////////////////////
    typedef char TdQuoteReqIDType[11];

    /////////////////////////////////////////////////////////////////////////
    ///TdTradeVolumeType成交数量类型
    /////////////////////////////////////////////////////////////////////////
    typedef int TdTradeVolumeType;

    /////////////////////////////////////////////////////////////////////////
    ///TdTradeIDType成交编号类型
    /////////////////////////////////////////////////////////////////////////
    typedef char TdTradeIDType[17];

    /////////////////////////////////////////////////////////////////////////
    ///TdCombIDType组合策略编码类型
    /////////////////////////////////////////////////////////////////////////
    typedef char TdCombIDType[9];

    /////////////////////////////////////////////////////////////////////////
    ///TdExchangeIdType交易所编号类型
    /////////////////////////////////////////////////////////////////////////
    ///上海证券交易所
    #define TD_Exchange_Sse        1
    ///深圳证券交易所
    #define TD_Exchange_Szse     2
    ///中金所
    #define TD_Exchange_Cffex     3
    ///上期所
    #define TD_Exchange_Shfe     4
    ///上海能源交易所
    #define TD_Exchange_Ine     5
    ///大连商品期货交易所
    #define TD_Exchange_Dce     6
    ///郑州商品期货交易所
    #define TD_Exchange_Zce     7
    ///广州商品期货交易所
    #define TD_Exchange_Gfex 	8

    typedef char TdExchangeIdType;

    /////////////////////////////////////////////////////////////////////////
    ///TdOffsetFlagType开平标志类型
    /////////////////////////////////////////////////////////////////////////
    ///开仓
    #define TD_OC_Open          1
    ///平仓
    #define TD_OC_Close         2
    ///平今
    #define TD_OC_CloseToday    3
    typedef char TdOffsetFlagType;

    /////////////////////////////////////////////////////////////////////////
    ///TdPriceTypeType报单价格条件
    //TD_PriceType_Best1: 上海证券交易所现货交易含义为该申报在对手方实时最优五个价位内以对手方价格为成交价逐次成交，剩余未成交部分自动撤销；
    //TD_PriceType_Best2: 上海证券交易所现货交易含义为该申报在对手方实时五个最优价位内以对手方价格为成交价逐次成交，剩余未成交部分按本申报最新成交价转为限价订单；
    //                      如无对手方申报与该申报成交的，则按本方最优报价转为限价订单；如无本方申报的，该市价订单自动撤销；
    //TD_PriceType_Best3: 上海证券交易所现货交易含义为该申报以其进入交易主机时，集中申报簿中本方最优报价为其申报价格。
    //                      如有本方申报的，则按本方最优报价转为限价订单；如无本方申报的，则该市价订单自动撤销
    //TD_PriceType_Best4: 上海证券交易所现货交易含义为该申报以其进入交易主机时，集中申报簿中对手方最优报价为其申报价格。
    //                      如有对手方申报，以对手方最优价为成交价与对手方撮合成交，剩余未成交部分按本申报最新成交价转为限价订单；如无对手方申报，该市价订单自动撤销；

    /////////////////////////////////////////////////////////////////////////
    ///市价(TimeInForce取值为:TD_TimeInForce_IOC)
    #define TD_PriceType_Market         1
    ///限价
    #define TD_PriceType_Limit          2
    ///本方最优剩余转限价
    #define TD_PriceType_BestPrice      3
    ///市价剩余转限价
    #define TD_PriceType_Market2Limit   4
    //最优五档即时成交剩余撤销的市价订单(TimeInForce取值为:TD_TimeInForce_IOC)
    #define TD_PriceType_Best1          5
    //表示最优五档即时成交剩余转限价的市价订单
    #define TD_PriceType_Best2          6
    //本方最优价格(TimeInForce取值为:TD_TimeInForce_IOC时剩余撤销,取值为:TD_TimeInForce_GFD时剩余转限价)
    #define TD_PriceType_Best3          7
    //对手方最优价格(TimeInForce取值为:TD_TimeInForce_IOC时剩余撤销,取值为:TD_TimeInForce_GFD时剩余转限价)
    #define TD_PriceType_Best4          8

    typedef char TdPriceTypeType;

    /////////////////////////////////////////////////////////////////////////
    ///TdTimeInForceType订单有效时间类型类型
    /////////////////////////////////////////////////////////////////////////
    ///当日有效
    #define TD_TimeInForce_GFD      1
    ///本节有效
    #define TD_TimeInForce_GIS      2
    ///即时成交剩余撤销
    #define TD_TimeInForce_IOC      3
    ///全部成交否则撤销
    #define TD_TimeInForce_FOK      4
    typedef char TdTimeInForceType;

    /////////////////////////////////////////////////////////////////////////
    ///TdCoveredOrUncoveredType备兑标签类型
    /////////////////////////////////////////////////////////////////////////
    ///备兑
    #define TD_Covered_Covered       1
    ///非备兑
    #define TD_Covered_Uncovered     2
    typedef char TdCoveredOrUncoveredType;

    /////////////////////////////////////////////////////////////////////////
    ///TdCombType组合与拆分组合标记
    /////////////////////////////////////////////////////////////////////////
    ///组合
    #define TD_Comb_Combed          'B'
    ///拆分组合
    #define TD_Comb_UnCombed        'C'
    typedef char TdCombType;

    /////////////////////////////////////////////////////////////////////////
    ///TdLegSideType单腿合约方向
    /////////////////////////////////////////////////////////////////////////
    ///权力仓
    #define TD_LegSide_Long        'L'
    ///义务仓
    #define TD_LegSide_Short       'S'
    typedef char TdLegSideType;

    /////////////////////////////////////////////////////////////////////////
    ///TdVolumeConditionType成交量类型类型
    /////////////////////////////////////////////////////////////////////////
    ///任何数量
    #define TD_VC_AV                1
    ///最小数量
    #define TD_VC_MV                2
    ///全部数量
    #define TD_VC_CV                3
    typedef char TdVolumeConditionType;

    /////////////////////////////////////////////////////////////////////////
    ///TdTrigConditionType触发条件类型
    /////////////////////////////////////////////////////////////////////////
    ///立即
    #define TD_CC_Immediately        1
    ///止损
    #define TD_CC_Touch              2
    typedef char TdTrigConditionType;

    /////////////////////////////////////////////////////////////////////////
    ///TdOwnerType订单所有类型类型
    /////////////////////////////////////////////////////////////////////////
    ///个人投资者发起
    #define TD_OWNER_Per            1
    ///交易所发起
    #define TD_OWNER_Ex             101
    ///经营机构（包括其风险管理部门）发起
    #define TD_OWNER_Op             102
    ///机构投资者发起
    #define TD_OWNER_Institutional  103
    ///自营交易发起
    #define TD_OWNER_Proprietary    104
    ///流动性服务提供商发起
    #define TD_OWNER_Maker          105
    ///结算结构发起
    #define TD_OWNER_Clear          106
    typedef int TdOwnerTypeType;

    /////////////////////////////////////////////////////////////////////////
    ///TdSideType买卖方向类型
    /////////////////////////////////////////////////////////////////////////
    ///买
    #define TD_SIDE_Buy             1
    ///卖
    #define TD_SIDE_Sell            2
    typedef char TdSideType;

    /////////////////////////////////////////////////////////////////////////
    ///TdLockType锁定标志类型
    /////////////////////////////////////////////////////////////////////////
    ///锁定
    #define TD_LOCK_Lock            1
    ///解锁
    #define TD_LOCK_UnLock          2
    typedef char TdLockType;

    /////////////////////////////////////////////////////////////////////////
    ///TdAccountTypeType资金账户类型类型
    /////////////////////////////////////////////////////////////////////////
    ///现货账户
    #define TD_ACCOUNT_Stk          1
    ///衍生品账户
    #define TD_ACCOUNT_Opt          2
    typedef char TdAccountTypeType;

    /////////////////////////////////////////////////////////////////////////
    ///TdPartyTypeType席位类型
    /////////////////////////////////////////////////////////////////////////
    ///现货席位
    #define TD_PARTY_Stk            1
    ///衍生品席位
    #define TD_PARTY_Opt            2

    typedef char TdPartyTypeType;

    /////////////////////////////////////////////////////////////////////////
    ///TdHedgeFlagType投机套保标志类型
    /////////////////////////////////////////////////////////////////////////
    ///投机
    #define TD_HF_Speculation        1
    ///套利
    #define TD_HF_Arbitrage          2
    ///套保
    #define TD_HF_Hedge              3
    ///做市商
    #define TD_HF_MarketMaker        4

    typedef char TdHedgeFlagType;

    /////////////////////////////////////////////////////////////////////////
    ///TdClientType交易编码类型
    /////////////////////////////////////////////////////////////////////////
    ///投机
    #define TD_CTYPE_Speculation      1
    ///套利
    #define TD_CTYPE_Arbitrage        2
    ///套保
    #define TD_CTYPE_Hedge            3
    typedef char TdClientType;

    /////////////////////////////////////////////////////////////////////////
    ///TdOrdStatusType当前订单的状态类型
    /////////////////////////////////////////////////////////////////////////
    ///已报入
    #define TD_Status_Success           1
    ///部分成交
    #define TD_Status_Trade             2
    ///全部成交
    #define TD_Status_All               3
    ///已撤单
    #define TD_Status_Cancel            4
    ///已拒绝
    #define TD_Status_Reject            8
    typedef char TdOrdStatusType;

    /////////////////////////////////////////////////////////////////////////
    ///TdProductType产品类型类型
    /////////////////////////////////////////////////////////////////////////
    ///股票
    #define TD_Product_Stk          'S'
    ///期货
    #define TD_Product_Fut          'F'
    ///期权
    #define TD_Product_Opt          'O'
    ///基金
    #define TD_Product_EU           'E'
    ///债券、集合资产管理计划、债券预发行、定向可转债取
    #define TD_Product_D            'D'
    ///权证
    #define TD_Product_RWS          'R'
    ///公募REITs
    #define TD_Product_CB           'C'
    ///国债
    #define TD_Product_GBF          'G'
    typedef char TdProductType;

    /////////////////////////////////////////////////////////////////////////
    ///TdCallOrPutType期权类型类型
    /////////////////////////////////////////////////////////////////////////
    ///认购期权
    #define TD_Options_Call        'C'
    ///认沽期权
    #define TD_Options_Put         'P'
    typedef char TdCallOrPutType;

    /////////////////////////////////////////////////////////////////////////
    ///TdTradeStatusType交易编码交易状态类型
    /////////////////////////////////////////////////////////////////////////
    ///正常
    #define TD_Status_Normal        0
    ///禁止开仓
    #define TD_Status_NoOpen        1
    ///禁止交易
    #define TD_Status_NoTrade       2
    ///无权限
    #define TD_Status_NoRight       3
    typedef char TdTradeStatusType;

    /////////////////////////////////////////////////////////////////////////
    ///TdOptionTypeType期权类型类型
    /////////////////////////////////////////////////////////////////////////
    ///欧式期权
    #define TD_OptionType_E         'E'
    ///美式期权
    #define TD_OptionType_A         'A'
    typedef char TdOptionTypeType;

    /////////////////////////////////////////////////////////////////////////
    ///TdQryLimitType 查询限制条件类型
    /////////////////////////////////////////////////////////////////////////
    ///不限制
    #define TD_QryLimitType_L 0
    ///限制
    #define TD_QryLimitType_O 1
    typedef char TdQryLimitType;

    /////////////////////////////////////////////////////////////////////////
   ///TdInstStatusType合约状态状态类型
   /////////////////////////////////////////////////////////////////////////
   ///开盘前
   #define TD_InstStatus_PreOpen        0
   ///即将开放
   #define TD_InstStatus_OpenUpComing   1
   ///开放
   #define TD_InstStatus_Open           2
   ///暂停开放
   #define TD_InstStatus_Halt           3
   ///关闭
   #define TD_InstStatus_Close          4
   ///集合竞价报单
   #define TD_InstStatus_AuctionOrdering 5
   ///集合竞价价格平衡
   #define TD_InstStatus_AuctionBalance 6
   ///集合竞价撮合
   #define TD_InstStatus_AuctionMatch 7
   typedef char TdInstStatusType;



    /////////////////////////////////////////////////////////////////////////
    ///TdBusinessType股票非交易业务业务类型
    /////////////////////////////////////////////////////////////////////////
    ///上海、深圳发行
    #define TD_Business_SseIn       1
    ///上海配股、科创板配售
    #define TD_Business_SseR1       2
    ///上海配转债
    #define TD_Business_SseR4       3    
    ///上海要约预受
    #define TD_Business_SseFS       4 
    ///上海要约撤销
    #define TD_Business_SseFC       5 
    ///上海开放式基金申购
    #define TD_Business_SseOC       6 
    ///上海开放式基金赎回
    #define TD_Business_SseOR       7 
    ///上海开放式基金认购
    #define TD_Business_SseOS       8
    ///上海开放式基金转托管
    #define TD_Business_SseOT       9 
    ///上海开放式基金分红设置
    #define TD_Business_SseOD       10 
    ///上海开放式基金转换
    #define TD_Business_SseOV       11 
    ///上海余券划转
    #define TD_Business_SseST       12 
    ///上海还券划转
    #define TD_Business_SseSR       13 
    ///上海担保品划入
    #define TD_Business_SseCI       14 
    ///上海担保品划出
    #define TD_Business_SseCO       15 
    ///上海券源划入
    #define TD_Business_SseSI       16 
    ///上海券源划出
    #define TD_Business_SseSO       17
    ///上海、深圳质押式回购(逆回购)
    #define TD_Business_SseCRP      18



    typedef char TdBusinessType;



    
}












#endif
