﻿#ifndef __TI_TD_API_H__
#define __TI_TD_API_H__

#include "TiDataStruct.h"


#if defined(_WIN32)
#ifdef LIB_TI_API_EXPORT
#define TI_API_EXPORT __declspec(dllexport)
#else
#define TI_API_EXPORT __declspec(dllimport)
#endif
#else
#define TI_API_EXPORT __attribute__ ((visibility ("default")))
#endif


namespace titd
{
    class CTiTdSpi
    {
    public:
        ///当客户端与交易后台建立起通信连接时（还未登录前），该方法被调用。
        virtual void OnConnected() {};

        ///当客户端与交易后台通信连接断开时，该方法被调用。当发生这个情况后，API会自动重新连接，客户端可不做处理。
        ///@param nReason 错误原因
        ///        0x1001 网络读失败
        ///        0x1002 网络写失败
        ///        0x2001 接收心跳超时
        ///        0x2002 发送心跳失败
        ///        0x2003 收到错误报文
        virtual void OnDisconnected(int nReason) {};

        ///用户登录应答
        virtual void OnRspUserLogin(CTdRspUserLoginField& pRspUserLogin, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///用户退出应答
        virtual void OnRspUserLogout(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///用户密码修改应答
        virtual void OnRspUserPasswordUpdate(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///股票报单应答
        virtual void OnRspStockInsert(CTdStockInsertRspField& pStockInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///股票撤单应答
        virtual void OnRspStockCancel(CTdOrderCancelRspField& pStockCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///股票非交易业务报单应答
        virtual void OnRspBusinessInsert(CTdBusinessInsertRspField& pStockInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///股票非交易业务撤单应答
        virtual void OnRspBusinessCancel(CTdOrderCancelRspField& pStockCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///证券锁定应答
        virtual void OnRspStockLock(CTdStockLockRspField& pStockLock, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///期权,期货报单应答
        virtual void OnRspOptionsInsert(CTdOrderInsertRspField& pOptionsInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///期权,期货撤单应答
        virtual void OnRspOptionsCancel(CTdOrderCancelRspField& pOptionsCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///期权,期货报价应答
        virtual void OnRspQuoteInsert(CTdQuoteInsertRspField& pQuoteInsert, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///期权,期货撤销报价应答
        virtual void OnRspQuoteCancel(CTdOrderCancelRspField& pQuoteCancel, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///询价应答
        virtual void OnRspForQuote(CTdForQuoteRspField& pForQuote, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///行权应答
        virtual void OnRspExercise(CTdExerciseRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///组合行权应答
        virtual void OnRspCombExercise(CTdCombExerciseRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///撤销行权应答
        virtual void OnRspExerciseCancel(CTdOrderCancelRspField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///客户申请组合应答
        virtual void OnRspMarginCombAction(CTdMarginCombActionRspField& pMarginCombAction, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///股票报单查询应答
        virtual void OnRspQryStockOrder(CTdRspQryStockOrderField& pOrder, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///股票非交易报单查询应答
        virtual void OnRspQryBusinessOrder(CTdRspQryBusinessOrderField& pOrder, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///期权,期货报单查询应答
        virtual void OnRspQryOptionsOrder(CTdRspQryOptionsOrderField& pOrder, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///报价查询应答
        virtual void OnRspQryQuoteOrder(CTdRspQryQuoteOrderField& pQuote, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///查询行权应答
        virtual void OnRspQryExercise(CTdRspQryExerciseField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///查询组合行权应答
        virtual void OnRspQryCombExercise(CTdRspQryCombExerciseField& pExercise, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///股票成交查询应答
        virtual void OnRspQryStockTrade(CTdRspQryStockTradeField& pTrade, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///期权,期货成交查询应答
        virtual void OnRspQryOptionsTrade(CTdRspQryOptionsTradeField& pTrade, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///期权,期货持仓查询应答
        virtual void OnRspQryOptionsPosition(CTdRspQryOptionsPositionField& pPosition, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///股票持仓查询应答
        virtual void OnRspQryStockPosition(CTdRspQryStockPositionField& pPosition, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///组合持仓查询应答
        virtual void OnRspQryCombPosition(CTdRspQryCombPositionField& pPosi, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///从服务端获取资金应答
        virtual void OnRspQryAccount(CTdRspQryAccountField& pAccount, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///行情查询应答
        virtual void OnRspQryMarketData(CTdRspQryMarketDataField& pMarketData, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///通知查询应答
        virtual void OnRspQryNotify(CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};

        ///期权,期货委托回报
        virtual void OnRtnOptionsOrder(CTdOptionsOrderRtnField& pOrder) {};

        ///股票委托回报
        virtual void OnRtnStockOrder(CTdStockOrderRtnField& pOrder) {};

        ///股票非交易业务委托回报
        virtual void OnRtnBusinessOrder(CTdBusinessOrderRtnField& pOrder) {};

        ///报价回报
        virtual void OnRtnQuoteOrder(CTdQuoteOrderRtnField& pQuote) {};

        ///期权,期货成交回报
        virtual void OnRtnOptionsTrade(CTdOptionsTradeRtnField& pTrade) {};

        ///股票成交回报
        virtual void OnRtnStockTrade(CTdStockTradeRtnField& pTrade) {};

        ///股票非交易业务成交回报
        virtual void OnRtnBusinessTrade(CTdBusinessTradeRtnField& pTrade) {};

        ///行权回报
        virtual void OnRtnExercise(CTdExerciseRtnField& pExercise) {};

        ///出入金通知
        virtual void OnRtnWithdrawDeposit(CTdWithdrawDepositRtnField& pWithdrawDeposit) {};

        ///客户申请组合通知
        virtual void OnRtnMarginCombAction(CTdMarginCombActionRtnField& pMarginCombAction) {};

        ///询价通知
        virtual void OnRtnForQuote(CTdForQuoteRtnField& pForQuote) {};

        ///合约状态变化通知
        virtual void OnRtnInstrumentStatus(CTdInstrumentStatusRtnField& pStatus) {};

        ///用户验证应答
        virtual void OnRspUserAuthentication(CTdRspUserAuthenField& pUserInfo, CTdRspInfoField& pRspInfo, int nRequestID, bool bIsLast) {};
    };

    class TI_API_EXPORT CTiTdApi
    {
    public:
        ///创建TraderApi
        ///@return 创建出的Api
        static CTiTdApi* CreateTiTdApi();

        ///获取系统版本号
        ///@return 系统标识字符串
        static const char* GetApiVersion();

        ///删除接口对象本身
        ///@remark 不再使用本接口对象时,调用该函数删除接口对象
        virtual void Release() = 0;

        ///注册回调接口(该方法必须在Init之前调用)
        ///@param pSpi 派生自回调接口类的实例
        virtual void RegisterSpi(CTiTdSpi* pSpi) = 0;

        ///初始化
        ///@param cfgInfo：初始化api所用的结构
        ///@remark 初始化运行环境,只有调用后,接口才开始工作
        virtual int Init(CTdConfigInfoField& cfgInfo) = 0;

        ///初始化
        ///@param cfgFile：初始化api的配置文件
        ///@remark 初始化运行环境,只有调用后,接口才开始工作
        virtual int Init(const char* cfgFile) = 0;

        ///获取交易编码
        virtual int GetClientList(TdRspQryClientList& output) = 0;

        ///根据交易编码获取交易编码信息
        virtual int GetClientInfo(char* clientId, CTdRspQryClientField& pClient) = 0;

        ///根据交易编码序号获取交易编码信息
        virtual int GetClientInfo(int clientNo, CTdRspQryClientField& pClient) = 0;

        ///根据交易编码获取交易编码序号
        virtual int GetClientNo(char *clientId,int &clientNo) = 0;

        ///获取交易前置列表
        virtual int GetFrontList(TdRspQryFrontFieldList& output) = 0;

        ///获取合约列表
        virtual int GetInstrumentList(TdRspQryInstrumentFieldList& output) = 0;

        ///根据合约编码获取合约信息(期货、期权、现货均可通过该接口查询)
        virtual int GetInstrumentInfo(char* instrumentId, CTdRspQryInstrumentField& pInstrument) = 0;

        ///根据合约序号获取合约信息(期货、期权、现货均可通过该接口查询)
        virtual int GetInstrumentInfo(int instrumentNo, CTdRspQryInstrumentField& pInstrument) = 0;

        ///根据合约编码获取合约序号
        virtual int GetInstrumentNo(char* instrumentId, int &instrumentNo) = 0;

        ///查询手续费信息(期货、期权、现货手续费均可通过该接口查询)
        virtual int GetRateList(TdRspQryRateFieldList& output) = 0;

        ///根据合约编码获取手续费信息(期货、期权、现货均可通过该接口查询)
        virtual int GetRateInfo(char* clientId, char* instrumentId, CTdRspQryRateField& pRatet) = 0;

        ///根据合约序号获取手续费信息(期货、期权、现货均可通过该接口查询)
        virtual int GetRateInfo(int clientNo, int instrumentNo, CTdRspQryRateField& pRate) = 0;

        ///查询期权保证金
        virtual int GetOptMarginList(TdRspQryOptMarginFieldList& output) = 0;

        ///根据合约编码获取期权保证金
        virtual int GetOptMarginInfo(char* clientId, char* instrumentId, CTdRspQryOptMarginField& pMargin) = 0;

        ///根据合约序号获取期权保证金
        virtual int GetOptMarginInfo(int clientNo, int instrumentNo, CTdRspQryOptMarginField& pMargin) = 0;

        ///查询期货保证金
        virtual int GetFutMarginList(TdRspQryFutMarginFieldList& output) = 0;

        ///根据合约编码获取期货保证金
        virtual int GetFutMarginInfo(char* clientId, char* instrumentId, CTdRspQryFutMarginField& pMargin) = 0;

        ///根据合约序号获取期货保证金
        virtual int GetFutMarginInfo(int clientNo, int instrumentNo, CTdRspQryFutMarginField& pMargin) = 0;

        ///从本地获取资金信息
        virtual int GetAccount(char * accountId, CTdRspQryAccountField& pRspPartAccount) = 0;

        ///用户登录请求
        virtual int ReqUserLogin(CTdReqUserLoginField* pReqUserLogin, int nRequestID) = 0;

        ///用户退出请求
        virtual int ReqUserLogout(int nRequestID) = 0;

        ///用户密码修改请求
        virtual int ReqUserPasswordUpdate(CTdUserPasswordUpdateField* pUserPasswordUpdate, int nRequestID) = 0;

        ///股票报单请求
        virtual int ReqStockInsert(CTdStockInsertReqField* pStockInsert, int nRequestID) = 0;

        ///股票撤单请求
        virtual int ReqStockCancel(CTdOrderCancelReqField* pStockCancel, int nRequestID) = 0;

        ///股票非交易业务报单请求
        virtual int ReqBusinessInsert(CTdBusinessInsertReqField* pStockInsert, int nRequestID) = 0;

        ///股票非交易业务撤单请求
        virtual int ReqBusinessCancel(CTdOrderCancelReqField* pStockCancel, int nRequestID) = 0;

        ///证券锁定请求
        virtual int ReqStockLock(CTdStockLockReqField* pStockLock, int nRequestID) = 0;

        ///期权,期货报单请求
        virtual int ReqOptionsInsert(CTdOrderInsertReqField* pOptionsInsert, int nRequestID) = 0;

        ///期权,期货撤单请求
        virtual int ReqOptionsCancel(CTdOrderCancelReqField* pOptionsCancel, int nRequestID) = 0;

        ///期权,期货报价请求
        virtual int ReqQuoteInsert(CTdQuoteInsertReqField* pQuoteInsert, int nRequestID) = 0;

        ///期权,期货撤销报价请求
        virtual int ReqQuoteCancel(CTdOrderCancelReqField* pQuoteCancel, int nRequestID) = 0;

        ///询价请求
        virtual int ReqForQuote(CTdForQuoteReqField* pForQuote, int nRequestID) = 0;

        ///行权请求
        virtual int ReqExercise(CTdExerciseReqField* pExercise, int nRequestID) = 0;

        ///组合行权请求
        virtual int ReqCombExercise(CTdCombExerciseReqField* pExercise, int nRequestID) = 0;

        ///撤销行权请求
        virtual int ReqExerciseCancel(CTdOrderCancelReqField* pExerciseCancel, int nRequestID) = 0;

        ///客户申请组合请求
        virtual int ReqMarginCombAction(CTdMarginCombActionField* pMarginCombAction, int nRequestID) = 0;

        ///股票报单查询请求
        virtual int ReqQryStockOrder(CTdQryStockOrderField* pQryOrder, int nRequestID) = 0;

        ///股票非交易业务报单查询请求
        virtual int ReqQryBusinessOrder(CTdQryBusinessOrderField* pQryOrder, int nRequestID) = 0;

        ///期权,期货报单查询请求
        virtual int ReqQryOptionsOrder(CTdQryOptionsOrderField* pQryOrder, int nRequestID) = 0;

        ///报价查询请求
        virtual int ReqQryQuoteOrder(CTdQryQuoteOrderField* pQryQuote, int nRequestID) = 0;

        //行权查询请求
        virtual int ReqQryExercise(CTdQryExerciseField* pExercise, int nRequestID) = 0;

        //组合行权查询请求
        virtual int ReqQryCombExercise(CTdQryCombExerciseField* pExercise, int nRequestID) = 0;

        ///股票成交查询请求
        virtual int ReqQryStockTrade(CTdQryStockTradeField* pQryTrade, int nRequestID) = 0;

        ///期权,期货成交查询请求
        virtual int ReqQryOptionsTrade(CTdQryOptionsTradeField* pQryTrade, int nRequestID) = 0;

        ///股票持仓查询请求
        virtual int ReqQryStockPosition(CTdQryStockPositionField* pQryPosition, int nRequestID) = 0;

        ///期权,期货持仓查询请求
        virtual int ReqQryOptionsPosition(CTdQryOptionsPositionField* pQryPosition, int nRequestID) = 0;

        ///组合持仓查询请求
        virtual int ReqQryCombPosition(CTdQryCombPositionField* pQryPosi, int nRequestID) = 0;

        ///从服务端获取资金信息
        virtual int ReqQryAccount(CTdQryAccountField* pQryPartAccount, int nRequestID) = 0;

        ///查询合约状态
        //virtual int ReqQryInstrumentStatus(CTdQryInstrumentStatusField* QryInstrumentStatus, int nRequestID) = 0;

        ///查询行情
        virtual int ReqQryMarketData(CTdQryMarketDataField* pQryMarketData, int nRequestID) = 0;

        ///查询通知
        virtual int ReqQryNotify(CTdQryNotifyField* pQryNotify, int nRequestID) = 0;

        ///用户验证请求
        virtual int ReqUserAuthentication(CTdReqUserAuthenField* pReqUserAuthen, int nRequestID) = 0;
    protected:
        ~CTiTdApi() {};
    };

}


#endif
